/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.ri.sp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.apache.openejb.spi.TransactionService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class PseudoTransactionService
implements TransactionService,
TransactionManager,
TransactionSynchronizationRegistry {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.core.cmp");
    private final ThreadLocal<MyTransaction> threadTransaction = new ThreadLocal();

    @Override
    public void init(Properties props) {
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this;
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this;
    }

    public int getStatus() {
        MyTransaction tx = this.threadTransaction.get();
        if (tx == null) {
            return 6;
        }
        return tx.getStatus();
    }

    public Transaction getTransaction() {
        return this.threadTransaction.get();
    }

    public boolean getRollbackOnly() {
        MyTransaction tx = this.threadTransaction.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction active");
        }
        return tx.getRollbackOnly();
    }

    public void setRollbackOnly() {
        MyTransaction tx = this.threadTransaction.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction active");
        }
        tx.setRollbackOnly();
    }

    public void begin() throws NotSupportedException {
        if (this.threadTransaction.get() != null) {
            throw new NotSupportedException("A transaction is already active");
        }
        MyTransaction tx = new MyTransaction();
        this.threadTransaction.set(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException {
        MyTransaction tx = this.threadTransaction.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction active");
        }
        try {
            tx.commit();
        }
        finally {
            this.threadTransaction.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        MyTransaction tx = this.threadTransaction.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction active");
        }
        try {
            tx.rollback();
        }
        finally {
            this.threadTransaction.set(null);
        }
    }

    public Transaction suspend() {
        return this.threadTransaction.get();
    }

    public void resume(Transaction tx) throws InvalidTransactionException {
        if (tx == null) {
            throw new InvalidTransactionException("Transaction is null");
        }
        if (!(tx instanceof MyTransaction)) {
            throw new InvalidTransactionException("Unknown transaction type " + tx.getClass().getName());
        }
        MyTransaction myTransaction = (MyTransaction)tx;
        if (this.threadTransaction.get() != null) {
            throw new IllegalStateException("A transaction is already active");
        }
        int status = myTransaction.getStatus();
        if (status != 0 && status != 1) {
            throw new InvalidTransactionException("Expected transaction to be STATUS_ACTIVE or STATUS_MARKED_ROLLBACK, but was " + status);
        }
        this.threadTransaction.set(myTransaction);
    }

    public Object getTransactionKey() {
        return this.getTransaction();
    }

    public int getTransactionStatus() {
        return this.getStatus();
    }

    public Object getResource(Object key) {
        MyTransaction tx = this.threadTransaction.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction active");
        }
        Object value = tx.getResource(key);
        return value;
    }

    public void putResource(Object key, Object value) {
        MyTransaction tx = this.threadTransaction.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction active");
        }
        tx.putResource(key, value);
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        MyTransaction tx = this.threadTransaction.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction active");
        }
        tx.registerInterposedSynchronization(synchronization);
    }

    public void setTransactionTimeout(int seconds) {
    }

    public class MyTransaction
    implements Transaction {
        private final List<Synchronization> registeredSynchronizations = Collections.synchronizedList(new ArrayList());
        private final List<XAResource> xaResources = Collections.synchronizedList(new ArrayList());
        private final Map<Object, Object> resources = new HashMap<Object, Object>();
        private int status = 0;

        public boolean delistResource(XAResource xaRes, int flag) {
            this.xaResources.remove(xaRes);
            return true;
        }

        public boolean enlistResource(XAResource xaRes) {
            this.xaResources.add(xaRes);
            return true;
        }

        public int getStatus() {
            return this.status;
        }

        public void registerSynchronization(Synchronization synchronization) {
            this.registeredSynchronizations.add(synchronization);
        }

        public void registerInterposedSynchronization(Synchronization synchronization) {
            this.registeredSynchronizations.add(synchronization);
        }

        public boolean getRollbackOnly() {
            return this.status == 1;
        }

        public void setRollbackOnly() {
            this.status = 1;
        }

        public Object getResource(Object key) {
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            return this.resources.get(key);
        }

        public void putResource(Object key, Object value) {
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            if (value != null) {
                this.resources.put(key, value);
            } else {
                this.resources.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() throws RollbackException {
            try {
                if (this.status == 1) {
                    this.rollback();
                    throw new RollbackException();
                }
                try {
                    this.doBeforeCompletion();
                }
                catch (Exception e) {
                    this.rollback();
                    throw (RollbackException)new RollbackException().initCause((Throwable)e);
                }
                this.doXAResources(3);
                this.status = 3;
                this.doAfterCompletion(3);
            }
            finally {
                PseudoTransactionService.this.threadTransaction.set(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() {
            try {
                this.doXAResources(4);
                this.doAfterCompletion(4);
                this.status = 4;
                this.registeredSynchronizations.clear();
            }
            finally {
                PseudoTransactionService.this.threadTransaction.set(null);
            }
        }

        private void doBeforeCompletion() {
            for (Synchronization sync : new ArrayList<Synchronization>(this.registeredSynchronizations)) {
                sync.beforeCompletion();
            }
        }

        private void doAfterCompletion(int status) {
            for (Synchronization sync : new ArrayList<Synchronization>(this.registeredSynchronizations)) {
                try {
                    sync.afterCompletion(status);
                }
                catch (RuntimeException e) {
                    logger.warning("Synchronization afterCompletion threw a RuntimeException", e);
                }
            }
        }

        private void doXAResources(int status) {
            for (XAResource xaRes : new ArrayList<XAResource>(this.xaResources)) {
                if (status == 3) {
                    try {
                        xaRes.commit(null, true);
                    }
                    catch (XAException xAException) {
                        // empty catch block
                    }
                    try {
                        xaRes.end(null, 0x4000000);
                    }
                    catch (XAException xAException) {}
                    continue;
                }
                try {
                    xaRes.rollback(null);
                }
                catch (XAException xAException) {
                    // empty catch block
                }
                try {
                    xaRes.end(null, 0x20000000);
                }
                catch (XAException xAException) {}
            }
            this.xaResources.clear();
        }
    }
}

