/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cli;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.openejb.cli.Main;
import org.apache.openejb.cli.SystemExitException;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemClassPath;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.openejb.util.URLs;

public class Bootstrap {
    private static final String OPENEJB_VERSION_PROPERTIES_FILE_NAME = "openejb-version.properties";
    private static final String OPENEJB_HOME_PROPERTY_NAME = "openejb.home";
    private static final String OPENEJB_BASE_PROPERTY_NAME = "openejb.base";
    private static final String OPENEJB_CLI_MAIN_CLASS_NAME = "org.apache.openejb.cli.MainImpl";

    private static void setupHome(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-Dopenejb.home")) {
                Bootstrap.addProperty(arg);
                continue;
            }
            if (!arg.startsWith("-Dopenejb.base")) continue;
            Bootstrap.addProperty(arg);
        }
        String homeProperty = System.getProperty(OPENEJB_HOME_PROPERTY_NAME);
        if (homeProperty != null && new File(homeProperty).exists()) {
            return;
        }
        try {
            URL classURL = Thread.currentThread().getContextClassLoader().getResource(OPENEJB_VERSION_PROPERTIES_FILE_NAME);
            if (classURL != null) {
                String propsString = classURL.getFile();
                URI uri = URLs.uri(propsString = propsString.substring(0, propsString.indexOf("!")));
                File jarFile = new File(uri.getSchemeSpecificPart());
                if (jarFile.getName().contains("openejb-core")) {
                    File lib = jarFile.getParentFile();
                    File home = lib.getParentFile().getCanonicalFile();
                    System.setProperty(OPENEJB_HOME_PROPERTY_NAME, home.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error setting openejb.home property: " + e.getClass() + ": " + e.getMessage());
        }
    }

    private static void addProperty(String arg) {
        String prop = arg.substring(arg.indexOf("-D") + 2, arg.indexOf("="));
        String val = arg.substring(arg.indexOf("=") + 1);
        System.setProperty(prop, val);
    }

    private static void setupClasspath() {
        String base = System.getProperty(OPENEJB_BASE_PROPERTY_NAME, "");
        String home = System.getProperty("catalina.home", System.getProperty(OPENEJB_HOME_PROPERTY_NAME, base));
        try {
            File lib = new File(home + File.separator + "lib");
            SystemClassPath systemCP = new SystemClassPath();
            File config = new File(base, "conf/catalina.properties");
            if (!config.isFile()) {
                config = new File(home, "conf/catalina.properties");
            }
            if (config.isFile()) {
                String val = IO.readProperties(config).getProperty("common.loader", lib.getAbsolutePath());
                val = PropertyPlaceHolderHelper.simpleValue(val.replace("${catalina.", "${openejb."));
                StringTokenizer tokenizer = new StringTokenizer(val, ",");
                while (tokenizer.hasMoreElements()) {
                    File dir;
                    String repository = tokenizer.nextToken().trim();
                    if (repository.isEmpty()) continue;
                    if (repository.startsWith("\"") && repository.endsWith("\"")) {
                        repository = repository.substring(1, repository.length() - 1);
                    }
                    if (repository.endsWith("*.jar")) {
                        dir = new File(repository.substring(0, repository.length() - "*.jar".length()));
                        if (!dir.isDirectory()) continue;
                        systemCP.addJarsToPath(dir);
                        continue;
                    }
                    if (repository.endsWith(".jar")) {
                        File file = new File(repository);
                        if (!file.isFile()) continue;
                        systemCP.addJarToPath(file.toURI().toURL());
                        continue;
                    }
                    dir = new File(repository);
                    if (!dir.isDirectory()) continue;
                    systemCP.addJarToPath(dir.toURI().toURL());
                }
            } else {
                systemCP.addJarsToPath(lib);
                systemCP.addJarToPath(lib.toURI().toURL());
            }
        }
        catch (Exception e) {
            System.err.println("Error setting up the classpath: " + e.getClass() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        Bootstrap.setupHome(args);
        Bootstrap.setupClasspath();
        Class<?> clazz = Bootstrap.class.getClassLoader().loadClass(OPENEJB_CLI_MAIN_CLASS_NAME);
        Main main = (Main)clazz.newInstance();
        try {
            main.main(args);
        }
        catch (SystemExitException e) {
            System.exit(e.getExitCode());
        }
    }
}

