/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LazyValidator
implements InvocationHandler {
    private final ReentrantLock lock = new ReentrantLock();
    private final ValidatorFactory factory;
    private Validator validator;

    public LazyValidator(ValidatorFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.ensureDelegate();
        try {
            return method.invoke((Object)this.validator, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDelegate() {
        if (this.validator == null) {
            ReentrantLock l = this.lock;
            l.lock();
            try {
                if (this.validator == null) {
                    this.validator = this.factory.usingContext().getValidator();
                }
            }
            finally {
                l.unlock();
            }
        }
    }

    public Validator getValidator() {
        this.ensureDelegate();
        return this.validator;
    }
}

