/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.ClusterRequest;
import org.apache.openejb.client.ClusterResponse;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.Response;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.ejbd.EjbDaemon;
import org.apache.openejb.server.ejbd.RequestHandler;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ClusterRequestHandler
extends RequestHandler
implements DiscoveryListener {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE.createChild("cluster"), ClusterRequestHandler.class);
    private final Data data = new Data();

    public ClusterRequestHandler(EjbDaemon daemon) {
        super(daemon);
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    public ClusterResponse processRequest(ObjectInputStream in, ProtocolMetaData metaData) throws Exception {
        ClusterRequest req = new ClusterRequest();
        req.setMetaData(metaData);
        ClusterResponse res = new ClusterResponse();
        res.setMetaData(metaData);
        try {
            req.readExternal((ObjectInput)in);
        }
        catch (IOException e) {
            res.setFailure((Throwable)e);
            return res;
        }
        catch (ClassNotFoundException e) {
            res.setFailure(new IOException().initCause(e));
            return res;
        }
        ClusterMetaData currentClusterMetaData = this.data.current();
        if (req.getClusterMetaDataVersion() < currentClusterMetaData.getVersion()) {
            if (logger.isDebugEnabled()) {
                Object[] locations = currentClusterMetaData.getLocations();
                if (locations.length < 10) {
                    logger.debug("Sending client updated cluster locations: [" + Join.join((String)", ", (Object[])locations) + "]");
                } else {
                    logger.debug("Sending client updated cluster locations: " + locations.length + " locations total");
                }
            }
            res.setUpdatedMetaData(currentClusterMetaData);
        } else {
            res.setCurrent();
        }
        return res;
    }

    @Override
    public String getName() {
        return "Cluster";
    }

    @Override
    public void processResponse(Response response, ObjectOutputStream out, ProtocolMetaData metaData) throws Exception {
        if (null != response) {
            if (ClusterResponse.class.isInstance(response)) {
                ClusterResponse res = (ClusterResponse)response;
                try {
                    res.setMetaData(metaData);
                    res.writeExternal((ObjectOutput)out);
                }
                catch (IOException e) {
                    logger.error("Failed to write to ClusterResponse", (Throwable)e);
                    throw e;
                }
            } else {
                logger.error("ClusterRequestHandler cannot process an instance of: " + response.getClass().getName());
            }
        }
    }

    public void serviceAdded(URI uri) {
        try {
            URI service = this.unwrap(uri);
            if ("ejb".equals(uri.getScheme())) {
                logger.info("Peer discovered: " + service.toString());
                this.data.add(service);
            }
        }
        catch (URISyntaxException e) {
            logger.error("serviceAdded: Invalid service URI format.  Expected <group>:<type>:<serverURI> but found '" + uri.toString() + "'");
        }
    }

    private URI unwrap(URI uri) throws URISyntaxException {
        return new URI(uri.getSchemeSpecificPart());
    }

    public void serviceRemoved(URI uri) {
        try {
            URI service = this.unwrap(uri);
            if ("ejb".equals(uri.getScheme())) {
                logger.info("Peer removed: " + service.toString());
                this.data.remove(service);
            }
        }
        catch (URISyntaxException e) {
            logger.error("serviceAdded: Invalid service URI format.  Expected <group>:<type>:<serverURI> but found '" + uri.toString() + "'");
        }
    }

    private static class Data {
        private final AtomicReference<ClusterMetaData> current = new AtomicReference();
        private final ReadWriteLock sync = new ReentrantReadWriteLock();
        private final Set set = new LinkedHashSet();

        public Data() {
            this.current.set(new ClusterMetaData(0L, new URI[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(URI o) {
            Lock lock = this.sync.writeLock();
            lock.lock();
            try {
                ClusterMetaData nextVersion;
                block11: {
                    nextVersion = null;
                    try {
                        if (!this.set.add(o)) break block11;
                        nextVersion = Data.newClusterMetaData(this.set, this.current.get());
                        boolean bl = true;
                        if (nextVersion != null) {
                            this.current.set(nextVersion);
                        }
                        return bl;
                    }
                    catch (Throwable throwable) {
                        if (nextVersion != null) {
                            this.current.set(nextVersion);
                        }
                        throw throwable;
                    }
                }
                boolean bl = false;
                if (nextVersion != null) {
                    this.current.set(nextVersion);
                }
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            Lock lock = this.sync.writeLock();
            lock.lock();
            try {
                ClusterMetaData nextVersion;
                block11: {
                    nextVersion = null;
                    try {
                        if (!this.set.remove(o)) break block11;
                        nextVersion = Data.newClusterMetaData(this.set, this.current.get());
                        boolean bl = true;
                        if (nextVersion != null) {
                            this.current.set(nextVersion);
                        }
                        return bl;
                    }
                    catch (Throwable throwable) {
                        if (nextVersion != null) {
                            this.current.set(nextVersion);
                        }
                        throw throwable;
                    }
                }
                boolean bl = false;
                if (nextVersion != null) {
                    this.current.set(nextVersion);
                }
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        private static ClusterMetaData newClusterMetaData(Set set, ClusterMetaData current) {
            URI[] locations = new URI[set.size()];
            set.toArray(locations);
            return new ClusterMetaData(System.currentTimeMillis(), locations);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClusterMetaData current() {
            Lock lock = this.sync.readLock();
            lock.lock();
            try {
                ClusterMetaData clusterMetaData = this.current.get();
                return clusterMetaData;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

