/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.openejb.loader.Options;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpServer;
import org.apache.openejb.server.httpd.OpenEJBHttpServer;
import org.apache.openejb.server.httpd.ServletRequestAdapter;
import org.apache.openejb.server.httpd.ServletResponseAdapter;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.HashSessionIdManager;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.jetty.servlet.SessionHandler;

public class JettyHttpServer
implements HttpServer {
    private final HttpListener listener;
    private Server server;
    private int port;

    public JettyHttpServer() {
        this(OpenEJBHttpServer.getHttpListenerRegistry());
    }

    public JettyHttpServer(HttpListener listener) {
        this.listener = listener;
    }

    @Override
    public HttpListener getListener() {
        return this.listener;
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException();
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return "jetty";
    }

    public int getPort() {
        return this.port;
    }

    public String getIP() {
        return "0.0.0.0";
    }

    public void init(Properties props) throws Exception {
        Options options = new Options(props);
        this.port = options.get("port", 8080);
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        ContextHandler context = new ContextHandler();
        context.setContextPath("/");
        ContextHandler.SContext servletContext = context.getServletContext();
        this.server.setHandler((Handler)context);
        AbstractHandler handler = new AbstractHandler((ServletContext)servletContext){
            final /* synthetic */ ServletContext val$servletContext;
            {
                this.val$servletContext = servletContext;
            }

            public void handle(String target, HttpServletRequest req, HttpServletResponse res, int dispatch) throws IOException, ServletException {
                try {
                    ((Request)req).setHandled(true);
                    ServletRequestAdapter httpRequest = new ServletRequestAdapter(req, res, this.val$servletContext);
                    ServletResponseAdapter httpResponse = new ServletResponseAdapter(res);
                    JettyHttpServer.this.listener.onMessage(httpRequest, httpResponse);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (ServletException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        };
        SessionHandler sessionHandler = new SessionHandler();
        HashSessionManager sessionManager = new HashSessionManager();
        sessionManager.setIdManager((SessionIdManager)new HashSessionIdManager());
        sessionHandler.setSessionManager((SessionManager)sessionManager);
        sessionHandler.setHandler((Handler)handler);
        context.setHandler((Handler)sessionHandler);
    }

    public void start() throws ServiceException {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void stop() throws ServiceException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

