/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import java.io.File;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.geronimo.osgi.locator.ProviderLocator;

class FactoryLocator {
    FactoryLocator() {
    }

    static Object locate(String factoryId) throws FactoryConfigurationError {
        return FactoryLocator.locate(factoryId, null);
    }

    static Object locate(String factoryId, String altClassName) throws FactoryConfigurationError {
        return FactoryLocator.locate(factoryId, altClassName, Thread.currentThread().getContextClassLoader());
    }

    static Object locate(String factoryId, String altClassName, ClassLoader classLoader) throws FactoryConfigurationError {
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryLocator.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        try {
            String factoryClassName = ProviderLocator.lookupByJREPropertyFile((String)("lib" + File.separator + "stax.properties"), (String)factoryId);
            if (factoryClassName != null) {
                return FactoryLocator.newInstance(factoryClassName, classLoader);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Object service = ProviderLocator.getService((String)factoryId, FactoryLocator.class, (ClassLoader)classLoader);
            if (service != null) {
                return service;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (altClassName == null) {
            throw new FactoryConfigurationError("Unable to locate factory for " + factoryId + ".", null);
        }
        return FactoryLocator.newInstance(altClassName, classLoader);
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws FactoryConfigurationError {
        try {
            return ProviderLocator.loadClass((String)className, FactoryLocator.class, (ClassLoader)classLoader).newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new FactoryConfigurationError("Requested factory " + className + " cannot be located.  Classloader =" + classLoader.toString(), x);
        }
        catch (Exception x) {
            throw new FactoryConfigurationError("Requested factory " + className + " could not be instantiated: " + x, x);
        }
    }
}

