/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecurityPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.osgi.locator.ProviderLocator;

public abstract class PolicyConfigurationFactory {
    private static final String FACTORY_NAME = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static PolicyConfigurationFactory policyConfigurationFactory;

    public static PolicyConfigurationFactory getPolicyConfigurationFactory() throws ClassNotFoundException, PolicyContextException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (policyConfigurationFactory != null) {
            return policyConfigurationFactory;
        }
        final String[] factoryClassName = new String[]{null};
        try {
            policyConfigurationFactory = (PolicyConfigurationFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    factoryClassName[0] = System.getProperty(PolicyConfigurationFactory.FACTORY_NAME);
                    if (factoryClassName[0] == null) {
                        throw new ClassNotFoundException("Property javax.security.jacc.PolicyConfigurationFactory.provider not set");
                    }
                    Thread currentThread = Thread.currentThread();
                    ClassLoader tccl = currentThread.getContextClassLoader();
                    return ProviderLocator.loadClass((String)factoryClassName[0], PolicyConfigurationFactory.class, (ClassLoader)tccl).newInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)pae.getException();
            }
            if (pae.getException() instanceof InstantiationException) {
                throw new ClassNotFoundException(factoryClassName[0] + " could not be instantiated");
            }
            if (pae.getException() instanceof IllegalAccessException) {
                throw new ClassNotFoundException("Illegal access to " + factoryClassName);
            }
            throw new PolicyContextException(pae.getException());
        }
        return policyConfigurationFactory;
    }

    public abstract PolicyConfiguration getPolicyConfiguration(String var1, boolean var2) throws PolicyContextException;

    public abstract boolean inService(String var1) throws PolicyContextException;
}

