/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Join;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.lib.jdbc.DelegatingDatabaseMetaData;
import org.apache.openjpa.lib.jdbc.DelegatingPreparedStatement;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UserException;

public class OracleDictionary
extends DBDictionary {
    public static final String SELECT_HINT = "openjpa.hint.OracleSelectHint";
    public static final String VENDOR_ORACLE = "oracle";
    private static final int BEHAVE_OTHER = 0;
    private static final int BEHAVE_ORACLE = 1;
    private static final int BEHAVE_DATADIRECT31 = 2;
    private static Blob EMPTY_BLOB = null;
    private static Clob EMPTY_CLOB = null;
    private static final Localizer _loc = Localizer.forPackage(OracleDictionary.class);
    public boolean useTriggersForAutoAssign = false;
    public String autoAssignSequenceName = null;
    public boolean openjpa3GeneratedKeyNames = false;
    public boolean useSetFormOfUseForUnicode = true;
    @Deprecated
    public boolean supportsSetClob = false;
    @Deprecated
    private boolean logSupportsSetClobWarning = true;
    public String xmlTypeMarker = "XMLType(?)";
    private boolean _checkedUpdateBug = false;
    private boolean _warnedCharColumn = false;
    private boolean _warnedNcharColumn = false;
    private int _driverBehavior = -1;
    private Method _putBytes = null;
    private Method _putString = null;
    private Method _putChars = null;
    private Class oraclePreparedStatementClass = null;
    private Field oraclePreparedStatementFormNvarcharField = null;
    private Method oracleClob_empty_lob_Method = null;
    private Method oracleBlob_empty_lob_Method = null;
    private Method oracleClob_isEmptyLob_Method = null;
    private int defaultBatchLimit = 100;

    public OracleDictionary() {
        this.platform = "Oracle";
        this.validationSQL = "SELECT SYSDATE FROM DUAL";
        this.nextSequenceQuery = "SELECT {0}.NEXTVAL FROM DUAL";
        this.stringLengthFunction = "LENGTH({0})";
        this.joinSyntax = 2;
        this.maxTableNameLength = 30;
        this.maxColumnNameLength = 30;
        this.maxIndexNameLength = 30;
        this.maxConstraintNameLength = 30;
        this.maxEmbeddedBlobSize = 4000;
        this.maxEmbeddedClobSize = 4000;
        this.inClauseLimit = 1000;
        this.supportsDeferredConstraints = true;
        this.supportsLockingWithDistinctClause = false;
        this.supportsSelectStartIndex = true;
        this.supportsSelectEndIndex = true;
        this.systemSchemaSet.addAll(Arrays.asList("CTXSYS", "MDSYS", "SYS", "SYSTEM", "WKSYS", "WMSYS", "XDB"));
        this.supportsXMLColumn = true;
        this.xmlTypeName = "XMLType";
        this.bigintTypeName = "NUMBER{0}";
        this.bitTypeName = "NUMBER{0}";
        this.decimalTypeName = "NUMBER{0}";
        this.doubleTypeName = "NUMBER{0}";
        this.integerTypeName = "NUMBER{0}";
        this.numericTypeName = "NUMBER{0}";
        this.smallintTypeName = "NUMBER{0}";
        this.tinyintTypeName = "NUMBER{0}";
        this.longVarcharTypeName = "LONG";
        this.binaryTypeName = "BLOB";
        this.varbinaryTypeName = "BLOB";
        this.longVarbinaryTypeName = "BLOB";
        this.timeTypeName = "DATE";
        this.varcharTypeName = "VARCHAR2{0}";
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("LONG RAW", "RAW", "LONG", "REF"));
        this.reservedWordSet.addAll(Arrays.asList("ACCESS", "AUDIT", "CLUSTER", "COMMENT", "COMPRESS", "EXCLUSIVE", "FILE", "IDENTIFIED", "INCREMENT", "INDEX", "INITIAL", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "NOAUDIT", "NOCOMPRESS", "NOWAIT", "OFFLINE", "ONLINE", "PCTFREE", "ROW"));
        this.invalidColumnWordSet.addAll(Arrays.asList("ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "END-EXEC", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "REVOKE", "ROW", "ROWS", "SELECT", "SESSION", "SET", "SIZE", "SMALLINT", "TABLE", "THEN", "TO", "UNION", "UNIQUE", "UPDATE", "USER", "VALUES", "VARCHAR", "VIEW", "WHENEVER", "WHERE", "WITH"));
        this.substringFunctionName = "SUBSTR";
        super.setBatchLimit(this.defaultBatchLimit);
        this.selectWordSet.add("WITH");
        this.reportsSuccessNoInfoOnBatchUpdates = true;
        try {
            this.oraclePreparedStatementClass = Class.forName("oracle.jdbc.OraclePreparedStatement");
            try {
                this.oraclePreparedStatementFormNvarcharField = this.oraclePreparedStatementClass.getField("FORM_NCHAR");
                this.oraclePreparedStatementFormNvarcharField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                this.log.warn("OraclePreparedStatement without FORM_NCHAR field found");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.oracleClob_empty_lob_Method = this.getMethodByReflection("oracle.sql.CLOB", "empty_lob", new Class[0]);
        this.oracleBlob_empty_lob_Method = this.getMethodByReflection("oracle.sql.BLOB", "empty_lob", new Class[0]);
        this.oracleClob_isEmptyLob_Method = this.getMethodByReflection("oracle.sql.CLOB", "isEmptyLob", new Class[0]);
    }

    private Method getMethodByReflection(String className, String methodName, Class<?> ... paramTypes) {
        try {
            return Class.forName(className, true, AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction())).getMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void endConfiguration() {
        super.endConfiguration();
        if (this.useTriggersForAutoAssign) {
            this.supportsAutoAssign = true;
        }
    }

    @Override
    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        if (this.driverVendor == null) {
            DatabaseMetaData meta = conn.getMetaData();
            String url = meta.getURL() == null ? "" : meta.getURL();
            String driverName = meta.getDriverName();
            String metadataClassName = meta instanceof DelegatingDatabaseMetaData ? ((DelegatingDatabaseMetaData)meta).getInnermostDelegate().getClass().getName() : meta.getClass().getName();
            if (metadataClassName.startsWith("oracle.") || url.indexOf("jdbc:oracle:") != -1 || "Oracle JDBC driver".equals(driverName)) {
                String productVersion;
                int release;
                int jdbcMajor = meta.getDriverMajorVersion();
                int jdbcMinor = meta.getDriverMinorVersion();
                this.driverVendor = VENDOR_ORACLE + jdbcMajor + jdbcMinor;
                int jdbcVersion = jdbcMajor * 1000 + jdbcMinor;
                if (jdbcVersion >= 11002) {
                    this.maxEmbeddedBlobSize = -1;
                    this.maxEmbeddedClobSize = -1;
                }
                if ((release = Integer.parseInt(productVersion = meta.getDatabaseProductVersion().split("Release ", 0)[1].split("\\.", 0)[0])) <= 8) {
                    if (this.joinSyntax == 0 && this.log.isWarnEnabled()) {
                        this.log.warn(_loc.get("oracle-syntax"));
                    }
                    this.joinSyntax = 2;
                    this.dateTypeName = "DATE";
                    this.timestampTypeName = "DATE";
                    this.supportsXMLColumn = false;
                }
                this.getStringVal = ".getClobVal()";
            } else {
                this.driverVendor = metadataClassName.startsWith("com.ddtek.") || url.indexOf("jdbc:datadirect:oracle:") != -1 || "Oracle".equals(driverName) ? "datadirect" + meta.getDriverMajorVersion() + meta.getDriverMinorVersion() : "other";
            }
        }
        this.cacheDriverBehavior(this.driverVendor);
        this.guessJDBCVersion(conn);
    }

    private void cacheDriverBehavior(String driverVendor) {
        if (this._driverBehavior != -1) {
            return;
        }
        this._driverBehavior = (driverVendor = driverVendor.toLowerCase(Locale.ENGLISH)).startsWith(VENDOR_ORACLE) ? 1 : (driverVendor.equals("datadirect30") || driverVendor.equals("datadirect31") ? 2 : 0);
    }

    public void ensureDriverVendor() {
        if (this.driverVendor != null) {
            this.cacheDriverBehavior(this.driverVendor);
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(_loc.get("oracle-connecting-for-driver"));
        }
        Connection conn = null;
        try {
            conn = this.conf.getDataSource2(null).getConnection();
            this.connectedConfiguration(conn);
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    @Override
    public boolean supportsLocking(Select sel) {
        if (!super.supportsLocking(sel)) {
            return false;
        }
        return !this.requiresSubselectForRange(sel.getStartIndex(), sel.getEndIndex(), sel.isDistinct(), sel.getOrdering());
    }

    @Override
    protected SQLBuffer getSelects(Select sel, boolean distinctIdentifiers, boolean forUpdate) {
        if (!this.requiresSubselectForRange(sel.getStartIndex(), sel.getEndIndex(), sel.isDistinct(), sel.getOrdering())) {
            return super.getSelects(sel, distinctIdentifiers, forUpdate);
        }
        if (sel.getFromSelect() != null || sel.getTableAliases().size() < 2) {
            return super.getSelects(sel, distinctIdentifiers, forUpdate);
        }
        SQLBuffer selectSQL = new SQLBuffer(this);
        List aliases = distinctIdentifiers ? sel.getIdentifierAliases() : sel.getSelectAliases();
        int i = 0;
        Iterator itr = aliases.iterator();
        while (itr.hasNext()) {
            Object alias = itr.next();
            String asString = null;
            if (alias instanceof SQLBuffer) {
                asString = ((SQLBuffer)alias).getSQL();
                selectSQL.appendParamOnly((SQLBuffer)alias);
            } else {
                asString = alias.toString();
            }
            selectSQL.append(asString);
            if (asString.indexOf(" AS ") == -1) {
                selectSQL.append(" AS c").append(String.valueOf(i));
            }
            if (itr.hasNext()) {
                selectSQL.append(", ");
            }
            ++i;
        }
        return selectSQL;
    }

    @Override
    public boolean canOuterJoin(int syntax, ForeignKey fk) {
        if (!super.canOuterJoin(syntax, fk)) {
            return false;
        }
        if (fk != null && syntax == 2) {
            if (fk.getConstants().length > 0) {
                return false;
            }
            if (fk.getPrimaryKeyConstants().length > 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public SQLBuffer toNativeJoin(Join join) {
        if (join.getType() != 1) {
            return this.toTraditionalJoin(join);
        }
        ForeignKey fk = join.getForeignKey();
        if (fk == null) {
            return null;
        }
        boolean inverse = join.isForeignKeyInversed();
        Column[] from = inverse ? fk.getPrimaryKeyColumns() : fk.getColumns();
        Column[] to = inverse ? fk.getColumns() : fk.getPrimaryKeyColumns();
        SQLBuffer buf = new SQLBuffer(this);
        int count = 0;
        int i = 0;
        while (i < from.length) {
            if (count > 0) {
                buf.append(" AND ");
            }
            buf.append(join.getAlias1()).append(".").append(from[i]);
            buf.append(" = ");
            buf.append(join.getAlias2()).append(".").append(to[i]);
            buf.append("(+)");
            ++i;
            ++count;
        }
        if (fk.getConstantColumns().length > 0) {
            throw new StoreException(_loc.get("oracle-constant", join.getTable1(), join.getTable2())).setFatal(true);
        }
        if (fk.getConstantPrimaryKeyColumns().length > 0) {
            throw new StoreException(_loc.get("oracle-constant", join.getTable1(), join.getTable2())).setFatal(true);
        }
        return buf;
    }

    @Override
    protected SQLBuffer toSelect(SQLBuffer select, JDBCFetchConfiguration fetch, SQLBuffer tables, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, boolean forUpdate, long start, long end, boolean subselect, Select sel) {
        return this.toSelect(select, fetch, tables, where, group, having, order, distinct, forUpdate, start, end, sel);
    }

    @Override
    protected SQLBuffer toSelect(SQLBuffer select, JDBCFetchConfiguration fetch, SQLBuffer tables, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, boolean forUpdate, long start, long end, Select sel) {
        if (!this._checkedUpdateBug) {
            this.ensureDriverVendor();
            if (forUpdate && this._driverBehavior == 2) {
                this.log.warn(_loc.get("dd-lock-bug"));
            }
            this._checkedUpdateBug = true;
        }
        if (!this.isUsingRange(start, end)) {
            return super.toSelect(select, fetch, tables, where, group, having, order, distinct, forUpdate, 0L, Long.MAX_VALUE, sel);
        }
        SQLBuffer buf = new SQLBuffer(this);
        if (!this.requiresSubselectForRange(start, end, distinct, order)) {
            if (where != null && !where.isEmpty()) {
                buf.append(where).append(" AND ");
            }
            buf.append("ROWNUM <= ").appendValue(end);
            return super.toSelect(select, fetch, tables, buf, group, having, order, distinct, forUpdate, 0L, Long.MAX_VALUE, sel);
        }
        SQLBuffer newsel = super.toSelect(select, fetch, tables, where, group, having, order, distinct, forUpdate, 0L, Long.MAX_VALUE, sel);
        if (!this.isUsingOffset(start)) {
            buf.append(this.getSelectOperation(fetch) + " * FROM (");
            buf.append(newsel);
            buf.append(") WHERE ROWNUM <= ").appendValue(end);
            return buf;
        }
        buf.append(this.getSelectOperation(fetch)).append(" * FROM (SELECT r.*, ROWNUM RNUM FROM (");
        buf.append(newsel);
        buf.append(") r");
        if (this.isUsingLimit(end)) {
            buf.append(" WHERE ROWNUM <= ").appendValue(end);
        }
        buf.append(") WHERE RNUM > ").appendValue(start);
        return buf;
    }

    private boolean requiresSubselectForRange(long start, long end, boolean distinct, SQLBuffer order) {
        if (!this.isUsingRange(start, end)) {
            return false;
        }
        return this.isUsingOffset(start) || distinct || this.isUsingOrderBy(order);
    }

    @Override
    public String getSelectOperation(JDBCFetchConfiguration fetch) {
        Object hint = fetch == null ? null : fetch.getHint(SELECT_HINT);
        String select = "SELECT";
        if (hint != null) {
            select = select + " " + hint;
        }
        return select;
    }

    @Override
    public void setString(PreparedStatement stmnt, int idx, String val, Column col) throws SQLException {
        PreparedStatement inner;
        String typeName;
        String string = typeName = col == null ? null : col.getTypeIdentifier().getName();
        if (this.useSetFormOfUseForUnicode && typeName != null && (typeName.toLowerCase(Locale.ENGLISH).startsWith("nvarchar") || typeName.toLowerCase(Locale.ENGLISH).startsWith("nchar") || typeName.toLowerCase(Locale.ENGLISH).startsWith("nclob"))) {
            inner = stmnt;
            if (inner instanceof DelegatingPreparedStatement) {
                inner = ((DelegatingPreparedStatement)inner).getInnermostDelegate();
            }
            if (this.isOraclePreparedStatement(inner)) {
                try {
                    inner.getClass().getMethod("setFormOfUse", Integer.TYPE, Short.TYPE).invoke((Object)inner, idx, this.oraclePreparedStatementFormNvarcharField.get(null));
                }
                catch (Exception e) {
                    this.log.warn(e);
                }
            } else if (!this._warnedNcharColumn && this.log.isWarnEnabled()) {
                this._warnedNcharColumn = true;
                this.log.warn(_loc.get("unconfigured-nchar-cols"));
            }
        }
        if (col != null && col.getType() == 1 && val != null && val.length() != col.getSize()) {
            inner = stmnt;
            if (inner instanceof DelegatingPreparedStatement) {
                inner = ((DelegatingPreparedStatement)inner).getInnermostDelegate();
            }
            if (this.isOraclePreparedStatement(inner)) {
                try {
                    inner.getClass().getMethod("setFixedCHAR", Integer.TYPE, String.class).invoke((Object)inner, new Integer(idx), val);
                    return;
                }
                catch (Exception e) {
                    this.log.warn(e);
                }
            }
            if (!this._warnedCharColumn && this.log.isWarnEnabled()) {
                this._warnedCharColumn = true;
                this.log.warn(_loc.get("unpadded-char-cols"));
            }
        }
        super.setString(stmnt, idx, val, col);
    }

    @Override
    public void setBinaryStream(PreparedStatement stmnt, int idx, InputStream val, int length, Column col) throws SQLException {
        if (length == 0) {
            stmnt.setBlob(idx, this.getEmptyBlob());
        } else {
            super.setBinaryStream(stmnt, idx, val, length, col);
        }
    }

    @Override
    public void setClobString(PreparedStatement stmnt, int idx, String val, Column col) throws SQLException {
        if (this.supportsSetClob && this.logSupportsSetClobWarning) {
            this.log.warn(_loc.get("oracle-set-clob-warning"));
            this.logSupportsSetClobWarning = false;
        }
        if (col.isXML()) {
            if (this.isJDBC4) {
                stmnt.setClob(idx, new StringReader(val), val.length());
            } else {
                this.setCharacterStream(stmnt, idx, new StringReader(val), val.length(), col);
            }
            return;
        }
        if (!this.useSetStringForClobs && val.length() == 0) {
            stmnt.setClob(idx, this.getEmptyClob());
        } else {
            super.setClobString(stmnt, idx, val, col);
        }
    }

    @Override
    public void setNull(PreparedStatement stmnt, int idx, int colType, Column col) throws SQLException {
        if ((colType == 2005 || colType == 2004) && col.isNotNull()) {
            throw new UserException(_loc.get("null-blob-in-not-nullable", this.toDBName(col.getFullDBIdentifier())));
        }
        if (colType == 2004 && this._driverBehavior == 1) {
            stmnt.setBlob(idx, this.getEmptyBlob());
        } else if (colType == 2005 && this._driverBehavior == 1 && !col.isXML()) {
            stmnt.setClob(idx, this.getEmptyClob());
        } else if (!(colType != 2002 && colType != 1111 || col == null || DBIdentifier.isNull(col.getTypeIdentifier()))) {
            stmnt.setNull(idx, 2002, col.getTypeIdentifier().getName());
        } else if (colType == 91) {
            super.setNull(stmnt, idx, 93, col);
        } else if (colType == 1111 || col.isXML()) {
            super.setNull(stmnt, idx, 0, col);
        } else {
            super.setNull(stmnt, idx, colType, col);
        }
    }

    @Override
    public String getClobString(ResultSet rs, int column) throws SQLException {
        if (this._driverBehavior != 1) {
            return super.getClobString(rs, column);
        }
        Clob clob = this.getClob(rs, column);
        if (clob == null) {
            return null;
        }
        if (this.oracleClob_isEmptyLob_Method != null && clob.getClass().getName().equals("oracle.sql.CLOB")) {
            try {
                if (((Boolean)this.oracleClob_isEmptyLob_Method.invoke((Object)clob, new Object[0])).booleanValue()) {
                    return null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (clob.length() == 0L) {
            return null;
        }
        return clob.getSubString(1L, (int)clob.length());
    }

    @Override
    public Timestamp getTimestamp(ResultSet rs, int column, Calendar cal) throws SQLException {
        if (cal == null) {
            try {
                return super.getTimestamp(rs, column, cal);
            }
            catch (ArrayIndexOutOfBoundsException ae) {
                this.log.warn(_loc.get("oracle-timestamp-bug"), ae);
                throw ae;
            }
        }
        Timestamp ts = rs.getTimestamp(column, cal);
        if (ts != null && ts.getNanos() == 0) {
            ts.setNanos(rs.getTimestamp(column).getNanos());
        }
        return ts;
    }

    @Override
    public Object getObject(ResultSet rs, int column, Map map) throws SQLException {
        Object obj = super.getObject(rs, column, map);
        if (obj == null) {
            return null;
        }
        if ("oracle.sql.DATE".equals(obj.getClass().getName())) {
            obj = OracleDictionary.convertFromOracleType(obj, "dateValue");
        } else if ("oracle.sql.TIMESTAMP".equals(obj.getClass().getName())) {
            obj = OracleDictionary.convertFromOracleType(obj, "timestampValue");
        }
        return obj;
    }

    private static Object convertFromOracleType(Object obj, String convertMethod) throws SQLException {
        try {
            Method m = obj.getClass().getMethod(convertMethod, null);
            return m.invoke(obj, (Object[])null);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new SQLException(t.getMessage());
        }
    }

    @Override
    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        return this.getColumns(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), DBIdentifier.newColumn(columnName), conn);
    }

    @Override
    public Column[] getColumns(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, DBIdentifier columnName, Connection conn) throws SQLException {
        Column[] cols = super.getColumns(meta, catalog, schemaName, tableName, columnName, conn);
        for (int i = 0; cols != null && i < cols.length; ++i) {
            String typeName = cols[i].getTypeIdentifier().getName();
            if (typeName == null) continue;
            if (typeName.toUpperCase(Locale.ENGLISH).startsWith("TIMESTAMP")) {
                cols[i].setType(93);
                continue;
            }
            if ("BLOB".equalsIgnoreCase(typeName)) {
                cols[i].setType(2004);
                continue;
            }
            if ("CLOB".equalsIgnoreCase(typeName) || "NCLOB".equalsIgnoreCase(typeName)) {
                cols[i].setType(2005);
                continue;
            }
            if ("FLOAT".equalsIgnoreCase(typeName)) {
                cols[i].setType(6);
                continue;
            }
            if ("NVARCHAR".equalsIgnoreCase(typeName)) {
                cols[i].setType(12);
                continue;
            }
            if ("NCHAR".equalsIgnoreCase(typeName)) {
                cols[i].setType(1);
                continue;
            }
            if (!"XMLTYPE".equalsIgnoreCase(typeName)) continue;
            cols[i].setXML(true);
        }
        return cols;
    }

    @Override
    public PrimaryKey[] getPrimaryKeys(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        return this.getPrimaryKeys(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimaryKey[] getPrimaryKeys(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, Connection conn) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT t0.OWNER AS TABLE_SCHEM, ").append("t0.TABLE_NAME AS TABLE_NAME, ").append("t0.COLUMN_NAME AS COLUMN_NAME, ").append("t0.CONSTRAINT_NAME AS PK_NAME ").append("FROM ALL_CONS_COLUMNS t0, ALL_CONSTRAINTS t1 ").append("WHERE t0.OWNER = t1.OWNER ").append("AND t0.CONSTRAINT_NAME = t1.CONSTRAINT_NAME ").append("AND t1.CONSTRAINT_TYPE = 'P'");
        if (!DBIdentifier.isNull(schemaName)) {
            buf.append(" AND t0.OWNER = ?");
        }
        if (!DBIdentifier.isNull(tableName)) {
            buf.append(" AND t0.TABLE_NAME = ?");
        }
        PreparedStatement stmnt = conn.prepareStatement(buf.toString());
        ResultSet rs = null;
        try {
            int idx = 1;
            if (!DBIdentifier.isNull(schemaName)) {
                this.setString(stmnt, idx++, this.convertSchemaCase(schemaName), null);
            }
            if (!DBIdentifier.isNull(tableName)) {
                this.setString(stmnt, idx++, this.convertSchemaCase(tableName.getUnqualifiedName()), null);
            }
            this.setTimeouts(stmnt, this.conf, false);
            rs = stmnt.executeQuery();
            ArrayList<PrimaryKey> pkList = new ArrayList<PrimaryKey>();
            while (rs != null && rs.next()) {
                pkList.add(this.newPrimaryKey(rs));
            }
            PrimaryKey[] primaryKeyArray = pkList.toArray(new PrimaryKey[pkList.size()]);
            return primaryKeyArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            try {
                stmnt.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public Index[] getIndexInfo(DatabaseMetaData meta, String catalog, String schemaName, String tableName, boolean unique, boolean approx, Connection conn) throws SQLException {
        return this.getIndexInfo(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), unique, approx, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Index[] getIndexInfo(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, boolean unique, boolean approx, Connection conn) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT t0.INDEX_OWNER AS TABLE_SCHEM, ").append("t0.TABLE_NAME AS TABLE_NAME, ").append("DECODE(t1.UNIQUENESS, 'UNIQUE', 0, 'NONUNIQUE', 1) ").append("AS NON_UNIQUE, ").append("t0.INDEX_NAME AS INDEX_NAME, ").append("t0.COLUMN_NAME AS COLUMN_NAME ").append("FROM ALL_IND_COLUMNS t0, ALL_INDEXES t1 ").append("WHERE t0.INDEX_OWNER = t1.OWNER ").append("AND t0.INDEX_NAME = t1.INDEX_NAME");
        if (!DBIdentifier.isNull(schemaName)) {
            buf.append(" AND t0.TABLE_OWNER = ?");
        }
        if (!DBIdentifier.isNull(tableName)) {
            buf.append(" AND t0.TABLE_NAME = ?");
        }
        PreparedStatement stmnt = conn.prepareStatement(buf.toString());
        ResultSet rs = null;
        try {
            int idx = 1;
            if (!DBIdentifier.isNull(schemaName)) {
                this.setString(stmnt, idx++, this.convertSchemaCase(schemaName), null);
            }
            if (!DBIdentifier.isNull(tableName)) {
                this.setString(stmnt, idx++, this.convertSchemaCase(tableName), null);
            }
            this.setTimeouts(stmnt, this.conf, false);
            rs = stmnt.executeQuery();
            ArrayList<Index> idxList = new ArrayList<Index>();
            while (rs != null && rs.next()) {
                idxList.add(this.newIndex(rs));
            }
            Index[] indexArray = idxList.toArray(new Index[idxList.size()]);
            return indexArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            try {
                stmnt.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public ForeignKey[] getImportedKeys(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn, boolean partialKeys) throws SQLException {
        return this.getImportedKeys(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn, partialKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForeignKey[] getImportedKeys(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, Connection conn, boolean partialKeys) throws SQLException {
        StringBuilder delAction = new StringBuilder("DECODE(t1.DELETE_RULE").append(", 'NO ACTION', ").append(3).append(", 'RESTRICT', ").append(1).append(", 'CASCADE', ").append(0).append(", 'SET NULL', ").append(2).append(", 'SET DEFAULT', ").append(4).append(")");
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT t2.OWNER AS PKTABLE_SCHEM, ").append("t2.TABLE_NAME AS PKTABLE_NAME, ").append("t2.COLUMN_NAME AS PKCOLUMN_NAME, ").append("t0.OWNER AS FKTABLE_SCHEM, ").append("t0.TABLE_NAME AS FKTABLE_NAME, ").append("t0.COLUMN_NAME AS FKCOLUMN_NAME, ").append("t0.POSITION AS KEY_SEQ, ").append((CharSequence)delAction).append(" AS DELETE_RULE, ").append("t0.CONSTRAINT_NAME AS FK_NAME, ").append("DECODE(t1.DEFERRED, 'DEFERRED', ").append(5).append(", 'IMMEDIATE', ").append(6).append(") AS DEFERRABILITY ").append("FROM ALL_CONS_COLUMNS t0, ALL_CONSTRAINTS t1, ").append("ALL_CONS_COLUMNS t2 ").append("WHERE t0.OWNER = t1.OWNER ").append("AND t0.CONSTRAINT_NAME = t1.CONSTRAINT_NAME ").append("AND t1.CONSTRAINT_TYPE = 'R' ").append("AND t1.R_OWNER = t2.OWNER ").append("AND t1.R_CONSTRAINT_NAME = t2.CONSTRAINT_NAME ").append("AND t0.POSITION = t2.POSITION");
        if (!DBIdentifier.isNull(schemaName)) {
            buf.append(" AND t0.OWNER = ?");
        }
        if (!DBIdentifier.isNull(tableName)) {
            buf.append(" AND t0.TABLE_NAME = ?");
        }
        buf.append(" ORDER BY t2.OWNER, t2.TABLE_NAME, t0.POSITION");
        PreparedStatement stmnt = conn.prepareStatement(buf.toString());
        ResultSet rs = null;
        try {
            int idx = 1;
            if (!DBIdentifier.isNull(schemaName)) {
                this.setString(stmnt, idx++, this.convertSchemaCase(schemaName), null);
            }
            if (!DBIdentifier.isNull(tableName)) {
                this.setString(stmnt, idx++, this.convertSchemaCase(tableName), null);
            }
            this.setTimeouts(stmnt, this.conf, false);
            rs = stmnt.executeQuery();
            ArrayList<ForeignKey> fkList = new ArrayList<ForeignKey>();
            HashMap<ForeignKey.FKMapKey, ForeignKey> fkMap = new HashMap<ForeignKey.FKMapKey, ForeignKey>();
            while (rs != null && rs.next()) {
                ForeignKey fk;
                ForeignKey nfk = this.newForeignKey(rs);
                if (!partialKeys && (fk = this.combineForeignKey(fkMap, nfk)) != nfk) continue;
                fkList.add(nfk);
            }
            ForeignKey[] foreignKeyArray = fkList.toArray(new ForeignKey[fkList.size()]);
            return foreignKeyArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            try {
                stmnt.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public String[] getCreateTableSQL(Table table) {
        String[] create = super.getCreateTableSQL(table);
        if (!this.useTriggersForAutoAssign) {
            return create;
        }
        Column[] cols = table.getColumns();
        ArrayList<String> seqs = null;
        for (int i = 0; cols != null && i < cols.length; ++i) {
            String seq;
            if (!cols[i].isAutoAssigned()) continue;
            if (seqs == null) {
                seqs = new ArrayList<String>(4);
            }
            if ((seq = this.autoAssignSequenceName) == null) {
                seq = this.openjpa3GeneratedKeyNames ? this.getOpenJPA3GeneratedKeySequenceName(cols[i]) : this.getGeneratedKeySequenceName(cols[i]);
                seqs.add("CREATE SEQUENCE " + seq + " START WITH 1");
            }
            String trig = this.openjpa3GeneratedKeyNames ? this.getOpenJPA3GeneratedKeyTriggerName(cols[i]) : this.getGeneratedKeyTriggerName(cols[i]);
            seqs.add("CREATE OR REPLACE TRIGGER " + trig + " BEFORE INSERT ON " + this.toDBName(table.getIdentifier()) + " FOR EACH ROW BEGIN SELECT " + seq + ".nextval INTO " + ":new." + this.toDBName(cols[i].getIdentifier()) + " FROM DUAL; " + "END " + trig + ";");
        }
        if (seqs == null) {
            return create;
        }
        String[] sql2 = new String[create.length + seqs.size()];
        System.arraycopy(create, 0, sql2, 0, create.length);
        for (int i = 0; i < seqs.size(); ++i) {
            sql2[create.length + i] = (String)seqs.get(i);
        }
        return sql2;
    }

    @Override
    public int getJDBCType(int metaTypeCode, boolean lob, int precis, int scale, boolean xml) {
        return this.getJDBCType(metaTypeCode, lob || xml, precis, scale);
    }

    @Override
    protected String getSequencesSQL(String schemaName, String sequenceName) {
        return this.getSequencesSQL(DBIdentifier.newSchema(schemaName), DBIdentifier.newSequence(sequenceName));
    }

    @Override
    protected String getSequencesSQL(DBIdentifier schemaName, DBIdentifier sequenceName) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT SEQUENCE_OWNER AS SEQUENCE_SCHEMA, ").append("SEQUENCE_NAME FROM ALL_SEQUENCES");
        if (!DBIdentifier.isNull(schemaName) || !DBIdentifier.isNull(sequenceName)) {
            buf.append(" WHERE ");
        }
        if (!DBIdentifier.isNull(schemaName)) {
            buf.append("SEQUENCE_OWNER = ?");
            if (!DBIdentifier.isNull(sequenceName)) {
                buf.append(" AND ");
            }
        }
        if (!DBIdentifier.isNull(sequenceName)) {
            buf.append("SEQUENCE_NAME = ?");
        }
        return buf.toString();
    }

    @Override
    public boolean isSystemSequence(String name, String schema, boolean targetSchema) {
        return this.isSystemSequence(DBIdentifier.newSequence(name), DBIdentifier.newSchema(schema), targetSchema);
    }

    @Override
    public boolean isSystemSequence(DBIdentifier name, DBIdentifier schema, boolean targetSchema) {
        if (super.isSystemSequence(name, schema, targetSchema)) {
            return true;
        }
        String strName = DBIdentifier.isNull(name) ? "" : name.getName();
        return this.autoAssignSequenceName != null && strName.equalsIgnoreCase(this.autoAssignSequenceName) || this.autoAssignSequenceName == null && strName.toUpperCase(Locale.ENGLISH).startsWith("ST_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getGeneratedKey(Column col, Connection conn) throws SQLException {
        if (!this.useTriggersForAutoAssign) {
            return 0L;
        }
        String seq = this.autoAssignSequenceName;
        if (seq == null && this.openjpa3GeneratedKeyNames) {
            seq = this.getOpenJPA3GeneratedKeySequenceName(col);
        } else if (seq == null) {
            seq = this.getGeneratedKeySequenceName(col);
        }
        PreparedStatement stmnt = conn.prepareStatement("SELECT " + seq + ".currval FROM DUAL");
        ResultSet rs = null;
        try {
            this.setTimeouts(stmnt, this.conf, false);
            rs = stmnt.executeQuery();
            rs.next();
            Long l = rs.getLong(1);
            return l;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            try {
                stmnt.close();
            }
            catch (SQLException se) {}
        }
    }

    protected String getGeneratedKeyTriggerName(Column col) {
        String seqName = this.getGeneratedKeySequenceName(col);
        return seqName.substring(0, seqName.length() - 3) + "TRG";
    }

    protected String getOpenJPA3GeneratedKeySequenceName(Column col) {
        Table table = col.getTable();
        DBIdentifier sName = DBIdentifier.preCombine(table.getIdentifier(), "SEQ");
        return this.toDBName(this.getNamingUtil().makeIdentifierValid(sName, table.getSchema().getSchemaGroup(), this.maxTableNameLength, true));
    }

    protected String getOpenJPA3GeneratedKeyTriggerName(Column col) {
        Table table = col.getTable();
        DBIdentifier sName = DBIdentifier.preCombine(table.getIdentifier(), "TRIG");
        return this.toDBName(this.getNamingUtil().makeIdentifierValid(sName, table.getSchema().getSchemaGroup(), this.maxTableNameLength, true));
    }

    @Override
    public void putBytes(Blob blob, byte[] data) throws SQLException {
        if (blob == null) {
            return;
        }
        if (this._putBytes == null) {
            try {
                this._putBytes = blob.getClass().getMethod("putBytes", Long.TYPE, byte[].class);
            }
            catch (Exception e) {
                throw new StoreException(e);
            }
        }
        OracleDictionary.invokePutLobMethod(this._putBytes, blob, data);
    }

    @Override
    public void putString(Clob clob, String data) throws SQLException {
        if (this._putString == null) {
            try {
                this._putString = clob.getClass().getMethod("putString", Long.TYPE, String.class);
            }
            catch (Exception e) {
                throw new StoreException(e);
            }
        }
        OracleDictionary.invokePutLobMethod(this._putString, clob, data);
    }

    @Override
    public void putChars(Clob clob, char[] data) throws SQLException {
        if (this._putChars == null) {
            try {
                this._putChars = clob.getClass().getMethod("putChars", Long.TYPE, char[].class);
            }
            catch (Exception e) {
                throw new StoreException(e);
            }
        }
        OracleDictionary.invokePutLobMethod(this._putChars, clob, data);
    }

    private static void invokePutLobMethod(Method method, Object target, Object data) throws SQLException {
        try {
            method.invoke(target, 1L, data);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new StoreException(t);
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    private Clob getEmptyClob() throws SQLException {
        if (EMPTY_CLOB != null) {
            return EMPTY_CLOB;
        }
        try {
            EMPTY_CLOB = (Clob)this.oracleClob_empty_lob_Method.invoke(null, new Object[0]);
            return EMPTY_CLOB;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private Blob getEmptyBlob() throws SQLException {
        if (EMPTY_BLOB != null) {
            return EMPTY_BLOB;
        }
        try {
            EMPTY_BLOB = (Blob)this.oracleBlob_empty_lob_Method.invoke(null, new Object[0]);
            return EMPTY_BLOB;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private boolean isOraclePreparedStatement(Statement stmnt) {
        return this.oraclePreparedStatementClass != null && this.oraclePreparedStatementClass.isInstance(stmnt);
    }

    @Override
    public void appendXmlComparison(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs, boolean lhsxml, boolean rhsxml) {
        super.appendXmlComparison(buf, op, lhs, rhs, lhsxml, rhsxml);
        if (lhsxml && rhsxml) {
            this.appendXmlComparison2(buf, op, lhs, rhs);
        } else if (lhsxml) {
            this.appendXmlComparison1(buf, op, lhs, rhs);
        } else {
            this.appendXmlComparison1(buf, op, rhs, lhs);
        }
    }

    private void appendXmlComparison1(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs) {
        this.appendXmlExtractValue(buf, lhs);
        buf.append(" ").append(op).append(" ");
        rhs.appendTo(buf);
    }

    private void appendXmlComparison2(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs) {
        this.appendXmlExtractValue(buf, lhs);
        buf.append(" ").append(op).append(" ");
        this.appendXmlExtractValue(buf, rhs);
    }

    private void appendXmlExtractValue(SQLBuffer buf, FilterValue val) {
        buf.append("extractValue(").append(val.getColumnAlias(val.getFieldMapping().getColumns()[0])).append(",'/*/");
        val.appendTo(buf);
        buf.append("')");
    }

    @Override
    public void insertClobForStreamingLoad(Row row, Column col, Object ob) throws SQLException {
        if (ob == null) {
            col.setType(1111);
            row.setNull(col);
        } else {
            row.setClob(col, this.getEmptyClob());
        }
    }

    @Override
    public int getBatchUpdateCount(PreparedStatement ps) throws SQLException {
        int updateSuccessCnt = 0;
        if (this.batchLimit != 0 && ps != null) {
            updateSuccessCnt = ps.getUpdateCount();
            if (this.log.isTraceEnabled()) {
                this.log.trace(_loc.get("batch-update-success-count", updateSuccessCnt));
            }
        }
        return updateSuccessCnt;
    }

    @Override
    public boolean isFatalException(int subtype, SQLException ex) {
        String errorState = ex.getSQLState();
        int errorCode = ex.getErrorCode();
        if (subtype == 1 && ("61000".equals(errorState) && (errorCode == 54 || errorCode == 60 || errorCode == 4020 || errorCode == 4021 || errorCode == 4022) || "42000".equals(errorState) && errorCode == 2049)) {
            return false;
        }
        if ("72000".equals(errorState) && errorCode == 1013) {
            return false;
        }
        return super.isFatalException(subtype, ex);
    }

    @Override
    public void insertBlobForStreamingLoad(Row row, Column col, JDBCStore store, Object ob, Select sel) throws SQLException {
        if (ob == null) {
            col.setType(1111);
            row.setNull(col);
        } else {
            row.setBlob(col, this.getEmptyBlob());
        }
    }

    @Override
    public boolean isImplicitJoin() {
        return this.joinSyntax == 2;
    }

    @Override
    public String getMarkerForInsertUpdate(Column col, Object val) {
        if (col.isXML() && val != RowImpl.NULL) {
            return this.xmlTypeMarker;
        }
        return super.getMarkerForInsertUpdate(col, val);
    }

    protected void guessJDBCVersion(Connection conn) {
        if (this._driverBehavior != 1) {
            return;
        }
        this.isJDBC4 = true;
        try {
            conn.getClientInfo();
        }
        catch (SQLException e) {
        }
        catch (Throwable t) {
            this.isJDBC4 = false;
        }
    }

    @Override
    public String getIsNullSQL(String colAlias, int colType) {
        switch (colType) {
            case 2004: 
            case 2005: {
                return String.format("length (%s) = 0", colAlias);
            }
        }
        return super.getIsNullSQL(colAlias, colType);
    }

    @Override
    public String getIsNotNullSQL(String colAlias, int colType) {
        switch (colType) {
            case 2004: 
            case 2005: {
                return String.format("length (%s) != 0 ", colAlias);
            }
        }
        return super.getIsNotNullSQL(colAlias, colType);
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("INSTR(");
        str.appendTo(buf);
        buf.append(", ");
        find.appendTo(buf);
        if (start != null) {
            buf.append(", ");
            start.appendTo(buf);
        }
        buf.append(")");
    }
}

