/*
 * Decompiled with CFR 0.152.
 */
package npanday.assembler.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import npanday.InitializationException;
import npanday.PlatformUnsupportedException;
import npanday.assembler.AssemblerContext;
import npanday.assembler.AssemblyInfo;
import npanday.assembler.AssemblyInfoException;
import npanday.assembler.AssemblyInfoMarshaller;
import npanday.assembler.impl.AssemblyPluginsRepository;
import npanday.model.assembly.plugins.AssemblyPlugin;
import npanday.registry.RepositoryRegistry;
import org.apache.maven.model.Organization;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;

public final class AssemblerContextImpl
implements AssemblerContext,
LogEnabled {
    private static final String SNAPSHOT_SUFFIX = "SNAPSHOT";
    private RepositoryRegistry repositoryRegistry;
    private MavenProject mavenProject;
    private Logger logger;
    private AssemblyPluginsRepository repository;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssemblyInfo getAssemblyInfo() {
        String basedir = this.mavenProject.getBasedir().toString();
        AssemblyInfo assemblyInfo = new AssemblyInfo();
        String description = this.mavenProject.getDescription();
        String version = this.mavenProject.getVersion();
        String name = this.mavenProject.getName();
        Organization org = this.mavenProject.getOrganization();
        String company = org != null ? org.getName() : "";
        String copyright = null;
        String informationalVersion = "";
        String configuration = "";
        File file = new File(basedir + "/COPYRIGHT.txt");
        if (file.exists()) {
            this.logger.debug("NPANDAY-020-000: Found Copyright: " + file.getAbsolutePath());
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                copyright = IOUtil.toString((InputStream)fis).replace("\r", " ").replace("\n", " ").replace("\"", "'");
            }
            catch (IOException e) {
                this.logger.info("NPANDAY-020-001: Could not get copyright: File = " + file.getAbsolutePath(), (Throwable)e);
            }
            finally {
                if (fis != null) {
                    IOUtil.close((InputStream)fis);
                }
            }
        }
        informationalVersion = version;
        if (version.contains("-")) {
            version = version.split("-")[0];
        }
        assemblyInfo.setCompany(company);
        assemblyInfo.setCopyright(copyright);
        assemblyInfo.setCulture("");
        assemblyInfo.setDescription(description);
        assemblyInfo.setProduct(company + "-" + name);
        assemblyInfo.setTitle(name);
        assemblyInfo.setTrademark("");
        assemblyInfo.setInformationalVersion(informationalVersion);
        assemblyInfo.setVersion(version);
        assemblyInfo.setConfiguration(configuration);
        return assemblyInfo;
    }

    public AssemblyInfoMarshaller getAssemblyInfoMarshallerFor(String language) throws AssemblyInfoException {
        AssemblyInfoMarshaller marshaller;
        AssemblyPlugin plugin = this.repository.getAssemblyPluginFor(language);
        String className = plugin.getPluginClass();
        try {
            Class<?> cc = Class.forName(className);
            marshaller = (AssemblyInfoMarshaller)cc.newInstance();
            marshaller.init(plugin);
        }
        catch (ClassNotFoundException e) {
            throw new AssemblyInfoException("NPANDAY-020-002: Unable to create AssemblyInfoMarshaller: Class Name = " + className, e);
        }
        catch (InstantiationException e) {
            throw new AssemblyInfoException("NPANDAY-020-003: Unable to create AssemblyInfoMarshaller: Class Name = " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new AssemblyInfoException("NPANDAY-020-004: Unable to create AssemblyInfoMarshaller: Class Name = " + className, e);
        }
        return marshaller;
    }

    public String getClassExtensionFor(String language) throws PlatformUnsupportedException {
        try {
            return this.repository.getAssemblyPluginFor(language).getExtension();
        }
        catch (AssemblyInfoException e) {
            throw new PlatformUnsupportedException("NPANDAY-020-006: Language not supported: Language = " + language, (Throwable)e);
        }
    }

    public void init(MavenProject mavenProject) throws InitializationException {
        this.mavenProject = mavenProject;
        this.repository = (AssemblyPluginsRepository)this.repositoryRegistry.find("assembly-plugins");
        if (this.repository == null) {
            throw new InitializationException("NPANDAY-020-005: Unable to find the assembly-plugins.xml file");
        }
    }
}

