/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.nifi.websocket.WebSocketSessionInfo;

public class WebSocketMessage {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private final WebSocketSessionInfo sessionInfo;
    private byte[] payload;
    private int offset;
    private int length;
    private Type type;

    public WebSocketMessage(WebSocketSessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    public WebSocketSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(String text) {
        if (text == null) {
            return;
        }
        byte[] bytes = text.getBytes(CHARSET);
        this.setPayload(bytes, 0, bytes.length);
        this.type = Type.TEXT;
    }

    public void setPayload(byte[] payload, int offset, int length) {
        this.payload = payload;
        this.offset = offset;
        this.length = length;
        this.type = Type.BINARY;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        TEXT,
        BINARY;

    }
}

