/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.web.authentication.logout;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.ApplicationCookieService;
import org.apache.nifi.web.security.cookie.StandardApplicationCookieService;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.saml2.SamlUrlPath;
import org.apache.nifi.web.security.token.LogoutAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class Saml2SingleLogoutFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(Saml2SingleLogoutFilter.class);
    private static final ApplicationCookieService applicationCookieService = new StandardApplicationCookieService();
    private final PathPatternRequestMatcher requestMatcher = PathPatternRequestMatcher.withDefaults().matcher(SamlUrlPath.SINGLE_LOGOUT_REQUEST.getPath());
    private final LogoutRequestManager logoutRequestManager;
    private final LogoutSuccessHandler logoutSuccessHandler;

    public Saml2SingleLogoutFilter(LogoutRequestManager logoutRequestManager, LogoutSuccessHandler logoutSuccessHandler) {
        this.logoutRequestManager = Objects.requireNonNull(logoutRequestManager, "Request Manager require");
        this.logoutSuccessHandler = Objects.requireNonNull(logoutSuccessHandler, "Success Handler required");
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.requestMatcher.matches(request)) {
            Optional<String> requestIdentifier = applicationCookieService.getCookieValue(request, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
            if (requestIdentifier.isPresent()) {
                String identifier = requestIdentifier.get();
                LogoutRequest logoutRequest = this.logoutRequestManager.get(identifier);
                if (logoutRequest == null) {
                    logger.warn("SAML 2 Logout Request [{}] not found", (Object)identifier);
                } else {
                    String userIdentity = logoutRequest.getMappedUserIdentity();
                    LogoutAuthenticationToken authentication = new LogoutAuthenticationToken(userIdentity);
                    this.logoutSuccessHandler.onLogoutSuccess(request, response, (Authentication)authentication);
                }
            } else {
                logger.warn("SAML 2 Logout Request cookie not found");
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

