/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.csrf;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.nifi.web.security.csrf.CsrfCookieRequestMatcher;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class SkipReplicatedCsrfFilter
extends OncePerRequestFilter {
    protected static final String REPLICATED_REQUEST_HEADER = "request-transaction-id";
    private static final RequestMatcher REQUEST_MATCHER = new AndRequestMatcher(new RequestMatcher[]{new RequestHeaderRequestMatcher("request-transaction-id"), new NegatedRequestMatcher((RequestMatcher)new CsrfCookieRequestMatcher())});

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (REQUEST_MATCHER.matches(request)) {
            CsrfFilter.skipRequest((HttpServletRequest)request);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

