/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import jakarta.ws.rs.WebApplicationException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.status.analytics.StatusAnalytics;
import org.apache.nifi.prometheusutil.ConnectionAnalyticsMetricsRegistry;
import org.apache.nifi.prometheusutil.PrometheusMetricsUtil;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.controller.ControllerFacade;
import org.apache.nifi.web.util.PredictionBasedParallelProcessingService;

public class VirtualThreadParallelProcessingService
implements PredictionBasedParallelProcessingService,
Closeable {
    private boolean analyticsEnabled;
    private ExecutorService parallelProcessingExecutorService;
    private long parallelProcessingTimeout;

    public VirtualThreadParallelProcessingService(NiFiProperties properties) {
        this.parallelProcessingTimeout = Math.round(FormatUtils.getPreciseTimeDuration((String)properties.getProperty("nifi.web.request.timeout", "1 min"), (TimeUnit)TimeUnit.MILLISECONDS)) - 5000L;
        this.analyticsEnabled = Boolean.parseBoolean(properties.getProperty("nifi.analytics.predict.enabled", Boolean.FALSE.toString()));
        if (this.analyticsEnabled) {
            this.parallelProcessingExecutorService = Executors.newVirtualThreadPerTaskExecutor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Map<String, Long>> createConnectionStatusAnalyticsMetricsAndCollectPredictions(ControllerFacade controllerFacade, ConnectionAnalyticsMetricsRegistry connectionAnalyticsMetricsRegistry, String instanceId) {
        List<Map<String, Long>> predictions = Collections.synchronizedList(new ArrayList());
        if (!this.analyticsEnabled) {
            return predictions;
        }
        Set connections = controllerFacade.getFlowManager().findAllConnections();
        CountDownLatch countDownLatch = new CountDownLatch(connections.size());
        try {
            for (Connection c : connections) {
                this.parallelProcessingExecutorService.execute(() -> {
                    try {
                        StatusAnalytics statusAnalytics = controllerFacade.getConnectionStatusAnalytics(c.getIdentifier());
                        PrometheusMetricsUtil.createConnectionStatusAnalyticsMetrics((ConnectionAnalyticsMetricsRegistry)connectionAnalyticsMetricsRegistry, (StatusAnalytics)statusAnalytics, (String)instanceId, (String)"Connection", (String)c.getName(), (String)c.getIdentifier(), (String)c.getProcessGroup().getIdentifier(), (String)c.getSource().getName(), (String)c.getSource().getIdentifier(), (String)c.getDestination().getName(), (String)c.getDestination().getIdentifier());
                        predictions.add(statusAnalytics.getPredictions());
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
        }
        finally {
            try {
                boolean finished = countDownLatch.await(this.parallelProcessingTimeout, TimeUnit.MILLISECONDS);
                if (!finished) {
                    throw new WebApplicationException("Populating flow metrics timed out");
                }
            }
            catch (InterruptedException e) {
                throw new WebApplicationException("Populating flow metrics cancelled");
            }
        }
        return predictions;
    }

    @Override
    public void close() throws IOException {
        if (this.parallelProcessingExecutorService != null) {
            this.parallelProcessingExecutorService.close();
        }
    }
}

