/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.nifi.web.util.Interval;
import org.apache.nifi.web.util.IntervalFactory;
import org.apache.nifi.web.util.PaginationHelper;

public class PaginationHelper {
    public static <T, E> List<T> paginateByContainedItems(Iterable<T> original, int offset, int limit, Function<T, List<E>> getContainedItems, BiFunction<T, List<E>, T> createPartialItem) {
        Objects.requireNonNull(original);
        Objects.requireNonNull(getContainedItems);
        Objects.requireNonNull(createPartialItem);
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("Limit cannot be negative");
        }
        LinkedList<Object> result = new LinkedList<Object>();
        int higherBoundary = limit == 0 ? 0 : offset + limit;
        Interval interval = IntervalFactory.getClosedOpenInterval((int)offset, (int)higherBoundary);
        int pointer = 0;
        if (offset == 0 && limit == 0) {
            original.forEach(result::add);
            return result;
        }
        for (Object object : original) {
            List<E> containedItems = getContainedItems.apply(object);
            Interval.RelativePosition position = interval.getRelativePositionOf(pointer, pointer + containedItems.size());
            switch (1.$SwitchMap$org$apache$nifi$web$util$Interval$RelativePosition[position.ordinal()]) {
                case 1: {
                    pointer += containedItems.size();
                    break;
                }
                case 2: {
                    int startingPoint = offset - pointer;
                    List<E> partialItems = containedItems.subList(startingPoint, limit + 1);
                    T partial = createPartialItem.apply(object, partialItems);
                    result.add(partial);
                    pointer += startingPoint + partialItems.size();
                    break;
                }
                case 3: {
                    List<E> partialItems = containedItems.subList(offset - pointer, containedItems.size());
                    T partial = createPartialItem.apply(object, partialItems);
                    result.add(partial);
                    pointer += containedItems.size();
                    break;
                }
                case 4: {
                    result.add(object);
                    pointer += containedItems.size();
                    break;
                }
                case 5: {
                    List<E> partialItems = containedItems.subList(0, limit + offset - pointer);
                    T partial = createPartialItem.apply(object, partialItems);
                    result.add(partial);
                    pointer += partialItems.size();
                    break;
                }
            }
        }
        return result;
    }
}

