/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.resultenrichment;

import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.api.dto.search.SearchResultGroupDTO;
import org.apache.nifi.web.search.resultenrichment.ComponentSearchResultEnricher;

abstract class AbstractComponentSearchResultEnricher
implements ComponentSearchResultEnricher {
    protected final ProcessGroup processGroup;
    protected final NiFiUser user;
    protected final Authorizer authorizer;

    AbstractComponentSearchResultEnricher(ProcessGroup processGroup, NiFiUser user, Authorizer authorizer) {
        this.processGroup = processGroup;
        this.user = user;
        this.authorizer = authorizer;
    }

    protected SearchResultGroupDTO buildVersionedGroup(ProcessGroup group, NiFiUser user) {
        if (group == null) {
            return null;
        }
        ProcessGroup current = group;
        while (!current.isRootGroup()) {
            if (current.getVersionControlInformation() != null) {
                return this.buildResultGroup(current, user);
            }
            current = current.getParent();
        }
        return null;
    }

    protected SearchResultGroupDTO buildResultGroup(ProcessGroup group, NiFiUser user) {
        if (group == null) {
            return null;
        }
        SearchResultGroupDTO resultGroup = new SearchResultGroupDTO();
        resultGroup.setId(group.getIdentifier());
        if (group.isAuthorized(this.authorizer, RequestAction.READ, user)) {
            resultGroup.setName(group.getName());
        }
        return resultGroup;
    }
}

