/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.attributematchers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;

public class PropertyMatcher<T extends ComponentNode>
implements AttributeMatcher<T> {
    private static final String LABEL_NAME = "Property name";
    private static final String LABEL_VALUE = "Property value";
    private static final String LABEL_DESCRIPTION = "Property description";
    private static final String FILTER_NAME_PROPERTIES = "properties";
    private static final Set<String> FILTER_VALUES_PROPERTIES_EXCLUSION = new HashSet<String>(Arrays.asList("no", "none", "false", "exclude", "0"));

    public void match(T component, SearchQuery query, List<String> matches) {
        String searchTerm = query.getTerm();
        if (!this.propertiesAreFilteredOut(query)) {
            for (Map.Entry entry : component.getRawPropertyValues().entrySet()) {
                String value;
                PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
                AttributeMatcher.addIfMatching((String)searchTerm, (String)descriptor.getName(), (String)LABEL_NAME, matches);
                AttributeMatcher.addIfMatching((String)searchTerm, (String)descriptor.getDescription(), (String)LABEL_DESCRIPTION, matches);
                if (descriptor.isSensitive() || !StringUtils.containsIgnoreCase((CharSequence)(value = Optional.ofNullable((String)entry.getValue()).orElse(descriptor.getDefaultValue())), (CharSequence)searchTerm)) continue;
                matches.add("Property value: " + descriptor.getName() + " - " + value);
            }
        }
    }

    private boolean propertiesAreFilteredOut(SearchQuery query) {
        return query.hasFilter(FILTER_NAME_PROPERTIES) && FILTER_VALUES_PROPERTIES_EXCLUSION.contains(query.getFilter(FILTER_NAME_PROPERTIES));
    }
}

