/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ParametersApplication;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.exception.ValidationException;
import org.apache.nifi.controller.parameter.ParameterProviderInstantiationException;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.logging.repository.NopLogRepository;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.ParameterGroupConfiguration;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ConfigVerificationResultDTO;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.dao.ComponentStateDAO;
import org.apache.nifi.web.dao.ParameterProviderDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class StandardParameterProviderDAO
extends ComponentDAO
implements ParameterProviderDAO {
    private ComponentStateDAO componentStateDAO;
    private ReloadComponent reloadComponent;
    private FlowController flowController;

    private ParameterProviderNode locateParameterProvider(String parameterProviderId) {
        ParameterProviderNode parameterProvider = this.flowController.getFlowManager().getParameterProvider(parameterProviderId);
        if (parameterProvider == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate parameter provider with id '%s'.", parameterProviderId));
        }
        return parameterProvider;
    }

    public void verifyCreate(ParameterProviderDTO parameterProviderDTO) {
        this.verifyCreate(this.flowController.getExtensionManager(), parameterProviderDTO.getType(), parameterProviderDTO.getBundle());
    }

    public ParameterProviderNode createParameterProvider(ParameterProviderDTO parameterProviderDTO) {
        if (parameterProviderDTO.getType() == null) {
            throw new IllegalArgumentException("The parameter provider type must be specified.");
        }
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        BundleCoordinate bundleCoordinate = BundleUtils.getBundle((ExtensionManager)extensionManager, (String)parameterProviderDTO.getType(), (BundleDTO)parameterProviderDTO.getBundle());
        ParameterProviderNode parameterProvider = this.flowController.getFlowManager().createParameterProvider(parameterProviderDTO.getType(), parameterProviderDTO.getId(), bundleCoordinate, true);
        this.verifyUpdate(parameterProvider, parameterProviderDTO);
        this.configureParameterProvider(parameterProvider, parameterProviderDTO);
        return parameterProvider;
    }

    public ParameterProviderNode getParameterProvider(String parameterProviderId) {
        return this.locateParameterProvider(parameterProviderId);
    }

    public boolean hasParameterProvider(String parameterProviderId) {
        return this.flowController.getFlowManager().getParameterProvider(parameterProviderId) != null;
    }

    public Set<ParameterProviderNode> getParameterProviders() {
        return this.flowController.getFlowManager().getAllParameterProviders();
    }

    public ParameterProviderNode updateParameterProvider(ParameterProviderDTO parameterProviderDTO) {
        ParameterProviderNode parameterProvider = this.locateParameterProvider(parameterProviderDTO.getId());
        this.verifyUpdate(parameterProvider, parameterProviderDTO);
        this.configureParameterProvider(parameterProvider, parameterProviderDTO);
        this.updateBundle(parameterProvider, parameterProviderDTO);
        return parameterProvider;
    }

    public ParameterProviderNode fetchParameters(String parameterProviderId) {
        ParameterProviderNode parameterProviderNode = this.locateParameterProvider(parameterProviderId);
        parameterProviderNode.fetchParameters();
        return parameterProviderNode;
    }

    public void verifyCanApplyParameters(String parameterProviderId, Collection<ParameterGroupConfiguration> parameterNames) {
        ParameterProviderNode parameterProviderNode = this.locateParameterProvider(parameterProviderId);
        parameterProviderNode.verifyCanApplyParameters(parameterNames);
    }

    public List<ParametersApplication> getFetchedParametersToApply(String parameterProviderId, Collection<ParameterGroupConfiguration> parameterNames) {
        ParameterProviderNode parameterProviderNode = this.locateParameterProvider(parameterProviderId);
        return parameterProviderNode.getFetchedParametersToApply(parameterNames);
    }

    private void updateBundle(ParameterProviderNode parameterProvider, ParameterProviderDTO parameterProviderDTO) {
        BundleDTO bundleDTO = parameterProviderDTO.getBundle();
        if (bundleDTO != null) {
            ExtensionManager extensionManager = this.flowController.getExtensionManager();
            BundleCoordinate incomingCoordinate = BundleUtils.getBundle((ExtensionManager)extensionManager, (String)parameterProvider.getCanonicalClassName(), (BundleDTO)bundleDTO);
            BundleCoordinate existingCoordinate = parameterProvider.getBundleCoordinate();
            if (!existingCoordinate.getCoordinate().equals(incomingCoordinate.getCoordinate())) {
                try {
                    ConfigurableComponent tempComponent = extensionManager.getTempComponent(parameterProvider.getCanonicalClassName(), incomingCoordinate);
                    Set additionalUrls = parameterProvider.getAdditionalClasspathResources(tempComponent.getPropertyDescriptors());
                    this.reloadComponent.reload(parameterProvider, parameterProvider.getCanonicalClassName(), incomingCoordinate, additionalUrls);
                }
                catch (ParameterProviderInstantiationException e) {
                    throw new NiFiCoreException(String.format("Unable to update parameter provider %s from %s to %s due to: %s", parameterProviderDTO.getId(), parameterProvider.getBundleCoordinate().getCoordinate(), incomingCoordinate.getCoordinate(), e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private List<String> validateProposedConfiguration(ParameterProviderNode parameterProvider, ParameterProviderDTO parameterProviderDTO) {
        return Collections.emptyList();
    }

    public void verifyDelete(String parameterProviderId) {
        ParameterProviderNode parameterProviderNode = this.locateParameterProvider(parameterProviderId);
        parameterProviderNode.verifyCanDelete();
    }

    public void verifyCanFetchParameters(String parameterProviderId) {
        ParameterProviderNode parameterProviderNode = this.locateParameterProvider(parameterProviderId);
        parameterProviderNode.verifyCanFetchParameters();
    }

    public void verifyUpdate(ParameterProviderDTO parameterProviderDTO) {
        ParameterProviderNode parameterProvider = this.locateParameterProvider(parameterProviderDTO.getId());
        this.verifyUpdate(parameterProvider, parameterProviderDTO);
    }

    private void verifyUpdate(ParameterProviderNode parameterProvider, ParameterProviderDTO parameterProviderDTO) {
        List requestValidation;
        if (this.isAnyNotNull(new Object[]{parameterProviderDTO.getName(), parameterProviderDTO.getAnnotationData(), parameterProviderDTO.getProperties(), parameterProviderDTO.getBundle()}) && !(requestValidation = this.validateProposedConfiguration(parameterProvider, parameterProviderDTO)).isEmpty()) {
            throw new ValidationException(requestValidation);
        }
        BundleDTO bundleDTO = parameterProviderDTO.getBundle();
        if (bundleDTO != null) {
            BundleCoordinate bundleCoordinate = BundleUtils.getBundle((ExtensionManager)this.flowController.getExtensionManager(), (String)parameterProvider.getCanonicalClassName(), (BundleDTO)bundleDTO);
            parameterProvider.verifyCanUpdateBundle(bundleCoordinate);
        }
    }

    public void verifyConfigVerification(String parameterProviderId) {
        this.locateParameterProvider(parameterProviderId);
    }

    public List<ConfigVerificationResultDTO> verifyConfiguration(String parameterProviderId, Map<String, String> properties) {
        ParameterProviderNode parameterProviderNode = this.locateParameterProvider(parameterProviderId);
        NopLogRepository logRepository = new NopLogRepository();
        SimpleProcessLogger configVerificationLog = new SimpleProcessLogger((Object)parameterProviderNode.getParameterProvider(), (LogRepository)logRepository, (LoggingContext)new StandardLoggingContext(null));
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        ParameterLookup parameterLookup = ParameterLookup.EMPTY;
        StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)parameterProviderNode, properties, parameterProviderNode.getAnnotationData(), parameterLookup, (ControllerServiceLookup)this.flowController.getControllerServiceProvider(), null);
        List verificationResults = parameterProviderNode.verifyConfiguration((ConfigurationContext)configurationContext, (ComponentLog)configVerificationLog, extensionManager);
        List<ConfigVerificationResultDTO> resultsDtos = verificationResults.stream().map(arg_0 -> this.createConfigVerificationResultDto(arg_0)).collect(Collectors.toList());
        return resultsDtos;
    }

    private ConfigVerificationResultDTO createConfigVerificationResultDto(ConfigVerificationResult result) {
        ConfigVerificationResultDTO dto = new ConfigVerificationResultDTO();
        dto.setExplanation(result.getExplanation());
        dto.setOutcome(result.getOutcome().name());
        dto.setVerificationStepName(result.getVerificationStepName());
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureParameterProvider(ParameterProviderNode parameterProvider, ParameterProviderDTO parameterProviderDTO) {
        String name = parameterProviderDTO.getName();
        String annotationData = parameterProviderDTO.getAnnotationData();
        String comments = parameterProviderDTO.getComments();
        Map properties = parameterProviderDTO.getProperties();
        parameterProvider.pauseValidationTrigger();
        try {
            if (this.isNotNull((Object)name)) {
                parameterProvider.setName(name);
            }
            if (this.isNotNull((Object)annotationData)) {
                parameterProvider.setAnnotationData(annotationData);
            }
            if (this.isNotNull((Object)comments)) {
                parameterProvider.setComments(comments);
            }
            if (this.isNotNull((Object)properties)) {
                parameterProvider.setProperties(properties);
            }
        }
        finally {
            parameterProvider.resumeValidationTrigger();
        }
    }

    public StateMap getState(String parameterProviderId, Scope scope) {
        ParameterProviderNode parameterProvider = this.locateParameterProvider(parameterProviderId);
        return this.componentStateDAO.getState(parameterProvider, scope);
    }

    public void verifyClearState(String parameterProviderId) {
        ParameterProviderNode parameterProvider = this.locateParameterProvider(parameterProviderId);
        parameterProvider.verifyCanClearState();
    }

    public void clearState(String parameterProviderId) {
        ParameterProviderNode parameterProvider = this.locateParameterProvider(parameterProviderId);
        this.componentStateDAO.clearState(parameterProvider);
    }

    public void deleteParameterProvider(String parameterProviderId) {
        ParameterProviderNode parameterProvider = this.locateParameterProvider(parameterProviderId);
        this.flowController.getFlowManager().removeParameterProvider(parameterProvider);
    }

    @Autowired
    public void setComponentStateDAO(ComponentStateDAO componentStateDAO) {
        this.componentStateDAO = componentStateDAO;
    }

    @Autowired
    public void setReloadComponent(ReloadComponent reloadComponent) {
        this.reloadComponent = reloadComponent;
    }

    @Autowired
    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

