/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.io.IOException;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.dao.ComponentStateDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class StandardComponentStateDAO
implements ComponentStateDAO {
    private StateManagerProvider stateManagerProvider;

    private StateMap getState(String componentId, Scope scope) {
        try {
            StateManager manager = this.stateManagerProvider.getStateManager(componentId);
            if (manager == null) {
                throw new ResourceNotFoundException(String.format("State for the specified component %s could not be found.", componentId));
            }
            return manager.getState(scope);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(String.format("Unable to get the state for the specified component %s: %s", componentId, ioe), ioe);
        }
    }

    private void clearState(String componentId) {
        try {
            StateManager manager = this.stateManagerProvider.getStateManager(componentId);
            if (manager == null) {
                throw new ResourceNotFoundException(String.format("State for the specified component %s could not be found.", componentId));
            }
            manager.clear(Scope.CLUSTER);
            manager.clear(Scope.LOCAL);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(String.format("Unable to clear the state for the specified component %s: %s", componentId, ioe), ioe);
        }
    }

    public StateMap getState(ProcessorNode processor, Scope scope) {
        return this.getState(processor.getIdentifier(), scope);
    }

    public void clearState(ProcessorNode processor) {
        this.clearState(processor.getIdentifier());
    }

    public StateMap getState(ControllerServiceNode controllerService, Scope scope) {
        return this.getState(controllerService.getIdentifier(), scope);
    }

    public void clearState(ControllerServiceNode controllerService) {
        this.clearState(controllerService.getIdentifier());
    }

    public StateMap getState(ReportingTaskNode reportingTask, Scope scope) {
        return this.getState(reportingTask.getIdentifier(), scope);
    }

    public void clearState(ReportingTaskNode reportingTask) {
        this.clearState(reportingTask.getIdentifier());
    }

    public StateMap getState(FlowAnalysisRuleNode flowAnalysisRule, Scope scope) {
        return this.getState(flowAnalysisRule.getIdentifier(), scope);
    }

    public void clearState(FlowAnalysisRuleNode flowAnalysisRule) {
        this.clearState(flowAnalysisRule.getIdentifier());
    }

    public StateMap getState(ParameterProviderNode parameterProvider, Scope scope) {
        return this.getState(parameterProvider.getIdentifier(), scope);
    }

    public void clearState(ParameterProviderNode parameterProvider) {
        this.clearState(parameterProvider.getIdentifier());
    }

    public StateMap getState(RemoteProcessGroup remoteProcessGroup, Scope scope) {
        return this.getState(remoteProcessGroup.getIdentifier(), scope);
    }

    @Autowired
    public void setStateManagerProvider(StateManagerProvider stateManagerProvider) {
        this.stateManagerProvider = stateManagerProvider;
    }
}

