/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.configuration;

import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.StandardAuthorizableLookup;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.StandardReloadComponent;
import org.apache.nifi.controller.reporting.ReportingTaskProvider;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.manifest.RuntimeManifestService;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.ContentAccess;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.NiFiServiceFacadeLock;
import org.apache.nifi.web.NiFiWebConfigurationContext;
import org.apache.nifi.web.StandardNiFiContentAccess;
import org.apache.nifi.web.StandardNiFiServiceFacade;
import org.apache.nifi.web.StandardNiFiWebConfigurationContext;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.EntityFactory;
import org.apache.nifi.web.api.metrics.jmx.JmxMetricsCollector;
import org.apache.nifi.web.api.metrics.jmx.JmxMetricsResultConverter;
import org.apache.nifi.web.api.metrics.jmx.JmxMetricsService;
import org.apache.nifi.web.api.metrics.jmx.StandardJmxMetricsService;
import org.apache.nifi.web.controller.ControllerFacade;
import org.apache.nifi.web.controller.ControllerSearchService;
import org.apache.nifi.web.dao.AccessPolicyDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.apache.nifi.web.revision.RevisionManager;
import org.apache.nifi.web.search.query.RegexSearchQueryParser;
import org.apache.nifi.web.search.query.SearchQueryParser;
import org.apache.nifi.web.util.ClusterReplicationComponentLifecycle;
import org.apache.nifi.web.util.LocalComponentLifecycle;
import org.apache.nifi.web.util.ParameterContextNameCollisionResolver;
import org.apache.nifi.web.util.ParameterContextReplacer;
import org.apache.nifi.web.util.SnippetUtils;
import org.apache.nifi.web.util.VirtualThreadParallelProcessingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;

@ComponentScan(basePackageClasses={ComponentDAO.class, NiFiAuditor.class, ApplicationResource.class})
@Import(value={StandardAuthorizableLookup.class, StandardNiFiServiceFacade.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
@Configuration
public class WebApplicationConfiguration {
    private final Authorizer authorizer;
    private final AccessPolicyDAO accessPolicyDao;
    private final AuditService auditService;
    private final BulletinRepository bulletinRepository;
    private final ExtensionManager extensionManager;
    private final FlowController flowController;
    private final FlowService flowService;
    private final NiFiProperties properties;
    private final RevisionManager revisionManager;
    private final RuntimeManifestService runtimeManifestService;
    private final ControllerSearchService controllerSearchService;
    private ClusterCoordinator clusterCoordinator;
    private RequestReplicator requestReplicator;
    private NiFiServiceFacade serviceFacade;

    public WebApplicationConfiguration(Authorizer authorizer, AccessPolicyDAO accessPolicyDao, AuditService auditService, BulletinRepository bulletinRepository, ExtensionManager extensionManager, FlowController flowController, FlowService flowService, NiFiProperties properties, RevisionManager revisionManager, RuntimeManifestService runtimeManifestService, ControllerSearchService controllerSearchService) {
        this.authorizer = authorizer;
        this.accessPolicyDao = accessPolicyDao;
        this.auditService = auditService;
        this.bulletinRepository = bulletinRepository;
        this.extensionManager = extensionManager;
        this.flowController = flowController;
        this.flowService = flowService;
        this.properties = properties;
        this.revisionManager = revisionManager;
        this.runtimeManifestService = runtimeManifestService;
        this.controllerSearchService = controllerSearchService;
    }

    @Autowired(required=false)
    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    @Autowired(required=false)
    public void setRequestReplicator(RequestReplicator requestReplicator) {
        this.requestReplicator = requestReplicator;
    }

    @Autowired
    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    @Bean
    public EntityFactory entityFactory() {
        return new EntityFactory();
    }

    @Bean
    public ContentAccess contentAccess() {
        StandardNiFiContentAccess contentAccess = new StandardNiFiContentAccess();
        contentAccess.setClusterCoordinator(this.clusterCoordinator);
        contentAccess.setProperties(this.properties);
        contentAccess.setRequestReplicator(this.requestReplicator);
        contentAccess.setServiceFacade(this.serviceFacade);
        return contentAccess;
    }

    @Bean
    public DtoFactory dtoFactory() {
        DtoFactory dtoFactory = new DtoFactory();
        dtoFactory.setAuthorizer(this.authorizer);
        dtoFactory.setBulletinRepository(this.bulletinRepository);
        dtoFactory.setControllerServiceProvider(this.flowController.getControllerServiceProvider());
        dtoFactory.setEntityFactory(this.entityFactory());
        dtoFactory.setExtensionManager(this.extensionManager);
        return dtoFactory;
    }

    @Bean
    public ControllerServiceProvider controllerServiceProvider() {
        return this.flowController.getControllerServiceProvider();
    }

    @Bean
    public SnippetUtils snippetUtils() {
        SnippetUtils snippetUtils = new SnippetUtils();
        snippetUtils.setDtoFactory(this.dtoFactory());
        snippetUtils.setFlowController(this.flowController);
        snippetUtils.setAccessPolicyDAO(this.accessPolicyDao);
        return snippetUtils;
    }

    @Bean
    public NiFiServiceFacadeLock serviceFacadeLock() {
        return new NiFiServiceFacadeLock();
    }

    @Bean
    public ClusterReplicationComponentLifecycle clusterComponentLifecycle() {
        ClusterReplicationComponentLifecycle lifecycle = new ClusterReplicationComponentLifecycle();
        lifecycle.setClusterCoordinator(this.clusterCoordinator);
        lifecycle.setDtoFactory(this.dtoFactory());
        lifecycle.setRequestReplicator(this.requestReplicator);
        lifecycle.setServiceFacade(this.serviceFacade);
        return lifecycle;
    }

    @Bean
    public LocalComponentLifecycle localComponentLifecycle() {
        LocalComponentLifecycle lifecycle = new LocalComponentLifecycle();
        lifecycle.setDtoFactory(this.dtoFactory());
        lifecycle.setServiceFacade(this.serviceFacade);
        lifecycle.setRevisionManager(this.revisionManager);
        return lifecycle;
    }

    @Bean
    public VirtualThreadParallelProcessingService parallelProcessingService() {
        return new VirtualThreadParallelProcessingService(this.properties);
    }

    @Bean
    public JmxMetricsService jmxMetricsService() {
        JmxMetricsResultConverter metricsResultConverter = new JmxMetricsResultConverter();
        JmxMetricsCollector metricsCollector = new JmxMetricsCollector(metricsResultConverter);
        StandardJmxMetricsService jmxMetricsService = new StandardJmxMetricsService();
        jmxMetricsService.setMetricsCollector(metricsCollector);
        jmxMetricsService.setProperties(this.properties);
        return jmxMetricsService;
    }

    @Bean
    public ParameterContextReplacer parameterContextReplacer() {
        ParameterContextNameCollisionResolver nameCollisionResolver = new ParameterContextNameCollisionResolver();
        return new ParameterContextReplacer(nameCollisionResolver);
    }

    @Bean
    public RegexSearchQueryParser searchQueryParser() {
        return new RegexSearchQueryParser();
    }

    @Bean
    public StandardReloadComponent reloadComponent() {
        return new StandardReloadComponent(this.flowController);
    }

    @Bean
    public NiFiWebConfigurationContext nifiWebConfigurationContext() {
        StandardNiFiWebConfigurationContext context = new StandardNiFiWebConfigurationContext();
        context.setAuthorizer(this.authorizer);
        context.setAuditService(this.auditService);
        context.setProperties(this.properties);
        context.setClusterCoordinator(this.clusterCoordinator);
        context.setControllerServiceProvider(this.flowController.getControllerServiceProvider());
        context.setRequestReplicator(this.requestReplicator);
        context.setReportingTaskProvider((ReportingTaskProvider)this.flowController);
        context.setServiceFacade(this.serviceFacade);
        return context;
    }

    @Bean
    public ControllerFacade controllerFacade() {
        ControllerFacade controllerFacade = new ControllerFacade();
        controllerFacade.setAuthorizer(this.authorizer);
        controllerFacade.setFlowController(this.flowController);
        controllerFacade.setDtoFactory(this.dtoFactory());
        controllerFacade.setProperties(this.properties);
        controllerFacade.setFlowService(this.flowService);
        controllerFacade.setRuntimeManifestService(this.runtimeManifestService);
        controllerFacade.setControllerSearchService(this.controllerSearchService);
        controllerFacade.setSearchQueryParser((SearchQueryParser)this.searchQueryParser());
        return controllerFacade;
    }
}

