/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.streaming;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.nifi.web.api.streaming.ByteRange;
import org.apache.nifi.web.api.streaming.ByteRangeParser;
import org.apache.nifi.web.api.streaming.ByteRangeStreamingOutput;
import org.apache.nifi.web.api.streaming.InputStreamingOutput;
import org.apache.nifi.web.api.streaming.StandardByteRangeParser;

public class StreamingOutputResponseBuilder {
    static final String ACCEPT_RANGES_HEADER = "Accept-Ranges";
    static final String CONTENT_RANGE_HEADER = "Content-Range";
    private static final String BYTES_UNIT = "bytes";
    private static final String CONTENT_RANGE_BYTES = "bytes %d-%d/%d";
    private static final int LAST_POSITION_OFFSET = -1;
    private static final ByteRangeParser byteRangeParser = new StandardByteRangeParser();
    private final InputStream inputStream;
    private String range;
    private boolean acceptRanges;

    public StreamingOutputResponseBuilder(InputStream inputStream) {
        this.inputStream = Objects.requireNonNull(inputStream, "Input Stream required");
    }

    public StreamingOutputResponseBuilder range(String range) {
        this.range = range;
        this.acceptRanges = true;
        return this;
    }

    public Response.ResponseBuilder build() {
        Response.ResponseBuilder responseBuilder;
        Optional byteRangeFound = byteRangeParser.readByteRange(this.range);
        if (byteRangeFound.isPresent()) {
            int completeLength = this.getCompleteLength();
            ByteRange byteRange = (ByteRange)byteRangeFound.get();
            ByteRangeStreamingOutput streamingOutput = new ByteRangeStreamingOutput(this.inputStream, byteRange);
            responseBuilder = Response.status((Response.Status)Response.Status.PARTIAL_CONTENT).entity((Object)streamingOutput);
            String contentRange = this.getContentRange(byteRange, completeLength);
            responseBuilder.header(CONTENT_RANGE_HEADER, (Object)contentRange);
        } else {
            InputStreamingOutput streamingOutput = new InputStreamingOutput(this.inputStream);
            responseBuilder = Response.ok((Object)streamingOutput);
        }
        if (this.acceptRanges) {
            responseBuilder.header(ACCEPT_RANGES_HEADER, (Object)BYTES_UNIT);
        }
        return responseBuilder;
    }

    private int getCompleteLength() {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Complete Length read failed", e);
        }
    }

    private String getContentRange(ByteRange byteRange, int completeLength) {
        long lastPosition;
        OptionalLong lastPositionFound = byteRange.getLastPosition();
        OptionalLong firstPositionFound = byteRange.getFirstPosition();
        long lastPositionCompleteLength = completeLength - -1;
        if (lastPositionFound.isEmpty()) {
            lastPosition = lastPositionCompleteLength;
        } else {
            long lastPositionRequested = lastPositionFound.getAsLong();
            lastPosition = Math.min(lastPositionRequested, lastPositionCompleteLength);
        }
        long firstPosition = firstPositionFound.isEmpty() ? 0L : firstPositionFound.getAsLong();
        return CONTENT_RANGE_BYTES.formatted(firstPosition, lastPosition, completeLength);
    }
}

