/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.OperationAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.PortRunStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/output-ports")
@Tag(name="OutputPorts")
public class OutputPortResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public Set<PortEntity> populateRemainingOutputPortEntitiesContent(Set<PortEntity> outputPortEntities) {
        for (PortEntity outputPortEntity : outputPortEntities) {
            this.populateRemainingOutputPortEntityContent(outputPortEntity);
        }
        return outputPortEntities;
    }

    public PortEntity populateRemainingOutputPortEntityContent(PortEntity outputPortEntity) {
        outputPortEntity.setUri(this.generateResourceUri(new String[]{"output-ports", outputPortEntity.getId()}));
        return outputPortEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Gets an output port", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PortEntity.class))})}, security={@SecurityRequirement(name="Read - /output-ports/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getOutputPort(@Parameter(description="The output port id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable outputPort = lookup.getOutputPort(id);
            outputPort.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        PortEntity entity = this.serviceFacade.getOutputPort(id);
        this.populateRemainingOutputPortEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Updates an output port", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PortEntity.class))})}, security={@SecurityRequirement(name="Write - /output-ports/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateOutputPort(@Parameter(description="The output port id.", required=true) @PathParam(value="id") String id, @Parameter(description="The output port configuration details.", required=true) PortEntity requestPortEntity) {
        if (requestPortEntity == null || requestPortEntity.getComponent() == null) {
            throw new IllegalArgumentException("Output port details must be specified.");
        }
        if (requestPortEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        PortDTO requestPortDTO = requestPortEntity.getComponent();
        if (!id.equals(requestPortDTO.getId())) {
            throw new IllegalArgumentException(String.format("The output port id (%s) in the request body does not equal the output port id of the requested resource (%s).", requestPortDTO.getId(), id));
        }
        PositionDTO proposedPosition = requestPortDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestPortEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestPortEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestPortEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestPortEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getOutputPort(id);
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateOutputPort(requestPortDTO), (revision, portEntity) -> {
            PortDTO portDTO = portEntity.getComponent();
            PortEntity entity = this.serviceFacade.updateOutputPort(revision, portDTO);
            this.populateRemainingOutputPortEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Deletes an output port", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PortEntity.class))})}, security={@SecurityRequirement(name="Write - /output-ports/{uuid}"), @SecurityRequirement(name="Write - Parent Process Group - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response removeOutputPort(@Parameter(description="The revision is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The output port id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        PortEntity requestPortEntity = new PortEntity();
        requestPortEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestPortEntity, requestRevision, lookup -> {
            Authorizable outputPort = lookup.getOutputPort(id);
            outputPort.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            outputPort.getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyDeleteOutputPort(id), (revision, portEntity) -> {
            PortEntity entity = this.serviceFacade.deleteOutputPort(revision, portEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/run-status")
    @Operation(summary="Updates run status of an output-port", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorEntity.class))})}, security={@SecurityRequirement(name="Write - /output-ports/{uuid} or /operation/output-ports/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateRunStatus(@Parameter(description="The port id.", required=true) @PathParam(value="id") String id, @Parameter(description="The port run status.", required=true) PortRunStatusEntity requestRunStatus) {
        if (requestRunStatus == null) {
            throw new IllegalArgumentException("Port run status must be specified.");
        }
        if (requestRunStatus.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        requestRunStatus.validateState();
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRunStatus);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRunStatus.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestRunStatus.getRevision(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRunStatus, requestRevision, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Authorizable authorizable = lookup.getOutputPort(id);
            OperationAuthorizable.authorizeOperation((Authorizable)authorizable, (Authorizer)this.authorizer, (NiFiUser)user);
        }, () -> this.serviceFacade.verifyUpdateOutputPort(this.createDTOWithDesiredRunStatus(id, requestRunStatus.getState())), (revision, runStatusEntity) -> {
            PortEntity entity = this.serviceFacade.updateOutputPort(revision, this.createDTOWithDesiredRunStatus(id, runStatusEntity.getState()));
            this.populateRemainingOutputPortEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    private PortDTO createDTOWithDesiredRunStatus(String id, String runStatus) {
        PortDTO dto = new PortDTO();
        dto.setId(id);
        dto.setState(runStatus);
        return dto;
    }

    @Autowired
    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    @Autowired
    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

