/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.text.Collator;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.OperationAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.c2.protocol.component.api.ControllerServiceDefinition;
import org.apache.nifi.c2.protocol.component.api.FlowAnalysisRuleDefinition;
import org.apache.nifi.c2.protocol.component.api.ParameterProviderDefinition;
import org.apache.nifi.c2.protocol.component.api.ProcessorDefinition;
import org.apache.nifi.c2.protocol.component.api.ReportingTaskDefinition;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.flow.VersionedReportingTaskSnapshot;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.FlowVersionLocation;
import org.apache.nifi.web.IllegalClusterResourceRequestException;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ConnectionResource;
import org.apache.nifi.web.api.ControllerServiceResource;
import org.apache.nifi.web.api.FunnelResource;
import org.apache.nifi.web.api.InputPortResource;
import org.apache.nifi.web.api.LabelResource;
import org.apache.nifi.web.api.OutputPortResource;
import org.apache.nifi.web.api.ParameterProviderResource;
import org.apache.nifi.web.api.ProcessGroupResource;
import org.apache.nifi.web.api.ProcessorResource;
import org.apache.nifi.web.api.RemoteProcessGroupResource;
import org.apache.nifi.web.api.ReportingTaskResource;
import org.apache.nifi.web.api.dto.AboutDTO;
import org.apache.nifi.web.api.dto.BannerDTO;
import org.apache.nifi.web.api.dto.BulletinBoardDTO;
import org.apache.nifi.web.api.dto.BulletinQueryDTO;
import org.apache.nifi.web.api.dto.ClusterDTO;
import org.apache.nifi.web.api.dto.ClusterSummaryDTO;
import org.apache.nifi.web.api.dto.ComponentDifferenceDTO;
import org.apache.nifi.web.api.dto.ContentViewerDTO;
import org.apache.nifi.web.api.dto.DifferenceDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.SupportedMimeTypesDTO;
import org.apache.nifi.web.api.dto.action.HistoryDTO;
import org.apache.nifi.web.api.dto.action.HistoryQueryDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.flow.ProcessGroupFlowDTO;
import org.apache.nifi.web.api.dto.search.NodeSearchResultDTO;
import org.apache.nifi.web.api.dto.search.SearchResultsDTO;
import org.apache.nifi.web.api.dto.status.ControllerStatusDTO;
import org.apache.nifi.web.api.entity.AboutEntity;
import org.apache.nifi.web.api.entity.ActionEntity;
import org.apache.nifi.web.api.entity.ActivateControllerServicesEntity;
import org.apache.nifi.web.api.entity.AdditionalDetailsEntity;
import org.apache.nifi.web.api.entity.BannerEntity;
import org.apache.nifi.web.api.entity.BulletinBoardEntity;
import org.apache.nifi.web.api.entity.ClusterSearchResultsEntity;
import org.apache.nifi.web.api.entity.ClusterSummaryEntity;
import org.apache.nifi.web.api.entity.ComponentHistoryEntity;
import org.apache.nifi.web.api.entity.ConnectionStatisticsEntity;
import org.apache.nifi.web.api.entity.ConnectionStatusEntity;
import org.apache.nifi.web.api.entity.ContentViewerEntity;
import org.apache.nifi.web.api.entity.ControllerBulletinsEntity;
import org.apache.nifi.web.api.entity.ControllerServiceTypesEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;
import org.apache.nifi.web.api.entity.ControllerStatusEntity;
import org.apache.nifi.web.api.entity.CurrentUserEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowAnalysisResultEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleTypesEntity;
import org.apache.nifi.web.api.entity.FlowBreadcrumbEntity;
import org.apache.nifi.web.api.entity.FlowComparisonEntity;
import org.apache.nifi.web.api.entity.FlowConfigurationEntity;
import org.apache.nifi.web.api.entity.FlowRegistryBranchesEntity;
import org.apache.nifi.web.api.entity.FlowRegistryBucketEntity;
import org.apache.nifi.web.api.entity.FlowRegistryBucketsEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientsEntity;
import org.apache.nifi.web.api.entity.HistoryEntity;
import org.apache.nifi.web.api.entity.ParameterContextsEntity;
import org.apache.nifi.web.api.entity.ParameterProviderTypesEntity;
import org.apache.nifi.web.api.entity.ParameterProvidersEntity;
import org.apache.nifi.web.api.entity.PortStatusEntity;
import org.apache.nifi.web.api.entity.PrioritizerTypesEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorTypesEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ReportingTaskTypesEntity;
import org.apache.nifi.web.api.entity.ReportingTasksEntity;
import org.apache.nifi.web.api.entity.RuntimeManifestEntity;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;
import org.apache.nifi.web.api.entity.SearchResultsEntity;
import org.apache.nifi.web.api.entity.StatusHistoryEntity;
import org.apache.nifi.web.api.entity.VersionedFlowEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;
import org.apache.nifi.web.api.entity.VersionedFlowsEntity;
import org.apache.nifi.web.api.metrics.JsonFormatPrometheusMetricsWriter;
import org.apache.nifi.web.api.metrics.TextFormatPrometheusMetricsWriter;
import org.apache.nifi.web.api.request.BulletinBoardPatternParameter;
import org.apache.nifi.web.api.request.DateTimeParameter;
import org.apache.nifi.web.api.request.FlowMetricsProducer;
import org.apache.nifi.web.api.request.FlowMetricsRegistry;
import org.apache.nifi.web.api.request.IntegerParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.apache.nifi.web.servlet.shared.RequestUriBuilder;
import org.apache.nifi.web.util.PaginationHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@Path(value="/flow")
@Tag(name="Flow")
public class FlowResource
extends ApplicationResource {
    private static final String RECURSIVE = "false";
    private static final String VERSIONED_REPORTING_TASK_SNAPSHOT_FILENAME_PATTERN = "VersionedReportingTaskSnapshot-%s.json";
    private static final String VERSIONED_REPORTING_TASK_SNAPSHOT_DATE_FORMAT = "yyyyMMddHHmmss";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    private ProcessorResource processorResource;
    private InputPortResource inputPortResource;
    private OutputPortResource outputPortResource;
    private FunnelResource funnelResource;
    private LabelResource labelResource;
    private RemoteProcessGroupResource remoteProcessGroupResource;
    private ConnectionResource connectionResource;
    private ProcessGroupResource processGroupResource;
    private ControllerServiceResource controllerServiceResource;
    private ReportingTaskResource reportingTaskResource;
    private ParameterProviderResource parameterProviderResource;
    @Context
    private ServletContext servletContext;

    private void populateRemainingFlowContent(ProcessGroupFlowDTO flow) {
        FlowDTO flowStructure = flow.getFlow();
        if (flowStructure != null) {
            this.populateRemainingFlowStructure(flowStructure);
        }
        flow.setUri(this.generateResourceUri(new String[]{"flow", "process-groups", flow.getId()}));
    }

    private void populateRemainingFlowStructure(FlowDTO flowStructure) {
        this.processorResource.populateRemainingProcessorEntitiesContent(flowStructure.getProcessors());
        this.connectionResource.populateRemainingConnectionEntitiesContent(flowStructure.getConnections());
        this.inputPortResource.populateRemainingInputPortEntitiesContent(flowStructure.getInputPorts());
        this.outputPortResource.populateRemainingOutputPortEntitiesContent(flowStructure.getOutputPorts());
        this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntitiesContent(flowStructure.getRemoteProcessGroups());
        this.funnelResource.populateRemainingFunnelEntitiesContent(flowStructure.getFunnels());
        this.labelResource.populateRemainingLabelEntitiesContent(flowStructure.getLabels());
        this.processGroupResource.populateRemainingProcessGroupEntitiesContent(flowStructure.getProcessGroups());
        for (ProcessGroupEntity processGroupEntity : flowStructure.getProcessGroups()) {
            ProcessGroupDTO processGroup = processGroupEntity.getComponent();
            if (processGroup == null) continue;
            processGroup.setContents(null);
        }
    }

    private void authorizeFlow() {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable flow = lookup.getFlow();
            flow.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="client-id")
    @Operation(summary="Generates a client id.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=String.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response generateClientId() {
        this.authorizeFlow();
        return this.generateOkResponse((Object)this.generateUuid()).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="config")
    @Operation(summary="Retrieves the configuration for this NiFi flow", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowConfigurationEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowConfig() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        FlowConfigurationEntity entity = this.serviceFacade.getFlowConfiguration();
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="content-viewers")
    @Operation(summary="Retrieves the registered content viewers", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ContentViewerEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getContentViewers(@Context HttpServletRequest httpServletRequest) {
        this.authorizeFlow();
        Collection contentViewers = (Collection)this.servletContext.getAttribute("content-viewers");
        ArrayList dtos = new ArrayList();
        contentViewers.forEach(contentViewer -> {
            String contextPath = contentViewer.getContextPath();
            BundleCoordinate bundleCoordinate = contentViewer.getBundle().getBundleDetails().getCoordinate();
            String displayName = StringUtils.substringBefore((String)contextPath.substring(1), (String)("-" + bundleCoordinate.getVersion()));
            ContentViewerDTO dto = new ContentViewerDTO();
            dto.setDisplayName(displayName + " " + bundleCoordinate.getVersion());
            List supportedMimeTypes = contentViewer.getSupportedMimeTypes().stream().map(supportedMimeType -> {
                SupportedMimeTypesDTO mimeTypesDto = new SupportedMimeTypesDTO();
                mimeTypesDto.setDisplayName(supportedMimeType.getDisplayName());
                mimeTypesDto.setMimeTypes(supportedMimeType.getMimeTypes());
                return mimeTypesDto;
            }).collect(Collectors.toList());
            dto.setSupportedMimeTypes(supportedMimeTypes);
            URI contentViewerUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)httpServletRequest).path(contextPath).build();
            dto.setUri(contentViewerUri.toString());
            dtos.add(dto);
        });
        ContentViewerEntity entity = new ContentViewerEntity();
        entity.setContentViewers(dtos);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="current-user")
    @Operation(summary="Retrieves the user identity of the user making the request", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=CurrentUserEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    public Response getCurrentUser() {
        CurrentUserEntity entity;
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            try (Response replicatedResponse = this.replicate("GET");){
                CurrentUserEntity replicatedCurrentUserEntity = this.readReplicatedCurrentUserEntity(replicatedResponse);
                CurrentUserEntity currentUserEntity = this.serviceFacade.getCurrentUser();
                replicatedCurrentUserEntity.setLogoutSupported(currentUserEntity.isLogoutSupported());
                entity = replicatedCurrentUserEntity;
            }
        } else {
            entity = this.serviceFacade.getCurrentUser();
        }
        return this.generateOkResponse((Object)entity).build();
    }

    private CurrentUserEntity readReplicatedCurrentUserEntity(Response replicatedResponse) {
        Object entity = replicatedResponse.getEntity();
        if (entity instanceof CurrentUserEntity) {
            CurrentUserEntity replicatedCurrentUserEntity = (CurrentUserEntity)entity;
            return replicatedCurrentUserEntity;
        }
        if (entity instanceof StreamingOutput) {
            StreamingOutput streamingOutput = (StreamingOutput)entity;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                streamingOutput.write((OutputStream)outputStream);
                byte[] bytes = outputStream.toByteArray();
                return (CurrentUserEntity)objectMapper.readValue(bytes, CurrentUserEntity.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Read Current User Entity failed", e);
            }
        }
        throw new IllegalStateException("Current User Entity not expected [%s]".formatted(entity));
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @Operation(summary="Gets a process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupFlowEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")}, description="If the uiOnly query parameter is provided with a value of true, the returned entity may only contain fields that are necessary for rendering the NiFi User Interface. As such, the selected fields may change at any time, even during incremental releases, without warning. As a result, this parameter should not be provided by any client other than the UI.")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlow(@Parameter(description="The process group id.") @PathParam(value="id") String groupId, @QueryParam(value="uiOnly") @DefaultValue(value="false") boolean uiOnly) {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ProcessGroupFlowEntity entity = this.serviceFacade.getProcessGroupFlow(groupId, uiOnly);
        this.populateRemainingFlowContent(entity.getProcessGroupFlow());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/breadcrumbs")
    @Operation(summary="Gets the breadcrumbs for a process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowBreadcrumbEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getBreadcrumbs(@Parameter(description="The process group id.") @PathParam(value="id") String groupId) {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        FlowBreadcrumbEntity breadcrumbEntity = this.serviceFacade.getProcessGroupBreadcrumbs(groupId);
        return this.generateOkResponse((Object)breadcrumbEntity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="metrics/{producer}")
    @Operation(summary="Gets all metrics for the flow from a particular node", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=StreamingOutput.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowMetrics(@Parameter(description="The producer for flow file metrics. Each producer may have its own output format.", required=true) @PathParam(value="producer") String producer, @Parameter(description="Set of included metrics registries") @QueryParam(value="includedRegistries") Set<FlowMetricsRegistry> includedRegistries, @Parameter(description="Regular Expression Pattern to be applied against the sample name field") @QueryParam(value="sampleName") String sampleName, @Parameter(description="Regular Expression Pattern to be applied against the sample label value field") @QueryParam(value="sampleLabelValue") String sampleLabelValue, @Parameter(description="Name of the first field of JSON object. Applicable for JSON producer only.") @QueryParam(value="rootFieldName") String rootFieldName) {
        this.authorizeFlow();
        Set<Object> selectedRegistries = includedRegistries == null ? Collections.emptySet() : includedRegistries;
        Collection registries = this.serviceFacade.generateFlowMetrics(selectedRegistries);
        if (FlowMetricsProducer.PROMETHEUS.getProducer().equalsIgnoreCase(producer)) {
            StreamingOutput response = outputStream -> {
                TextFormatPrometheusMetricsWriter prometheusMetricsWriter = new TextFormatPrometheusMetricsWriter(sampleName, sampleLabelValue);
                prometheusMetricsWriter.write(registries, outputStream);
            };
            return this.generateOkResponse((Object)response).type("text/plain; version=0.0.4; charset=utf-8").build();
        }
        if (FlowMetricsProducer.JSON.getProducer().equals(producer)) {
            StreamingOutput output = outputStream -> {
                JsonFormatPrometheusMetricsWriter jsonPrometheusMetricsWriter = new JsonFormatPrometheusMetricsWriter(sampleName, sampleLabelValue, rootFieldName);
                jsonPrometheusMetricsWriter.write(registries, outputStream);
            };
            return this.generateOkResponse((Object)output).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        throw new ResourceNotFoundException("The specified producer is missing or invalid.");
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="controller/controller-services")
    @Operation(summary="Gets controller services for reporting tasks", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ControllerServicesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")}, description="If the uiOnly query parameter is provided with a value of true, the returned entity may only contain fields that are necessary for rendering the NiFi User Interface. As such, the selected fields may change at any time, even during incremental releases, without warning. As a result, this parameter should not be provided by any client other than the UI.")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getControllerServicesFromController(@QueryParam(value="uiOnly") @DefaultValue(value="false") boolean uiOnly, @QueryParam(value="includeReferencingComponents") @DefaultValue(value="true") @Parameter(description="Whether or not to include services' referencing components in the response") boolean includeReferences) {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set controllerServices = this.serviceFacade.getControllerServices(null, false, false, includeReferences);
        if (uiOnly) {
            controllerServices.forEach(arg_0 -> ((FlowResource)this).stripNonUiRelevantFields(arg_0));
        }
        this.controllerServiceResource.populateRemainingControllerServiceEntitiesContent(controllerServices);
        ControllerServicesEntity entity = new ControllerServicesEntity();
        entity.setCurrentTime(new Date());
        entity.setControllerServices(controllerServices);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/controller-services")
    @Operation(summary="Gets all controller services", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ControllerServicesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")}, description="If the uiOnly query parameter is provided with a value of true, the returned entity may only contain fields that are necessary for rendering the NiFi User Interface. As such, the selected fields may change at any time, even during incremental releases, without warning. As a result, this parameter should not be provided by any client other than the UI.")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getControllerServicesFromGroup(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="Whether or not to include parent/ancestor process groups") @QueryParam(value="includeAncestorGroups") @DefaultValue(value="true") boolean includeAncestorGroups, @Parameter(description="Whether or not to include descendant process groups") @QueryParam(value="includeDescendantGroups") @DefaultValue(value="false") boolean includeDescendantGroups, @Parameter(description="Whether or not to include services' referencing components in the response") @QueryParam(value="includeReferencingComponents") @DefaultValue(value="true") boolean includeReferences, @QueryParam(value="uiOnly") @DefaultValue(value="false") boolean uiOnly) {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set controllerServices = this.serviceFacade.getControllerServices(groupId, includeAncestorGroups, includeDescendantGroups, includeReferences);
        if (uiOnly) {
            controllerServices.forEach(arg_0 -> ((FlowResource)this).stripNonUiRelevantFields(arg_0));
        }
        this.controllerServiceResource.populateRemainingControllerServiceEntitiesContent(controllerServices);
        ControllerServicesEntity entity = new ControllerServicesEntity();
        entity.setCurrentTime(new Date());
        entity.setControllerServices(controllerServices);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="parameter-providers")
    @Operation(summary="Gets all parameter providers", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProvidersEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getParameterProviders() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set parameterProviders = this.serviceFacade.getParameterProviders();
        this.parameterProviderResource.populateRemainingParameterProviderEntitiesContent(parameterProviders);
        ParameterProvidersEntity entity = new ParameterProvidersEntity();
        entity.setParameterProviders(parameterProviders);
        entity.setCurrentTime(new Date());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="reporting-tasks")
    @Operation(summary="Gets all reporting tasks", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ReportingTasksEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getReportingTasks() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set reportingTasks = this.serviceFacade.getReportingTasks();
        this.reportingTaskResource.populateRemainingReportingTaskEntitiesContent(reportingTasks);
        ReportingTasksEntity entity = new ReportingTasksEntity();
        entity.setCurrentTime(new Date());
        entity.setReportingTasks(reportingTasks);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="reporting-tasks/snapshot")
    @Operation(summary="Get a snapshot of the given reporting tasks and any controller services they use", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VersionedReportingTaskSnapshot.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getReportingTaskSnapshot(@Parameter(description="Specifies a reporting task id to export. If not specified, all reporting tasks will be exported.") @QueryParam(value="reportingTaskId") String reportingTaskId) {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        VersionedReportingTaskSnapshot snapshot = reportingTaskId == null ? this.serviceFacade.getVersionedReportingTaskSnapshot() : this.serviceFacade.getVersionedReportingTaskSnapshot(reportingTaskId);
        return this.generateOkResponse((Object)snapshot).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="reporting-tasks/download")
    @Operation(summary="Download a snapshot of the given reporting tasks and any controller services they use", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=byte[].class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response downloadReportingTaskSnapshot(@Parameter(description="Specifies a reporting task id to export. If not specified, all reporting tasks will be exported.") @QueryParam(value="reportingTaskId") String reportingTaskId) {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        VersionedReportingTaskSnapshot snapshot = reportingTaskId == null ? this.serviceFacade.getVersionedReportingTaskSnapshot() : this.serviceFacade.getVersionedReportingTaskSnapshot(reportingTaskId);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String filename = "VersionedReportingTaskSnapshot-%s.json".formatted(formatter.format(OffsetDateTime.now()));
        return this.generateOkResponse((Object)snapshot).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", filename)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @Operation(summary="Schedule or unschedule components in the specified Process Group.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ScheduleComponentsEntity.class))})}, security={@SecurityRequirement(name="Read - /flow"), @SecurityRequirement(name="Write - /{component-type}/{uuid} or /operation/{component-type}/{uuid} - For every component being scheduled/unscheduled")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response scheduleComponents(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String id, @Parameter(description="The request to schedule or unschedule. If the components in the request are not specified, all authorized components will be considered.", required=true) ScheduleComponentsEntity requestScheduleComponentsEntity) {
        ScheduledState state;
        if (requestScheduleComponentsEntity == null) {
            throw new IllegalArgumentException("Schedule Component must be specified.");
        }
        if (!id.equals(requestScheduleComponentsEntity.getId())) {
            throw new IllegalArgumentException(String.format("The process group id (%s) in the request body does not equal the process group id of the requested resource (%s).", requestScheduleComponentsEntity.getId(), id));
        }
        if (requestScheduleComponentsEntity.getState() == null) {
            throw new IllegalArgumentException("The scheduled state must be specified.");
        }
        if (requestScheduleComponentsEntity.getState().equals("ENABLED")) {
            state = ScheduledState.STOPPED;
        } else {
            try {
                state = ScheduledState.valueOf((String)requestScheduleComponentsEntity.getState());
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException(String.format("The scheduled must be one of [%s].", StringUtils.join((Object[])new Object[]{Stream.of(ScheduledState.RUNNING, ScheduledState.STOPPED, "ENABLED", ScheduledState.DISABLED), ", "})));
            }
        }
        if (ScheduledState.STARTING.equals((Object)state) || ScheduledState.STOPPING.equals((Object)state)) {
            throw new IllegalArgumentException(String.format("The scheduled must be one of [%s].", StringUtils.join((Object[])new Object[]{Stream.of(ScheduledState.RUNNING, ScheduledState.STOPPED, "ENABLED", ScheduledState.DISABLED), ", "})));
        }
        if (requestScheduleComponentsEntity.getComponents() == null) {
            Supplier<Predicate> getProcessorFilter = () -> {
                if (ScheduledState.RUNNING.equals((Object)state)) {
                    return ProcessGroup.START_PROCESSORS_FILTER;
                }
                if (ScheduledState.STOPPED.equals((Object)state)) {
                    if (requestScheduleComponentsEntity.getState().equals("ENABLED")) {
                        return ProcessGroup.ENABLE_PROCESSORS_FILTER;
                    }
                    return ProcessGroup.STOP_PROCESSORS_FILTER;
                }
                return ProcessGroup.DISABLE_PROCESSORS_FILTER;
            };
            Supplier<Predicate> getPortFilter = () -> {
                if (ScheduledState.RUNNING.equals((Object)state)) {
                    return ProcessGroup.START_PORTS_FILTER;
                }
                if (ScheduledState.STOPPED.equals((Object)state)) {
                    if (requestScheduleComponentsEntity.getState().equals("ENABLED")) {
                        return ProcessGroup.ENABLE_PORTS_FILTER;
                    }
                    return ProcessGroup.STOP_PORTS_FILTER;
                }
                return ProcessGroup.DISABLE_PORTS_FILTER;
            };
            Set revisions2 = this.serviceFacade.getRevisionsFromGroup(id, group -> {
                HashSet componentIds = new HashSet();
                HashSet statelessGroupIdsToSchedule = new HashSet();
                group.findAllProcessGroups().stream().filter(child -> child.getExecutionEngine() == ExecutionEngine.STATELESS).filter(child -> child.getParent() == null || child.getParent().resolveExecutionEngine() == ExecutionEngine.STANDARD).filter(child -> OperationAuthorizable.isOperationAuthorized((Authorizable)child, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser())).forEach(child -> {
                    componentIds.add(child.getIdentifier());
                    statelessGroupIdsToSchedule.add(child.getIdentifier());
                    child.findAllProcessGroups().forEach(descendent -> statelessGroupIdsToSchedule.add(descendent.getIdentifier()));
                });
                group.findAllProcessors().stream().filter((Predicate)getProcessorFilter.get()).filter(processor -> !statelessGroupIdsToSchedule.contains(processor.getProcessGroupIdentifier())).filter(processor -> OperationAuthorizable.isOperationAuthorized((Authorizable)processor, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser())).forEach(processor -> componentIds.add(processor.getIdentifier()));
                group.findAllInputPorts().stream().filter((Predicate)getPortFilter.get()).filter(processor -> !statelessGroupIdsToSchedule.contains(processor.getProcessGroupIdentifier())).filter(inputPort -> OperationAuthorizable.isOperationAuthorized((Authorizable)inputPort, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser())).forEach(inputPort -> componentIds.add(inputPort.getIdentifier()));
                group.findAllOutputPorts().stream().filter((Predicate)getPortFilter.get()).filter(processor -> !statelessGroupIdsToSchedule.contains(processor.getProcessGroupIdentifier())).filter(outputPort -> OperationAuthorizable.isOperationAuthorized((Authorizable)outputPort, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser())).forEach(outputPort -> componentIds.add(outputPort.getIdentifier()));
                return componentIds;
            });
            HashMap componentsToSchedule = new HashMap();
            revisions2.forEach(revision -> {
                RevisionDTO dto = new RevisionDTO();
                dto.setClientId(revision.getClientId());
                dto.setVersion(revision.getVersion());
                componentsToSchedule.put(revision.getComponentId(), dto);
            });
            requestScheduleComponentsEntity.setComponents(componentsToSchedule);
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestScheduleComponentsEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestScheduleComponentsEntity.isDisconnectedNodeAcknowledged());
        }
        Map requestComponentsToSchedule = requestScheduleComponentsEntity.getComponents();
        Map<String, Revision> requestComponentRevisions = requestComponentsToSchedule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getRevision((RevisionDTO)e.getValue(), (String)e.getKey())));
        HashSet<Revision> requestRevisions = new HashSet<Revision>(requestComponentRevisions.values());
        return this.withWriteLock(this.serviceFacade, (Entity)requestScheduleComponentsEntity, requestRevisions, lookup -> {
            this.authorizeFlow();
            requestComponentsToSchedule.keySet().forEach(componentId -> {
                Authorizable connectable = lookup.getLocalConnectable(componentId);
                OperationAuthorizable.authorizeOperation((Authorizable)connectable, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
            });
        }, () -> {
            if ("ENABLED".equals(requestScheduleComponentsEntity.getState()) || "DISABLED".equals(requestScheduleComponentsEntity.getState())) {
                this.serviceFacade.verifyEnableComponents(id, state, requestComponentRevisions.keySet());
            } else {
                this.serviceFacade.verifyScheduleComponents(id, state, requestComponentRevisions.keySet());
            }
        }, (revisions, scheduleComponentsEntity) -> {
            ScheduledState scheduledState = "ENABLED".equals(scheduleComponentsEntity.getState()) ? ScheduledState.STOPPED : ScheduledState.valueOf((String)scheduleComponentsEntity.getState());
            Map componentsToSchedule = scheduleComponentsEntity.getComponents();
            Map<String, Revision> componentRevisions = componentsToSchedule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getRevision((RevisionDTO)e.getValue(), (String)e.getKey())));
            ScheduleComponentsEntity entity = "ENABLED".equals(scheduleComponentsEntity.getState()) || "DISABLED".equals(scheduleComponentsEntity.getState()) ? this.serviceFacade.enableComponents(id, scheduledState, componentRevisions) : this.serviceFacade.scheduleComponents(id, scheduledState, componentRevisions);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/controller-services")
    @Operation(summary="Enable or disable Controller Services in the specified Process Group.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ActivateControllerServicesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow"), @SecurityRequirement(name="Write - /{component-type}/{uuid} or /operation/{component-type}/{uuid} - For every service being enabled/disabled")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response activateControllerServices(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String id, @Parameter(description="The request to schedule or unschedule. If the comopnents in the request are not specified, all authorized components will be considered.", required=true) ActivateControllerServicesEntity requestEntity) {
        ControllerServiceState desiredState;
        if (requestEntity == null) {
            throw new IllegalArgumentException("Controller service must be specified.");
        }
        if (!id.equals(requestEntity.getId())) {
            throw new IllegalArgumentException(String.format("The process group id (%s) in the request body does not equal the process group id of the requested resource (%s).", requestEntity.getId(), id));
        }
        if (requestEntity.getState() == null) {
            throw new IllegalArgumentException("The controller service state must be specified.");
        }
        try {
            desiredState = ControllerServiceState.valueOf((String)requestEntity.getState());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(String.format("The controller service state must be one of [%s].", StringUtils.join(EnumSet.of(ControllerServiceState.ENABLED, ControllerServiceState.DISABLED), (String)", ")));
        }
        if (ControllerServiceState.DISABLING.equals((Object)desiredState) || ControllerServiceState.ENABLING.equals((Object)desiredState)) {
            throw new IllegalArgumentException(String.format("The scheduled must be one of [%s].", StringUtils.join(EnumSet.of(ControllerServiceState.ENABLED, ControllerServiceState.DISABLED), (String)", ")));
        }
        if (requestEntity.getComponents() == null) {
            Set revisions2 = this.serviceFacade.getRevisionsFromGroup(id, group -> {
                HashSet componentIds = new HashSet();
                Predicate<ControllerServiceNode> filter = ControllerServiceState.ENABLED.equals((Object)desiredState) ? service -> !service.isActive() : ControllerServiceNode::isActive;
                group.findAllControllerServices().stream().filter(filter).filter(service -> service.getProcessGroup().resolveExecutionEngine() == ExecutionEngine.STANDARD).filter(service -> OperationAuthorizable.isOperationAuthorized((Authorizable)service, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser())).forEach(service -> componentIds.add(service.getIdentifier()));
                return componentIds;
            });
            HashMap componentsToSchedule = new HashMap();
            revisions2.forEach(revision -> {
                RevisionDTO dto = new RevisionDTO();
                dto.setClientId(revision.getClientId());
                dto.setVersion(revision.getVersion());
                componentsToSchedule.put(revision.getComponentId(), dto);
            });
            requestEntity.setComponents(componentsToSchedule);
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        Map requestComponentsToSchedule = requestEntity.getComponents();
        Map<String, Revision> requestComponentRevisions = requestComponentsToSchedule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getRevision((RevisionDTO)e.getValue(), (String)e.getKey())));
        HashSet<Revision> requestRevisions = new HashSet<Revision>(requestComponentRevisions.values());
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, requestRevisions, lookup -> {
            this.authorizeFlow();
            requestComponentsToSchedule.keySet().forEach(componentId -> {
                Authorizable authorizable = lookup.getControllerService(componentId).getAuthorizable();
                OperationAuthorizable.authorizeOperation((Authorizable)authorizable, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
            });
        }, () -> this.serviceFacade.verifyActivateControllerServices(id, desiredState, requestComponentRevisions.keySet()), (revisions, scheduleComponentsEntity) -> {
            ControllerServiceState serviceState = ControllerServiceState.valueOf((String)scheduleComponentsEntity.getState());
            Map componentsToSchedule = scheduleComponentsEntity.getComponents();
            Map<String, Revision> componentRevisions = componentsToSchedule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getRevision((RevisionDTO)e.getValue(), (String)e.getKey())));
            ActivateControllerServicesEntity entity = this.serviceFacade.activateControllerServices(id, serviceState, componentRevisions);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="search-results")
    @Operation(summary="Performs a search against this NiFi using the specified search term", description="Only search results from authorized components will be returned.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=SearchResultsEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response searchFlow(@QueryParam(value="q") @DefaultValue(value="") String value, @QueryParam(value="a") @DefaultValue(value="") String activeGroupId) {
        this.authorizeFlow();
        SearchResultsDTO results = this.serviceFacade.searchController(value, activeGroupId);
        SearchResultsEntity entity = new SearchResultsEntity();
        entity.setSearchResultsDTO(results);
        return this.noCache(Response.ok((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="status")
    @Operation(summary="Gets the current status of this NiFi", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ControllerStatusEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getControllerStatus() throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerStatusDTO controllerStatus = this.serviceFacade.getControllerStatus();
        ControllerStatusEntity entity = new ControllerStatusEntity();
        entity.setControllerStatus(controllerStatus);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/summary")
    @Operation(summary="The cluster summary for this NiFi", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ClusterSummaryEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getClusterSummary() {
        this.authorizeFlow();
        ClusterSummaryDTO clusterConfiguration = new ClusterSummaryDTO();
        ClusterCoordinator clusterCoordinator = this.getClusterCoordinator();
        if (clusterCoordinator != null && clusterCoordinator.isConnected()) {
            Map stateMap = clusterCoordinator.getConnectionStates();
            int totalNodeCount = 0;
            for (List nodeList : stateMap.values()) {
                totalNodeCount += nodeList.size();
            }
            List connectedNodeIds = (List)stateMap.get(NodeConnectionState.CONNECTED);
            int connectedNodeCount = connectedNodeIds == null ? 0 : connectedNodeIds.size();
            clusterConfiguration.setConnectedNodeCount(Integer.valueOf(connectedNodeCount));
            clusterConfiguration.setTotalNodeCount(Integer.valueOf(totalNodeCount));
            clusterConfiguration.setConnectedNodes(connectedNodeCount + " / " + totalNodeCount);
        }
        clusterConfiguration.setClustered(Boolean.valueOf(this.isClustered()));
        clusterConfiguration.setConnectedToCluster(Boolean.valueOf(this.isConnectedToCluster()));
        ClusterSummaryEntity entity = new ClusterSummaryEntity();
        entity.setClusterSummary(clusterConfiguration);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="controller/bulletins")
    @Operation(summary="Retrieves Controller level bulletins", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ControllerBulletinsEntity.class))})}, security={@SecurityRequirement(name="Read - /flow"), @SecurityRequirement(name="Read - /controller - For controller bulletins"), @SecurityRequirement(name="Read - /controller-services/{uuid} - For controller service bulletins"), @SecurityRequirement(name="Read - /reporting-tasks/{uuid} - For reporting task bulletins")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getBulletins() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerBulletinsEntity entity = this.serviceFacade.getControllerBulletins();
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="banners")
    @Operation(summary="Retrieves the banners for this NiFi", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=BannerEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getBanners() {
        this.authorizeFlow();
        String bannerText = this.getProperties().getBannerText();
        BannerDTO bannerDTO = new BannerDTO();
        bannerDTO.setHeaderText(bannerText);
        bannerDTO.setFooterText(bannerText);
        BannerEntity entity = new BannerEntity();
        entity.setBanners(bannerDTO);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="processor-types")
    @Operation(summary="Retrieves the types of processors that this NiFi supports", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorTypesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessorTypes(@Parameter(description="If specified, will only return types that are a member of this bundle group.") @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @Parameter(description="If specified, will only return types that are a member of this bundle artifact.") @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @Parameter(description="If specified, will only return types whose fully qualified classname matches.") @QueryParam(value="type") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ProcessorTypesEntity entity = new ProcessorTypesEntity();
        entity.setProcessorTypes(this.serviceFacade.getProcessorTypes(bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="controller-service-types")
    @Operation(summary="Retrieves the types of controller services that this NiFi supports", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ControllerServiceTypesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getControllerServiceTypes(@Parameter(description="If specified, will only return controller services that are compatible with this type of service.") @QueryParam(value="serviceType") String serviceType, @Parameter(description="If serviceType specified, is the bundle group of the serviceType.") @QueryParam(value="serviceBundleGroup") String serviceBundleGroup, @Parameter(description="If serviceType specified, is the bundle artifact of the serviceType.") @QueryParam(value="serviceBundleArtifact") String serviceBundleArtifact, @Parameter(description="If serviceType specified, is the bundle version of the serviceType.") @QueryParam(value="serviceBundleVersion") String serviceBundleVersion, @Parameter(description="If specified, will only return types that are a member of this bundle group.") @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @Parameter(description="If specified, will only return types that are a member of this bundle artifact.") @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @Parameter(description="If specified, will only return types whose fully qualified classname matches.") @QueryParam(value="typeFilter") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (serviceType != null && (serviceBundleGroup == null || serviceBundleArtifact == null || serviceBundleVersion == null)) {
            throw new IllegalArgumentException("When specifying the serviceType the serviceBundleGroup, serviceBundleArtifact, and serviceBundleVersion must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerServiceTypesEntity entity = new ControllerServiceTypesEntity();
        entity.setControllerServiceTypes(this.serviceFacade.getControllerServiceTypes(serviceType, serviceBundleGroup, serviceBundleArtifact, serviceBundleVersion, bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="reporting-task-types")
    @Operation(summary="Retrieves the types of reporting tasks that this NiFi supports", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ReportingTaskTypesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getReportingTaskTypes(@Parameter(description="If specified, will only return types that are a member of this bundle group.") @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @Parameter(description="If specified, will only return types that are a member of this bundle artifact.") @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @Parameter(description="If specified, will only return types whose fully qualified classname matches.") @QueryParam(value="type") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ReportingTaskTypesEntity entity = new ReportingTaskTypesEntity();
        entity.setReportingTaskTypes(this.serviceFacade.getReportingTaskTypes(bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="runtime-manifest")
    @Operation(summary="Retrieves the runtime manifest for this NiFi instance.", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=RuntimeManifestEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getRuntimeManifest() throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        RuntimeManifestEntity entity = new RuntimeManifestEntity();
        entity.setRuntimeManifest(this.serviceFacade.getRuntimeManifest());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="processor-definition/{group}/{artifact}/{version}/{type}")
    @Operation(summary="Retrieves the Processor Definition for the specified component type.", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorDefinition.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The processor definition for the coordinates could not be located.")})
    public Response getProcessorDefinition(@Parameter(description="The bundle group", required=true) @PathParam(value="group") String group, @Parameter(description="The bundle artifact", required=true) @PathParam(value="artifact") String artifact, @Parameter(description="The bundle version", required=true) @PathParam(value="version") String version, @Parameter(description="The processor type", required=true) @PathParam(value="type") String type) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ProcessorDefinition entity = this.serviceFacade.getProcessorDefinition(group, artifact, version, type);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="controller-service-definition/{group}/{artifact}/{version}/{type}")
    @Operation(summary="Retrieves the Controller Service Definition for the specified component type.", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ControllerServiceDefinition.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The controller service definition for the coordinates could not be located.")})
    public Response getControllerServiceDefinition(@Parameter(description="The bundle group", required=true) @PathParam(value="group") String group, @Parameter(description="The bundle artifact", required=true) @PathParam(value="artifact") String artifact, @Parameter(description="The bundle version", required=true) @PathParam(value="version") String version, @Parameter(description="The controller service type", required=true) @PathParam(value="type") String type) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerServiceDefinition entity = this.serviceFacade.getControllerServiceDefinition(group, artifact, version, type);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="reporting-task-definition/{group}/{artifact}/{version}/{type}")
    @Operation(summary="Retrieves the Reporting Task Definition for the specified component type.", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ReportingTaskDefinition.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The reporting task definition for the coordinates could not be located.")})
    public Response getReportingTaskDefinition(@Parameter(description="The bundle group", required=true) @PathParam(value="group") String group, @Parameter(description="The bundle artifact", required=true) @PathParam(value="artifact") String artifact, @Parameter(description="The bundle version", required=true) @PathParam(value="version") String version, @Parameter(description="The reporting task type", required=true) @PathParam(value="type") String type) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ReportingTaskDefinition entity = this.serviceFacade.getReportingTaskDefinition(group, artifact, version, type);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="parameter-provider-definition/{group}/{artifact}/{version}/{type}")
    @Operation(summary="Retrieves the Parameter Provider Definition for the specified component type.", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderDefinition.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The reporting task definition for the coordinates could not be located.")})
    public Response getParameterProviderDefinition(@Parameter(description="The bundle group", required=true) @PathParam(value="group") String group, @Parameter(description="The bundle artifact", required=true) @PathParam(value="artifact") String artifact, @Parameter(description="The bundle version", required=true) @PathParam(value="version") String version, @Parameter(description="The parameter provider type", required=true) @PathParam(value="type") String type) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ParameterProviderDefinition entity = this.serviceFacade.getParameterProviderDefinition(group, artifact, version, type);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rule-definition/{group}/{artifact}/{version}/{type}")
    @Operation(summary="Retrieves the Flow Analysis Rule Definition for the specified component type.", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowAnalysisRuleDefinition.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The flow analysis rule definition for the coordinates could not be located.")})
    public Response getFlowAnalysisRuleDefinition(@Parameter(description="The bundle group", required=true) @PathParam(value="group") String group, @Parameter(description="The bundle artifact", required=true) @PathParam(value="artifact") String artifact, @Parameter(description="The bundle version", required=true) @PathParam(value="version") String version, @Parameter(description="The flow analysis rule type", required=true) @PathParam(value="type") String type) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        FlowAnalysisRuleDefinition entity = this.serviceFacade.getFlowAnalysisRuleDefinition(group, artifact, version, type);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="additional-details/{group}/{artifact}/{version}/{type}")
    @Operation(summary="Retrieves the additional details for the specified component type.", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=AdditionalDetailsEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The additional details for the coordinates could not be located.")})
    public Response getAdditionalDetails(@Parameter(description="The bundle group", required=true) @PathParam(value="group") String group, @Parameter(description="The bundle artifact", required=true) @PathParam(value="artifact") String artifact, @Parameter(description="The bundle version", required=true) @PathParam(value="version") String version, @Parameter(description="The processor type", required=true) @PathParam(value="type") String type) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        String additionalDetails = this.serviceFacade.getAdditionalDetails(group, artifact, version, type);
        AdditionalDetailsEntity entity = new AdditionalDetailsEntity();
        entity.setAdditionalDetails(additionalDetails);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="parameter-provider-types")
    @Operation(summary="Retrieves the types of parameter providers that this NiFi supports", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderTypesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getParameterProviderTypes(@Parameter(description="If specified, will only return types that are a member of this bundle group.") @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @Parameter(description="If specified, will only return types that are a member of this bundle artifact.") @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @Parameter(description="If specified, will only return types whose fully qualified classname matches.") @QueryParam(value="type") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ParameterProviderTypesEntity entity = new ParameterProviderTypesEntity();
        entity.setParameterProviderTypes(this.serviceFacade.getParameterProviderTypes(bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rule-types")
    @Operation(summary="Retrieves the types of available Flow Analysis Rules", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowAnalysisRuleTypesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowAnalysisRuleTypes(@Parameter(description="If specified, will only return types that are a member of this bundle group.") @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @Parameter(description="If specified, will only return types that are a member of this bundle artifact.") @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @Parameter(description="If specified, will only return types whose fully qualified classname matches.") @QueryParam(value="type") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        FlowAnalysisRuleTypesEntity entity = new FlowAnalysisRuleTypesEntity();
        entity.setFlowAnalysisRuleTypes(this.serviceFacade.getFlowAnalysisRuleTypes(bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="prioritizers")
    @Operation(summary="Retrieves the types of prioritizers that this NiFi supports", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PrioritizerTypesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getPrioritizers() throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        PrioritizerTypesEntity entity = new PrioritizerTypesEntity();
        entity.setPrioritizerTypes(this.serviceFacade.getWorkQueuePrioritizerTypes());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="about")
    @Operation(summary="Retrieves details about this NiFi to put in the About dialog", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=AboutEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getAboutInfo(@Context HttpServletRequest httpServletRequest) {
        this.authorizeFlow();
        AboutDTO aboutDTO = new AboutDTO();
        aboutDTO.setTitle("NiFi");
        aboutDTO.setUri(this.generateResourceUri(new String[0]));
        aboutDTO.setTimezone(new Date());
        URI contentViewerUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)httpServletRequest).path("/nifi/").fragment("/content-viewer").build();
        aboutDTO.setContentViewerUrl(contentViewerUri.toString());
        Bundle frameworkBundle = NarClassLoadersHolder.getInstance().getFrameworkBundle();
        if (frameworkBundle != null) {
            BundleDetails frameworkDetails = frameworkBundle.getBundleDetails();
            aboutDTO.setVersion(frameworkDetails.getCoordinate().getVersion());
            aboutDTO.setBuildTag(frameworkDetails.getBuildTag());
            aboutDTO.setBuildRevision(frameworkDetails.getBuildRevision());
            aboutDTO.setBuildBranch(frameworkDetails.getBuildBranch());
            aboutDTO.setBuildTimestamp(frameworkDetails.getBuildTimestampDate());
        }
        AboutEntity entity = new AboutEntity();
        entity.setAbout(aboutDTO);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries")
    @Operation(summary="Gets the listing of available flow registry clients", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowRegistryClientsEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getRegistryClients() {
        this.authorizeFlow();
        Set registryClients = this.serviceFacade.getRegistryClientsForUser();
        FlowRegistryClientsEntity registryClientEntities = new FlowRegistryClientsEntity();
        registryClientEntities.setCurrentTime(new Date());
        registryClientEntities.setRegistries(registryClients);
        return this.generateOkResponse((Object)this.populateRemainingRegistryClientEntityContent(registryClientEntities)).build();
    }

    private FlowRegistryClientEntity populateRemainingRegistryClientEntityContent(FlowRegistryClientEntity flowRegistryClientEntity) {
        flowRegistryClientEntity.setUri(this.generateResourceUri(new String[]{"controller", "registry-clients", flowRegistryClientEntity.getId()}));
        return flowRegistryClientEntity;
    }

    private FlowRegistryClientsEntity populateRemainingRegistryClientEntityContent(FlowRegistryClientsEntity flowRegistryClientsEntity) {
        for (FlowRegistryClientEntity entity : flowRegistryClientsEntity.getRegistries()) {
            this.populateRemainingRegistryClientEntityContent(entity);
        }
        return flowRegistryClientsEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries/{id}/branches")
    @Operation(summary="Gets the branches from the specified registry for the current user", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowRegistryBranchesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getBranches(@Parameter(description="The registry id.", required=true) @PathParam(value="id") String id) throws NiFiRegistryException {
        this.authorizeFlow();
        Set branches = this.serviceFacade.getBranches(id);
        FlowRegistryBranchesEntity flowRegistryBranchesEntity = new FlowRegistryBranchesEntity();
        flowRegistryBranchesEntity.setBranches(branches);
        return this.generateOkResponse((Object)flowRegistryBranchesEntity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries/{id}/buckets")
    @Operation(summary="Gets the buckets from the specified registry for the current user", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowRegistryBucketsEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getBuckets(@Parameter(description="The registry id.", required=true) @PathParam(value="id") String id, @Parameter(description="The name of a branch to get the buckets from. If not specified the default branch of the registry client will be used.") @QueryParam(value="branch") String branch) {
        this.authorizeFlow();
        String selectedBranch = branch == null ? this.serviceFacade.getDefaultBranch(id).getBranch().getName() : branch;
        Set buckets = this.serviceFacade.getBucketsForUser(id, selectedBranch);
        SortedSet sortedBuckets = this.sortBuckets(buckets);
        FlowRegistryBucketsEntity flowRegistryBucketsEntity = new FlowRegistryBucketsEntity();
        flowRegistryBucketsEntity.setBuckets((Set)sortedBuckets);
        return this.generateOkResponse((Object)flowRegistryBucketsEntity).build();
    }

    private SortedSet<FlowRegistryBucketEntity> sortBuckets(Set<FlowRegistryBucketEntity> buckets) {
        TreeSet<FlowRegistryBucketEntity> sortedBuckets = new TreeSet<FlowRegistryBucketEntity>((entity1, entity2) -> Collator.getInstance().compare(this.getBucketName(entity1), this.getBucketName(entity2)));
        sortedBuckets.addAll(buckets);
        return sortedBuckets;
    }

    private String getBucketName(FlowRegistryBucketEntity entity) {
        return entity.getBucket() == null ? null : entity.getBucket().getName();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries/{registry-id}/buckets/{bucket-id}/flows")
    @Operation(summary="Gets the flows from the specified registry and bucket for the current user", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VersionedFlowsEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlows(@Parameter(description="The registry client id.", required=true) @PathParam(value="registry-id") String registryId, @Parameter(description="The bucket id.", required=true) @PathParam(value="bucket-id") String bucketId, @Parameter(description="The name of a branch to get the flows from. If not specified the default branch of the registry client will be used.") @QueryParam(value="branch") String branch) {
        this.authorizeFlow();
        String selectedBranch = branch == null ? this.serviceFacade.getDefaultBranch(registryId).getBranch().getName() : branch;
        Set registeredFlows = this.serviceFacade.getFlowsForUser(registryId, selectedBranch, bucketId);
        SortedSet sortedFlows = this.sortFlows(registeredFlows);
        VersionedFlowsEntity versionedFlowsEntity = new VersionedFlowsEntity();
        versionedFlowsEntity.setVersionedFlows((Set)sortedFlows);
        return this.generateOkResponse((Object)versionedFlowsEntity).build();
    }

    private SortedSet<VersionedFlowEntity> sortFlows(Set<VersionedFlowEntity> versionedFlows) {
        TreeSet<VersionedFlowEntity> sortedFlows = new TreeSet<VersionedFlowEntity>((entity1, entity2) -> Collator.getInstance().compare(this.getFlowName(entity1), this.getFlowName(entity2)));
        sortedFlows.addAll(versionedFlows);
        return sortedFlows;
    }

    private String getFlowName(VersionedFlowEntity flowEntity) {
        return flowEntity.getVersionedFlow() == null ? "" : flowEntity.getVersionedFlow().getFlowName();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries/{registry-id}/buckets/{bucket-id}/flows/{flow-id}/details")
    @Operation(summary="Gets the details of a flow from the specified registry and bucket for the specified flow for the current user", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VersionedFlowEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getDetails(@Parameter(description="The registry client id.", required=true) @PathParam(value="registry-id") String registryId, @Parameter(description="The bucket id.", required=true) @PathParam(value="bucket-id") String bucketId, @Parameter(description="The flow id.", required=true) @PathParam(value="flow-id") String flowId, @Parameter(description="The name of a branch to get the flow from. If not specified the default branch of the registry client will be used.") @QueryParam(value="branch") String branch) {
        this.authorizeFlow();
        String selectedBranch = branch == null ? this.serviceFacade.getDefaultBranch(registryId).getBranch().getName() : branch;
        VersionedFlowEntity flowDetails = this.serviceFacade.getFlowForUser(registryId, selectedBranch, bucketId, flowId);
        return this.generateOkResponse((Object)flowDetails).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries/{registry-id}/branches/{branch-id-a}/buckets/{bucket-id-a}/flows/{flow-id-a}/{version-a}/diff/branches/{branch-id-b}/buckets/{bucket-id-b}/flows/{flow-id-b}/{version-b}")
    @Operation(summary="Gets the differences between two versions of the same versioned flow, the basis of the comparison will be the first version", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowComparisonEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getVersionDifferences(@Parameter(description="The registry client id.", required=true) @PathParam(value="registry-id") String registryId, @Parameter(description="The branch id for the base version.", required=true) @PathParam(value="branch-id-a") String branchIdA, @Parameter(description="The bucket id for the base version.", required=true) @PathParam(value="bucket-id-a") String bucketIdA, @Parameter(description="The flow id for the base version.", required=true) @PathParam(value="flow-id-a") String flowIdA, @Parameter(description="The base version.", required=true) @PathParam(value="version-a") String versionA, @Parameter(description="The branch id for the compared version.", required=true) @PathParam(value="branch-id-b") String branchIdB, @Parameter(description="The bucket id for the compared version.", required=true) @PathParam(value="bucket-id-b") String bucketIdB, @Parameter(description="The flow id for the compared version.", required=true) @PathParam(value="flow-id-b") String flowIdB, @Parameter(description="The compared version.", required=true) @PathParam(value="version-b") String versionB, @QueryParam(value="offset") @Parameter(description="Must be a non-negative number. Specifies the starting point of the listing. 0 means start from the beginning.") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @Parameter(description="Limits the number of differences listed. This might lead to partial result. 0 means no limitation is applied.") @DefaultValue(value="1000") int limit) {
        this.authorizeFlow();
        FlowVersionLocation baseVersionLocation = new FlowVersionLocation(branchIdA, bucketIdA, flowIdA, versionA);
        FlowVersionLocation comparedVersionLocation = new FlowVersionLocation(branchIdB, bucketIdB, flowIdB, versionB);
        FlowComparisonEntity versionDifference = this.serviceFacade.getVersionDifference(registryId, baseVersionLocation, comparedVersionLocation);
        return this.generateOkResponse((Object)FlowResource.limitDifferences((FlowComparisonEntity)versionDifference, (int)offset, (int)limit)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries/{registry-id}/buckets/{bucket-id}/flows/{flow-id}/versions")
    @Operation(summary="Gets the flow versions from the specified registry and bucket for the specified flow for the current user", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VersionedFlowSnapshotMetadataSetEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getVersions(@Parameter(description="The registry client id.", required=true) @PathParam(value="registry-id") String registryId, @Parameter(description="The bucket id.", required=true) @PathParam(value="bucket-id") String bucketId, @Parameter(description="The flow id.", required=true) @PathParam(value="flow-id") String flowId, @Parameter(description="The name of a branch to get the flow versions from. If not specified the default branch of the registry client will be used.") @QueryParam(value="branch") String branch) {
        this.authorizeFlow();
        String selectedBranch = branch == null ? this.serviceFacade.getDefaultBranch(registryId).getBranch().getName() : branch;
        Set registeredFlowSnapshotMetadataSet = this.serviceFacade.getFlowVersionsForUser(registryId, selectedBranch, bucketId, flowId);
        VersionedFlowSnapshotMetadataSetEntity versionedFlowSnapshotMetadataSetEntity = new VersionedFlowSnapshotMetadataSetEntity();
        versionedFlowSnapshotMetadataSetEntity.setVersionedFlowSnapshotMetadataSet(registeredFlowSnapshotMetadataSet);
        return this.generateOkResponse((Object)versionedFlowSnapshotMetadataSetEntity).build();
    }

    private static FlowComparisonEntity limitDifferences(FlowComparisonEntity original, int offset, int limit) {
        List limited = PaginationHelper.paginateByContainedItems((Iterable)original.getComponentDifferences(), (int)offset, (int)limit, ComponentDifferenceDTO::getDifferences, FlowResource::limitDifferences);
        FlowComparisonEntity result = new FlowComparisonEntity();
        result.setComponentDifferences(new HashSet(limited));
        return result;
    }

    private static ComponentDifferenceDTO limitDifferences(ComponentDifferenceDTO original, List<DifferenceDTO> partial) {
        ComponentDifferenceDTO result = new ComponentDifferenceDTO();
        result.setComponentType(original.getComponentType());
        result.setComponentId(original.getComponentId());
        result.setComponentName(original.getComponentName());
        result.setProcessGroupId(original.getProcessGroupId());
        result.setDifferences(partial);
        return result;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="bulletin-board")
    @Operation(summary="Gets current bulletins", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=BulletinBoardEntity.class))})}, security={@SecurityRequirement(name="Read - /flow"), @SecurityRequirement(name="Read - /{component-type}/{uuid} - For component specific bulletins")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getBulletinBoard(@Parameter(description="Includes bulletins with an id after this value.") @QueryParam(value="after") LongParameter after, @Parameter(description="Includes bulletins originating from this sources whose name match this regular expression.") @QueryParam(value="sourceName") BulletinBoardPatternParameter sourceName, @Parameter(description="Includes bulletins whose message that match this regular expression.") @QueryParam(value="message") BulletinBoardPatternParameter message, @Parameter(description="Includes bulletins originating from this sources whose id match this regular expression.") @QueryParam(value="sourceId") BulletinBoardPatternParameter sourceId, @Parameter(description="Includes bulletins originating from this sources whose group id match this regular expression.") @QueryParam(value="groupId") BulletinBoardPatternParameter groupId, @Parameter(description="The number of bulletins to limit the response to.") @QueryParam(value="limit") IntegerParameter limit) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        BulletinQueryDTO query = new BulletinQueryDTO();
        if (sourceId != null) {
            query.setSourceId(sourceId.getRawPattern());
        }
        if (groupId != null) {
            query.setGroupId(groupId.getRawPattern());
        }
        if (sourceName != null) {
            query.setName(sourceName.getRawPattern());
        }
        if (message != null) {
            query.setMessage(message.getRawPattern());
        }
        if (after != null) {
            query.setAfter(after.getLong());
        }
        if (limit != null) {
            query.setLimit(limit.getInteger());
        }
        BulletinBoardDTO bulletinBoard = this.serviceFacade.getBulletinBoard(query);
        BulletinBoardEntity entity = new BulletinBoardEntity();
        entity.setBulletinBoard(bulletinBoard);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="processors/{id}/status")
    @Operation(summary="Gets status for a processor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorStatusEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessorStatus(@Parameter(description="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @Parameter(description="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ProcessorStatusEntity entity = (ProcessorStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getProcessorStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ProcessorStatusEntity entity = this.serviceFacade.getProcessorStatus(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="input-ports/{id}/status")
    @Operation(summary="Gets status for an input port", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PortStatusEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getInputPortStatus(@Parameter(description="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @Parameter(description="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The input port id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                PortStatusEntity entity = (PortStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getPortStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        PortStatusEntity entity = this.serviceFacade.getInputPortStatus(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="output-ports/{id}/status")
    @Operation(summary="Gets status for an output port", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PortStatusEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getOutputPortStatus(@Parameter(description="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @Parameter(description="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The output port id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                PortStatusEntity entity = (PortStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getPortStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        PortStatusEntity entity = this.serviceFacade.getOutputPortStatus(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="remote-process-groups/{id}/status")
    @Operation(summary="Gets status for a remote process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=RemoteProcessGroupStatusEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getRemoteProcessGroupStatus(@Parameter(description="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @Parameter(description="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The remote process group id.") @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                RemoteProcessGroupStatusEntity entity = (RemoteProcessGroupStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getRemoteProcessGroupStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        RemoteProcessGroupStatusEntity entity = this.serviceFacade.getRemoteProcessGroupStatus(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/status")
    @Operation(summary="Gets the status for a process group", description="The status for a process group includes status for all descendent components. When invoked on the root group with recursive set to true, it will return the current status of every component in the flow.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupStatusEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessGroupStatus(@Parameter(description="Whether all descendant groups and the status of their content will be included. Optional, defaults to false") @QueryParam(value="recursive") @DefaultValue(value="false") Boolean recursive, @Parameter(description="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @Parameter(description="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ProcessGroupStatusEntity entity = (ProcessGroupStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getProcessGroupStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ProcessGroupStatusEntity entity = this.serviceFacade.getProcessGroupStatus(groupId, recursive.booleanValue());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="connections/{id}/status")
    @Operation(summary="Gets status for a connection", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConnectionStatusEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getConnectionStatus(@Parameter(description="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @Parameter(description="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ConnectionStatusEntity entity = (ConnectionStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getConnectionStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ConnectionStatusEntity entity = this.serviceFacade.getConnectionStatus(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="connections/{id}/statistics")
    @Operation(summary="Gets statistics for a connection", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConnectionStatisticsEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getConnectionStatistics(@Parameter(description="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @Parameter(description="The id of the node where to get the statistics.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ConnectionStatisticsEntity entity = (ConnectionStatisticsEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getConnectionStatistics().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ConnectionStatisticsEntity entity = this.serviceFacade.getConnectionStatistics(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="processors/{id}/status/history")
    @Operation(summary="Gets status history for a processor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=StatusHistoryEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessorStatusHistory(@Parameter(description="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getProcessorStatusHistory(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/status/history")
    @Operation(summary="Gets status history for a remote process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=StatusHistoryEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessGroupStatusHistory(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getProcessGroupStatusHistory(groupId);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="remote-process-groups/{id}/status/history")
    @Operation(summary="Gets the status history", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=StatusHistoryEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getRemoteProcessGroupStatusHistory(@Parameter(description="The remote process group id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getRemoteProcessGroupStatusHistory(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="connections/{id}/status/history")
    @Operation(summary="Gets the status history for a connection", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=StatusHistoryEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getConnectionStatusHistory(@Parameter(description="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getConnectionStatusHistory(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="parameter-contexts")
    @Operation(summary="Gets all Parameter Contexts", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextsEntity.class))})}, security={@SecurityRequirement(name="Read - /parameter-contexts/{id} for each Parameter Context")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getParameterContexts() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set parameterContexts = this.serviceFacade.getParameterContexts();
        parameterContexts.forEach(entity -> entity.setUri(this.generateResourceUri(new String[]{"parameter-contexts", entity.getId()})));
        ParameterContextsEntity entity2 = new ParameterContextsEntity();
        entity2.setParameterContexts(parameterContexts);
        entity2.setCurrentTime(new Date());
        return this.generateOkResponse((Object)entity2).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history")
    @Operation(summary="Gets configuration history", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=HistoryEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response queryHistory(@Parameter(description="The offset into the result set.", required=true) @QueryParam(value="offset") IntegerParameter offset, @Parameter(description="The number of actions to return.", required=true) @QueryParam(value="count") IntegerParameter count, @Parameter(description="The field to sort on.") @QueryParam(value="sortColumn") String sortColumn, @Parameter(description="The direction to sort.") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Include actions after this date.") @QueryParam(value="startDate") DateTimeParameter startDate, @Parameter(description="Include actions before this date.") @QueryParam(value="endDate") DateTimeParameter endDate, @Parameter(description="Include actions performed by this user.") @QueryParam(value="userIdentity") String userIdentity, @Parameter(description="Include actions on this component.") @QueryParam(value="sourceId") String sourceId) {
        this.authorizeFlow();
        if (offset == null) {
            throw new IllegalArgumentException("The desired offset must be specified.");
        }
        if (offset.getInteger() < 0) {
            throw new IllegalArgumentException("The desired offset must be an integer value greater than or equal to 0.");
        }
        if (count == null) {
            throw new IllegalArgumentException("The desired row count must be specified.");
        }
        if (count.getInteger() < 1) {
            throw new IllegalArgumentException("The desired row count must be an integer value greater than 0.");
        }
        if (sortOrder != null && !sortOrder.equalsIgnoreCase("asc") && !sortOrder.equalsIgnoreCase("desc")) {
            throw new IllegalArgumentException("The sort order must be 'asc' or 'desc'.");
        }
        if (endDate != null && startDate != null && endDate.getDateTime().before(startDate.getDateTime())) {
            throw new IllegalArgumentException("The start date/time must come before the end date/time.");
        }
        HistoryQueryDTO query = new HistoryQueryDTO();
        query.setSortColumn(sortColumn);
        query.setSortOrder(sortOrder);
        query.setOffset(offset.getInteger());
        query.setCount(count.getInteger());
        if (startDate != null) {
            query.setStartDate(startDate.getDateTime());
        }
        if (endDate != null) {
            query.setEndDate(endDate.getDateTime());
        }
        if (userIdentity != null) {
            query.setUserIdentity(userIdentity);
        }
        if (sourceId != null) {
            query.setSourceId(sourceId);
        }
        HistoryDTO history = this.serviceFacade.getActions(query);
        HistoryEntity entity = new HistoryEntity();
        entity.setHistory(history);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history/{id}")
    @Operation(summary="Gets an action", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ActionEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getAction(@Parameter(description="The action id.", required=true) @PathParam(value="id") IntegerParameter id) {
        this.authorizeFlow();
        if (id == null) {
            throw new IllegalArgumentException("The action id must be specified.");
        }
        ActionEntity entity = this.serviceFacade.getAction(id.getInteger());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history/components/{componentId}")
    @Operation(summary="Gets configuration history for a component", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ComponentHistoryEntity.class))})}, security={@SecurityRequirement(name="Read - /flow"), @SecurityRequirement(name="Read underlying component - /{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getComponentHistory(@Parameter(description="The component id.", required=true) @PathParam(value="componentId") String componentId) {
        this.serviceFacade.authorizeAccess(lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            this.authorizeFlow();
            try {
                Authorizable authorizable = lookup.getProcessor(componentId).getAuthorizable();
                authorizable.authorize(this.authorizer, RequestAction.READ, user);
                return;
            }
            catch (ResourceNotFoundException authorizable) {
                try {
                    Authorizable authorizable2 = lookup.getControllerService(componentId).getAuthorizable();
                    authorizable2.authorize(this.authorizer, RequestAction.READ, user);
                    return;
                }
                catch (ResourceNotFoundException authorizable2) {
                    try {
                        Authorizable authorizable3 = lookup.getReportingTask(componentId).getAuthorizable();
                        authorizable3.authorize(this.authorizer, RequestAction.READ, user);
                        return;
                    }
                    catch (ResourceNotFoundException authorizable3) {
                        try {
                            Authorizable authorizable4 = lookup.getParameterProvider(componentId).getAuthorizable();
                            authorizable4.authorize(this.authorizer, RequestAction.READ, user);
                            return;
                        }
                        catch (ResourceNotFoundException authorizable4) {
                            Authorizable controller = lookup.getController();
                            controller.authorize(this.authorizer, RequestAction.READ, user);
                            return;
                        }
                    }
                }
            }
        });
        ComponentHistoryEntity entity = new ComponentHistoryEntity();
        entity.setComponentHistory(this.serviceFacade.getComponentHistory(componentId));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis/results/{processGroupId}")
    @Operation(summary="Returns flow analysis results produced by the analysis of a given process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowAnalysisResultEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowAnalysisResults(@Parameter(description="The id of the process group representing (a part of) the flow to be analyzed.", required=true) @PathParam(value="processGroupId") String processGroupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.authorizeFlow();
        FlowAnalysisResultEntity entity = this.serviceFacade.getFlowAnalysisResult(processGroupId);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis/results")
    @Operation(summary="Returns all flow analysis results currently in effect", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowAnalysisResultEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getAllFlowAnalysisResults() {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.authorizeFlow();
        FlowAnalysisResultEntity entity = this.serviceFacade.getFlowAnalysisResult();
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/search-results")
    @Operation(summary="Searches the cluster for a node with the specified address", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ClusterSearchResultsEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response searchCluster(@Parameter(description="Node address to search for.", required=true) @QueryParam(value="q") @DefaultValue(value="") String value) {
        this.authorizeFlow();
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        ArrayList<NodeSearchResultDTO> nodeMatches = new ArrayList<NodeSearchResultDTO>();
        ClusterDTO cluster = this.serviceFacade.getCluster();
        for (NodeDTO node : cluster.getNodes()) {
            if (!NodeConnectionState.CONNECTED.name().equals(node.getStatus())) continue;
            String address = node.getAddress() + ":" + node.getApiPort();
            if (!StringUtils.isBlank((CharSequence)value) && !StringUtils.containsIgnoreCase((CharSequence)address, (CharSequence)value)) continue;
            NodeSearchResultDTO nodeMatch = new NodeSearchResultDTO();
            nodeMatch.setId(node.getNodeId());
            nodeMatch.setAddress(address);
            nodeMatches.add(nodeMatch);
        }
        ClusterSearchResultsEntity results = new ClusterSearchResultsEntity();
        results.setNodeResults(nodeMatches);
        return this.noCache(Response.ok((Object)results)).build();
    }

    @Autowired
    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    @Autowired
    public void setProcessorResource(ProcessorResource processorResource) {
        this.processorResource = processorResource;
    }

    @Autowired
    public void setInputPortResource(InputPortResource inputPortResource) {
        this.inputPortResource = inputPortResource;
    }

    @Autowired
    public void setOutputPortResource(OutputPortResource outputPortResource) {
        this.outputPortResource = outputPortResource;
    }

    @Autowired
    public void setFunnelResource(FunnelResource funnelResource) {
        this.funnelResource = funnelResource;
    }

    @Autowired
    public void setLabelResource(LabelResource labelResource) {
        this.labelResource = labelResource;
    }

    @Autowired
    public void setRemoteProcessGroupResource(RemoteProcessGroupResource remoteProcessGroupResource) {
        this.remoteProcessGroupResource = remoteProcessGroupResource;
    }

    @Autowired
    public void setConnectionResource(ConnectionResource connectionResource) {
        this.connectionResource = connectionResource;
    }

    @Autowired
    public void setProcessGroupResource(ProcessGroupResource processGroupResource) {
        this.processGroupResource = processGroupResource;
    }

    @Autowired
    public void setControllerServiceResource(ControllerServiceResource controllerServiceResource) {
        this.controllerServiceResource = controllerServiceResource;
    }

    @Autowired
    public void setReportingTaskResource(ReportingTaskResource reportingTaskResource) {
        this.reportingTaskResource = reportingTaskResource;
    }

    @Autowired
    public void setParameterProviderResource(ParameterProviderResource parameterProviderResource) {
        this.parameterProviderResource = parameterProviderResource;
    }

    @Autowired
    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

