/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.exception.UnknownNodeException;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.CounterDTO;
import org.apache.nifi.web.api.dto.CountersDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.CounterEntity;
import org.apache.nifi.web.api.entity.CountersEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/counters")
@Tag(name="Counters")
public class CountersResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private void authorizeCounters(RequestAction action) {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable counters = lookup.getCounters();
            counters.authorize(this.authorizer, action, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="")
    @Operation(summary="Gets the current counters for this NiFi", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=CountersEntity.class))})}, security={@SecurityRequirement(name="Read - /counters")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getCounters(@Parameter(description="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @Parameter(description="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId) throws InterruptedException {
        this.authorizeCounters(RequestAction.READ);
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("GET", this.getAbsolutePath(), (Object)this.getRequestParameters(), this.getHeaders()).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "GET", this.getAbsolutePath(), (Object)this.getRequestParameters(), this.getHeaders()).awaitMergedResponse();
                CountersEntity entity = (CountersEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getCounters().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            NodeIdentifier targetNode = this.getClusterCoordinator().getNodeIdentifier(clusterNodeId);
            if (targetNode == null) {
                throw new UnknownNodeException("The specified cluster node does not exist.");
            }
            return this.replicate("GET", targetNode);
        }
        CountersDTO countersReport = this.serviceFacade.getCounters();
        CountersEntity entity = new CountersEntity();
        entity.setCounters(countersReport);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Updates the specified counter. This will reset the counter value to 0", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=CounterEntity.class))})}, security={@SecurityRequirement(name="Write - /counters")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateCounter(@Parameter(description="The id of the counter.") @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("PUT");
        }
        ComponentEntity requestComponentEntity = new ComponentEntity();
        requestComponentEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestComponentEntity, lookup -> this.authorizeCounters(RequestAction.WRITE), null, componentEntity -> {
            CounterDTO counter = this.serviceFacade.updateCounter(componentEntity.getId());
            CounterEntity entity = new CounterEntity();
            entity.setCounter(counter);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @Autowired
    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    @Autowired
    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

