/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.controller;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.search.SearchContext;

public class StandardSearchContext
implements SearchContext {
    private final String searchTerm;
    private final ProcessorNode processorNode;
    private final ControllerServiceLookup controllerServiceLookup;

    public StandardSearchContext(String searchTerm, ProcessorNode processorNode, ControllerServiceLookup controllerServiceLookup) {
        this.searchTerm = searchTerm;
        this.processorNode = processorNode;
        this.controllerServiceLookup = controllerServiceLookup;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public String getAnnotationData() {
        return this.processorNode.getAnnotationData();
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String configuredValue = this.processorNode.getRawPropertyValue(property);
        StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)new StandardResourceReferenceFactory(), property);
        return new StandardPropertyValue((ResourceContext)resourceContext, configuredValue == null ? property.getDefaultValue() : configuredValue, this.controllerServiceLookup, ParameterLookup.EMPTY);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.processorNode.getRawPropertyValues();
    }
}

