/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.diagnostics.DiagnosticLevel;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.SystemDiagnosticsDTO;
import org.apache.nifi.web.api.entity.JmxMetricsResultsEntity;
import org.apache.nifi.web.api.entity.SystemDiagnosticsEntity;
import org.apache.nifi.web.api.metrics.jmx.JmxMetricsService;

@Path(value="/system-diagnostics")
@Tag(name="SystemDiagnostics")
public class SystemDiagnosticsResource
extends ApplicationResource {
    private JmxMetricsService jmxMetricsService;
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private void authorizeSystem() {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable system = lookup.getSystem();
            system.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets the diagnostics for the system NiFi is running on", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=SystemDiagnosticsEntity.class))})}, security={@SecurityRequirement(name="Read - /system")})
    @ApiResponses(value={@ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request.")})
    public Response getSystemDiagnostics(@Parameter(description="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @Parameter(description="Whether or not to include verbose details. Optional, defaults to false") @QueryParam(value="diagnosticLevel") @DefaultValue(value="BASIC") DiagnosticLevel diagnosticLevel, @Parameter(description="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId) throws InterruptedException {
        this.authorizeSystem();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("GET", this.getAbsolutePath(), (Object)this.getRequestParameters(), this.getHeaders()).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "GET", this.getAbsolutePath(), (Object)this.getRequestParameters(), this.getHeaders()).awaitMergedResponse();
                SystemDiagnosticsEntity entity = (SystemDiagnosticsEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getSystemDiagnostics().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET");
        }
        SystemDiagnosticsDTO systemDiagnosticsDto = this.serviceFacade.getSystemDiagnostics(diagnosticLevel);
        SystemDiagnosticsEntity entity = new SystemDiagnosticsEntity();
        entity.setSystemDiagnostics(systemDiagnosticsDto);
        return this.generateOkResponse((Object)entity).build();
    }

    @Path(value="jmx-metrics")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve available JMX metrics", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=JmxMetricsResultsEntity.class))})}, security={@SecurityRequirement(name="Read - /system")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getJmxMetrics(@Parameter(description="Regular Expression Pattern to be applied against the ObjectName") @QueryParam(value="beanNameFilter") String beanNameFilter) {
        this.authorizeJmxMetrics();
        Collection results = this.jmxMetricsService.getFilteredMBeanMetrics(beanNameFilter);
        JmxMetricsResultsEntity entity = new JmxMetricsResultsEntity();
        entity.setJmxMetricsResults(results);
        return this.generateOkResponse((Object)entity).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private void authorizeJmxMetrics() {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable system = lookup.getSystem();
            system.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setJmxMetricsService(JmxMetricsService jmxMetricsService) {
        this.jmxMetricsService = jmxMetricsService;
    }
}

