/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ProvenanceResource;
import org.apache.nifi.web.api.dto.provenance.ProvenanceDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceOptionsDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageRequestDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageResultsDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.LineageEntity;
import org.apache.nifi.web.api.entity.ProvenanceEntity;
import org.apache.nifi.web.api.entity.ProvenanceOptionsEntity;

@Path(value="/provenance")
@Tag(name="Provenance")
public class ProvenanceResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private ProvenanceDTO populateRemainingProvenanceContent(ProvenanceDTO provenance) {
        provenance.setUri(this.generateResourceUri(new String[]{"provenance", provenance.getId()}));
        return provenance;
    }

    private LineageDTO populateRemainingLineageContent(LineageDTO lineage, String clusterNodeId) {
        lineage.setUri(this.generateResourceUri(new String[]{"provenance", "lineage", lineage.getId()}));
        lineage.getRequest().setClusterNodeId(clusterNodeId);
        LineageResultsDTO results = lineage.getResults();
        if (results != null && results.getNodes() != null) {
            results.getNodes().forEach(node -> node.setClusterNodeIdentifier(clusterNodeId));
        }
        return lineage;
    }

    private void authorizeProvenanceRequest() {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable provenance = lookup.getProvenance();
            provenance.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="search-options")
    @Operation(summary="Gets the searchable attributes for provenance events", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProvenanceOptionsEntity.class))})}, security={@SecurityRequirement(name="Read - /provenance")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getSearchOptions() {
        this.authorizeProvenanceRequest();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ProvenanceOptionsDTO searchOptions = this.serviceFacade.getProvenanceSearchOptions();
        ProvenanceOptionsEntity entity = new ProvenanceOptionsEntity();
        entity.setProvenanceOptions(searchOptions);
        return this.noCache(Response.ok((Object)entity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="")
    @Operation(summary="Submits a provenance query", description="Provenance queries may be long running so this endpoint submits a request. The response will include the current state of the query. If the request is not completed the URI in the response can be used at a later time to get the updated state of the query. Once the query has completed the provenance request should be deleted by the client who originally submitted it.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProvenanceEntity.class))})}, security={@SecurityRequirement(name="Read - /provenance"), @SecurityRequirement(name="Read - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitProvenanceRequest(@Parameter(description="The provenance query details.", required=true) ProvenanceEntity requestProvenanceEntity) {
        ProvenanceDTO requestProvenanceDto;
        if (requestProvenanceEntity == null) {
            requestProvenanceEntity = new ProvenanceEntity();
        }
        if (requestProvenanceEntity.getProvenance() != null) {
            requestProvenanceDto = requestProvenanceEntity.getProvenance();
        } else {
            requestProvenanceDto = new ProvenanceDTO();
            requestProvenanceEntity.setProvenance(requestProvenanceDto);
        }
        if (this.isReplicateRequest()) {
            HashMap<String, String> headersToOverride = new HashMap<String, String>();
            headersToOverride.put("content-type", "application/json");
            if (requestProvenanceDto.getRequest() == null || requestProvenanceDto.getRequest().getClusterNodeId() == null) {
                return this.replicate("POST", (Object)requestProvenanceEntity, headersToOverride);
            }
            return this.replicate("POST", (Object)requestProvenanceEntity, requestProvenanceDto.getRequest().getClusterNodeId(), headersToOverride);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestProvenanceEntity, lookup -> this.authorizeProvenanceRequest(), null, provenanceEntity -> {
            ProvenanceDTO provenanceDTO = provenanceEntity.getProvenance();
            String provenanceId = this.generateUuid();
            provenanceDTO.setId(provenanceId);
            ProvenanceDTO dto = this.serviceFacade.submitProvenance(provenanceDTO);
            this.populateRemainingProvenanceContent(dto);
            if (provenanceDTO.getRequest() != null && provenanceDTO.getRequest().getClusterNodeId() != null) {
                dto.getRequest().setClusterNodeId(provenanceDTO.getRequest().getClusterNodeId());
            }
            ProvenanceEntity entity = new ProvenanceEntity();
            entity.setProvenance(dto);
            return this.generateCreatedResponse(URI.create(dto.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Gets a provenance query", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProvenanceEntity.class))})}, security={@SecurityRequirement(name="Read - /provenance"), @SecurityRequirement(name="Read - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProvenance(@Parameter(description="The id of the node where this query exists if clustered.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="Whether or not incremental results are returned. If false, provenance events are only returned once the query completes. This property is true by default.") @QueryParam(value="summarize") @DefaultValue(value="false") Boolean summarize, @Parameter(description="Whether or not to summarize provenance events returned. This property is false by default.") @QueryParam(value="incrementalResults") @DefaultValue(value="true") Boolean incrementalResults, @Parameter(description="The id of the provenance query.", required=true) @PathParam(value="id") String id) {
        this.authorizeProvenanceRequest();
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                return this.replicate("GET");
            }
            return this.replicate("GET", clusterNodeId);
        }
        ProvenanceDTO dto = this.serviceFacade.getProvenance(id, summarize, incrementalResults);
        dto.getRequest().setClusterNodeId(clusterNodeId);
        this.populateRemainingProvenanceContent(dto);
        ProvenanceEntity entity = new ProvenanceEntity();
        entity.setProvenance(dto);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Deletes a provenance query", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProvenanceEntity.class))})}, security={@SecurityRequirement(name="Read - /provenance")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteProvenance(@Parameter(description="The id of the node where this query exists if clustered.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The id of the provenance query.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                return this.replicate("DELETE");
            }
            return this.replicate("DELETE", clusterNodeId);
        }
        ComponentEntity requestEntity = new ComponentEntity();
        requestEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> this.authorizeProvenanceRequest(), null, entity -> {
            this.serviceFacade.deleteProvenance(entity.getId());
            return this.generateOkResponse((Object)new ProvenanceEntity()).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="lineage")
    @Operation(summary="Submits a lineage query", description="Lineage queries may be long running so this endpoint submits a request. The response will include the current state of the query. If the request is not completed the URI in the response can be used at a later time to get the updated state of the query. Once the query has completed the lineage request should be deleted by the client who originally submitted it.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=LineageEntity.class))})}, security={@SecurityRequirement(name="Read - /provenance"), @SecurityRequirement(name="Read - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitLineageRequest(@Parameter(description="The lineage query details.", required=true) LineageEntity requestLineageEntity) {
        if (requestLineageEntity == null || requestLineageEntity.getLineage() == null || requestLineageEntity.getLineage().getRequest() == null) {
            throw new IllegalArgumentException("Lineage request must be specified.");
        }
        LineageDTO requestLineageDto = requestLineageEntity.getLineage();
        LineageRequestDTO requestDto = requestLineageDto.getRequest();
        if (requestDto.getLineageRequestType() == null) {
            throw new IllegalArgumentException("The type of lineage request must be specified.");
        }
        switch (1.$SwitchMap$org$apache$nifi$web$api$dto$provenance$lineage$LineageRequestDTO$LineageRequestType[requestDto.getLineageRequestType().ordinal()]) {
            case 1: 
            case 2: {
                if (requestDto.getEventId() != null) break;
                throw new IllegalArgumentException("The event id must be specified when the event type is PARENTS or CHILDREN.");
            }
            case 3: {
                if (requestDto.getUuid() != null || requestDto.getEventId() != null) break;
                throw new IllegalArgumentException("The flowfile uuid or event id must be specified when the event type is FLOWFILE.");
            }
        }
        if (this.isReplicateRequest()) {
            if (requestDto.getClusterNodeId() == null) {
                throw new IllegalArgumentException("The cluster node identifier must be specified.");
            }
            HashMap<String, String> headersToOverride = new HashMap<String, String>();
            headersToOverride.put("content-type", "application/json");
            return this.replicate("POST", (Object)requestLineageEntity, requestDto.getClusterNodeId(), headersToOverride);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestLineageEntity, lookup -> this.authorizeProvenanceRequest(), null, lineageEntity -> {
            LineageDTO lineageDTO = lineageEntity.getLineage();
            LineageDTO dto = this.serviceFacade.submitLineage(lineageDTO);
            this.populateRemainingLineageContent(dto, lineageDTO.getRequest().getClusterNodeId());
            LineageEntity entity = new LineageEntity();
            entity.setLineage(dto);
            return this.generateCreatedResponse(URI.create(dto.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="lineage/{id}")
    @Operation(summary="Gets a lineage query", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=LineageEntity.class))})}, security={@SecurityRequirement(name="Read - /provenance"), @SecurityRequirement(name="Read - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getLineage(@Parameter(description="The id of the node where this query exists if clustered.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The id of the lineage query.", required=true) @PathParam(value="id") String id) {
        this.authorizeProvenanceRequest();
        if (this.isReplicateRequest()) {
            return this.replicate("GET", clusterNodeId);
        }
        LineageDTO dto = this.serviceFacade.getLineage(id);
        this.populateRemainingLineageContent(dto, clusterNodeId);
        LineageEntity entity = new LineageEntity();
        entity.setLineage(dto);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="lineage/{id}")
    @Operation(summary="Deletes a lineage query", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=LineageEntity.class))})}, security={@SecurityRequirement(name="Read - /provenance")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteLineage(@Parameter(description="The id of the node where this query exists if clustered.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The id of the lineage query.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE", clusterNodeId);
        }
        ComponentEntity requestEntity = new ComponentEntity();
        requestEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> this.authorizeProvenanceRequest(), null, entity -> {
            this.serviceFacade.deleteLineage(entity.getId());
            return this.generateOkResponse((Object)new LineageEntity()).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

