/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.google.common.base.Functions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterGroupConfiguration;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.parameter.ParameterSensitivity;
import org.apache.nifi.ui.extension.UiExtension;
import org.apache.nifi.ui.extension.UiExtensionMapping;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.ResumeFlowException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.UiExtensionType;
import org.apache.nifi.web.api.AbstractParameterResource;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ParameterProviderResource;
import org.apache.nifi.web.api.concurrent.AsyncRequestManager;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.apache.nifi.web.api.concurrent.StandardAsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.StandardUpdateStep;
import org.apache.nifi.web.api.concurrent.UpdateStep;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ConfigVerificationResultDTO;
import org.apache.nifi.web.api.dto.ConfigurationAnalysisDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.dto.ParameterProviderApplyParametersRequestDTO;
import org.apache.nifi.web.api.dto.ParameterProviderApplyParametersUpdateStepDTO;
import org.apache.nifi.web.api.dto.ParameterProviderConfigurationDTO;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.api.dto.ParameterStatus;
import org.apache.nifi.web.api.dto.ParameterStatusDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.VerifyConfigRequestDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.ConfigurationAnalysisEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.apache.nifi.web.api.entity.ParameterGroupConfigurationEntity;
import org.apache.nifi.web.api.entity.ParameterProviderApplyParametersRequestEntity;
import org.apache.nifi.web.api.entity.ParameterProviderConfigurationEntity;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;
import org.apache.nifi.web.api.entity.ParameterProviderParameterApplicationEntity;
import org.apache.nifi.web.api.entity.ParameterProviderParameterFetchEntity;
import org.apache.nifi.web.api.entity.ParameterProviderReferencingComponentEntity;
import org.apache.nifi.web.api.entity.ParameterProviderReferencingComponentsEntity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.apache.nifi.web.util.ComponentLifecycle;
import org.apache.nifi.web.util.LifecycleManagementException;
import org.apache.nifi.web.util.ParameterUpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/parameter-providers")
@Tag(name="ParameterProviders")
public class ParameterProviderResource
extends AbstractParameterResource {
    private static final Logger logger = LoggerFactory.getLogger(ParameterProviderResource.class);
    private NiFiServiceFacade serviceFacade;
    private DtoFactory dtoFactory;
    private Authorizer authorizer;
    private ParameterUpdateManager parameterUpdateManager;
    private static final String VERIFICATION_REQUEST_TYPE = "verification-request";
    private RequestManager<VerifyConfigRequestEntity, List<ConfigVerificationResultDTO>> configVerificationRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Verify Parameter Provider Config Thread");
    private RequestManager<List<ParameterContextEntity>, List<ParameterContextEntity>> updateRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Parameter Provider Apply Thread");
    private ComponentLifecycle clusterComponentLifecycle;
    private ComponentLifecycle localComponentLifecycle;
    @Context
    private ServletContext servletContext;

    public void init() {
        this.parameterUpdateManager = new ParameterUpdateManager(this.serviceFacade, this.dtoFactory, this.authorizer, (AbstractParameterResource)this);
    }

    private void authorizeReadParameterProvider(String parameterProviderId) {
        if (parameterProviderId == null) {
            throw new IllegalArgumentException("Parameter Provider ID must be specified");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            ComponentAuthorizable parameterProvider = lookup.getParameterProvider(parameterProviderId);
            parameterProvider.getAuthorizable().authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    public Set<ParameterProviderEntity> populateRemainingParameterProviderEntitiesContent(Set<ParameterProviderEntity> parameterProviderEntities) {
        for (ParameterProviderEntity parameterProviderEntity : parameterProviderEntities) {
            this.populateRemainingParameterProviderEntityContent(parameterProviderEntity);
        }
        return parameterProviderEntities;
    }

    public ParameterProviderEntity populateRemainingParameterProviderEntityContent(ParameterProviderEntity parameterProviderEntity) {
        parameterProviderEntity.setUri(this.generateResourceUri(new String[]{"parameter-providers", parameterProviderEntity.getId()}));
        if (parameterProviderEntity.getComponent() != null) {
            this.populateRemainingParameterProviderContent(parameterProviderEntity.getComponent());
        }
        return parameterProviderEntity;
    }

    public ParameterProviderDTO populateRemainingParameterProviderContent(ParameterProviderDTO parameterProvider) {
        BundleDTO bundle = parameterProvider.getBundle();
        if (bundle == null) {
            return parameterProvider;
        }
        UiExtensionMapping uiExtensionMapping = (UiExtensionMapping)this.servletContext.getAttribute("nifi-ui-extensions");
        if (uiExtensionMapping.hasUiExtension(parameterProvider.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion())) {
            List uiExtensions = uiExtensionMapping.getUiExtension(parameterProvider.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
            for (UiExtension uiExtension : uiExtensions) {
                if (!UiExtensionType.ParameterProviderConfiguration.equals((Object)uiExtension.getExtensionType())) continue;
                parameterProvider.setCustomUiUrl(uiExtension.getContextPath() + "/configure");
            }
        }
        return parameterProvider;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Gets a parameter provider", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderEntity.class))})}, security={@SecurityRequirement(name="Read - /parameter-providers/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getParameterProvider(@Parameter(description="The parameter provider id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable parameterProvider = lookup.getParameterProvider(id).getAuthorizable();
            parameterProvider.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ParameterProviderEntity parameterProvider = this.serviceFacade.getParameterProvider(id);
        this.populateRemainingParameterProviderEntityContent(parameterProvider);
        return this.generateOkResponse((Object)parameterProvider).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/references")
    @Operation(summary="Gets all references to a parameter provider", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderReferencingComponentsEntity.class))})}, security={@SecurityRequirement(name="Read - /parameter-providers/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getParameterProviderReferences(@Parameter(description="The parameter provider id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable parameterProvider = lookup.getParameterProvider(id).getAuthorizable();
            parameterProvider.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ParameterProviderReferencingComponentsEntity entity = this.serviceFacade.getParameterProviderReferencingComponents(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/descriptors")
    @Operation(summary="Gets a parameter provider property descriptor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PropertyDescriptorEntity.class))})}, security={@SecurityRequirement(name="Read - /parameter-providers/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getPropertyDescriptor(@Parameter(description="The parameter provider id.", required=true) @PathParam(value="id") String id, @Parameter(description="The property name.", required=true) @QueryParam(value="propertyName") String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable parameterProvider = lookup.getParameterProvider(id).getAuthorizable();
            parameterProvider.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        PropertyDescriptorDTO descriptor = this.serviceFacade.getParameterProviderPropertyDescriptor(id, propertyName);
        PropertyDescriptorEntity entity = new PropertyDescriptorEntity();
        entity.setPropertyDescriptor(descriptor);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state")
    @Operation(summary="Gets the state for a parameter provider", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ComponentStateEntity.class))})}, security={@SecurityRequirement(name="Write - /parameter-providers/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getState(@Parameter(description="The parameter provider id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable parameterProvider = lookup.getParameterProvider(id).getAuthorizable();
            parameterProvider.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        });
        ComponentStateDTO state = this.serviceFacade.getParameterProviderState(id);
        ComponentStateEntity entity = new ComponentStateEntity();
        entity.setComponentState(state);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state/clear-requests")
    @Operation(summary="Clears the state for a parameter provider", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ComponentStateEntity.class))})}, security={@SecurityRequirement(name="Write - /parameter-providers/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response clearState(@Parameter(description="The parameter provider id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ParameterProviderEntity requestParameterProviderEntity = new ParameterProviderEntity();
        requestParameterProviderEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestParameterProviderEntity, lookup -> {
            Authorizable processor = lookup.getParameterProvider(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanClearParameterProviderState(id), parameterProviderEntity -> {
            this.serviceFacade.clearParameterProviderState(parameterProviderEntity.getId());
            ComponentStateEntity entity = new ComponentStateEntity();
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Updates a parameter provider", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderEntity.class))})}, security={@SecurityRequirement(name="Write - /parameter-providers/{uuid}"), @SecurityRequirement(name="Read - any referenced Controller Services if this request changes the reference - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateParameterProvider(@Parameter(description="The parameter provider id.", required=true) @PathParam(value="id") String id, @Parameter(description="The parameter provider configuration details.", required=true) ParameterProviderEntity requestParameterProviderEntity) {
        if (requestParameterProviderEntity == null || requestParameterProviderEntity.getComponent() == null) {
            throw new IllegalArgumentException("Parameter provider details must be specified.");
        }
        if (requestParameterProviderEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ParameterProviderDTO requestParameterProviderDTO = requestParameterProviderEntity.getComponent();
        if (!id.equals(requestParameterProviderDTO.getId())) {
            throw new IllegalArgumentException(String.format("The parameter provider id (%s) in the request body does not equal the parameter provider id of the requested resource (%s).", requestParameterProviderDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestParameterProviderEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestParameterProviderEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestParameterProviderEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestParameterProviderEntity, requestRevision, lookup -> {
            ComponentAuthorizable authorizable = lookup.getParameterProvider(id);
            authorizable.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestParameterProviderDTO.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
        }, () -> this.serviceFacade.verifyUpdateParameterProvider(requestParameterProviderDTO), (revision, parameterProviderEntity) -> {
            ParameterProviderDTO parameterProviderDTO = parameterProviderEntity.getComponent();
            ParameterProviderEntity entity = this.serviceFacade.updateParameterProvider(revision, parameterProviderDTO);
            this.populateRemainingParameterProviderEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Deletes a parameter provider", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderEntity.class))})}, security={@SecurityRequirement(name="Write - /parameter-providers/{uuid}"), @SecurityRequirement(name="Write - /controller"), @SecurityRequirement(name="Read - any referenced Controller Services - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response removeParameterProvider(@Parameter(description="The revision is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The parameter provider id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        ParameterProviderEntity requestParameterProviderEntity = new ParameterProviderEntity();
        requestParameterProviderEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestParameterProviderEntity, requestRevision, lookup -> {
            ComponentAuthorizable parameterProvider = lookup.getParameterProvider(id);
            parameterProvider.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            parameterProvider.getAuthorizable().getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)parameterProvider, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (boolean)false);
        }, () -> this.serviceFacade.verifyDeleteParameterProvider(id), (revision, parameterProviderEntity) -> {
            ParameterProviderEntity entity = this.serviceFacade.deleteParameterProvider(revision, parameterProviderEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/parameters/fetch-requests")
    @Operation(summary="Fetches and temporarily caches the parameters for a provider", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderEntity.class))})}, security={@SecurityRequirement(name="Write - /parameter-providers/{uuid} or  or /operation/parameter-providers/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response fetchParameters(@Parameter(description="The parameter provider id.", required=true) @PathParam(value="id") String parameterProviderId, @Parameter(description="The parameter fetch request.", required=true) ParameterProviderParameterFetchEntity fetchParametersEntity) {
        if (fetchParametersEntity.getId() == null) {
            throw new IllegalArgumentException("The ID of the Parameter Provider must be specified");
        }
        if (!fetchParametersEntity.getId().equals(parameterProviderId)) {
            throw new IllegalArgumentException("The ID of the Parameter Provider must match the ID specified in the URL's path");
        }
        if (fetchParametersEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)fetchParametersEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(fetchParametersEntity.isDisconnectedNodeAcknowledged());
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        ParameterProviderEntity parameterProviderEntity = this.serviceFacade.getParameterProvider(fetchParametersEntity.getId());
        Collection references = Optional.ofNullable(parameterProviderEntity.getComponent().getReferencingParameterContexts()).orElse(Collections.emptySet());
        HashSet referencingComponents = new HashSet();
        HashSet referencingParameterContextDtos = new HashSet();
        references.forEach(referencingEntity -> {
            String parameterContextId = referencingEntity.getComponent().getId();
            ParameterContextEntity parameterContextEntity = this.serviceFacade.getParameterContext(parameterContextId, true, user);
            parameterContextEntity.getComponent().getParameters().stream().filter(dto -> Boolean.TRUE.equals(dto.getParameter().getProvided())).forEach(p -> referencingComponents.addAll(p.getParameter().getReferencingComponents()));
            referencingParameterContextDtos.add(parameterContextEntity.getComponent());
        });
        Revision requestRevision = this.getRevision(fetchParametersEntity.getRevision(), fetchParametersEntity.getId());
        return this.withWriteLock(this.serviceFacade, (Entity)fetchParametersEntity, requestRevision, lookup -> {
            ComponentAuthorizable authorizable = lookup.getParameterProvider(fetchParametersEntity.getId());
            authorizable.getAuthorizable().authorize(this.authorizer, RequestAction.READ, user);
            references.forEach(reference -> lookup.getParameterContext(reference.getComponent().getId()).authorize(this.authorizer, RequestAction.READ, user));
        }, () -> this.serviceFacade.verifyCanFetchParameters(fetchParametersEntity.getId()), (revision, parameterProviderFetchEntity) -> {
            Set parameterStatus;
            ParameterProviderEntity entity = this.serviceFacade.fetchParameters(parameterProviderFetchEntity.getId());
            ArrayList parameterGroupConfigurations = new ArrayList();
            this.getParameterGroupConfigurations(entity.getComponent().getParameterGroupConfigurations()).forEach(group -> {
                Set<String> unspecifiedParameters = group.getParameterSensitivities().entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
                HashMap updatedSensitivities = new HashMap(group.getParameterSensitivities());
                unspecifiedParameters.forEach(parameterName -> updatedSensitivities.put(parameterName, ParameterSensitivity.SENSITIVE));
                parameterGroupConfigurations.add(new ParameterGroupConfiguration(group.getGroupName(), group.getParameterContextName(), updatedSensitivities, group.isSynchronized()));
            });
            List parameterContextUpdates = this.serviceFacade.getParameterContextUpdatesForAppliedParameters(parameterProviderId, parameterGroupConfigurations);
            Set removedParameters = parameterContextUpdates.stream().flatMap(context -> context.getComponent().getParameters().stream()).filter(parameterEntity -> {
                ParameterDTO dto = parameterEntity.getParameter();
                return dto.getSensitive() == null && dto.getValue() == null && dto.getDescription() == null;
            }).collect(Collectors.toSet());
            Set affectedComponents = this.getAffectedComponentEntities(parameterContextUpdates);
            if (!affectedComponents.isEmpty()) {
                entity.getComponent().setAffectedComponents(affectedComponents);
            }
            if (!(parameterStatus = this.getParameterStatus(entity, parameterContextUpdates, removedParameters, user)).isEmpty()) {
                entity.getComponent().setParameterStatus(parameterStatus);
            }
            this.populateRemainingParameterProviderEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    private void authorizeReferencingComponents(String parameterContextId, AuthorizableLookup lookup, NiFiUser user) {
        ParameterContextEntity context = this.serviceFacade.getParameterContext(parameterContextId, false, NiFiUserUtils.getNiFiUser());
        for (ParameterEntity parameterEntity : context.getComponent().getParameters()) {
            ParameterDTO dto = parameterEntity.getParameter();
            if (dto == null) continue;
            for (AffectedComponentEntity affectedComponent : dto.getReferencingComponents()) {
                this.parameterUpdateManager.authorizeAffectedComponent(affectedComponent, lookup, user, true, false);
            }
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{providerId}/apply-parameters-requests")
    @Operation(summary="Initiate a request to apply the fetched parameters of a Parameter Provider", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderApplyParametersRequestEntity.class))})}, description="This will initiate the process of applying fetched parameters to all referencing Parameter Contexts. Changing the value of a Parameter may require that one or more components be stopped and restarted, so this action may take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterProviderApplyParametersRequestEntity, and the process of updating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-providers/apply-parameters-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-providers/apply-parameters-requests/{requestId}.", security={@SecurityRequirement(name="Read - /parameter-providers/{parameterProviderId}"), @SecurityRequirement(name="Write - /parameter-providers/{parameterProviderId}"), @SecurityRequirement(name="Read - for every component that is affected by the update"), @SecurityRequirement(name="Write - for every component that is affected by the update")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitApplyParameters(@PathParam(value="providerId") String parameterProviderId, @Parameter(description="The apply parameters request.", required=true) ParameterProviderParameterApplicationEntity requestEntity) {
        if (requestEntity == null) {
            throw new IllegalArgumentException("Apply Parameters Request must be specified.");
        }
        RevisionDTO revisionDto = requestEntity.getRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Parameter Provider Revision must be specified");
        }
        if (requestEntity.getId() == null) {
            throw new IllegalArgumentException("Parameter Provider's ID must be specified");
        }
        if (!requestEntity.getId().equals(parameterProviderId)) {
            throw new IllegalArgumentException("ID of Parameter Provider in message body does not match Parameter Provider ID supplied in URI");
        }
        boolean replicateRequest = this.isReplicateRequest();
        ComponentLifecycle componentLifecycle = replicateRequest ? this.clusterComponentLifecycle : this.localComponentLifecycle;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Collection parameterGroupConfigurations = this.getParameterGroupConfigurations(requestEntity.getParameterGroupConfigurations());
        this.validateParameterGroupConfigurations(parameterProviderId, parameterGroupConfigurations, user);
        parameterGroupConfigurations.stream().filter(parameterGroupConfiguration -> this.requiresNewParameterContext(parameterGroupConfiguration, user)).forEach(parameterGroupConfiguration -> {
            ParameterContextEntity newParameterContext = this.getNewParameterContextEntity(parameterProviderId, parameterGroupConfiguration);
            try {
                this.performParameterContextCreate(user, this.getAbsolutePath(), replicateRequest, newParameterContext);
            }
            catch (LifecycleManagementException e) {
                throw new RuntimeException("Failed to create Parameter Context " + parameterGroupConfiguration.getGroupName(), e);
            }
        });
        List parameterContextUpdates = this.serviceFacade.getParameterContextUpdatesForAppliedParameters(parameterProviderId, parameterGroupConfigurations);
        Set affectedComponents = this.getAffectedComponentEntities(parameterContextUpdates);
        logger.debug("Received Apply Request for Parameter Provider: {}; the following {} components will be affected: {}", new Object[]{requestEntity, affectedComponents.size(), affectedComponents});
        InitiateParameterProviderApplyParametersRequestWrapper requestWrapper = new InitiateParameterProviderApplyParametersRequestWrapper(parameterProviderId, parameterContextUpdates, componentLifecycle, this.getAbsolutePath(), affectedComponents, replicateRequest, user);
        Revision requestRevision = this.getRevision(requestEntity.getRevision(), parameterProviderId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestWrapper, requestRevision, lookup -> {
            ComponentAuthorizable parameterProvider = lookup.getParameterProvider(parameterProviderId);
            parameterProvider.getAuthorizable().authorize(this.authorizer, RequestAction.READ, user);
            parameterContextUpdates.forEach(context -> {
                ParameterContext parameterContext = lookup.getParameterContext(context.getComponent().getId());
                parameterContext.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
                parameterContext.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            });
            affectedComponents.forEach(component -> this.parameterUpdateManager.authorizeAffectedComponent(component, lookup, user, true, true));
        }, () -> this.serviceFacade.verifyCanApplyParameters(parameterProviderId, parameterGroupConfigurations), (arg_0, arg_1) -> this.submitApplyRequest(arg_0, arg_1));
    }

    private Set<AffectedComponentEntity> getAffectedComponentEntities(List<ParameterContextEntity> parameterContextUpdates) {
        Collection updatedParameterContextDTOs = parameterContextUpdates.stream().map(ParameterContextEntity::getComponent).collect(Collectors.toList());
        return this.serviceFacade.getComponentsAffectedByParameterContextUpdate(updatedParameterContextDTOs);
    }

    private Set<ParameterStatusDTO> getParameterStatus(ParameterProviderEntity parameterProvider, List<ParameterContextEntity> parameterContextUpdates, Set<ParameterEntity> removedParameters, NiFiUser niFiUser) {
        HashSet<ParameterStatusDTO> parameterStatus = new HashSet<ParameterStatusDTO>();
        if (parameterProvider.getComponent() == null || parameterProvider.getComponent().getReferencingParameterContexts() == null) {
            return parameterStatus;
        }
        HashMap removedParameterNamesByContextId = new HashMap();
        removedParameters.forEach(parameterEntity -> removedParameterNamesByContextId.computeIfAbsent(parameterEntity.getParameter().getParameterContext().getComponent().getId(), key -> new HashSet()).add(parameterEntity.getParameter().getName()));
        Map parameterContextUpdateMap = parameterContextUpdates.stream().collect(Collectors.toMap(entity -> entity.getComponent().getId(), Functions.identity()));
        for (ParameterProviderReferencingComponentEntity reference : parameterProvider.getComponent().getReferencingParameterContexts()) {
            String parameterContextId = reference.getComponent().getId();
            ParameterContextEntity parameterContext = this.serviceFacade.getParameterContext(parameterContextId, false, niFiUser);
            if (parameterContext.getComponent() == null) continue;
            Set removedParameterNames = (Set)removedParameterNamesByContextId.get(parameterContext.getComponent().getId());
            ParameterContextEntity parameterContextUpdate = (ParameterContextEntity)parameterContextUpdateMap.get(parameterContextId);
            Map<String, ParameterEntity> updatedParameters = parameterContextUpdate == null ? Collections.emptyMap() : parameterContextUpdate.getComponent().getParameters().stream().collect(Collectors.toMap(parameter -> parameter.getParameter().getName(), Functions.identity()));
            HashSet<String> currentParameterNames = new HashSet<String>();
            for (ParameterEntity parameter2 : parameterContext.getComponent().getParameters()) {
                currentParameterNames.add(parameter2.getParameter().getName());
                ParameterStatusDTO dto2 = new ParameterStatusDTO();
                ParameterEntity updatedParameter = (ParameterEntity)updatedParameters.get(parameter2.getParameter().getName());
                if (updatedParameter == null) {
                    dto2.setParameter(parameter2);
                    if (removedParameterNames != null && removedParameterNames.contains(parameter2.getParameter().getName())) {
                        dto2.setStatus(ParameterStatus.MISSING_BUT_REFERENCED);
                    } else {
                        dto2.setStatus(ParameterStatus.UNCHANGED);
                    }
                } else {
                    ParameterDTO updatedParameterDTO = updatedParameter.getParameter();
                    boolean isDeletion = updatedParameterDTO.getSensitive() == null && updatedParameterDTO.getDescription() == null && updatedParameterDTO.getValue() == null;
                    dto2.setParameter(updatedParameter);
                    dto2.setStatus(isDeletion ? ParameterStatus.REMOVED : ParameterStatus.CHANGED);
                }
                parameterStatus.add(dto2);
            }
            updatedParameters.forEach((parameterName, parameterEntity) -> {
                if (!currentParameterNames.contains(parameterName)) {
                    ParameterStatusDTO dto = new ParameterStatusDTO();
                    dto.setParameter(parameterEntity);
                    dto.setStatus(ParameterStatus.NEW);
                    parameterStatus.add(dto);
                }
            });
            parameterStatus.forEach(dto -> {
                ParameterDTO parameterDTO = dto.getParameter().getParameter();
                if (parameterDTO.getValue() != null && parameterDTO.getSensitive() != null && parameterDTO.getSensitive().booleanValue()) {
                    parameterDTO.setValue("********");
                }
            });
        }
        return parameterStatus;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{providerId}/apply-parameters-requests/{requestId}")
    @Operation(summary="Returns the Apply Parameters Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderApplyParametersRequestEntity.class))})}, description="Returns the Apply Parameters Request with the given ID. Once an Apply Parameters Request has been created by performing a POST to /nifi-api/parameter-providers, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the state, such as percent complete, the current state of the request, and any failures. ", security={@SecurityRequirement(name="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getParameterProviderApplyParametersRequest(@Parameter(description="The ID of the Parameter Provider") @PathParam(value="providerId") String parameterProviderId, @Parameter(description="The ID of the Apply Parameters Request") @PathParam(value="requestId") String applyParametersRequestId) {
        this.authorizeReadParameterProvider(parameterProviderId);
        return this.retrieveApplyParametersRequest("apply-parameters-requests", parameterProviderId, applyParametersRequestId);
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{providerId}/apply-parameters-requests/{requestId}")
    @Operation(summary="Deletes the Apply Parameters Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderApplyParametersRequestEntity.class))})}, description="Deletes the Apply Parameters Request with the given ID. After a request is created via a POST to /nifi-api/parameter-providers/apply-parameters-requests, it is expected that the client will properly clean up the request by DELETE'ing it, once the Apply process has completed. If the request is deleted before the request completes, then the Apply Parameters Request will finish the step that it is currently performing and then will cancel any subsequent steps.", security={@SecurityRequirement(name="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteApplyParametersRequest(@Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The ID of the Parameter Provider") @PathParam(value="providerId") String parameterProviderId, @Parameter(description="The ID of the Apply Parameters Request") @PathParam(value="requestId") String applyParametersRequestId) {
        this.authorizeReadParameterProvider(parameterProviderId);
        return this.deleteApplyParametersRequest("apply-parameters-requests", parameterProviderId, applyParametersRequestId, disconnectedNodeAcknowledged.booleanValue());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/config/analysis")
    @Operation(summary="Performs analysis of the component's configuration, providing information about which attributes are referenced.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConfigurationAnalysisEntity.class))})}, security={@SecurityRequirement(name="Read - /parameter-providers/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response analyzeConfiguration(@Parameter(description="The parameter provider id.", required=true) @PathParam(value="id") String parameterProviderId, @Parameter(description="The configuration analysis request.", required=true) ConfigurationAnalysisEntity configurationAnalysis) {
        if (configurationAnalysis == null || configurationAnalysis.getConfigurationAnalysis() == null) {
            throw new IllegalArgumentException("Parameter Provider's configuration must be specified");
        }
        ConfigurationAnalysisDTO dto = configurationAnalysis.getConfigurationAnalysis();
        if (dto.getComponentId() == null) {
            throw new IllegalArgumentException("Parameter Provider's identifier must be specified in the request");
        }
        if (!dto.getComponentId().equals(parameterProviderId)) {
            throw new IllegalArgumentException("Parameter Provider's identifier in the request must match the identifier provided in the URL");
        }
        if (dto.getProperties() == null) {
            throw new IllegalArgumentException("Parameter Provider's properties must be specified in the request");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)configurationAnalysis);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)configurationAnalysis, lookup -> {
            ComponentAuthorizable parameterProvider = lookup.getParameterProvider(parameterProviderId);
            parameterProvider.getAuthorizable().authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> {}, entity -> {
            ConfigurationAnalysisDTO analysis = entity.getConfigurationAnalysis();
            ConfigurationAnalysisEntity resultsEntity = this.serviceFacade.analyzeParameterProviderConfiguration(analysis.getComponentId(), analysis.getProperties());
            return this.generateOkResponse((Object)resultsEntity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/config/verification-requests")
    @Operation(summary="Performs verification of the Parameter Provider's configuration", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="This will initiate the process of verifying a given Parameter Provider configuration. This may be a long-running task. As a result, this endpoint will immediately return a ParameterProviderConfigVerificationRequestEntity, and the process of performing the verification will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-providers/{serviceId}/verification-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-providers/{providerId}/verification-requests/{requestId}.", security={@SecurityRequirement(name="Read - /parameter-providers/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitConfigVerificationRequest(@Parameter(description="The parameter provider id.", required=true) @PathParam(value="id") String parameterProviderId, @Parameter(description="The parameter provider configuration verification request.", required=true) VerifyConfigRequestEntity parameterProviderConfigRequest) {
        if (parameterProviderConfigRequest == null) {
            throw new IllegalArgumentException("Parameter Provider's configuration must be specified");
        }
        VerifyConfigRequestDTO requestDto = parameterProviderConfigRequest.getRequest();
        if (requestDto == null || requestDto.getProperties() == null) {
            throw new IllegalArgumentException("Parameter Provider Properties must be specified");
        }
        if (requestDto.getComponentId() == null) {
            throw new IllegalArgumentException("Parameter Provider's identifier must be specified in the request");
        }
        if (!requestDto.getComponentId().equals(parameterProviderId)) {
            throw new IllegalArgumentException("Parameter Provider's identifier in the request must match the identifier provided in the URL");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)parameterProviderConfigRequest);
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return this.withWriteLock(this.serviceFacade, (Entity)parameterProviderConfigRequest, lookup -> {
            ComponentAuthorizable parameterProvider = lookup.getParameterProvider(parameterProviderId);
            parameterProvider.getAuthorizable().authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanVerifyParameterProviderConfig(parameterProviderId), entity -> this.performAsyncConfigVerification(entity, user));
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/config/verification-requests/{requestId}")
    @Operation(summary="Returns the Verification Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="Returns the Verification Request with the given ID. Once an Verification Request has been created, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. ", security={@SecurityRequirement(name="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getVerificationRequest(@Parameter(description="The ID of the Parameter Provider") @PathParam(value="id") String parameterProviderId, @Parameter(description="The ID of the Verification Request") @PathParam(value="requestId") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.configVerificationRequestManager.getRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
        VerifyConfigRequestEntity updateRequestEntity = this.createVerifyParameterProviderConfigRequestEntity(asyncRequest, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/config/verification-requests/{requestId}")
    @Operation(summary="Deletes the Verification Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="Deletes the Verification Request with the given ID. After a request is created, it is expected that the client will properly clean up the request by DELETE'ing it, once the Verification process has completed. If the request is deleted before the request completes, then the Verification request will finish the step that it is currently performing and then will cancel any subsequent steps.", security={@SecurityRequirement(name="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteVerificationRequest(@Parameter(description="The ID of the Parameter Provider") @PathParam(value="id") String parameterProviderId, @Parameter(description="The ID of the Verification Request") @PathParam(value="requestId") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        boolean twoPhaseRequest = this.isTwoPhaseRequest(this.httpServletRequest);
        boolean executionPhase = this.isExecutionPhase(this.httpServletRequest);
        if (!twoPhaseRequest || executionPhase) {
            AsynchronousWebRequest asyncRequest = this.configVerificationRequestManager.removeRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
            if (asyncRequest == null) {
                throw new ResourceNotFoundException("Could not find request of type verification-request with ID " + requestId);
            }
            if (!asyncRequest.isComplete()) {
                asyncRequest.cancel();
            }
            VerifyConfigRequestEntity updateRequestEntity = this.createVerifyParameterProviderConfigRequestEntity(asyncRequest, requestId);
            return this.generateOkResponse((Object)updateRequestEntity).build();
        }
        if (this.isValidationPhase(this.httpServletRequest)) {
            this.configVerificationRequestManager.getRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
            return this.generateContinueResponse().build();
        }
        if (this.isCancellationPhase(this.httpServletRequest)) {
            return this.generateOkResponse().build();
        }
        throw new IllegalStateException("This request does not appear to be part of the two phase commit.");
    }

    public Response performAsyncConfigVerification(VerifyConfigRequestEntity configRequest, NiFiUser user) {
        String requestId = this.generateUuid();
        VerifyConfigRequestDTO requestDto = configRequest.getRequest();
        String parameterProviderId = requestDto.getComponentId();
        List<StandardUpdateStep> updateSteps = Collections.singletonList(new StandardUpdateStep("Verify Parameter Provider Configuration"));
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)configRequest, parameterProviderId, user, updateSteps);
        Consumer<AsynchronousWebRequest> verifyTask = asyncRequest -> {
            try {
                List results = this.serviceFacade.performParameterProviderConfigVerification(parameterProviderId, requestDto.getProperties());
                asyncRequest.markStepComplete((Object)results);
            }
            catch (Exception e) {
                logger.error("Failed to verify Parameter Provider configuration", (Throwable)e);
                asyncRequest.fail("Failed to verify Parameter Provider configuration due to " + String.valueOf(e));
            }
        };
        this.configVerificationRequestManager.submitRequest(VERIFICATION_REQUEST_TYPE, requestId, (AsynchronousWebRequest)request, verifyTask);
        VerifyConfigRequestEntity resultsEntity = this.createVerifyParameterProviderConfigRequestEntity((AsynchronousWebRequest)request, requestId);
        return this.generateOkResponse((Object)resultsEntity).build();
    }

    private VerifyConfigRequestEntity createVerifyParameterProviderConfigRequestEntity(AsynchronousWebRequest<VerifyConfigRequestEntity, List<ConfigVerificationResultDTO>> asyncRequest, String requestId) {
        VerifyConfigRequestDTO requestDto = ((VerifyConfigRequestEntity)asyncRequest.getRequest()).getRequest();
        List resultsList = (List)asyncRequest.getResults();
        VerifyConfigRequestDTO dto = new VerifyConfigRequestDTO();
        dto.setComponentId(requestDto.getComponentId());
        dto.setProperties(requestDto.getProperties());
        dto.setResults(resultsList);
        dto.setComplete(resultsList != null);
        dto.setFailureReason(asyncRequest.getFailureReason());
        dto.setLastUpdated(asyncRequest.getLastUpdated());
        dto.setPercentCompleted(asyncRequest.getPercentComplete());
        dto.setRequestId(requestId);
        dto.setState(asyncRequest.getState());
        dto.setUri(this.generateResourceUri(new String[]{"parameter-providers", requestDto.getComponentId(), "config", "verification-requests", requestId}));
        VerifyConfigRequestEntity entity = new VerifyConfigRequestEntity();
        entity.setRequest(dto);
        return entity;
    }

    private Response retrieveApplyParametersRequest(String requestType, String parameterProviderId, String requestId) {
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.updateRequestManager.getRequest(requestType, requestId, user);
        ParameterProviderApplyParametersRequestEntity applyParametersRequestEntity = this.createApplyParametersRequestEntity(asyncRequest, requestType, parameterProviderId, requestId);
        return this.generateOkResponse((Object)applyParametersRequestEntity).build();
    }

    private Response deleteApplyParametersRequest(String requestType, String parameterProviderId, String requestId, boolean disconnectedNodeAcknowledged) {
        NiFiUser user;
        AsynchronousWebRequest asyncRequest;
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(Boolean.valueOf(disconnectedNodeAcknowledged));
        }
        if ((asyncRequest = this.updateRequestManager.removeRequest(requestType, requestId, user = NiFiUserUtils.getNiFiUser())) == null) {
            throw new ResourceNotFoundException("Could not find request of type " + requestType + " with ID " + requestId);
        }
        if (!asyncRequest.isComplete()) {
            asyncRequest.cancel();
        }
        ParameterProviderApplyParametersRequestEntity applyParametersRequestEntity = this.createApplyParametersRequestEntity(asyncRequest, requestType, parameterProviderId, requestId);
        return this.generateOkResponse((Object)applyParametersRequestEntity).build();
    }

    private ParameterProviderApplyParametersRequestEntity createApplyParametersRequestEntity(AsynchronousWebRequest<List<ParameterContextEntity>, List<ParameterContextEntity>> asyncRequest, String requestType, String parameterProviderId, String requestId) {
        ParameterProviderApplyParametersRequestEntity applyParametersRequestEntity = new ParameterProviderApplyParametersRequestEntity();
        ParameterProviderApplyParametersRequestDTO applyParametersRequestDTO = new ParameterProviderApplyParametersRequestDTO();
        applyParametersRequestDTO.setComplete(asyncRequest.isComplete());
        applyParametersRequestDTO.setFailureReason(asyncRequest.getFailureReason());
        applyParametersRequestDTO.setLastUpdated(asyncRequest.getLastUpdated());
        applyParametersRequestDTO.setRequestId(requestId);
        applyParametersRequestDTO.setUri(this.generateResourceUri(new String[]{"parameter-providers", parameterProviderId, requestType, requestId}));
        applyParametersRequestDTO.setState(asyncRequest.getState());
        applyParametersRequestDTO.setPercentCompleted(asyncRequest.getPercentComplete());
        ParameterProviderEntity parameterProvider = this.serviceFacade.getParameterProvider(parameterProviderId);
        applyParametersRequestDTO.setParameterProvider(parameterProvider.getComponent());
        ArrayList<ParameterProviderApplyParametersUpdateStepDTO> updateSteps = new ArrayList<ParameterProviderApplyParametersUpdateStepDTO>();
        for (UpdateStep updateStep : asyncRequest.getUpdateSteps()) {
            ParameterProviderApplyParametersUpdateStepDTO stepDto = new ParameterProviderApplyParametersUpdateStepDTO();
            stepDto.setDescription(updateStep.getDescription());
            stepDto.setComplete(updateStep.isComplete());
            stepDto.setFailureReason(updateStep.getFailureReason());
            updateSteps.add(stepDto);
        }
        applyParametersRequestDTO.setUpdateSteps(updateSteps);
        HashMap<String, AffectedComponentEntity> overallAffectedComponents = new HashMap<String, AffectedComponentEntity>();
        ArrayList<ParameterContextUpdateEntity> parameterContextUpdates = new ArrayList<ParameterContextUpdateEntity>();
        applyParametersRequestDTO.setParameterContextUpdates(parameterContextUpdates);
        List initialRequestList = (List)asyncRequest.getRequest();
        for (ParameterContextEntity parameterContextEntity : initialRequestList) {
            HashMap<String, AffectedComponentEntity> affectedComponents = new HashMap<String, AffectedComponentEntity>();
            for (ParameterEntity entity : parameterContextEntity.getComponent().getParameters()) {
                for (AffectedComponentEntity affectedComponentEntity : entity.getParameter().getReferencingComponents()) {
                    AffectedComponentEntity updatedAffectedComponentEntity = this.serviceFacade.getUpdatedAffectedComponentEntity(affectedComponentEntity);
                    String affectedComponentEntityId = affectedComponentEntity.getId();
                    affectedComponents.put(affectedComponentEntityId, updatedAffectedComponentEntity);
                    overallAffectedComponents.put(affectedComponentEntityId, updatedAffectedComponentEntity);
                }
            }
            ParameterContextEntity contextEntity = this.serviceFacade.getParameterContext(parameterContextEntity.getId(), false, NiFiUserUtils.getNiFiUser());
            ParameterContextUpdateEntity parameterContextUpdate = new ParameterContextUpdateEntity();
            parameterContextUpdate.setReferencingComponents(new HashSet(affectedComponents.values()));
            if (applyParametersRequestDTO.isComplete()) {
                parameterContextUpdate.setParameterContext(contextEntity == null ? null : contextEntity.getComponent());
                parameterContextUpdate.setParameterContextRevision(contextEntity == null ? null : contextEntity.getRevision());
            }
            parameterContextUpdates.add(parameterContextUpdate);
        }
        applyParametersRequestDTO.setReferencingComponents(new HashSet(overallAffectedComponents.values()));
        applyParametersRequestEntity.setRequest(applyParametersRequestDTO);
        return applyParametersRequestEntity;
    }

    private void validateParameterGroupConfigurations(String parameterProviderId, Collection<ParameterGroupConfiguration> configurations, NiFiUser user) {
        HashSet<String> synchronizedParameterContextNames = new HashSet<String>();
        for (ParameterGroupConfiguration configuration : configurations) {
            this.validateParameterGroupConfiguration(parameterProviderId, configuration, user);
            if (configuration.isSynchronized() == null || !configuration.isSynchronized().booleanValue()) continue;
            String parameterContextName = Optional.ofNullable(configuration.getParameterContextName()).orElse(configuration.getGroupName());
            if (parameterContextName == null) {
                throw new IllegalArgumentException("A parameter group name is required for every synchronized parameter group");
            }
            if (synchronizedParameterContextNames.add(parameterContextName)) continue;
            throw new IllegalArgumentException(String.format("Two parameter groups cannot be mapped to the same parameter context [%s]", parameterContextName));
        }
    }

    private void validateParameterGroupConfiguration(String parameterProviderId, ParameterGroupConfiguration configuration, NiFiUser user) {
        ParameterProvider existingParameterProvider;
        String parameterContextName;
        ParameterContext existingParameterContext;
        if (configuration.isSynchronized() != null && configuration.isSynchronized().booleanValue() && (existingParameterContext = this.serviceFacade.getParameterContextByName(parameterContextName = Optional.ofNullable(configuration.getParameterContextName()).orElse(configuration.getGroupName()), user)) != null && ((existingParameterProvider = existingParameterContext.getParameterProvider()) == null || !existingParameterProvider.getIdentifier().equals(parameterProviderId))) {
            ParameterProviderEntity requestedParameterProvider = this.serviceFacade.getParameterProvider(parameterProviderId);
            throw new IllegalStateException(String.format("Cannot synchronize parameter group [%s] to a Parameter Context [%s] that is not provided by Parameter Provider [%s]", configuration.getGroupName(), existingParameterContext.getName(), requestedParameterProvider.getId()));
        }
    }

    private boolean requiresNewParameterContext(ParameterGroupConfiguration parameterGroupConfiguration, NiFiUser user) {
        if (parameterGroupConfiguration.isSynchronized() != null && parameterGroupConfiguration.isSynchronized().booleanValue()) {
            ParameterContext existingParameterContext = this.serviceFacade.getParameterContextByName(parameterGroupConfiguration.getParameterContextName(), user);
            return existingParameterContext == null;
        }
        return false;
    }

    private ParameterContextEntity getNewParameterContextEntity(String parameterProviderId, ParameterGroupConfiguration parameterGroupConfiguration) {
        ParameterContextEntity parameterContextEntity = new ParameterContextEntity();
        ParameterContextDTO parameterContextDTO = new ParameterContextDTO();
        parameterContextDTO.setName(parameterGroupConfiguration.getParameterContextName());
        ParameterProviderConfigurationEntity parameterProviderConfiguration = new ParameterProviderConfigurationEntity();
        ParameterProviderConfigurationDTO parameterProviderConfigurationDTO = new ParameterProviderConfigurationDTO();
        parameterProviderConfigurationDTO.setParameterProviderId(parameterProviderId);
        parameterProviderConfigurationDTO.setParameterGroupName(parameterGroupConfiguration.getGroupName());
        parameterProviderConfigurationDTO.setSynchronized(Boolean.valueOf(true));
        parameterProviderConfiguration.setComponent(parameterProviderConfigurationDTO);
        parameterContextDTO.setParameterProviderConfiguration(parameterProviderConfiguration);
        parameterContextEntity.setComponent(parameterContextDTO);
        RevisionDTO initialRevision = new RevisionDTO();
        initialRevision.setVersion(Long.valueOf(0L));
        parameterContextEntity.setRevision(initialRevision);
        return parameterContextEntity;
    }

    private Response submitApplyRequest(Revision requestRevision, InitiateParameterProviderApplyParametersRequestWrapper requestWrapper) {
        String requestId = UUID.randomUUID().toString();
        String parameterProviderId = requestWrapper.getParameterProviderId();
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)requestWrapper.getParameterContextEntities(), parameterProviderId, requestWrapper.getUser(), this.getUpdateSteps());
        Consumer<AsynchronousWebRequest> updateTask = asyncRequest -> {
            try {
                List updatedParameterContextEntities = this.parameterUpdateManager.updateParameterContexts(asyncRequest, requestWrapper.getComponentLifecycle(), requestWrapper.getExampleUri(), requestWrapper.getReferencingComponents(), requestWrapper.isReplicateRequest(), requestRevision, requestWrapper.getParameterContextEntities());
                asyncRequest.markStepComplete((Object)updatedParameterContextEntities);
            }
            catch (ResumeFlowException rfe) {
                logger.error(rfe.getMessage(), (Throwable)rfe);
                asyncRequest.fail(rfe.getMessage());
            }
            catch (Exception e) {
                logger.error("Failed to apply parameters", (Throwable)e);
                asyncRequest.fail("Failed to apply parameters due to " + String.valueOf(e));
            }
        };
        this.updateRequestManager.submitRequest("apply-parameters-requests", requestId, (AsynchronousWebRequest)request, updateTask);
        ParameterProviderApplyParametersRequestEntity applicationRequestEntity = this.createApplyParametersRequestEntity((AsynchronousWebRequest)request, "apply-parameters-requests", parameterProviderId, requestId);
        return this.generateOkResponse((Object)applicationRequestEntity).build();
    }

    private ParameterContextEntity performParameterContextCreate(NiFiUser user, URI exampleUri, boolean replicateRequest, ParameterContextEntity parameterContext) throws LifecycleManagementException {
        if (replicateRequest) {
            URI updateUri;
            try {
                updateUri = new URI(exampleUri.getScheme(), exampleUri.getUserInfo(), exampleUri.getHost(), exampleUri.getPort(), "/nifi-api/parameter-contexts", null, exampleUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("content-type", "application/json");
            NodeResponse clusterResponse = this.createParameterContext(parameterContext, updateUri, headers, user);
            int updateFlowStatus = clusterResponse.getStatus();
            if (updateFlowStatus != Response.Status.CREATED.getStatusCode()) {
                String explanation = (String)ParameterUpdateManager.getResponseEntity((NodeResponse)clusterResponse, String.class);
                logger.error("Failed to update flow across cluster when replicating POST request to {} for user {}. Received {} response with explanation: {}", new Object[]{updateUri, user, updateFlowStatus, explanation});
                throw new LifecycleManagementException("Failed to update Flow on all nodes in cluster due to " + explanation);
            }
            String parameterContextId = ((ParameterContextEntity)ParameterUpdateManager.getResponseEntity((NodeResponse)clusterResponse, ParameterContextEntity.class)).getId();
            return this.serviceFacade.getParameterContext(parameterContextId, false, user);
        }
        this.serviceFacade.verifyCreateParameterContext(parameterContext.getComponent());
        String contextId = this.generateUuid();
        parameterContext.getComponent().setId(contextId);
        Revision revision = this.getRevision(parameterContext.getRevision(), contextId);
        return this.serviceFacade.createParameterContext(revision, parameterContext.getComponent());
    }

    public NodeResponse createParameterContext(ParameterContextEntity parameterContext, URI updateUri, Map<String, String> headers, NiFiUser user) throws LifecycleManagementException {
        NodeResponse clusterResponse;
        try {
            logger.debug("Replicating POST request to {} for user {}", (Object)updateUri, (Object)user);
            clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "POST", updateUri, (Object)parameterContext, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "POST", updateUri, (Object)parameterContext, headers).awaitMergedResponse();
        }
        catch (InterruptedException ie) {
            logger.warn("Interrupted while replicating POST request to {} for user {}", (Object)updateUri, (Object)user);
            Thread.currentThread().interrupt();
            throw new LifecycleManagementException("Interrupted while updating flows across cluster", (Throwable)ie);
        }
        return clusterResponse;
    }

    private List<UpdateStep> getUpdateSteps() {
        return Arrays.asList(new StandardUpdateStep("Stopping Affected Processors"), new StandardUpdateStep("Disabling Affected Controller Services"), new StandardUpdateStep("Updating Parameter Contexts"), new StandardUpdateStep("Re-Enabling Affected Controller Services"), new StandardUpdateStep("Restarting Affected Processors"));
    }

    private Collection<ParameterGroupConfiguration> getParameterGroupConfigurations(Collection<ParameterGroupConfigurationEntity> groupConfigurationEntities) {
        ArrayList<ParameterGroupConfiguration> parameterGroupConfigurations = new ArrayList<ParameterGroupConfiguration>();
        if (groupConfigurationEntities != null) {
            for (ParameterGroupConfigurationEntity configurationEntity : groupConfigurationEntities) {
                parameterGroupConfigurations.add(new ParameterGroupConfiguration(configurationEntity.getGroupName(), configurationEntity.getParameterContextName(), configurationEntity.getParameterSensitivities(), configurationEntity.isSynchronized()));
            }
        }
        return parameterGroupConfigurations;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public ComponentLifecycle getClusterComponentLifecycle() {
        return this.clusterComponentLifecycle;
    }

    public void setClusterComponentLifecycle(ComponentLifecycle clusterComponentLifecycle) {
        this.clusterComponentLifecycle = clusterComponentLifecycle;
    }

    public ComponentLifecycle getLocalComponentLifecycle() {
        return this.localComponentLifecycle;
    }

    public void setLocalComponentLifecycle(ComponentLifecycle localComponentLifecycle) {
        this.localComponentLifecycle = localComponentLifecycle;
    }

    public DtoFactory getDtoFactory() {
        return this.dtoFactory;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }
}

