/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.service.StandardControllerServiceNode;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterReferencedControllerServiceData;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.ResumeFlowException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.AbstractParameterResource;
import org.apache.nifi.web.api.ParameterContextResource;
import org.apache.nifi.web.api.concurrent.AsyncRequestManager;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.apache.nifi.web.api.concurrent.StandardAsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.StandardUpdateStep;
import org.apache.nifi.web.api.concurrent.UpdateStep;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterContextUpdateRequestDTO;
import org.apache.nifi.web.api.dto.ParameterContextUpdateStepDTO;
import org.apache.nifi.web.api.dto.ParameterContextValidationRequestDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ComponentValidationResultsEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ParameterContextValidationRequestEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.apache.nifi.web.util.ComponentLifecycle;
import org.apache.nifi.web.util.ParameterUpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/parameter-contexts")
@Tag(name="ParameterContexts")
public class ParameterContextResource
extends AbstractParameterResource {
    private static final Logger logger = LoggerFactory.getLogger(ParameterContextResource.class);
    private static final Pattern VALID_PARAMETER_NAME_PATTERN = Pattern.compile("[A-Za-z0-9 ._\\-]+");
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    private DtoFactory dtoFactory;
    private ComponentLifecycle clusterComponentLifecycle;
    private ComponentLifecycle localComponentLifecycle;
    private ParameterUpdateManager parameterUpdateManager;
    private RequestManager<List<ParameterContextEntity>, List<ParameterContextEntity>> updateRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Parameter Context Update Thread");
    private RequestManager<ParameterContextValidationRequestEntity, ComponentValidationResultsEntity> validationRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Parameter Context Validation Thread");

    public void init() {
        this.parameterUpdateManager = new ParameterUpdateManager(this.serviceFacade, this.dtoFactory, this.authorizer, (AbstractParameterResource)this);
    }

    private void authorizeReadParameterContext(String parameterContextId) {
        if (parameterContextId == null) {
            throw new IllegalArgumentException("Parameter Context ID must be specified");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            ParameterContext parameterContext = lookup.getParameterContext(parameterContextId);
            parameterContext.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Returns the Parameter Context with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextEntity.class))})}, description="Returns the Parameter Context with the given ID.", security={@SecurityRequirement(name="Read - /parameter-contexts/{id}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getParameterContext(@io.swagger.v3.oas.annotations.Parameter(description="The ID of the Parameter Context") @PathParam(value="id") String parameterContextId, @io.swagger.v3.oas.annotations.Parameter(description="Whether or not to include inherited parameters from other parameter contexts, and therefore also overridden values.  If true, the result will be the 'effective' parameter context.") @QueryParam(value="includeInheritedParameters") @DefaultValue(value="false") boolean includeInheritedParameters) {
        this.authorizeReadParameterContext(parameterContextId);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ParameterContextEntity entity = this.serviceFacade.getParameterContext(parameterContextId, includeInheritedParameters, NiFiUserUtils.getNiFiUser());
        entity.setUri(this.generateResourceUri(new String[]{"parameter-contexts", entity.getId()}));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Parameter Context", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextEntity.class))})}, security={@SecurityRequirement(name="Write - /parameter-contexts"), @SecurityRequirement(name="Read - for every inherited parameter context")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createParameterContext(@io.swagger.v3.oas.annotations.Parameter(description="The Parameter Context.", required=true) ParameterContextEntity requestEntity) {
        if (requestEntity == null || requestEntity.getComponent() == null) {
            throw new IllegalArgumentException("Parameter Context must be specified");
        }
        if (requestEntity.getRevision() == null || requestEntity.getRevision().getVersion() == null || requestEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Parameter Context.");
        }
        ParameterContextDTO context = requestEntity.getComponent();
        if (context.getName() == null) {
            throw new IllegalArgumentException("Parameter Context's Name must be specified");
        }
        this.validateParameterNames(requestEntity.getComponent());
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> {
            Authorizable parameterContexts = lookup.getParameterContexts();
            parameterContexts.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCreateParameterContext(requestEntity.getComponent()), entity -> {
            String contextId = this.generateUuid();
            entity.getComponent().setId(contextId);
            Revision revision = this.getRevision(entity.getRevision(), contextId);
            ParameterContextEntity contextEntity = this.serviceFacade.createParameterContext(revision, entity.getComponent());
            String uri = this.generateResourceUri(new String[]{"parameter-contexts", contextEntity.getId()});
            contextEntity.setUri(uri);
            return this.generateCreatedResponse(URI.create(uri), (Object)contextEntity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Modifies a Parameter Context", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextEntity.class))})}, description="This endpoint will update a Parameter Context to match the provided entity. However, this request will fail if any component is running and is referencing a Parameter in the Parameter Context. Generally, this endpoint is not called directly. Instead, an update request should be submitted by making a POST to the /parameter-contexts/update-requests endpoint. That endpoint will, in turn, call this endpoint.", security={@SecurityRequirement(name="Read - /parameter-contexts/{id}"), @SecurityRequirement(name="Write - /parameter-contexts/{id}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateParameterContext(@PathParam(value="id") String contextId, @io.swagger.v3.oas.annotations.Parameter(description="The updated Parameter Context", required=true) ParameterContextEntity requestEntity) {
        if (requestEntity.getId() == null) {
            throw new IllegalArgumentException("The ID of the Parameter Context must be specified");
        }
        if (!requestEntity.getId().equals(contextId)) {
            throw new IllegalArgumentException("The ID of the Parameter Context must match the ID specified in the URL's path");
        }
        ParameterContextDTO updateDto = requestEntity.getComponent();
        if (updateDto == null) {
            throw new IllegalArgumentException("The Parameter Context must be supplied");
        }
        RevisionDTO revisionDto = requestEntity.getRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("The Revision of the Parameter Context must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestEntity.getRevision(), updateDto.getId());
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, requestRevision, lookup -> {
            ParameterContext parameterContext = lookup.getParameterContext(contextId);
            parameterContext.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
            parameterContext.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateParameterContext(updateDto, true), (rev, entity) -> {
            ParameterContextEntity updatedEntity = this.serviceFacade.updateParameterContext(rev, entity.getComponent());
            updatedEntity.setUri(this.generateResourceUri(new String[]{"parameter-contexts", entity.getId()}));
            return this.generateOkResponse((Object)updatedEntity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/update-requests")
    @Operation(summary="Initiate the Update Request of a Parameter Context", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextUpdateRequestEntity.class))})}, description="This will initiate the process of updating a Parameter Context. Changing the value of a Parameter may require that one or more components be stopped and restarted, so this action may take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterContextUpdateRequestEntity, and the process of updating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-contexts/update-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-contexts/update-requests/{requestId}.", security={@SecurityRequirement(name="Read - /parameter-contexts/{parameterContextId}"), @SecurityRequirement(name="Write - /parameter-contexts/{parameterContextId}"), @SecurityRequirement(name="Read - for every component that is affected by the update"), @SecurityRequirement(name="Write - for every component that is affected by the update"), @SecurityRequirement(name="Read - for every currently inherited parameter context"), @SecurityRequirement(name="Read - for any new inherited parameter context")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitParameterContextUpdate(@PathParam(value="contextId") String contextId, @io.swagger.v3.oas.annotations.Parameter(description="The updated version of the parameter context.", required=true) ParameterContextEntity requestEntity) {
        if (requestEntity == null) {
            throw new IllegalArgumentException("Parameter Context must be specified.");
        }
        RevisionDTO revisionDto = requestEntity.getRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Parameter Context Revision must be specified");
        }
        ParameterContextDTO contextDto = requestEntity.getComponent();
        if (contextDto == null) {
            throw new IllegalArgumentException("Parameter Context must be specified");
        }
        if (contextDto.getId() == null) {
            throw new IllegalArgumentException("Parameter Context's ID must be specified");
        }
        if (!contextDto.getId().equals(contextId)) {
            throw new IllegalArgumentException("ID of Parameter Context in message body does not match Parameter Context ID supplied in URI");
        }
        this.validateParameterNames(contextDto);
        boolean replicateRequest = this.isReplicateRequest();
        ComponentLifecycle componentLifecycle = replicateRequest ? this.clusterComponentLifecycle : this.localComponentLifecycle;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Set affectedComponents = this.serviceFacade.getComponentsAffectedByParameterContextUpdate(Collections.singletonList(contextDto));
        logger.debug("Received Update Request for Parameter Context: {}; the following {} components will be affected: {}", new Object[]{requestEntity, affectedComponents.size(), affectedComponents});
        InitiateChangeParameterContextRequestWrapper requestWrapper = new InitiateChangeParameterContextRequestWrapper(requestEntity, componentLifecycle, this.getAbsolutePath(), affectedComponents, replicateRequest, user);
        Revision requestRevision = this.getRevision(requestEntity.getRevision(), contextDto.getId());
        return this.withWriteLock(this.serviceFacade, (Entity)requestWrapper, requestRevision, lookup -> {
            ParameterContext parameterContext = lookup.getParameterContext(contextId);
            parameterContext.authorize(this.authorizer, RequestAction.READ, user);
            parameterContext.authorize(this.authorizer, RequestAction.WRITE, user);
            affectedComponents.forEach(component -> this.parameterUpdateManager.authorizeAffectedComponent(component, lookup, user, true, true));
            Set parametersEntities = requestEntity.getComponent().getParameters();
            for (ParameterEntity parameterEntity : parametersEntities) {
                Authorizable newControllerServiceAuthorizable;
                ComponentAuthorizable newControllerService;
                String newParameterValue;
                Authorizable currentControllerServiceAuthorizable;
                ComponentAuthorizable currentControllerService;
                String currentParameterValue;
                String parameterName = parameterEntity.getParameter().getName();
                List referencedControllerServiceDataSet = parameterContext.getParameterReferenceManager().getReferencedControllerServiceData(parameterContext, parameterName);
                Set referencedControllerServiceTypes = referencedControllerServiceDataSet.stream().map(ParameterReferencedControllerServiceData::getReferencedControllerServiceType).collect(Collectors.toSet());
                if (referencedControllerServiceTypes.size() > 1) {
                    throw new IllegalStateException("Parameter is used by multiple different types of controller service references");
                }
                if (referencedControllerServiceTypes.isEmpty()) continue;
                Optional parameterOptional = parameterContext.getParameter(parameterName);
                if (parameterOptional.isPresent() && (currentParameterValue = ((Parameter)parameterOptional.get()).getValue()) != null && (currentControllerService = lookup.getControllerService(currentParameterValue)) != null && (currentControllerServiceAuthorizable = currentControllerService.getAuthorizable()) != null) {
                    currentControllerServiceAuthorizable.authorize(this.authorizer, RequestAction.READ, user);
                    currentControllerServiceAuthorizable.authorize(this.authorizer, RequestAction.WRITE, user);
                }
                if ((newParameterValue = parameterEntity.getParameter().getValue()) == null || (newControllerService = lookup.getControllerService(newParameterValue)) == null || (newControllerServiceAuthorizable = newControllerService.getAuthorizable()) == null) continue;
                newControllerServiceAuthorizable.authorize(this.authorizer, RequestAction.READ, user);
                newControllerServiceAuthorizable.authorize(this.authorizer, RequestAction.WRITE, user);
                if (((Class)referencedControllerServiceTypes.iterator().next()).isAssignableFrom(((StandardControllerServiceNode)newControllerServiceAuthorizable).getComponent().getClass())) continue;
                throw new IllegalArgumentException("New Parameter value attempts to reference an incompatible controller service");
            }
        }, () -> this.serviceFacade.verifyUpdateParameterContext(contextDto, false), (arg_0, arg_1) -> this.submitUpdateRequest(arg_0, arg_1));
    }

    private void validateParameterNames(ParameterContextDTO parameterContextDto) {
        if (parameterContextDto.getParameters() != null) {
            for (ParameterEntity entity : parameterContextDto.getParameters()) {
                String parameterName = entity.getParameter().getName();
                if (this.isLegalParameterName(parameterName)) continue;
                throw new IllegalArgumentException("Request contains an illegal Parameter Name (" + parameterName + "). Parameter names may only include letters, numbers, spaces, and the special characters .-_");
            }
        }
    }

    private boolean isLegalParameterName(String parameterName) {
        return VALID_PARAMETER_NAME_PATTERN.matcher(parameterName).matches();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/update-requests/{requestId}")
    @Operation(summary="Returns the Update Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextUpdateRequestEntity.class))})}, description="Returns the Update Request with the given ID. Once an Update Request has been created by performing a POST to /nifi-api/parameter-contexts, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. ", security={@SecurityRequirement(name="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getParameterContextUpdate(@io.swagger.v3.oas.annotations.Parameter(description="The ID of the Parameter Context") @PathParam(value="contextId") String contextId, @io.swagger.v3.oas.annotations.Parameter(description="The ID of the Update Request") @PathParam(value="requestId") String updateRequestId) {
        this.authorizeReadParameterContext(contextId);
        return this.retrieveUpdateRequest("update-requests", contextId, updateRequestId);
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/update-requests/{requestId}")
    @Operation(summary="Deletes the Update Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextUpdateRequestEntity.class))})}, description="Deletes the Update Request with the given ID. After a request is created via a POST to /nifi-api/parameter-contexts/update-requests, it is expected that the client will properly clean up the request by DELETE'ing it, once the Update process has completed. If the request is deleted before the request completes, then the Update request will finish the step that it is currently performing and then will cancel any subsequent steps.", security={@SecurityRequirement(name="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteUpdateRequest(@io.swagger.v3.oas.annotations.Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @io.swagger.v3.oas.annotations.Parameter(description="The ID of the ParameterContext") @PathParam(value="contextId") String contextId, @io.swagger.v3.oas.annotations.Parameter(description="The ID of the Update Request") @PathParam(value="requestId") String updateRequestId) {
        this.authorizeReadParameterContext(contextId);
        return this.deleteUpdateRequest("update-requests", contextId, updateRequestId, disconnectedNodeAcknowledged.booleanValue());
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Deletes the Parameter Context with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextEntity.class))})}, description="Deletes the Parameter Context with the given ID.", security={@SecurityRequirement(name="Read - /parameter-contexts/{uuid}"), @SecurityRequirement(name="Write - /parameter-contexts/{uuid}"), @SecurityRequirement(name="Read - /process-groups/{uuid}, for any Process Group that is currently bound to the Parameter Context"), @SecurityRequirement(name="Write - /process-groups/{uuid}, for any Process Group that is currently bound to the Parameter Context")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteParameterContext(@io.swagger.v3.oas.annotations.Parameter(description="The version is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @io.swagger.v3.oas.annotations.Parameter(description="If the client id is not specified, a new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @io.swagger.v3.oas.annotations.Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @io.swagger.v3.oas.annotations.Parameter(description="The Parameter Context ID.") @PathParam(value="id") String parameterContextId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), parameterContextId);
        return this.withWriteLock(this.serviceFacade, null, requestRevision, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            ParameterContext parameterContext = lookup.getParameterContext(parameterContextId);
            parameterContext.authorize(this.authorizer, RequestAction.READ, user);
            parameterContext.authorize(this.authorizer, RequestAction.WRITE, user);
            ParameterContextEntity contextEntity = this.serviceFacade.getParameterContext(parameterContextId, false, user);
            for (ProcessGroupEntity boundGroupEntity : contextEntity.getComponent().getBoundProcessGroups()) {
                String groupId = boundGroupEntity.getId();
                Authorizable groupAuthorizable = lookup.getProcessGroup(groupId).getAuthorizable();
                groupAuthorizable.authorize(this.authorizer, RequestAction.READ, user);
                groupAuthorizable.authorize(this.authorizer, RequestAction.WRITE, user);
            }
        }, () -> this.serviceFacade.verifyDeleteParameterContext(parameterContextId), (revision, groupEntity) -> {
            ParameterContextEntity entity = this.serviceFacade.deleteParameterContext(revision, parameterContextId);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/validation-requests")
    @Operation(summary="Initiate a Validation Request to determine how the validity of components will change if a Parameter Context were to be updated", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextValidationRequestEntity.class))})}, description="This will initiate the process of validating all components whose Process Group is bound to the specified Parameter Context. Performing validation against an arbitrary number of components may be expect and take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterContextValidationRequestEntity, and the process of validating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-contexts/validation-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-contexts/validation-requests/{requestId}.", security={@SecurityRequirement(name="Read - /parameter-contexts/{parameterContextId}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitValidationRequest(@PathParam(value="contextId") String contextId, @io.swagger.v3.oas.annotations.Parameter(description="The validation request", required=true) ParameterContextValidationRequestEntity requestEntity) {
        if (requestEntity == null) {
            throw new IllegalArgumentException("Parameter Context must be specified.");
        }
        ParameterContextValidationRequestDTO requestDto = requestEntity.getRequest();
        if (requestDto == null) {
            throw new IllegalArgumentException("Parameter Context must be specified");
        }
        if (requestDto.getParameterContext() == null) {
            throw new IllegalArgumentException("Parameter Context must be specified");
        }
        if (requestDto.getParameterContext().getId() == null) {
            throw new IllegalArgumentException("Parameter Context's ID must be specified");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> {
            ParameterContext parameterContext = lookup.getParameterContext(contextId);
            parameterContext.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
            this.authorizeReferencingComponents(requestEntity.getRequest().getParameterContext().getId(), lookup, NiFiUserUtils.getNiFiUser());
        }, () -> {}, entity -> this.performAsyncValidation(entity, NiFiUserUtils.getNiFiUser()));
    }

    private void authorizeReferencingComponents(String parameterContextId, AuthorizableLookup lookup, NiFiUser user) {
        ParameterContextEntity context = this.serviceFacade.getParameterContext(parameterContextId, false, NiFiUserUtils.getNiFiUser());
        for (ParameterEntity parameterEntity : context.getComponent().getParameters()) {
            ParameterDTO dto = parameterEntity.getParameter();
            if (dto == null) continue;
            for (AffectedComponentEntity affectedComponent : dto.getReferencingComponents()) {
                this.parameterUpdateManager.authorizeAffectedComponent(affectedComponent, lookup, user, true, false);
            }
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/validation-requests/{id}")
    @Operation(summary="Returns the Validation Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextValidationRequestEntity.class))})}, description="Returns the Validation Request with the given ID. Once a Validation Request has been created by performing a POST to /nifi-api/validation-contexts, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. ", security={@SecurityRequirement(name="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getValidationRequest(@io.swagger.v3.oas.annotations.Parameter(description="The ID of the Parameter Context") @PathParam(value="contextId") String contextId, @io.swagger.v3.oas.annotations.Parameter(description="The ID of the Validation Request") @PathParam(value="id") String validationRequestId) {
        this.authorizeReadParameterContext(contextId);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        return this.retrieveValidationRequest("validation-requests", contextId, validationRequestId);
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/validation-requests/{id}")
    @Operation(summary="Deletes the Validation Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterContextValidationRequestEntity.class))})}, description="Deletes the Validation Request with the given ID. After a request is created via a POST to /nifi-api/validation-contexts, it is expected that the client will properly clean up the request by DELETE'ing it, once the validation process has completed. If the request is deleted before the request completes, then the Validation request will finish the step that it is currently performing and then will cancel any subsequent steps.", security={@SecurityRequirement(name="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteValidationRequest(@io.swagger.v3.oas.annotations.Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @io.swagger.v3.oas.annotations.Parameter(description="The ID of the Parameter Context") @PathParam(value="contextId") String contextId, @io.swagger.v3.oas.annotations.Parameter(description="The ID of the Update Request") @PathParam(value="id") String validationRequestId) {
        this.authorizeReadParameterContext(contextId);
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        return this.deleteValidationRequest("validation-requests", contextId, validationRequestId, disconnectedNodeAcknowledged.booleanValue());
    }

    private Response performAsyncValidation(ParameterContextValidationRequestEntity requestEntity, NiFiUser user) {
        String requestId = this.generateUuid();
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)requestEntity, null, user, this.getValidationSteps());
        Consumer<AsynchronousWebRequest> validationTask = asyncRequest -> {
            try {
                ComponentValidationResultsEntity resultEntity = this.validateComponents(requestEntity, user);
                asyncRequest.markStepComplete((Object)resultEntity);
            }
            catch (Exception e) {
                logger.error("Failed to validate components", (Throwable)e);
                asyncRequest.fail("Failed to validation components due to " + String.valueOf(e));
            }
        };
        this.validationRequestManager.submitRequest("validation-requests", requestId, (AsynchronousWebRequest)request, validationTask);
        ParameterContextValidationRequestDTO validationRequestDto = new ParameterContextValidationRequestDTO();
        validationRequestDto.setComplete(request.isComplete());
        validationRequestDto.setFailureReason(request.getFailureReason());
        validationRequestDto.setLastUpdated(request.getLastUpdated());
        validationRequestDto.setRequestId(requestId);
        validationRequestDto.setUri(this.generateResourceUri(new String[]{"parameter-contexts", "validation-requests", requestId}));
        validationRequestDto.setPercentCompleted(request.getPercentComplete());
        validationRequestDto.setState(request.getState());
        validationRequestDto.setComponentValidationResults((ComponentValidationResultsEntity)request.getResults());
        ParameterContextValidationRequestEntity validationRequestEntity = new ParameterContextValidationRequestEntity();
        validationRequestEntity.setRequest(validationRequestDto);
        return this.generateOkResponse((Object)validationRequestEntity).build();
    }

    private List<UpdateStep> getValidationSteps() {
        return Collections.singletonList(new StandardUpdateStep("Validating Components"));
    }

    private ComponentValidationResultsEntity validateComponents(ParameterContextValidationRequestEntity requestEntity, NiFiUser user) {
        List resultEntities = this.serviceFacade.validateComponents(requestEntity.getRequest().getParameterContext(), user);
        ComponentValidationResultsEntity resultsEntity = new ComponentValidationResultsEntity();
        resultsEntity.setValidationResults(resultEntities);
        return resultsEntity;
    }

    private Response submitUpdateRequest(Revision requestRevision, InitiateChangeParameterContextRequestWrapper requestWrapper) {
        String requestId = UUID.randomUUID().toString();
        String contextId = requestWrapper.getParameterContextEntity().getComponent().getId();
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, Collections.singletonList(requestWrapper.getParameterContextEntity()), contextId, requestWrapper.getUser(), this.getUpdateSteps());
        Consumer<AsynchronousWebRequest> updateTask = asyncRequest -> {
            try {
                List updatedParameterContextEntities = this.parameterUpdateManager.updateParameterContexts(asyncRequest, requestWrapper.getComponentLifecycle(), requestWrapper.getExampleUri(), requestWrapper.getReferencingComponents(), requestWrapper.isReplicateRequest(), requestRevision, Collections.singletonList(requestWrapper.getParameterContextEntity()));
                asyncRequest.markStepComplete((Object)updatedParameterContextEntities);
            }
            catch (ResumeFlowException rfe) {
                logger.error(rfe.getMessage(), (Throwable)rfe);
                asyncRequest.fail(rfe.getMessage());
            }
            catch (Exception e) {
                logger.error("Failed to update Parameter Context", (Throwable)e);
                asyncRequest.fail("Failed to update Parameter Context due to " + String.valueOf(e));
            }
        };
        this.updateRequestManager.submitRequest("update-requests", requestId, (AsynchronousWebRequest)request, updateTask);
        ParameterContextUpdateRequestEntity updateRequestEntity = this.createUpdateRequestEntity((AsynchronousWebRequest)request, "update-requests", contextId, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    private List<UpdateStep> getUpdateSteps() {
        return Arrays.asList(new StandardUpdateStep("Stopping Affected Processors"), new StandardUpdateStep("Disabling Affected Controller Services"), new StandardUpdateStep("Updating Parameter Context"), new StandardUpdateStep("Re-Enabling Affected Controller Services"), new StandardUpdateStep("Restarting Affected Processors"));
    }

    private Response retrieveValidationRequest(String requestType, String contextId, String requestId) {
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.validationRequestManager.getRequest(requestType, requestId, user);
        ParameterContextValidationRequestEntity requestEntity = this.createValidationRequestEntity(asyncRequest, contextId, requestType, requestId);
        return this.generateOkResponse((Object)requestEntity).build();
    }

    private Response deleteValidationRequest(String requestType, String contextId, String requestId, boolean disconnectedNodeAcknowledged) {
        NiFiUser user;
        AsynchronousWebRequest asyncRequest;
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(Boolean.valueOf(disconnectedNodeAcknowledged));
        }
        if ((asyncRequest = this.validationRequestManager.removeRequest(requestType, requestId, user = NiFiUserUtils.getNiFiUser())) == null) {
            throw new ResourceNotFoundException("Could not find request of type " + requestType + " with ID " + requestId);
        }
        if (!asyncRequest.isComplete()) {
            asyncRequest.cancel();
        }
        ParameterContextValidationRequestEntity requestEntity = this.createValidationRequestEntity(asyncRequest, contextId, requestType, requestId);
        return this.generateOkResponse((Object)requestEntity).build();
    }

    private ParameterContextValidationRequestEntity createValidationRequestEntity(AsynchronousWebRequest<?, ComponentValidationResultsEntity> asyncRequest, String requestType, String contextId, String requestId) {
        ParameterContextValidationRequestDTO requestDto = new ParameterContextValidationRequestDTO();
        requestDto.setComplete(asyncRequest.isComplete());
        requestDto.setFailureReason(asyncRequest.getFailureReason());
        requestDto.setLastUpdated(asyncRequest.getLastUpdated());
        requestDto.setRequestId(requestId);
        requestDto.setUri(this.generateResourceUri(new String[]{"parameter-contexts", contextId, requestType, requestId}));
        requestDto.setState(asyncRequest.getState());
        requestDto.setPercentCompleted(asyncRequest.getPercentComplete());
        requestDto.setComponentValidationResults((ComponentValidationResultsEntity)asyncRequest.getResults());
        ParameterContextValidationRequestEntity entity = new ParameterContextValidationRequestEntity();
        entity.setRequest(requestDto);
        return entity;
    }

    private Response retrieveUpdateRequest(String requestType, String contextId, String requestId) {
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.updateRequestManager.getRequest(requestType, requestId, user);
        ParameterContextUpdateRequestEntity updateRequestEntity = this.createUpdateRequestEntity(asyncRequest, requestType, contextId, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    private Response deleteUpdateRequest(String requestType, String contextId, String requestId, boolean disconnectedNodeAcknowledged) {
        NiFiUser user;
        AsynchronousWebRequest asyncRequest;
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(Boolean.valueOf(disconnectedNodeAcknowledged));
        }
        if ((asyncRequest = this.updateRequestManager.removeRequest(requestType, requestId, user = NiFiUserUtils.getNiFiUser())) == null) {
            throw new ResourceNotFoundException("Could not find request of type " + requestType + " with ID " + requestId);
        }
        if (!asyncRequest.isComplete()) {
            asyncRequest.cancel();
        }
        ParameterContextUpdateRequestEntity updateRequestEntity = this.createUpdateRequestEntity(asyncRequest, requestType, contextId, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    private ParameterContextUpdateRequestEntity createUpdateRequestEntity(AsynchronousWebRequest<List<ParameterContextEntity>, List<ParameterContextEntity>> asyncRequest, String requestType, String contextId, String requestId) {
        List initialRequestList = (List)asyncRequest.getRequest();
        ParameterContextEntity initialEntity = (ParameterContextEntity)initialRequestList.get(0);
        ParameterContextUpdateRequestDTO updateRequestDto = new ParameterContextUpdateRequestDTO();
        updateRequestDto.setComplete(asyncRequest.isComplete());
        updateRequestDto.setFailureReason(asyncRequest.getFailureReason());
        updateRequestDto.setLastUpdated(asyncRequest.getLastUpdated());
        updateRequestDto.setRequestId(requestId);
        updateRequestDto.setUri(this.generateResourceUri(new String[]{"parameter-contexts", contextId, requestType, requestId}));
        updateRequestDto.setState(asyncRequest.getState());
        updateRequestDto.setPercentCompleted(asyncRequest.getPercentComplete());
        ArrayList<ParameterContextUpdateStepDTO> updateSteps = new ArrayList<ParameterContextUpdateStepDTO>();
        for (Object updateStep : asyncRequest.getUpdateSteps()) {
            ParameterContextUpdateStepDTO stepDto = new ParameterContextUpdateStepDTO();
            stepDto.setDescription(updateStep.getDescription());
            stepDto.setComplete(updateStep.isComplete());
            stepDto.setFailureReason(updateStep.getFailureReason());
            updateSteps.add(stepDto);
        }
        updateRequestDto.setUpdateSteps(updateSteps);
        HashMap<String, AffectedComponentEntity> affectedComponents = new HashMap<String, AffectedComponentEntity>();
        for (ParameterEntity entity : initialEntity.getComponent().getParameters()) {
            for (AffectedComponentEntity affectedComponentEntity : entity.getParameter().getReferencingComponents()) {
                affectedComponents.put(affectedComponentEntity.getId(), this.serviceFacade.getUpdatedAffectedComponentEntity(affectedComponentEntity));
            }
        }
        updateRequestDto.setReferencingComponents(new HashSet(affectedComponents.values()));
        ParameterContextEntity contextEntity = this.serviceFacade.getParameterContext(asyncRequest.getComponentId(), false, NiFiUserUtils.getNiFiUser());
        ParameterContextUpdateRequestEntity updateRequestEntity = new ParameterContextUpdateRequestEntity();
        if (updateRequestDto.isComplete()) {
            updateRequestDto.setParameterContext(contextEntity == null ? null : contextEntity.getComponent());
            updateRequestEntity.setParameterContextRevision(contextEntity == null ? null : contextEntity.getRevision());
        }
        updateRequestEntity.setRequest(updateRequestDto);
        return updateRequestEntity;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setClusterComponentLifecycle(ComponentLifecycle componentLifecycle) {
        this.clusterComponentLifecycle = componentLifecycle;
    }

    public void setLocalComponentLifecycle(ComponentLifecycle componentLifecycle) {
        this.localComponentLifecycle = componentLifecycle;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }
}

