/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedReportingTaskSnapshot;
import org.apache.nifi.util.Tuple;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.dto.BundleDTO;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowRegistryUtils {
    public static Set<ConfigurableComponent> getRestrictedComponents(VersionedProcessGroup group, NiFiServiceFacade serviceFacade) {
        HashSet componentTypes = new HashSet();
        FlowRegistryUtils.populateComponentTypes((VersionedProcessGroup)group, componentTypes);
        return FlowRegistryUtils.getRestrictedComponents((NiFiServiceFacade)serviceFacade, componentTypes);
    }

    public static Set<ConfigurableComponent> getRestrictedComponents(VersionedReportingTaskSnapshot reportingTaskSnapshot, NiFiServiceFacade serviceFacade) {
        HashSet componentTypes = new HashSet();
        FlowRegistryUtils.populateComponentTypes((VersionedReportingTaskSnapshot)reportingTaskSnapshot, componentTypes);
        return FlowRegistryUtils.getRestrictedComponents((NiFiServiceFacade)serviceFacade, componentTypes);
    }

    private static Set<ConfigurableComponent> getRestrictedComponents(NiFiServiceFacade serviceFacade, Set<Tuple<String, BundleCoordinate>> componentTypes) {
        HashSet<ConfigurableComponent> restrictedComponents = new HashSet<ConfigurableComponent>();
        for (Tuple<String, BundleCoordinate> tuple : componentTypes) {
            boolean isRestricted;
            ConfigurableComponent component = serviceFacade.getTempComponent((String)tuple.getKey(), (BundleCoordinate)tuple.getValue());
            if (component == null || !(isRestricted = component.getClass().isAnnotationPresent(Restricted.class))) continue;
            restrictedComponents.add(component);
        }
        return restrictedComponents;
    }

    private static void populateComponentTypes(VersionedProcessGroup group, Set<Tuple<String, BundleCoordinate>> componentTypes) {
        group.getProcessors().stream().map(versionedProc -> new Tuple((Object)versionedProc.getType(), (Object)FlowRegistryUtils.createBundleCoordinate((Bundle)versionedProc.getBundle()))).forEach(componentTypes::add);
        group.getControllerServices().stream().map(versionedSvc -> new Tuple((Object)versionedSvc.getType(), (Object)FlowRegistryUtils.createBundleCoordinate((Bundle)versionedSvc.getBundle()))).forEach(componentTypes::add);
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            FlowRegistryUtils.populateComponentTypes((VersionedProcessGroup)childGroup, componentTypes);
        }
    }

    private static void populateComponentTypes(VersionedReportingTaskSnapshot reportingTaskSnapshot, Set<Tuple<String, BundleCoordinate>> componentTypes) {
        Optional.ofNullable(reportingTaskSnapshot.getReportingTasks()).orElse(Collections.emptyList()).stream().map(versionedReportingTask -> new Tuple((Object)versionedReportingTask.getType(), (Object)FlowRegistryUtils.createBundleCoordinate((Bundle)versionedReportingTask.getBundle()))).forEach(componentTypes::add);
        Optional.ofNullable(reportingTaskSnapshot.getControllerServices()).orElse(Collections.emptyList()).stream().map(versionedSvc -> new Tuple((Object)versionedSvc.getType(), (Object)FlowRegistryUtils.createBundleCoordinate((Bundle)versionedSvc.getBundle()))).forEach(componentTypes::add);
    }

    public static BundleCoordinate createBundleCoordinate(Bundle bundle) {
        return new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
    }

    public static BundleDTO createBundleDto(Bundle bundle) {
        return new BundleDTO(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
    }
}

