/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Date;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.dao.PortDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class PortAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(PortAuditor.class);

    @Around(value="within(org.apache.nifi.web.dao.PortDAO+) && execution(org.apache.nifi.connectable.Port createPort(java.lang.String, org.apache.nifi.web.api.dto.PortDTO))")
    public Port createPortAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Port port = (Port)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(port, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return port;
    }

    @Around(value="within(org.apache.nifi.web.dao.PortDAO+) && execution(org.apache.nifi.connectable.Port updatePort(org.apache.nifi.web.api.dto.PortDTO)) && args(portDTO) && target(portDAO)")
    public Port updatePortAdvice(ProceedingJoinPoint proceedingJoinPoint, PortDTO portDTO, PortDAO portDAO) throws Throwable {
        Port port = portDAO.getPort(portDTO.getId());
        ScheduledState scheduledState = port.getScheduledState();
        String name = port.getName();
        String comments = port.getComments();
        int maxConcurrentTasks = port.getMaxConcurrentTasks();
        boolean isPublicPort = port instanceof PublicPort;
        Port updatedPort = (Port)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ScheduledState updatedScheduledState;
            FlowChangeConfigureDetails configDetails;
            ArrayList<FlowChangeConfigureDetails> configurationDetails = new ArrayList<FlowChangeConfigureDetails>();
            if (name != null && portDTO.getName() != null && !name.equals(updatedPort.getName())) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("Name");
                configDetails.setValue(updatedPort.getName());
                configDetails.setPreviousValue(name);
                configurationDetails.add(configDetails);
            }
            if (comments != null && portDTO.getComments() != null && !comments.equals(updatedPort.getComments())) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("Comments");
                configDetails.setValue(updatedPort.getComments());
                configDetails.setPreviousValue(comments);
                configurationDetails.add(configDetails);
            }
            if (isPublicPort && portDTO.getConcurrentlySchedulableTaskCount() != null && updatedPort.getMaxConcurrentTasks() != maxConcurrentTasks) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("Concurrent Tasks");
                configDetails.setValue(String.valueOf(updatedPort.getMaxConcurrentTasks()));
                configDetails.setPreviousValue(String.valueOf(maxConcurrentTasks));
                configurationDetails.add(configDetails);
            }
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            Component componentType = Component.OutputPort;
            if (ConnectableType.INPUT_PORT == updatedPort.getConnectableType()) {
                componentType = Component.InputPort;
            }
            if (!configurationDetails.isEmpty()) {
                Date timestamp = new Date();
                for (ActionDetails actionDetails : configurationDetails) {
                    FlowChangeAction portAction = new FlowChangeAction();
                    portAction.setUserIdentity(user.getIdentity());
                    portAction.setOperation(Operation.Configure);
                    portAction.setTimestamp(timestamp);
                    portAction.setSourceId(updatedPort.getIdentifier());
                    portAction.setSourceName(updatedPort.getName());
                    portAction.setSourceType(componentType);
                    portAction.setActionDetails(actionDetails);
                    actions.add(portAction);
                }
            }
            if (scheduledState != (updatedScheduledState = updatedPort.getScheduledState())) {
                FlowChangeAction processorAction = new FlowChangeAction();
                processorAction.setUserIdentity(user.getIdentity());
                processorAction.setTimestamp(new Date());
                processorAction.setSourceId(updatedPort.getIdentifier());
                processorAction.setSourceName(updatedPort.getName());
                processorAction.setSourceType(componentType);
                if (ScheduledState.RUNNING.equals((Object)updatedScheduledState)) {
                    processorAction.setOperation(Operation.Start);
                } else if (ScheduledState.DISABLED.equals((Object)updatedScheduledState)) {
                    processorAction.setOperation(Operation.Disable);
                } else if (ScheduledState.RUNNING.equals((Object)scheduledState)) {
                    processorAction.setOperation(Operation.Stop);
                } else if (ScheduledState.DISABLED.equals((Object)scheduledState)) {
                    processorAction.setOperation(Operation.Enable);
                }
                actions.add(processorAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedPort;
    }

    @Around(value="within(org.apache.nifi.web.dao.PortDAO+) && execution(void deletePort(java.lang.String)) && args(portId) && target(portDAO)")
    public void removePortAdvice(ProceedingJoinPoint proceedingJoinPoint, String portId, PortDAO portDAO) throws Throwable {
        Port port = portDAO.getPort(portId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(port, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public Action generateAuditRecord(Port port, Operation operation) {
        return this.generateAuditRecord(port, operation, null);
    }

    public Action generateAuditRecord(Port port, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            Component componentType = Component.OutputPort;
            if (ConnectableType.INPUT_PORT == port.getConnectableType()) {
                componentType = Component.InputPort;
            }
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(port.getIdentifier());
            action.setSourceName(port.getName());
            action.setSourceType(componentType);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }
}

