/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.search.SearchContext;
import org.apache.nifi.search.SearchResult;
import org.apache.nifi.search.Searchable;
import org.apache.nifi.web.api.dto.search.ComponentSearchResultDTO;
import org.apache.nifi.web.api.dto.search.SearchResultGroupDTO;
import org.apache.nifi.web.api.dto.search.SearchResultsDTO;
import org.apache.nifi.web.controller.StandardSearchContext;

public class ControllerSearchService {
    private FlowController flowController;
    private Authorizer authorizer;
    private VariableRegistry variableRegistry;

    public void search(SearchResultsDTO results, String search, ProcessGroup group) {
        ComponentSearchResultDTO match;
        ComponentSearchResultDTO groupMatch;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (group.isAuthorized(this.authorizer, RequestAction.READ, user) && (groupMatch = this.search(search, group)) != null) {
            groupMatch.setParentGroup(this.buildResultGroup(group.getParent(), user));
            groupMatch.setVersionedGroup(this.buildVersionedGroup(group.getParent(), user));
            results.getProcessGroupResults().add(groupMatch);
        }
        for (ProcessorNode procNode : group.getProcessors()) {
            if (!procNode.isAuthorized(this.authorizer, RequestAction.READ, user) || (match = this.search(search, procNode)) == null) continue;
            match.setGroupId(group.getIdentifier());
            match.setParentGroup(this.buildResultGroup(group, user));
            match.setVersionedGroup(this.buildVersionedGroup(group, user));
            results.getProcessorResults().add(match);
        }
        for (Connection connection : group.getConnections()) {
            if (!connection.isAuthorized(this.authorizer, RequestAction.READ, user) || (match = this.search(search, connection)) == null) continue;
            match.setGroupId(group.getIdentifier());
            match.setParentGroup(this.buildResultGroup(group, user));
            match.setVersionedGroup(this.buildVersionedGroup(group, user));
            results.getConnectionResults().add(match);
        }
        for (RemoteProcessGroup remoteGroup : group.getRemoteProcessGroups()) {
            if (!remoteGroup.isAuthorized(this.authorizer, RequestAction.READ, user) || (match = this.search(search, remoteGroup)) == null) continue;
            match.setGroupId(group.getIdentifier());
            match.setParentGroup(this.buildResultGroup(group, user));
            match.setVersionedGroup(this.buildVersionedGroup(group, user));
            results.getRemoteProcessGroupResults().add(match);
        }
        for (Port port : group.getInputPorts()) {
            if (!port.isAuthorized(this.authorizer, RequestAction.READ, user) || (match = this.search(search, port)) == null) continue;
            match.setGroupId(group.getIdentifier());
            match.setParentGroup(this.buildResultGroup(group, user));
            match.setVersionedGroup(this.buildVersionedGroup(group, user));
            results.getInputPortResults().add(match);
        }
        for (Port port : group.getOutputPorts()) {
            if (!port.isAuthorized(this.authorizer, RequestAction.READ, user) || (match = this.search(search, port)) == null) continue;
            match.setGroupId(group.getIdentifier());
            match.setParentGroup(this.buildResultGroup(group, user));
            match.setVersionedGroup(this.buildVersionedGroup(group, user));
            results.getOutputPortResults().add(match);
        }
        for (Funnel funnel : group.getFunnels()) {
            if (!funnel.isAuthorized(this.authorizer, RequestAction.READ, user) || (match = this.search(search, funnel)) == null) continue;
            match.setGroupId(group.getIdentifier());
            match.setParentGroup(this.buildResultGroup(group, user));
            match.setVersionedGroup(this.buildVersionedGroup(group, user));
            results.getFunnelResults().add(match);
        }
        for (ProcessGroup processGroup : group.getProcessGroups()) {
            this.search(results, search, processGroup);
        }
    }

    private ComponentSearchResultDTO search(String searchStr, Port port) {
        ArrayList<String> matches = new ArrayList<String>();
        this.addIfAppropriate(searchStr, port.getIdentifier(), "Id", matches);
        this.addIfAppropriate(searchStr, (String)port.getVersionedComponentId().orElse(null), "Version Control ID", matches);
        this.addIfAppropriate(searchStr, port.getName(), "Name", matches);
        this.addIfAppropriate(searchStr, port.getComments(), "Comments", matches);
        if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
            if (StringUtils.containsIgnoreCase((CharSequence)"disabled", (CharSequence)searchStr)) {
                matches.add("Run status: Disabled");
            }
        } else if (StringUtils.containsIgnoreCase((CharSequence)"invalid", (CharSequence)searchStr) && !port.isValid()) {
            matches.add("Run status: Invalid");
        } else if (ScheduledState.RUNNING.equals((Object)port.getScheduledState()) && StringUtils.containsIgnoreCase((CharSequence)"running", (CharSequence)searchStr)) {
            matches.add("Run status: Running");
        } else if (ScheduledState.STOPPED.equals((Object)port.getScheduledState()) && StringUtils.containsIgnoreCase((CharSequence)"stopped", (CharSequence)searchStr)) {
            matches.add("Run status: Stopped");
        }
        if (port instanceof RootGroupPort) {
            RootGroupPort rootGroupPort = (RootGroupPort)port;
            for (String userAccessControl : rootGroupPort.getUserAccessControl()) {
                this.addIfAppropriate(searchStr, userAccessControl, "User access control", matches);
            }
            for (String groupAccessControl : rootGroupPort.getGroupAccessControl()) {
                this.addIfAppropriate(searchStr, groupAccessControl, "Group access control", matches);
            }
        }
        if (matches.isEmpty()) {
            return null;
        }
        ComponentSearchResultDTO dto = new ComponentSearchResultDTO();
        dto.setId(port.getIdentifier());
        dto.setName(port.getName());
        dto.setMatches(matches);
        return dto;
    }

    private ComponentSearchResultDTO search(String searchStr, ProcessorNode procNode) {
        ArrayList<String> matches = new ArrayList<String>();
        Processor processor = procNode.getProcessor();
        this.addIfAppropriate(searchStr, procNode.getIdentifier(), "Id", matches);
        this.addIfAppropriate(searchStr, (String)procNode.getVersionedComponentId().orElse(null), "Version Control ID", matches);
        this.addIfAppropriate(searchStr, procNode.getName(), "Name", matches);
        this.addIfAppropriate(searchStr, procNode.getComments(), "Comments", matches);
        if (SchedulingStrategy.EVENT_DRIVEN.equals((Object)procNode.getSchedulingStrategy()) && StringUtils.containsIgnoreCase((CharSequence)"event", (CharSequence)searchStr)) {
            matches.add("Scheduling strategy: Event driven");
        } else if (SchedulingStrategy.TIMER_DRIVEN.equals((Object)procNode.getSchedulingStrategy()) && StringUtils.containsIgnoreCase((CharSequence)"timer", (CharSequence)searchStr)) {
            matches.add("Scheduling strategy: Timer driven");
        } else if (SchedulingStrategy.PRIMARY_NODE_ONLY.equals((Object)procNode.getSchedulingStrategy()) && StringUtils.containsIgnoreCase((CharSequence)"primary", (CharSequence)searchStr)) {
            matches.add("Scheduling strategy: On primary node");
        }
        if (ExecutionNode.PRIMARY.equals((Object)procNode.getExecutionNode()) && StringUtils.containsIgnoreCase((CharSequence)"primary", (CharSequence)searchStr)) {
            matches.add("Execution node: primary");
        }
        if (ScheduledState.DISABLED.equals((Object)procNode.getScheduledState())) {
            if (StringUtils.containsIgnoreCase((CharSequence)"disabled", (CharSequence)searchStr)) {
                matches.add("Run status: Disabled");
            }
        } else if (StringUtils.containsIgnoreCase((CharSequence)"invalid", (CharSequence)searchStr) && procNode.getValidationStatus() == ValidationStatus.INVALID) {
            matches.add("Run status: Invalid");
        } else if (StringUtils.containsIgnoreCase((CharSequence)"validating", (CharSequence)searchStr) && procNode.getValidationStatus() == ValidationStatus.VALIDATING) {
            matches.add("Run status: Validating");
        } else if (ScheduledState.RUNNING.equals((Object)procNode.getScheduledState()) && StringUtils.containsIgnoreCase((CharSequence)"running", (CharSequence)searchStr)) {
            matches.add("Run status: Running");
        } else if (ScheduledState.STOPPED.equals((Object)procNode.getScheduledState()) && StringUtils.containsIgnoreCase((CharSequence)"stopped", (CharSequence)searchStr)) {
            matches.add("Run status: Stopped");
        }
        for (Relationship relationship : procNode.getRelationships()) {
            this.addIfAppropriate(searchStr, relationship.getName(), "Relationship", matches);
        }
        this.addIfAppropriate(searchStr, processor.getClass().getSimpleName(), "Type", matches);
        this.addIfAppropriate(searchStr, procNode.getComponentType(), "Type", matches);
        for (Map.Entry entry : procNode.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            this.addIfAppropriate(searchStr, descriptor.getName(), "Property name", matches);
            this.addIfAppropriate(searchStr, descriptor.getDescription(), "Property description", matches);
            if (descriptor.isSensitive()) continue;
            String value = (String)entry.getValue();
            if (value == null) {
                value = descriptor.getDefaultValue();
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)searchStr)) continue;
            matches.add("Property value: " + descriptor.getName() + " - " + value);
        }
        if (processor instanceof Searchable) {
            Searchable searchable = (Searchable)processor;
            StandardSearchContext standardSearchContext = new StandardSearchContext(searchStr, procNode, (ControllerServiceLookup)this.flowController.getControllerServiceProvider(), this.variableRegistry);
            try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), processor.getClass(), (String)processor.getIdentifier());){
                Collection searchResults = searchable.search((SearchContext)standardSearchContext);
                if (CollectionUtils.isNotEmpty((Collection)searchResults)) {
                    for (SearchResult searchResult : searchResults) {
                        matches.add(searchResult.getLabel() + ": " + searchResult.getMatch());
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (matches.isEmpty()) {
            return null;
        }
        ComponentSearchResultDTO result = new ComponentSearchResultDTO();
        result.setId(procNode.getIdentifier());
        result.setMatches(matches);
        result.setName(procNode.getName());
        return result;
    }

    private ComponentSearchResultDTO search(String searchStr, ProcessGroup group) {
        ArrayList matches = new ArrayList();
        ProcessGroup parent = group.getParent();
        if (parent == null) {
            return null;
        }
        this.addIfAppropriate(searchStr, group.getIdentifier(), "Id", matches);
        this.addIfAppropriate(searchStr, (String)group.getVersionedComponentId().orElse(null), "Version Control ID", matches);
        this.addIfAppropriate(searchStr, group.getName(), "Name", matches);
        this.addIfAppropriate(searchStr, group.getComments(), "Comments", matches);
        ComponentVariableRegistry varRegistry = group.getVariableRegistry();
        if (varRegistry != null) {
            Map variableMap = varRegistry.getVariableMap();
            for (Map.Entry entry : variableMap.entrySet()) {
                this.addIfAppropriate(searchStr, ((VariableDescriptor)entry.getKey()).getName(), "Variable Name", matches);
                this.addIfAppropriate(searchStr, (String)entry.getValue(), "Variable Value", matches);
            }
        }
        if (matches.isEmpty()) {
            return null;
        }
        ComponentSearchResultDTO result = new ComponentSearchResultDTO();
        result.setId(group.getIdentifier());
        result.setName(group.getName());
        result.setGroupId(parent.getIdentifier());
        result.setMatches(matches);
        return result;
    }

    private ComponentSearchResultDTO search(String searchStr, Connection connection) {
        int expirationMillis;
        ArrayList<String> matches = new ArrayList<String>();
        this.addIfAppropriate(searchStr, connection.getIdentifier(), "Id", matches);
        this.addIfAppropriate(searchStr, (String)connection.getVersionedComponentId().orElse(null), "Version Control ID", matches);
        this.addIfAppropriate(searchStr, connection.getName(), "Name", matches);
        for (Object relationship : connection.getRelationships()) {
            this.addIfAppropriate(searchStr, relationship.getName(), "Relationship", matches);
        }
        FlowFileQueue queue = connection.getFlowFileQueue();
        for (FlowFilePrioritizer comparator : queue.getPriorities()) {
            this.addIfAppropriate(searchStr, comparator.getClass().getName(), "Prioritizer", matches);
        }
        if ((StringUtils.containsIgnoreCase((CharSequence)"expires", (CharSequence)searchStr) || StringUtils.containsIgnoreCase((CharSequence)"expiration", (CharSequence)searchStr)) && (expirationMillis = connection.getFlowFileQueue().getFlowFileExpiration(TimeUnit.MILLISECONDS)) > 0) {
            matches.add("FlowFile expiration: " + connection.getFlowFileQueue().getFlowFileExpiration());
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"back pressure", (CharSequence)searchStr) || StringUtils.containsIgnoreCase((CharSequence)"pressure", (CharSequence)searchStr)) {
            long backPressureCount;
            String backPressureDataSize = connection.getFlowFileQueue().getBackPressureDataSizeThreshold();
            Double backPressureBytes = DataUnit.parseDataSize((String)backPressureDataSize, (DataUnit)DataUnit.B);
            if (backPressureBytes > 0.0) {
                matches.add("Back pressure data size: " + backPressureDataSize);
            }
            if ((backPressureCount = connection.getFlowFileQueue().getBackPressureObjectThreshold()) > 0L) {
                matches.add("Back pressure count: " + backPressureCount);
            }
        }
        Connectable source = connection.getSource();
        this.addIfAppropriate(searchStr, source.getIdentifier(), "Source id", matches);
        this.addIfAppropriate(searchStr, source.getName(), "Source name", matches);
        this.addIfAppropriate(searchStr, source.getComments(), "Source comments", matches);
        Connectable destination = connection.getDestination();
        this.addIfAppropriate(searchStr, destination.getIdentifier(), "Destination id", matches);
        this.addIfAppropriate(searchStr, destination.getName(), "Destination name", matches);
        this.addIfAppropriate(searchStr, destination.getComments(), "Destination comments", matches);
        if (matches.isEmpty()) {
            return null;
        }
        ComponentSearchResultDTO result = new ComponentSearchResultDTO();
        result.setId(connection.getIdentifier());
        if (StringUtils.isNotBlank((CharSequence)connection.getName())) {
            result.setName(connection.getName());
        } else if (!connection.getRelationships().isEmpty()) {
            ArrayList<String> relationships = new ArrayList<String>(connection.getRelationships().size());
            for (Relationship relationship : connection.getRelationships()) {
                if (!StringUtils.isNotBlank((CharSequence)relationship.getName())) continue;
                relationships.add(relationship.getName());
            }
            if (!relationships.isEmpty()) {
                result.setName(StringUtils.join(relationships, (String)", "));
            }
        }
        if (result.getName() == null) {
            result.setName("From source " + connection.getSource().getName());
        }
        result.setMatches(matches);
        return result;
    }

    private ComponentSearchResultDTO search(String searchStr, RemoteProcessGroup group) {
        ArrayList<String> matches = new ArrayList<String>();
        this.addIfAppropriate(searchStr, group.getIdentifier(), "Id", matches);
        this.addIfAppropriate(searchStr, (String)group.getVersionedComponentId().orElse(null), "Version Control ID", matches);
        this.addIfAppropriate(searchStr, group.getName(), "Name", matches);
        this.addIfAppropriate(searchStr, group.getComments(), "Comments", matches);
        this.addIfAppropriate(searchStr, group.getTargetUris(), "URLs", matches);
        if ((StringUtils.containsIgnoreCase((CharSequence)"transmitting", (CharSequence)searchStr) || StringUtils.containsIgnoreCase((CharSequence)"transmission enabled", (CharSequence)searchStr)) && group.isTransmitting()) {
            matches.add("Transmission: On");
        } else if ((StringUtils.containsIgnoreCase((CharSequence)"not transmitting", (CharSequence)searchStr) || StringUtils.containsIgnoreCase((CharSequence)"transmission disabled", (CharSequence)searchStr)) && !group.isTransmitting()) {
            matches.add("Transmission: Off");
        }
        if (matches.isEmpty()) {
            return null;
        }
        ComponentSearchResultDTO result = new ComponentSearchResultDTO();
        result.setId(group.getIdentifier());
        result.setName(group.getName());
        result.setMatches(matches);
        return result;
    }

    private ComponentSearchResultDTO search(String searchStr, Funnel funnel) {
        ArrayList matches = new ArrayList();
        this.addIfAppropriate(searchStr, funnel.getIdentifier(), "Id", matches);
        this.addIfAppropriate(searchStr, (String)funnel.getVersionedComponentId().orElse(null), "Version Control ID", matches);
        if (matches.isEmpty()) {
            return null;
        }
        ComponentSearchResultDTO dto = new ComponentSearchResultDTO();
        dto.setId(funnel.getIdentifier());
        dto.setName(funnel.getName());
        dto.setMatches(matches);
        return dto;
    }

    private SearchResultGroupDTO buildVersionedGroup(ProcessGroup group, NiFiUser user) {
        if (group == null) {
            return null;
        }
        ProcessGroup tmpParent = group.getParent();
        ProcessGroup tmpGroup = group;
        while (!tmpGroup.isRootGroup()) {
            if (tmpGroup.getVersionControlInformation() != null) {
                return this.buildResultGroup(tmpGroup, user);
            }
            tmpGroup = tmpParent;
            tmpParent = tmpGroup.getParent();
        }
        return null;
    }

    private SearchResultGroupDTO buildResultGroup(ProcessGroup group, NiFiUser user) {
        if (group == null) {
            return null;
        }
        SearchResultGroupDTO resultGroup = new SearchResultGroupDTO();
        resultGroup.setId(group.getIdentifier());
        if (group.isAuthorized(this.authorizer, RequestAction.READ, user)) {
            resultGroup.setName(group.getName());
        }
        return resultGroup;
    }

    private void addIfAppropriate(String searchStr, String value, String label, List<String> matches) {
        if (StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)searchStr)) {
            matches.add(label + ": " + value);
        }
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setVariableRegistry(VariableRegistry variableRegistry) {
        this.variableRegistry = variableRegistry;
    }
}

