/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeAccess;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.ProcessGroupAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.SnippetAuthorizable;
import org.apache.nifi.authorization.TemplateContentsAuthorizable;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.serialization.FlowEncodingVersion;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.FlowRegistryUtils;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.registry.variable.VariableRegistryUpdateRequest;
import org.apache.nifi.registry.variable.VariableRegistryUpdateStep;
import org.apache.nifi.remote.util.SiteToSiteRestApiClient;
import org.apache.nifi.security.xml.XmlUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ConnectionResource;
import org.apache.nifi.web.api.ControllerServiceResource;
import org.apache.nifi.web.api.FunnelResource;
import org.apache.nifi.web.api.InputPortResource;
import org.apache.nifi.web.api.LabelResource;
import org.apache.nifi.web.api.OutputPortResource;
import org.apache.nifi.web.api.ProcessGroupResource;
import org.apache.nifi.web.api.ProcessorResource;
import org.apache.nifi.web.api.RemoteProcessGroupResource;
import org.apache.nifi.web.api.TemplateResource;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.dto.VariableRegistryDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusDTO;
import org.apache.nifi.web.api.entity.ActivateControllerServicesEntity;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.ConnectionsEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;
import org.apache.nifi.web.api.entity.CopySnippetRequestEntity;
import org.apache.nifi.web.api.entity.CreateTemplateRequestEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowComparisonEntity;
import org.apache.nifi.web.api.entity.FlowEntity;
import org.apache.nifi.web.api.entity.FunnelEntity;
import org.apache.nifi.web.api.entity.FunnelsEntity;
import org.apache.nifi.web.api.entity.InputPortsEntity;
import org.apache.nifi.web.api.entity.InstantiateTemplateRequestEntity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.entity.LabelsEntity;
import org.apache.nifi.web.api.entity.OutputPortsEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupsEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorsEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupsEntity;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;
import org.apache.nifi.web.api.entity.TemplateEntity;
import org.apache.nifi.web.api.entity.VariableRegistryEntity;
import org.apache.nifi.web.api.entity.VariableRegistryUpdateRequestEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.apache.nifi.web.util.Pause;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@Path(value="/process-groups")
@Api(value="/process-groups", description="Endpoint for managing a Process Group.")
public class ProcessGroupResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessGroupResource.class);
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    private ProcessorResource processorResource;
    private InputPortResource inputPortResource;
    private OutputPortResource outputPortResource;
    private FunnelResource funnelResource;
    private LabelResource labelResource;
    private RemoteProcessGroupResource remoteProcessGroupResource;
    private ConnectionResource connectionResource;
    private TemplateResource templateResource;
    private ControllerServiceResource controllerServiceResource;
    private DtoFactory dtoFactory;
    private final ConcurrentMap<String, VariableRegistryUpdateRequest> varRegistryUpdateRequests = new ConcurrentHashMap();
    private static final int MAX_VARIABLE_REGISTRY_UPDATE_REQUESTS = 100;
    private static final long VARIABLE_REGISTRY_UPDATE_REQUEST_EXPIRATION = TimeUnit.MINUTES.toMillis(1L);
    private final ExecutorService variableRegistryThreadPool = new ThreadPoolExecutor(1, 50, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);

    public Set<ProcessGroupEntity> populateRemainingProcessGroupEntitiesContent(Set<ProcessGroupEntity> processGroupEntities) {
        for (ProcessGroupEntity processGroupEntity : processGroupEntities) {
            this.populateRemainingProcessGroupEntityContent(processGroupEntity);
        }
        return processGroupEntities;
    }

    public ProcessGroupEntity populateRemainingProcessGroupEntityContent(ProcessGroupEntity processGroupEntity) {
        processGroupEntity.setUri(this.generateResourceUri(new String[]{"process-groups", processGroupEntity.getId()}));
        return processGroupEntity;
    }

    private FlowDTO populateRemainingSnippetContent(FlowDTO flow) {
        this.processorResource.populateRemainingProcessorEntitiesContent(flow.getProcessors());
        this.connectionResource.populateRemainingConnectionEntitiesContent(flow.getConnections());
        this.inputPortResource.populateRemainingInputPortEntitiesContent(flow.getInputPorts());
        this.outputPortResource.populateRemainingOutputPortEntitiesContent(flow.getOutputPorts());
        this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntitiesContent(flow.getRemoteProcessGroups());
        this.funnelResource.populateRemainingFunnelEntitiesContent(flow.getFunnels());
        this.labelResource.populateRemainingLabelEntitiesContent(flow.getLabels());
        if (flow.getProcessGroups() != null) {
            this.populateRemainingProcessGroupEntitiesContent(flow.getProcessGroups());
        }
        return flow;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a process group", response=ProcessGroupEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessGroup(@ApiParam(value="The process group id.", required=false) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ProcessGroupEntity entity = this.serviceFacade.getProcessGroup(groupId);
        this.populateRemainingProcessGroupEntityContent(entity);
        if (entity.getComponent() != null) {
            entity.getComponent().setContents(null);
        }
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/local-modifications")
    @ApiOperation(value="Gets a list of local modifications to the Process Group since it was last synchronized with the Flow Registry", response=FlowComparisonEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Read - /{component-type}/{uuid} - For all encapsulated components")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getLocalModifications(@ApiParam(value="The process group id.", required=false) @PathParam(value="id") String groupId) throws IOException, NiFiRegistryException {
        this.serviceFacade.authorizeAccess(lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.READ, false, false, true, false);
        });
        FlowComparisonEntity entity = this.serviceFacade.getLocalModifications(groupId);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/variable-registry")
    @ApiOperation(value="Gets a process group's variable registry", response=VariableRegistryEntity.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getVariableRegistry(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="Whether or not to include ancestor groups", required=false) @QueryParam(value="includeAncestorGroups") @DefaultValue(value="true") boolean includeAncestorGroups) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        VariableRegistryEntity entity = this.serviceFacade.getVariableRegistry(groupId, includeAncestorGroups);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates a process group", response=ProcessGroupEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The process group configuration details.", required=true) ProcessGroupEntity requestProcessGroupEntity) {
        if (requestProcessGroupEntity == null || requestProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Process group details must be specified.");
        }
        if (requestProcessGroupEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ProcessGroupDTO requestProcessGroupDTO = requestProcessGroupEntity.getComponent();
        if (!id.equals(requestProcessGroupDTO.getId())) {
            throw new IllegalArgumentException(String.format("The process group id (%s) in the request body does not equal the process group id of the requested resource (%s).", requestProcessGroupDTO.getId(), id));
        }
        PositionDTO proposedPosition = requestProcessGroupDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestProcessGroupEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestProcessGroupEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestProcessGroupEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessGroupEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getProcessGroup(id).getAuthorizable();
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateProcessGroup(requestProcessGroupDTO), (revision, processGroupEntity) -> {
            ProcessGroupEntity entity = this.serviceFacade.updateProcessGroup(revision, processGroupEntity.getComponent());
            this.populateRemainingProcessGroupEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{groupId}/variable-registry/update-requests/{updateId}")
    @ApiOperation(value="Gets a process group's variable registry", response=VariableRegistryUpdateRequestEntity.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getVariableRegistryUpdateRequest(@ApiParam(value="The process group id.", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="The ID of the Variable Registry Update Request", required=true) @PathParam(value="updateId") String updateId) {
        if (groupId == null || updateId == null) {
            throw new IllegalArgumentException("Group ID and Update ID must both be specified.");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, user);
        });
        VariableRegistryUpdateRequest request = (VariableRegistryUpdateRequest)this.varRegistryUpdateRequests.get(updateId);
        if (request == null) {
            throw new ResourceNotFoundException("Could not find a Variable Registry Update Request with identifier " + updateId);
        }
        if (!groupId.equals(request.getProcessGroupId())) {
            throw new ResourceNotFoundException("Could not find a Variable Registry Update Request with identifier " + updateId + " for Process Group with identifier " + groupId);
        }
        if (!user.equals(request.getUser())) {
            throw new IllegalArgumentException("Only the user that submitted the update request can retrieve it.");
        }
        VariableRegistryUpdateRequestEntity entity = new VariableRegistryUpdateRequestEntity();
        entity.setRequest(this.dtoFactory.createVariableRegistryUpdateRequestDto(request));
        entity.setProcessGroupRevision(request.getProcessGroupRevision());
        entity.getRequest().setUri(this.generateResourceUri(new String[]{"process-groups", groupId, "variable-registry", updateId}));
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{groupId}/variable-registry/update-requests/{updateId}")
    @ApiOperation(value="Deletes an update request for a process group's variable registry. If the request is not yet complete, it will automatically be cancelled.", response=VariableRegistryUpdateRequestEntity.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteVariableRegistryUpdateRequest(@ApiParam(value="The process group id.", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="The ID of the Variable Registry Update Request", required=true) @PathParam(value="updateId") String updateId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged) {
        if (groupId == null || updateId == null) {
            throw new IllegalArgumentException("Group ID and Update ID must both be specified.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, user);
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
        });
        VariableRegistryUpdateRequest request = (VariableRegistryUpdateRequest)this.varRegistryUpdateRequests.remove(updateId);
        if (request == null) {
            throw new ResourceNotFoundException("Could not find a Variable Registry Update Request with identifier " + updateId);
        }
        if (!groupId.equals(request.getProcessGroupId())) {
            throw new ResourceNotFoundException("Could not find a Variable Registry Update Request with identifier " + updateId + " for Process Group with identifier " + groupId);
        }
        if (!user.equals(request.getUser())) {
            throw new IllegalArgumentException("Only the user that submitted the update request can remove it.");
        }
        request.cancel();
        VariableRegistryUpdateRequestEntity entity = new VariableRegistryUpdateRequestEntity();
        entity.setRequest(this.dtoFactory.createVariableRegistryUpdateRequestDto(request));
        entity.setProcessGroupRevision(request.getProcessGroupRevision());
        entity.getRequest().setUri(this.generateResourceUri(new String[]{"process-groups", groupId, "variable-registry", updateId}));
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/variable-registry")
    @ApiOperation(value="Updates the contents of a Process Group's variable Registry", response=VariableRegistryEntity.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateVariableRegistry(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The variable registry configuration details.", required=true) VariableRegistryEntity requestVariableRegistryEntity) {
        if (requestVariableRegistryEntity == null || requestVariableRegistryEntity.getVariableRegistry() == null) {
            throw new IllegalArgumentException("Variable Registry details must be specified.");
        }
        if (requestVariableRegistryEntity.getProcessGroupRevision() == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified.");
        }
        VariableRegistryDTO requestRegistryDto = requestVariableRegistryEntity.getVariableRegistry();
        if (!groupId.equals(requestRegistryDto.getProcessGroupId())) {
            throw new IllegalArgumentException(String.format("The process group id (%s) in the request body does not equal the process group id of the requested resource (%s).", requestRegistryDto.getProcessGroupId(), groupId));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestVariableRegistryEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestVariableRegistryEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestVariableRegistryEntity.getProcessGroupRevision(), groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestVariableRegistryEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getProcessGroup(groupId).getAuthorizable();
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, variableRegistryEntity) -> {
            VariableRegistryDTO variableRegistry = variableRegistryEntity.getVariableRegistry();
            VariableRegistryEntity entity = this.serviceFacade.updateVariableRegistry(revision, variableRegistry);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/variable-registry/update-requests")
    @ApiOperation(value="Submits a request to update a process group's variable registry", response=VariableRegistryUpdateRequestEntity.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response submitUpdateVariableRegistryRequest(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The variable registry configuration details.", required=true) VariableRegistryEntity requestVariableRegistryEntity) {
        VariableRegistryEntity computedEntity;
        VariableRegistryDTO computedRegistryDto;
        if (requestVariableRegistryEntity == null || requestVariableRegistryEntity.getVariableRegistry() == null) {
            throw new IllegalArgumentException("Variable Registry details must be specified.");
        }
        if (requestVariableRegistryEntity.getProcessGroupRevision() == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestVariableRegistryEntity.isDisconnectedNodeAcknowledged());
        }
        if ((computedRegistryDto = (computedEntity = this.serviceFacade.populateAffectedComponents(requestVariableRegistryEntity.getVariableRegistry())).getVariableRegistry()) == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate group with id '%s'.", groupId));
        }
        Set allAffectedComponents = this.serviceFacade.getComponentsAffectedByVariableRegistryUpdate(requestVariableRegistryEntity.getVariableRegistry());
        Set activeAffectedComponents = this.serviceFacade.getActiveComponentsAffectedByVariableRegistryUpdate(requestVariableRegistryEntity.getVariableRegistry());
        Map<String, List<AffectedComponentDTO>> activeAffectedComponentsByType = activeAffectedComponents.stream().collect(Collectors.groupingBy(comp -> comp.getReferenceType()));
        List<AffectedComponentDTO> activeAffectedProcessors = activeAffectedComponentsByType.get("PROCESSOR");
        List<AffectedComponentDTO> activeAffectedServices = activeAffectedComponentsByType.get("CONTROLLER_SERVICE");
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AuthorizeAccess authorizeAccess = lookup -> {
            Authorizable authorizable;
            Authorizable groupAuthorizable = lookup.getProcessGroup(groupId).getAuthorizable();
            groupAuthorizable.authorize(this.authorizer, RequestAction.WRITE, user);
            if (activeAffectedProcessors != null) {
                for (AffectedComponentDTO activeAffectedComponent : activeAffectedProcessors) {
                    authorizable = lookup.getProcessor(activeAffectedComponent.getId()).getAuthorizable();
                    authorizable.authorize(this.authorizer, RequestAction.READ, user);
                    authorizable.authorize(this.authorizer, RequestAction.WRITE, user);
                }
            }
            if (activeAffectedServices != null) {
                for (AffectedComponentDTO activeAffectedComponent : activeAffectedServices) {
                    authorizable = lookup.getControllerService(activeAffectedComponent.getId()).getAuthorizable();
                    authorizable.authorize(this.authorizer, RequestAction.READ, user);
                    authorizable.authorize(this.authorizer, RequestAction.WRITE, user);
                }
            }
        };
        if (this.isReplicateRequest()) {
            this.serviceFacade.authorizeAccess(authorizeAccess);
            VariableRegistryUpdateRequest updateRequest = this.createVariableRegistryUpdateRequest(groupId, allAffectedComponents, user);
            updateRequest.getIdentifyRelevantComponentsStep().setComplete(true);
            URI originalUri = this.getAbsolutePath();
            Runnable taskWrapper = () -> {
                try {
                    NiFiAuthenticationToken authentication = new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails(user));
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                    this.updateVariableRegistryReplicated(groupId, originalUri, (Collection)activeAffectedProcessors, (Collection)activeAffectedServices, updateRequest, requestVariableRegistryEntity);
                    updateRequest.setComplete(true);
                }
                catch (Exception e) {
                    logger.error("Failed to update variable registry", (Throwable)e);
                    updateRequest.setComplete(true);
                    updateRequest.setFailureReason("An unexpected error has occurred: " + e);
                }
                finally {
                    SecurityContextHolder.getContext().setAuthentication(null);
                }
            };
            this.variableRegistryThreadPool.submit(taskWrapper);
            VariableRegistryUpdateRequestEntity responseEntity = new VariableRegistryUpdateRequestEntity();
            responseEntity.setRequest(this.dtoFactory.createVariableRegistryUpdateRequestDto(updateRequest));
            responseEntity.setProcessGroupRevision(updateRequest.getProcessGroupRevision());
            responseEntity.getRequest().setUri(this.generateResourceUri(new String[]{"process-groups", groupId, "variable-registry", "update-requests", updateRequest.getRequestId()}));
            URI location = URI.create(responseEntity.getRequest().getUri());
            return Response.status((Response.Status)Response.Status.ACCEPTED).location(location).entity((Object)responseEntity).build();
        }
        UpdateVariableRegistryRequestWrapper requestWrapper = new UpdateVariableRegistryRequestWrapper(allAffectedComponents, activeAffectedProcessors, activeAffectedServices, requestVariableRegistryEntity);
        Revision requestRevision = this.getRevision(requestVariableRegistryEntity.getProcessGroupRevision(), groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestWrapper, requestRevision, authorizeAccess, null, (revision, wrapper) -> this.updateVariableRegistryLocal(groupId, wrapper.getAllAffectedComponents(), wrapper.getActiveAffectedProcessors(), wrapper.getActiveAffectedServices(), user, revision, wrapper.getVariableRegistryEntity()));
    }

    private Pause createPause(VariableRegistryUpdateRequest updateRequest) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void updateVariableRegistryReplicated(String groupId, URI originalUri, Collection<AffectedComponentDTO> affectedProcessors, Collection<AffectedComponentDTO> affectedServices, VariableRegistryUpdateRequest updateRequest, VariableRegistryEntity requestEntity) throws InterruptedException, IOException {
        Pause pause = this.createPause(updateRequest);
        if (affectedProcessors != null) {
            logger.info("In order to update Variable Registry for Process Group with ID {}, replicating request to stop {} affected Processors", (Object)groupId, (Object)affectedProcessors.size());
            this.scheduleProcessors(groupId, originalUri, updateRequest, pause, affectedProcessors, ScheduledState.STOPPED, updateRequest.getStopProcessorsStep());
        } else {
            logger.info("In order to update Variable Registry for Process Group with ID {}, no Processors are affected.", (Object)groupId);
            updateRequest.getStopProcessorsStep().setComplete(true);
        }
        if (affectedServices != null) {
            logger.info("In order to update Variable Registry for Process Group with ID {}, replicating request to stop {} affected Controller Services", (Object)groupId, (Object)affectedServices.size());
            this.activateControllerServices(groupId, originalUri, updateRequest, pause, affectedServices, ControllerServiceState.DISABLED, updateRequest.getDisableServicesStep());
        } else {
            logger.info("In order to update Variable Registry for Process Group with ID {}, no Controller Services are affected.", (Object)groupId);
            updateRequest.getDisableServicesStep().setComplete(true);
        }
        logger.info("In order to update Variable Registry for Process Group with ID {}, replicating request to apply updates to variable registry", (Object)groupId);
        this.applyVariableRegistryUpdate(groupId, originalUri, updateRequest, requestEntity);
        if (affectedServices != null) {
            logger.info("In order to update Variable Registry for Process Group with ID {}, replicating request to re-enable {} affected services", (Object)groupId, (Object)affectedServices.size());
            this.activateControllerServices(groupId, originalUri, updateRequest, pause, affectedServices, ControllerServiceState.ENABLED, updateRequest.getEnableServicesStep());
        } else {
            logger.info("In order to update Variable Registry for Process Group with ID {}, no Controller Services are affected.", (Object)groupId);
            updateRequest.getEnableServicesStep().setComplete(true);
        }
        if (affectedProcessors != null) {
            logger.info("In order to update Variable Registry for Process Group with ID {}, replicating request to restart {} affected processors", (Object)groupId, (Object)affectedProcessors.size());
            this.scheduleProcessors(groupId, originalUri, updateRequest, pause, affectedProcessors, ScheduledState.RUNNING, updateRequest.getStartProcessorsStep());
        } else {
            logger.info("In order to update Variable Registry for Process Group with ID {}, no Processors are affected.", (Object)groupId);
            updateRequest.getStartProcessorsStep().setComplete(true);
        }
    }

    private boolean waitForProcessorStatus(URI originalUri, String groupId, Set<String> processorIds, ScheduledState desiredState, VariableRegistryUpdateRequest updateRequest, Pause pause) throws InterruptedException {
        URI groupUri;
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/process-groups/" + groupId + "/processors", "includeDescendantGroups=true", originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        MultivaluedHashMap requestEntity = new MultivaluedHashMap();
        boolean continuePolling = true;
        while (continuePolling) {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse();
            if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return false;
            }
            ProcessorsEntity processorsEntity = (ProcessorsEntity)this.getResponseEntity(clusterResponse, ProcessorsEntity.class);
            Set processorEntities = processorsEntity.getProcessors();
            if (this.isProcessorActionComplete(processorEntities, updateRequest, processorIds, desiredState)) {
                logger.debug("All {} processors of interest now have the desired state of {}", (Object)processorIds.size(), (Object)desiredState);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private boolean waitForLocalProcessor(String groupId, Set<String> processorIds, ScheduledState desiredState, VariableRegistryUpdateRequest updateRequest, Pause pause) {
        boolean continuePolling = true;
        while (continuePolling) {
            Set processorEntities = this.serviceFacade.getProcessors(groupId, true);
            if (this.isProcessorActionComplete(processorEntities, updateRequest, processorIds, desiredState)) {
                logger.debug("All {} processors of interest now have the desired state of {}", (Object)processorIds.size(), (Object)desiredState);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private boolean isProcessorActionComplete(Set<ProcessorEntity> processorEntities, VariableRegistryUpdateRequest updateRequest, Set<String> processorIds, ScheduledState desiredState) {
        String desiredStateName = desiredState.name();
        processorEntities.stream().filter(entity -> updateRequest.getAffectedComponents().containsKey(entity.getId())).forEach(entity -> {
            AffectedComponentEntity affectedComponentEntity = (AffectedComponentEntity)updateRequest.getAffectedComponents().get(entity.getId());
            affectedComponentEntity.setRevision(entity.getRevision());
            if (Boolean.TRUE.equals(affectedComponentEntity.getPermissions().getCanRead())) {
                AffectedComponentDTO affectedComponent = affectedComponentEntity.getComponent();
                affectedComponent.setState(entity.getStatus().getAggregateSnapshot().getRunStatus());
                affectedComponent.setActiveThreadCount(entity.getStatus().getAggregateSnapshot().getActiveThreadCount());
                if (Boolean.TRUE.equals(entity.getPermissions().getCanRead())) {
                    affectedComponent.setValidationErrors(entity.getComponent().getValidationErrors());
                }
            }
        });
        boolean allProcessorsMatch = processorEntities.stream().filter(entity -> processorIds.contains(entity.getId())).allMatch(entity -> {
            ProcessorStatusDTO status = entity.getStatus();
            String runStatus = status.getAggregateSnapshot().getRunStatus();
            boolean stateMatches = desiredStateName.equalsIgnoreCase(runStatus);
            if (!stateMatches) {
                return false;
            }
            return desiredState != ScheduledState.STOPPED || status.getAggregateSnapshot().getActiveThreadCount() == 0;
        });
        return allProcessorsMatch;
    }

    private void updateAffectedControllerServices(Set<ControllerServiceEntity> serviceEntities, VariableRegistryUpdateRequest updateRequest) {
        serviceEntities.stream().filter(entity -> updateRequest.getAffectedComponents().containsKey(entity.getId())).forEach(entity -> {
            AffectedComponentEntity affectedComponentEntity = (AffectedComponentEntity)updateRequest.getAffectedComponents().get(entity.getId());
            affectedComponentEntity.setRevision(entity.getRevision());
            if (Boolean.TRUE.equals(affectedComponentEntity.getPermissions().getCanRead())) {
                AffectedComponentDTO affectedComponent = affectedComponentEntity.getComponent();
                affectedComponent.setState(entity.getComponent().getState());
                if (Boolean.TRUE.equals(entity.getPermissions().getCanRead())) {
                    affectedComponent.setValidationErrors(entity.getComponent().getValidationErrors());
                }
            }
        });
    }

    private boolean waitForControllerServiceStatus(URI originalUri, String groupId, Set<String> serviceIds, ControllerServiceState desiredState, VariableRegistryUpdateRequest updateRequest, Pause pause) throws InterruptedException {
        URI groupUri;
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/flow/process-groups/" + groupId + "/controller-services", "includeAncestorGroups=false,includeDescendantGroups=true", originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        MultivaluedHashMap requestEntity = new MultivaluedHashMap();
        boolean continuePolling = true;
        while (continuePolling) {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse();
            if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return false;
            }
            ControllerServicesEntity controllerServicesEntity = (ControllerServicesEntity)this.getResponseEntity(clusterResponse, ControllerServicesEntity.class);
            Set serviceEntities = controllerServicesEntity.getControllerServices();
            this.updateAffectedControllerServices(serviceEntities, updateRequest);
            String desiredStateName = desiredState.name();
            boolean allServicesMatch = serviceEntities.stream().map(entity -> entity.getComponent()).filter(service -> serviceIds.contains(service.getId())).map(service -> service.getState()).allMatch(state -> state.equals(desiredStateName));
            if (allServicesMatch) {
                logger.debug("All {} controller services of interest now have the desired state of {}", (Object)serviceIds.size(), (Object)desiredState);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private boolean waitForLocalControllerServiceStatus(String groupId, Set<String> serviceIds, ControllerServiceState desiredState, VariableRegistryUpdateRequest updateRequest, Pause pause) {
        boolean continuePolling = true;
        while (continuePolling) {
            Set serviceEntities = this.serviceFacade.getControllerServices(groupId, false, true);
            this.updateAffectedControllerServices(serviceEntities, updateRequest);
            String desiredStateName = desiredState.name();
            boolean allServicesMatch = serviceEntities.stream().map(entity -> entity.getComponent()).filter(service -> serviceIds.contains(service.getId())).map(service -> service.getState()).allMatch(state -> desiredStateName.equals(state));
            if (allServicesMatch) {
                logger.debug("All {} controller services of interest now have the desired state of {}", (Object)serviceIds.size(), (Object)desiredState);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private VariableRegistryUpdateRequest createVariableRegistryUpdateRequest(String groupId, Set<AffectedComponentEntity> affectedComponents, NiFiUser user) {
        VariableRegistryUpdateRequest updateRequest = new VariableRegistryUpdateRequest(UUID.randomUUID().toString(), groupId, affectedComponents, user);
        Date oneMinuteAgo = new Date(System.currentTimeMillis() - VARIABLE_REGISTRY_UPDATE_REQUEST_EXPIRATION);
        List completedRequestIds = this.varRegistryUpdateRequests.entrySet().stream().filter(entry -> ((VariableRegistryUpdateRequest)entry.getValue()).isComplete()).filter(entry -> ((VariableRegistryUpdateRequest)entry.getValue()).getLastUpdated().before(oneMinuteAgo)).map(Map.Entry::getKey).collect(Collectors.toList());
        completedRequestIds.stream().forEach(id -> {
            VariableRegistryUpdateRequest cfr_ignored_0 = (VariableRegistryUpdateRequest)this.varRegistryUpdateRequests.remove(id);
        });
        int requestCount = this.varRegistryUpdateRequests.size();
        if (requestCount > 100) {
            throw new IllegalStateException("There are already " + requestCount + " update requests for variable registries. Cannot issue any more requests until the older ones are deleted or expire");
        }
        this.varRegistryUpdateRequests.put(updateRequest.getRequestId(), updateRequest);
        return updateRequest;
    }

    private Response updateVariableRegistryLocal(String groupId, Set<AffectedComponentEntity> affectedComponents, List<AffectedComponentDTO> affectedProcessors, List<AffectedComponentDTO> affectedServices, NiFiUser user, Revision requestRevision, VariableRegistryEntity requestEntity) {
        Set affectedProcessorIds = affectedProcessors == null ? Collections.emptySet() : affectedProcessors.stream().map(component -> component.getId()).collect(Collectors.toSet());
        Map processorRevisionMap = this.getRevisions(groupId, affectedProcessorIds);
        Set affectedServiceIds = affectedServices == null ? Collections.emptySet() : affectedServices.stream().map(component -> component.getId()).collect(Collectors.toSet());
        Map serviceRevisionMap = this.getRevisions(groupId, affectedServiceIds);
        VariableRegistryUpdateRequest updateRequest = this.createVariableRegistryUpdateRequest(groupId, affectedComponents, user);
        updateRequest.getIdentifyRelevantComponentsStep().setComplete(true);
        Pause pause = this.createPause(updateRequest);
        3 updateTask = new /* Unavailable Anonymous Inner Class!! */;
        this.variableRegistryThreadPool.submit((Runnable)updateTask);
        VariableRegistryUpdateRequestEntity responseEntity = new VariableRegistryUpdateRequestEntity();
        responseEntity.setRequest(this.dtoFactory.createVariableRegistryUpdateRequestDto(updateRequest));
        responseEntity.setProcessGroupRevision(updateRequest.getProcessGroupRevision());
        responseEntity.getRequest().setUri(this.generateResourceUri(new String[]{"process-groups", groupId, "variable-registry", "update-requests", updateRequest.getRequestId()}));
        URI location = URI.create(responseEntity.getRequest().getUri());
        return Response.status((Response.Status)Response.Status.ACCEPTED).location(location).entity((Object)responseEntity).build();
    }

    private Map<String, Revision> getRevisions(String groupId, Set<String> componentIds) {
        Set processorRevisions = this.serviceFacade.getRevisionsFromGroup(groupId, group -> componentIds);
        return processorRevisions.stream().collect(Collectors.toMap(revision -> revision.getComponentId(), Function.identity()));
    }

    private void performUpdateVariableRegistryStep(String groupId, VariableRegistryUpdateRequest request, VariableRegistryUpdateStep step, String stepDescription, Runnable action) {
        if (request.isComplete()) {
            logger.info("In updating Variable Registry for Process Group with ID {}, skipping the following step because the request has completed already: {}", (Object)groupId, (Object)stepDescription);
            return;
        }
        try {
            logger.info("In order to update Variable Registry for Process Group with ID {}, {}", (Object)groupId, (Object)stepDescription);
            action.run();
            step.setComplete(true);
        }
        catch (Exception e) {
            logger.error("Failed to update variable registry for Process Group with ID {}", (Object)groupId, (Object)e);
            step.setComplete(true);
            step.setFailureReason(e.getMessage());
            request.setComplete(true);
            request.setFailureReason("Failed to update Variable Registry because failed while performing step: " + stepDescription);
        }
        request.setLastUpdated(new Date());
    }

    private void stopProcessors(VariableRegistryUpdateRequest updateRequest, String processGroupId, Map<String, Revision> processorRevisions, Pause pause) {
        if (processorRevisions.isEmpty()) {
            return;
        }
        this.serviceFacade.verifyScheduleComponents(processGroupId, ScheduledState.STOPPED, processorRevisions.keySet());
        this.serviceFacade.scheduleComponents(processGroupId, ScheduledState.STOPPED, processorRevisions);
        this.waitForLocalProcessor(processGroupId, processorRevisions.keySet(), ScheduledState.STOPPED, updateRequest, pause);
    }

    private void startProcessors(VariableRegistryUpdateRequest request, String processGroupId, Map<String, Revision> processorRevisions, Pause pause) {
        if (processorRevisions.isEmpty()) {
            return;
        }
        this.serviceFacade.verifyScheduleComponents(processGroupId, ScheduledState.RUNNING, processorRevisions.keySet());
        this.serviceFacade.scheduleComponents(processGroupId, ScheduledState.RUNNING, processorRevisions);
        this.waitForLocalProcessor(processGroupId, processorRevisions.keySet(), ScheduledState.RUNNING, request, pause);
    }

    private void disableControllerServices(VariableRegistryUpdateRequest updateRequest, String processGroupId, Map<String, Revision> serviceRevisions, Pause pause) {
        if (serviceRevisions.isEmpty()) {
            return;
        }
        this.serviceFacade.verifyActivateControllerServices(processGroupId, ControllerServiceState.DISABLED, serviceRevisions.keySet());
        this.serviceFacade.activateControllerServices(processGroupId, ControllerServiceState.DISABLED, serviceRevisions);
        this.waitForLocalControllerServiceStatus(processGroupId, serviceRevisions.keySet(), ControllerServiceState.DISABLED, updateRequest, pause);
    }

    private void enableControllerServices(VariableRegistryUpdateRequest updateRequest, String processGroupId, Map<String, Revision> serviceRevisions, Pause pause) {
        if (serviceRevisions.isEmpty()) {
            return;
        }
        this.serviceFacade.verifyActivateControllerServices(processGroupId, ControllerServiceState.ENABLED, serviceRevisions.keySet());
        this.serviceFacade.activateControllerServices(processGroupId, ControllerServiceState.ENABLED, serviceRevisions);
        this.waitForLocalControllerServiceStatus(processGroupId, serviceRevisions.keySet(), ControllerServiceState.ENABLED, updateRequest, pause);
    }

    private void scheduleProcessors(String groupId, URI originalUri, VariableRegistryUpdateRequest updateRequest, Pause pause, Collection<AffectedComponentDTO> affectedProcessors, ScheduledState desiredState, VariableRegistryUpdateStep updateStep) throws InterruptedException {
        URI scheduleGroupUri;
        Set affectedProcessorIds = affectedProcessors.stream().map(component -> component.getId()).collect(Collectors.toSet());
        Map processorRevisionMap = this.getRevisions(groupId, affectedProcessorIds);
        Map<String, RevisionDTO> processorRevisionDtoMap = processorRevisionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.dtoFactory.createRevisionDTO((Revision)entry.getValue())));
        ScheduleComponentsEntity scheduleProcessorsEntity = new ScheduleComponentsEntity();
        scheduleProcessorsEntity.setComponents(processorRevisionDtoMap);
        scheduleProcessorsEntity.setId(groupId);
        scheduleProcessorsEntity.setState(desiredState.name());
        try {
            scheduleGroupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/flow/process-groups/" + groupId, null, originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("PUT", scheduleGroupUri, (Object)scheduleProcessorsEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "PUT", scheduleGroupUri, (Object)scheduleProcessorsEntity, headers).awaitMergedResponse();
        int stopProcessorStatus = clusterResponse.getStatus();
        if (stopProcessorStatus != Response.Status.OK.getStatusCode()) {
            updateRequest.getStopProcessorsStep().setFailureReason("Failed while " + updateStep.getDescription());
            updateStep.setComplete(true);
            updateRequest.setFailureReason("Failed while " + updateStep.getDescription());
            return;
        }
        updateRequest.setLastUpdated(new Date());
        boolean processorsTransitioned = this.waitForProcessorStatus(originalUri, groupId, affectedProcessorIds, desiredState, updateRequest, pause);
        updateStep.setComplete(true);
        if (!processorsTransitioned) {
            updateStep.setFailureReason("Failed while " + updateStep.getDescription());
            updateRequest.setComplete(true);
            updateRequest.setFailureReason("Failed while " + updateStep.getDescription());
        }
    }

    private void activateControllerServices(String groupId, URI originalUri, VariableRegistryUpdateRequest updateRequest, Pause pause, Collection<AffectedComponentDTO> affectedServices, ControllerServiceState desiredState, VariableRegistryUpdateStep updateStep) throws InterruptedException {
        URI controllerServicesUri;
        Set affectedServiceIds = affectedServices.stream().map(component -> component.getId()).collect(Collectors.toSet());
        Map serviceRevisionMap = this.getRevisions(groupId, affectedServiceIds);
        Map<String, RevisionDTO> serviceRevisionDtoMap = serviceRevisionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.dtoFactory.createRevisionDTO((Revision)entry.getValue())));
        ActivateControllerServicesEntity activateServicesEntity = new ActivateControllerServicesEntity();
        activateServicesEntity.setComponents(serviceRevisionDtoMap);
        activateServicesEntity.setId(groupId);
        activateServicesEntity.setState(desiredState.name());
        try {
            controllerServicesUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/flow/process-groups/" + groupId + "/controller-services", null, originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("PUT", controllerServicesUri, (Object)activateServicesEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "PUT", controllerServicesUri, (Object)activateServicesEntity, headers).awaitMergedResponse();
        int disableServicesStatus = clusterResponse.getStatus();
        if (disableServicesStatus != Response.Status.OK.getStatusCode()) {
            updateStep.setFailureReason("Failed while " + updateStep.getDescription());
            updateStep.setComplete(true);
            updateRequest.setFailureReason("Failed while " + updateStep.getDescription());
            return;
        }
        updateRequest.setLastUpdated(new Date());
        boolean serviceTransitioned = this.waitForControllerServiceStatus(originalUri, groupId, affectedServiceIds, desiredState, updateRequest, pause);
        updateStep.setComplete(true);
        if (!serviceTransitioned) {
            updateStep.setFailureReason("Failed while " + updateStep.getDescription());
            updateRequest.setComplete(true);
            updateRequest.setFailureReason("Failed while " + updateStep.getDescription());
        }
    }

    private void applyVariableRegistryUpdate(String groupId, URI originalUri, VariableRegistryUpdateRequest updateRequest, VariableRegistryEntity updateEntity) throws InterruptedException, IOException {
        URI applyUpdatesUri;
        try {
            applyUpdatesUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/process-groups/" + groupId + "/variable-registry", null, originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("PUT", applyUpdatesUri, (Object)updateEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "PUT", applyUpdatesUri, (Object)updateEntity, headers).awaitMergedResponse();
        int applyUpdatesStatus = clusterResponse.getStatus();
        updateRequest.setLastUpdated(new Date());
        updateRequest.getApplyUpdatesStep().setComplete(true);
        if (applyUpdatesStatus == Response.Status.OK.getStatusCode()) {
            VariableRegistryEntity entity = (VariableRegistryEntity)this.getResponseEntity(clusterResponse, VariableRegistryEntity.class);
            updateRequest.setProcessGroupRevision(entity.getProcessGroupRevision());
        } else {
            String message = (String)this.getResponseEntity(clusterResponse, String.class);
            updateRequest.getApplyUpdatesStep().setFailureReason("Failed to apply updates to the Variable Registry: " + message);
            updateRequest.setComplete(true);
            updateRequest.setFailureReason("Failed to apply updates to the Variable Registry: " + message);
        }
    }

    private <T> T getResponseEntity(NodeResponse nodeResponse, Class<T> clazz) {
        Object entity = nodeResponse.getUpdatedEntity();
        if (entity == null) {
            entity = nodeResponse.getClientResponse().readEntity(clazz);
        }
        return (T)entity;
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a process group", response=ProcessGroupEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Write - Parent Process Group - /process-groups/{uuid}"), @Authorization(value="Read - any referenced Controller Services by any encapsulated components - /controller-services/{uuid}"), @Authorization(value="Write - /{component-type}/{uuid} - For all encapsulated components")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        ProcessGroupEntity requestProcessGroupEntity = new ProcessGroupEntity();
        requestProcessGroupEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessGroupEntity, requestRevision, lookup -> {
            ProcessGroupAuthorizable processGroupAuthorizable = lookup.getProcessGroup(id);
            this.authorizeProcessGroup(processGroupAuthorizable, this.authorizer, lookup, RequestAction.WRITE, true, true, true, false);
            Authorizable parentAuthorizable = processGroupAuthorizable.getAuthorizable().getParentAuthorizable();
            if (parentAuthorizable != null) {
                parentAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            }
        }, () -> this.serviceFacade.verifyDeleteProcessGroup(id), (revision, processGroupEntity) -> {
            ProcessGroupEntity entity = this.serviceFacade.deleteProcessGroup(revision, processGroupEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/process-groups")
    @ApiOperation(value="Creates a process group", response=ProcessGroupEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The process group configuration details.", required=true) ProcessGroupEntity requestProcessGroupEntity) throws IOException {
        VersionedFlowSnapshot flowSnapshot;
        if (requestProcessGroupEntity == null || requestProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Process group details must be specified.");
        }
        if (requestProcessGroupEntity.getRevision() == null || requestProcessGroupEntity.getRevision().getVersion() == null || requestProcessGroupEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Process group.");
        }
        if (requestProcessGroupEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Process group ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestProcessGroupEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestProcessGroupEntity.getComponent().getName()) && requestProcessGroupEntity.getComponent().getVersionControlInformation() == null) {
            throw new IllegalArgumentException("The group name is required when the group is not imported from version control.");
        }
        if (requestProcessGroupEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestProcessGroupEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestProcessGroupEntity.getComponent().getParentGroupId(), groupId));
        }
        requestProcessGroupEntity.getComponent().setParentGroupId(groupId);
        VersionControlInformationDTO versionControlInfo = requestProcessGroupEntity.getComponent().getVersionControlInformation();
        if (versionControlInfo != null && requestProcessGroupEntity.getVersionedFlowSnapshot() == null) {
            flowSnapshot = this.serviceFacade.getVersionedFlowSnapshot(versionControlInfo, true);
            Bucket bucket = flowSnapshot.getBucket();
            VersionedFlow flow = flowSnapshot.getFlow();
            versionControlInfo.setBucketName(bucket.getName());
            versionControlInfo.setFlowName(flow.getName());
            versionControlInfo.setFlowDescription(flow.getDescription());
            versionControlInfo.setRegistryName(this.serviceFacade.getFlowRegistryName(versionControlInfo.getRegistryId()));
            VersionedFlowState flowState = flowSnapshot.isLatest() ? VersionedFlowState.UP_TO_DATE : VersionedFlowState.STALE;
            versionControlInfo.setState(flowState.name());
            this.serviceFacade.discoverCompatibleBundles(flowSnapshot.getFlowContents());
            requestProcessGroupEntity.setVersionedFlowSnapshot(flowSnapshot);
        }
        if (versionControlInfo != null) {
            flowSnapshot = requestProcessGroupEntity.getVersionedFlowSnapshot();
            this.serviceFacade.verifyImportProcessGroup(versionControlInfo, flowSnapshot.getFlowContents(), groupId);
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestProcessGroupEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestProcessGroupEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessGroupEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            VersionedFlowSnapshot versionedFlowSnapshot = requestProcessGroupEntity.getVersionedFlowSnapshot();
            if (versionedFlowSnapshot != null) {
                Set restrictedComponents = FlowRegistryUtils.getRestrictedComponents((VersionedProcessGroup)versionedFlowSnapshot.getFlowContents(), (NiFiServiceFacade)this.serviceFacade);
                restrictedComponents.forEach(restrictedComponent -> {
                    ComponentAuthorizable restrictedComponentAuthorizable = lookup.getConfigurableComponent(restrictedComponent);
                    this.authorizeRestrictions(this.authorizer, restrictedComponentAuthorizable);
                });
            }
        }, () -> {
            VersionedFlowSnapshot versionedFlowSnapshot = requestProcessGroupEntity.getVersionedFlowSnapshot();
            if (versionedFlowSnapshot != null) {
                this.serviceFacade.verifyComponentTypes(versionedFlowSnapshot.getFlowContents());
            }
        }, processGroupEntity -> {
            ProcessGroupDTO processGroup = processGroupEntity.getComponent();
            processGroup.setId(this.generateUuid());
            VersionedFlowSnapshot flowSnapshot = processGroupEntity.getVersionedFlowSnapshot();
            if (flowSnapshot != null && StringUtils.isNotBlank((CharSequence)flowSnapshot.getFlowContents().getName()) && StringUtils.isBlank((CharSequence)processGroup.getName())) {
                processGroup.setName(flowSnapshot.getFlowContents().getName());
            }
            Revision revision = this.getRevision((ComponentEntity)processGroupEntity, processGroup.getId());
            ProcessGroupEntity entity = this.serviceFacade.createProcessGroup(revision, groupId, processGroup);
            if (flowSnapshot != null) {
                RevisionDTO revisionDto = entity.getRevision();
                String newGroupId = entity.getComponent().getId();
                Revision newGroupRevision = new Revision(revisionDto.getVersion(), revisionDto.getClientId(), newGroupId);
                flowSnapshot.getFlowContents().setPosition(null);
                entity = this.serviceFacade.updateProcessGroupContents(newGroupRevision, newGroupId, versionControlInfo, flowSnapshot, (String)this.getIdGenerationSeed().orElse(null), false, true, true);
            }
            this.populateRemainingProcessGroupEntityContent(entity);
            String uri = entity.getUri();
            return this.generateCreatedResponse(URI.create(uri), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/process-groups")
    @ApiOperation(value="Gets all process groups", response=ProcessGroupsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessGroups(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set entities = this.serviceFacade.getProcessGroups(groupId);
        for (ProcessGroupEntity entity : entities) {
            if (entity.getComponent() == null) continue;
            entity.getComponent().setContents(null);
        }
        ProcessGroupsEntity entity = new ProcessGroupsEntity();
        entity.setProcessGroups(this.populateRemainingProcessGroupEntitiesContent(entities));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/processors")
    @ApiOperation(value="Creates a new processor", response=ProcessorEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}"), @Authorization(value="Write - if the Processor is restricted - /restricted-components")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createProcessor(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The processor configuration details.", required=true) ProcessorEntity requestProcessorEntity) {
        if (requestProcessorEntity == null || requestProcessorEntity.getComponent() == null) {
            throw new IllegalArgumentException("Processor details must be specified.");
        }
        if (requestProcessorEntity.getRevision() == null || requestProcessorEntity.getRevision().getVersion() == null || requestProcessorEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Processor.");
        }
        ProcessorDTO requestProcessor = requestProcessorEntity.getComponent();
        if (requestProcessor.getId() != null) {
            throw new IllegalArgumentException("Processor ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestProcessor.getType())) {
            throw new IllegalArgumentException("The type of processor to create must be specified.");
        }
        PositionDTO proposedPosition = requestProcessor.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestProcessor.getParentGroupId() != null && !groupId.equals(requestProcessor.getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestProcessor.getParentGroupId(), groupId));
        }
        requestProcessor.setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestProcessorEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestProcessorEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
            ComponentAuthorizable authorizable = null;
            try {
                ProcessorConfigDTO config;
                authorizable = lookup.getConfigurableComponent(requestProcessor.getType(), requestProcessor.getBundle());
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
                if ((config = requestProcessor.getConfig()) != null && config.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)config.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateProcessor(requestProcessor), processorEntity -> {
            ProcessorDTO processor = processorEntity.getComponent();
            processor.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)processorEntity, processor.getId());
            ProcessorEntity entity = this.serviceFacade.createProcessor(revision, groupId, processor);
            this.processorResource.populateRemainingProcessorEntityContent(entity);
            String uri = entity.getUri();
            return this.generateCreatedResponse(URI.create(uri), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/processors")
    @ApiOperation(value="Gets all processors", response=ProcessorsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessors(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="Whether or not to include processors from descendant process groups") @QueryParam(value="includeDescendantGroups") @DefaultValue(value="false") boolean includeDescendantGroups) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set processors = this.serviceFacade.getProcessors(groupId, includeDescendantGroups);
        ProcessorsEntity entity = new ProcessorsEntity();
        entity.setProcessors(this.processorResource.populateRemainingProcessorEntitiesContent(processors));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/input-ports")
    @ApiOperation(value="Creates an input port", response=PortEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createInputPort(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The input port configuration details.", required=true) PortEntity requestPortEntity) {
        if (requestPortEntity == null || requestPortEntity.getComponent() == null) {
            throw new IllegalArgumentException("Port details must be specified.");
        }
        if (requestPortEntity.getRevision() == null || requestPortEntity.getRevision().getVersion() == null || requestPortEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Input port.");
        }
        if (requestPortEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Input port ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestPortEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestPortEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestPortEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestPortEntity.getComponent().getParentGroupId(), groupId));
        }
        requestPortEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestPortEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestPortEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestPortEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, portEntity -> {
            portEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)portEntity, portEntity.getComponent().getId());
            PortEntity entity = this.serviceFacade.createInputPort(revision, groupId, portEntity.getComponent());
            this.inputPortResource.populateRemainingInputPortEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/input-ports")
    @ApiOperation(value="Gets all input ports", response=InputPortsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getInputPorts(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set inputPorts = this.serviceFacade.getInputPorts(groupId);
        InputPortsEntity entity = new InputPortsEntity();
        entity.setInputPorts(this.inputPortResource.populateRemainingInputPortEntitiesContent(inputPorts));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/output-ports")
    @ApiOperation(value="Creates an output port", response=PortEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createOutputPort(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The output port configuration.", required=true) PortEntity requestPortEntity) {
        if (requestPortEntity == null || requestPortEntity.getComponent() == null) {
            throw new IllegalArgumentException("Port details must be specified.");
        }
        if (requestPortEntity.getRevision() == null || requestPortEntity.getRevision().getVersion() == null || requestPortEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Output port.");
        }
        if (requestPortEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Output port ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestPortEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestPortEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestPortEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestPortEntity.getComponent().getParentGroupId(), groupId));
        }
        requestPortEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestPortEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestPortEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestPortEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, portEntity -> {
            portEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)portEntity, portEntity.getComponent().getId());
            PortEntity entity = this.serviceFacade.createOutputPort(revision, groupId, portEntity.getComponent());
            this.outputPortResource.populateRemainingOutputPortEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/output-ports")
    @ApiOperation(value="Gets all output ports", response=OutputPortsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getOutputPorts(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set outputPorts = this.serviceFacade.getOutputPorts(groupId);
        OutputPortsEntity entity = new OutputPortsEntity();
        entity.setOutputPorts(this.outputPortResource.populateRemainingOutputPortEntitiesContent(outputPorts));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/funnels")
    @ApiOperation(value="Creates a funnel", response=FunnelEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createFunnel(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The funnel configuration details.", required=true) FunnelEntity requestFunnelEntity) {
        if (requestFunnelEntity == null || requestFunnelEntity.getComponent() == null) {
            throw new IllegalArgumentException("Funnel details must be specified.");
        }
        if (requestFunnelEntity.getRevision() == null || requestFunnelEntity.getRevision().getVersion() == null || requestFunnelEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Funnel.");
        }
        if (requestFunnelEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Funnel ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestFunnelEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestFunnelEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestFunnelEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestFunnelEntity.getComponent().getParentGroupId(), groupId));
        }
        requestFunnelEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestFunnelEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestFunnelEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestFunnelEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, funnelEntity -> {
            funnelEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)funnelEntity, funnelEntity.getComponent().getId());
            FunnelEntity entity = this.serviceFacade.createFunnel(revision, groupId, funnelEntity.getComponent());
            this.funnelResource.populateRemainingFunnelEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/funnels")
    @ApiOperation(value="Gets all funnels", response=FunnelsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getFunnels(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set funnels = this.serviceFacade.getFunnels(groupId);
        FunnelsEntity entity = new FunnelsEntity();
        entity.setFunnels(this.funnelResource.populateRemainingFunnelEntitiesContent(funnels));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/labels")
    @ApiOperation(value="Creates a label", response=LabelEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createLabel(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The label configuration details.", required=true) LabelEntity requestLabelEntity) {
        if (requestLabelEntity == null || requestLabelEntity.getComponent() == null) {
            throw new IllegalArgumentException("Label details must be specified.");
        }
        if (requestLabelEntity.getRevision() == null || requestLabelEntity.getRevision().getVersion() == null || requestLabelEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Label.");
        }
        if (requestLabelEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Label ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestLabelEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestLabelEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestLabelEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestLabelEntity.getComponent().getParentGroupId(), groupId));
        }
        requestLabelEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestLabelEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestLabelEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestLabelEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, labelEntity -> {
            labelEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)labelEntity, labelEntity.getComponent().getId());
            LabelEntity entity = this.serviceFacade.createLabel(revision, groupId, labelEntity.getComponent());
            this.labelResource.populateRemainingLabelEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/labels")
    @ApiOperation(value="Gets all labels", response=LabelsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getLabels(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set labels = this.serviceFacade.getLabels(groupId);
        LabelsEntity entity = new LabelsEntity();
        entity.setLabels(this.labelResource.populateRemainingLabelEntitiesContent(labels));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/remote-process-groups")
    @ApiOperation(value="Creates a new process group", response=RemoteProcessGroupEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createRemoteProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The remote process group configuration details.", required=true) RemoteProcessGroupEntity requestRemoteProcessGroupEntity) {
        if (requestRemoteProcessGroupEntity == null || requestRemoteProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Remote process group details must be specified.");
        }
        if (requestRemoteProcessGroupEntity.getRevision() == null || requestRemoteProcessGroupEntity.getRevision().getVersion() == null || requestRemoteProcessGroupEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Remote process group.");
        }
        RemoteProcessGroupDTO requestRemoteProcessGroupDTO = requestRemoteProcessGroupEntity.getComponent();
        if (requestRemoteProcessGroupDTO.getId() != null) {
            throw new IllegalArgumentException("Remote process group ID cannot be specified.");
        }
        if (requestRemoteProcessGroupDTO.getTargetUri() == null) {
            throw new IllegalArgumentException("The URI of the process group must be specified.");
        }
        PositionDTO proposedPosition = requestRemoteProcessGroupDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestRemoteProcessGroupDTO.getParentGroupId() != null && !groupId.equals(requestRemoteProcessGroupDTO.getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestRemoteProcessGroupDTO.getParentGroupId(), groupId));
        }
        requestRemoteProcessGroupDTO.setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestRemoteProcessGroupEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRemoteProcessGroupEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, remoteProcessGroupEntity -> {
            RemoteProcessGroupDTO remoteProcessGroupDTO = remoteProcessGroupEntity.getComponent();
            remoteProcessGroupDTO.setId(this.generateUuid());
            String targetUris = remoteProcessGroupDTO.getTargetUris();
            SiteToSiteRestApiClient.parseClusterUrls((String)targetUris);
            remoteProcessGroupDTO.setTargetUris(targetUris);
            Revision revision = this.getRevision((ComponentEntity)remoteProcessGroupEntity, remoteProcessGroupDTO.getId());
            RemoteProcessGroupEntity entity = this.serviceFacade.createRemoteProcessGroup(revision, groupId, remoteProcessGroupDTO);
            this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/remote-process-groups")
    @ApiOperation(value="Gets all remote process groups", response=RemoteProcessGroupsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRemoteProcessGroups(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set remoteProcessGroups = this.serviceFacade.getRemoteProcessGroups(groupId);
        for (RemoteProcessGroupEntity remoteProcessGroupEntity : remoteProcessGroups) {
            if (remoteProcessGroupEntity.getComponent() == null) continue;
            remoteProcessGroupEntity.getComponent().setContents(null);
        }
        RemoteProcessGroupsEntity entity = new RemoteProcessGroupsEntity();
        entity.setRemoteProcessGroups(this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntitiesContent(remoteProcessGroups));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/connections")
    @ApiOperation(value="Creates a connection", response=ConnectionEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Write Source - /{component-type}/{uuid}"), @Authorization(value="Write Destination - /{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createConnection(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The connection configuration details.", required=true) ConnectionEntity requestConnectionEntity) {
        ConnectableType destinationConnectableType;
        ConnectableType sourceConnectableType;
        if (requestConnectionEntity == null || requestConnectionEntity.getComponent() == null) {
            throw new IllegalArgumentException("Connection details must be specified.");
        }
        if (requestConnectionEntity.getRevision() == null || requestConnectionEntity.getRevision().getVersion() == null || requestConnectionEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Connection.");
        }
        if (requestConnectionEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Connection ID cannot be specified.");
        }
        List proposedBends = requestConnectionEntity.getComponent().getBends();
        if (proposedBends != null) {
            for (PositionDTO proposedBend : proposedBends) {
                if (proposedBend.getX() != null && proposedBend.getY() != null) continue;
                throw new IllegalArgumentException("The x and y coordinate of the each bend must be specified.");
            }
        }
        if (requestConnectionEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestConnectionEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestConnectionEntity.getComponent().getParentGroupId(), groupId));
        }
        requestConnectionEntity.getComponent().setParentGroupId(groupId);
        ConnectionDTO requestConnection = requestConnectionEntity.getComponent();
        if (requestConnection.getSource() == null || requestConnection.getSource().getId() == null) {
            throw new IllegalArgumentException("The source of the connection must be specified.");
        }
        if (requestConnection.getSource().getType() == null) {
            throw new IllegalArgumentException("The type of the source of the connection must be specified.");
        }
        try {
            sourceConnectableType = ConnectableType.valueOf((String)requestConnection.getSource().getType());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unrecognized source type %s. Expected values are [%s]", requestConnection.getSource().getType(), StringUtils.join((Object[])ConnectableType.values(), (String)", ")));
        }
        if (requestConnection.getDestination() == null || requestConnection.getDestination().getId() == null) {
            throw new IllegalArgumentException("The destination of the connection must be specified.");
        }
        if (requestConnection.getDestination().getType() == null) {
            throw new IllegalArgumentException("The type of the destination of the connection must be specified.");
        }
        try {
            destinationConnectableType = ConnectableType.valueOf((String)requestConnection.getDestination().getType());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unrecognized destination type %s. Expected values are [%s]", requestConnection.getDestination().getType(), StringUtils.join((Object[])ConnectableType.values(), (String)", ")));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestConnectionEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestConnectionEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            Authorizable source = ConnectableType.REMOTE_OUTPUT_PORT.equals((Object)sourceConnectableType) ? lookup.getRemoteProcessGroup(requestConnection.getSource().getGroupId()) : lookup.getLocalConnectable(requestConnection.getSource().getId());
            if (source == null) {
                throw new ResourceNotFoundException("Cannot find source component with ID [" + requestConnection.getSource().getId() + "]");
            }
            source.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            Authorizable destination = ConnectableType.REMOTE_INPUT_PORT.equals((Object)destinationConnectableType) ? lookup.getRemoteProcessGroup(requestConnection.getDestination().getGroupId()) : lookup.getLocalConnectable(requestConnection.getDestination().getId());
            if (destination == null) {
                throw new ResourceNotFoundException("Cannot find destination component with ID [" + requestConnection.getDestination().getId() + "]");
            }
            destination.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCreateConnection(groupId, requestConnection), connectionEntity -> {
            ConnectionDTO connection = connectionEntity.getComponent();
            connection.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)connectionEntity, connection.getId());
            ConnectionEntity entity = this.serviceFacade.createConnection(revision, groupId, connection);
            this.connectionResource.populateRemainingConnectionEntityContent(entity);
            String uri = entity.getUri();
            return this.generateCreatedResponse(URI.create(uri), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/connections")
    @ApiOperation(value="Gets all connections", response=ConnectionsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getConnections(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set connections = this.serviceFacade.getConnections(groupId);
        ConnectionsEntity entity = new ConnectionsEntity();
        entity.setConnections(this.connectionResource.populateRemainingConnectionEntitiesContent(connections));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/snippet-instance")
    @ApiOperation(value="Copies a snippet and discards it.", response=FlowEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - /{component-type}/{uuid} - For each component in the snippet and their descendant components"), @Authorization(value="Write - if the snippet contains any restricted Processors - /restricted-components")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response copySnippet(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The copy snippet request.", required=true) CopySnippetRequestEntity requestCopySnippetEntity) {
        if (requestCopySnippetEntity == null || requestCopySnippetEntity.getOriginX() == null || requestCopySnippetEntity.getOriginY() == null) {
            throw new IllegalArgumentException("The  origin position (x, y) must be specified");
        }
        if (requestCopySnippetEntity.getSnippetId() == null) {
            throw new IllegalArgumentException("The snippet id must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestCopySnippetEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestCopySnippetEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestCopySnippetEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            SnippetAuthorizable snippet = this.authorizeSnippetUsage(lookup, groupId, requestCopySnippetEntity.getSnippetId(), false);
            Consumer<ComponentAuthorizable> authorizeRestricted = authorizable -> {
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
            };
            snippet.getSelectedProcessors().stream().forEach(authorizeRestricted);
            snippet.getSelectedProcessGroups().stream().forEach(processGroup -> processGroup.getEncapsulatedProcessors().forEach(authorizeRestricted));
        }, null, copySnippetRequestEntity -> {
            FlowEntity flowEntity = this.serviceFacade.copySnippet(groupId, copySnippetRequestEntity.getSnippetId(), copySnippetRequestEntity.getOriginX(), copySnippetRequestEntity.getOriginY(), (String)this.getIdGenerationSeed().orElse(null));
            FlowDTO flow = flowEntity.getFlow();
            for (ProcessGroupEntity childGroupEntity : flow.getProcessGroups()) {
                childGroupEntity.getComponent().setContents(null);
            }
            this.populateRemainingSnippetContent(flow);
            return this.generateCreatedResponse(this.getAbsolutePath(), (Object)flowEntity).build();
        });
    }

    private void discoverCompatibleBundles(FlowSnippetDTO snippet) {
        if (snippet.getProcessors() != null) {
            snippet.getProcessors().forEach(processor -> {
                BundleCoordinate coordinate = this.serviceFacade.getCompatibleBundle(processor.getType(), processor.getBundle());
                processor.setBundle(new BundleDTO(coordinate.getGroup(), coordinate.getId(), coordinate.getVersion()));
            });
        }
        if (snippet.getControllerServices() != null) {
            snippet.getControllerServices().forEach(controllerService -> {
                BundleCoordinate coordinate = this.serviceFacade.getCompatibleBundle(controllerService.getType(), controllerService.getBundle());
                controllerService.setBundle(new BundleDTO(coordinate.getGroup(), coordinate.getId(), coordinate.getVersion()));
            });
        }
        if (snippet.getProcessGroups() != null) {
            snippet.getProcessGroups().forEach(processGroup -> this.discoverCompatibleBundles(processGroup.getContents()));
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/template-instance")
    @ApiOperation(value="Instantiates a template", response=FlowEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - /templates/{uuid}"), @Authorization(value="Write - if the template contains any restricted components - /restricted-components")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response instantiateTemplate(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The instantiate template request.", required=true) InstantiateTemplateRequestEntity requestInstantiateTemplateRequestEntity) {
        if (requestInstantiateTemplateRequestEntity == null || requestInstantiateTemplateRequestEntity.getOriginX() == null || requestInstantiateTemplateRequestEntity.getOriginY() == null) {
            throw new IllegalArgumentException("The origin position (x, y) must be specified.");
        }
        if (requestInstantiateTemplateRequestEntity.getTemplateId() == null) {
            throw new IllegalArgumentException("The template id must be specified.");
        }
        if (requestInstantiateTemplateRequestEntity.getEncodingVersion() != null) {
            try {
                FlowEncodingVersion.parse((String)requestInstantiateTemplateRequestEntity.getEncodingVersion());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The template encoding version is not valid. The expected format is <number>.<number>");
            }
        }
        if (requestInstantiateTemplateRequestEntity.getEncodingVersion() == null) {
            requestInstantiateTemplateRequestEntity.setEncodingVersion("1.2");
        }
        if (requestInstantiateTemplateRequestEntity.getSnippet() == null) {
            TemplateDTO requestedTemplate = this.serviceFacade.exportTemplate(requestInstantiateTemplateRequestEntity.getTemplateId());
            FlowSnippetDTO requestTemplateContents = requestedTemplate.getSnippet();
            this.discoverCompatibleBundles(requestTemplateContents);
            requestInstantiateTemplateRequestEntity.setEncodingVersion(requestedTemplate.getEncodingVersion());
            requestInstantiateTemplateRequestEntity.setSnippet(requestTemplateContents);
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestInstantiateTemplateRequestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestInstantiateTemplateRequestEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestInstantiateTemplateRequestEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
            Authorizable template = lookup.getTemplate(requestInstantiateTemplateRequestEntity.getTemplateId());
            template.authorize(this.authorizer, RequestAction.READ, user);
            TemplateContentsAuthorizable templateContents = lookup.getTemplateContents(requestInstantiateTemplateRequestEntity.getSnippet());
            Consumer<ComponentAuthorizable> authorizeRestricted = authorizable -> {
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
            };
            templateContents.getEncapsulatedProcessors().forEach(authorizeRestricted);
            templateContents.getEncapsulatedControllerServices().forEach(authorizeRestricted);
        }, () -> this.serviceFacade.verifyComponentTypes(requestInstantiateTemplateRequestEntity.getSnippet()), instantiateTemplateRequestEntity -> {
            FlowEntity entity = this.serviceFacade.createTemplateInstance(groupId, instantiateTemplateRequestEntity.getOriginX(), instantiateTemplateRequestEntity.getOriginY(), instantiateTemplateRequestEntity.getEncodingVersion(), instantiateTemplateRequestEntity.getSnippet(), (String)this.getIdGenerationSeed().orElse(null));
            FlowDTO flowSnippet = entity.getFlow();
            for (ProcessGroupEntity childGroupEntity : flowSnippet.getProcessGroups()) {
                childGroupEntity.getComponent().setContents(null);
            }
            this.populateRemainingSnippetContent(flowSnippet);
            return this.generateCreatedResponse(this.getAbsolutePath(), (Object)entity).build();
        });
    }

    private SnippetAuthorizable authorizeSnippetUsage(AuthorizableLookup lookup, String groupId, String snippetId, boolean authorizeTransitiveServices) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        lookup.getProcessGroup(groupId).getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, user);
        SnippetAuthorizable snippet = lookup.getSnippet(snippetId);
        this.authorizeSnippet(snippet, this.authorizer, lookup, RequestAction.READ, true, authorizeTransitiveServices);
        return snippet;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/templates")
    @ApiOperation(value="Creates a template and discards the specified snippet.", response=TemplateEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - /{component-type}/{uuid} - For each component in the snippet and their descendant components")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createTemplate(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The create template request.", required=true) CreateTemplateRequestEntity requestCreateTemplateRequestEntity) {
        if (requestCreateTemplateRequestEntity.getSnippetId() == null) {
            throw new IllegalArgumentException("The snippet identifier must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestCreateTemplateRequestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestCreateTemplateRequestEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestCreateTemplateRequestEntity, lookup -> this.authorizeSnippetUsage(lookup, groupId, requestCreateTemplateRequestEntity.getSnippetId(), true), () -> this.serviceFacade.verifyCanAddTemplate(groupId, requestCreateTemplateRequestEntity.getName()), createTemplateRequestEntity -> {
            TemplateDTO template = this.serviceFacade.createTemplate(createTemplateRequestEntity.getName(), createTemplateRequestEntity.getDescription(), createTemplateRequestEntity.getSnippetId(), groupId, this.getIdGenerationSeed());
            this.templateResource.populateRemainingTemplateContent(template);
            TemplateEntity entity = new TemplateEntity();
            entity.setTemplate(template);
            return this.generateCreatedResponse(URI.create(template.getUri()), (Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/xml"})
    @Path(value="{id}/templates/upload")
    @ApiOperation(value="Uploads a template", response=TemplateEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="template", value="The binary content of the template file being uploaded.", required=true, type="file", paramType="formData")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response uploadTemplate(@Context HttpServletRequest httpServletRequest, @Context UriInfo uriInfo, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @FormDataParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @FormDataParam(value="template") InputStream in) throws InterruptedException {
        TemplateDTO template;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TemplateDTO.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            XMLStreamReader xsr = XmlUtils.createSafeReader((InputStream)in);
            JAXBElement templateElement = unmarshaller.unmarshal(xsr, TemplateDTO.class);
            template = (TemplateDTO)templateElement.getValue();
        }
        catch (JAXBException jaxbe) {
            logger.warn("An error occurred while parsing a template.", (Throwable)jaxbe);
            String responseXml = String.format("<errorResponse status=\"%s\" statusText=\"The specified template is not in a valid format.\"/>", Response.Status.BAD_REQUEST.getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseXml).type("application/xml").build();
        }
        catch (IllegalArgumentException iae) {
            logger.warn("Unable to import template.", (Throwable)iae);
            String responseXml = String.format("<errorResponse status=\"%s\" statusText=\"%s\"/>", Response.Status.BAD_REQUEST.getStatusCode(), iae.getMessage());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseXml).type("application/xml").build();
        }
        catch (Exception e) {
            logger.warn("An error occurred while importing a template.", (Throwable)e);
            String responseXml = String.format("<errorResponse status=\"%s\" statusText=\"Unable to import the specified template: %s\"/>", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseXml).type("application/xml").build();
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        TemplateEntity entity = new TemplateEntity();
        entity.setTemplate(template);
        entity.setDisconnectedNodeAcknowledged(disconnectedNodeAcknowledged);
        if (this.isReplicateRequest()) {
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.segment(new String[]{"process-groups", groupId, "templates", "import"});
            URI importUri = uriBuilder.build(new Object[0]);
            HashMap<String, String> headersToOverride = new HashMap<String, String>();
            headersToOverride.put("content-type", "application/xml");
            if (this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES) {
                return this.getRequestReplicator().replicate("POST", importUri, (Object)entity, this.getHeaders(headersToOverride)).awaitMergedResponse().getResponse();
            }
            return this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "POST", importUri, (Object)entity, this.getHeaders(headersToOverride)).awaitMergedResponse().getResponse();
        }
        return this.importTemplate(httpServletRequest, groupId, entity);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="{id}/templates/import")
    @ApiOperation(value="Imports a template", response=TemplateEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response importTemplate(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, TemplateEntity requestTemplateEntity) {
        if (requestTemplateEntity == null || requestTemplateEntity.getTemplate() == null || requestTemplateEntity.getTemplate().getSnippet() == null) {
            throw new IllegalArgumentException("Template details must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestTemplateEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestTemplateEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestTemplateEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanAddTemplate(groupId, requestTemplateEntity.getTemplate().getName()), templateEntity -> {
            try {
                TemplateDTO template = this.serviceFacade.importTemplate(templateEntity.getTemplate(), groupId, this.getIdGenerationSeed());
                this.templateResource.populateRemainingTemplateContent(template);
                TemplateEntity entity = new TemplateEntity();
                entity.setTemplate(template);
                return this.generateCreatedResponse(URI.create(template.getUri()), (Object)entity).build();
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                logger.info("Unable to import template: " + e);
                String responseXml = String.format("<errorResponse status=\"%s\" statusText=\"%s\"/>", Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)responseXml).type("application/xml").build();
            }
            catch (Exception e) {
                logger.warn("An error occurred while importing a template.", (Throwable)e);
                String responseXml = String.format("<errorResponse status=\"%s\" statusText=\"Unable to import the specified template: %s\"/>", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)responseXml).type("application/xml").build();
            }
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/controller-services")
    @ApiOperation(value="Creates a new controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}"), @Authorization(value="Write - if the Controller Service is restricted - /restricted-components")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createControllerService(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The controller service configuration details.", required=true) ControllerServiceEntity requestControllerServiceEntity) {
        if (requestControllerServiceEntity == null || requestControllerServiceEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller service details must be specified.");
        }
        if (requestControllerServiceEntity.getRevision() == null || requestControllerServiceEntity.getRevision().getVersion() == null || requestControllerServiceEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Controller service.");
        }
        ControllerServiceDTO requestControllerService = requestControllerServiceEntity.getComponent();
        if (requestControllerService.getId() != null) {
            throw new IllegalArgumentException("Controller service ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestControllerService.getType())) {
            throw new IllegalArgumentException("The type of controller service to create must be specified.");
        }
        if (requestControllerService.getParentGroupId() != null && !groupId.equals(requestControllerService.getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestControllerService.getParentGroupId(), groupId));
        }
        requestControllerService.setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestControllerServiceEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestControllerServiceEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
            ComponentAuthorizable authorizable = null;
            try {
                authorizable = lookup.getConfigurableComponent(requestControllerService.getType(), requestControllerService.getBundle());
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
                if (requestControllerService.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestControllerService.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateControllerService(requestControllerService), controllerServiceEntity -> {
            ControllerServiceDTO controllerService = controllerServiceEntity.getComponent();
            controllerService.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)controllerServiceEntity, controllerService.getId());
            ControllerServiceEntity entity = this.serviceFacade.createControllerService(revision, groupId, controllerService);
            this.controllerServiceResource.populateRemainingControllerServiceEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setProcessorResource(ProcessorResource processorResource) {
        this.processorResource = processorResource;
    }

    public void setInputPortResource(InputPortResource inputPortResource) {
        this.inputPortResource = inputPortResource;
    }

    public void setOutputPortResource(OutputPortResource outputPortResource) {
        this.outputPortResource = outputPortResource;
    }

    public void setFunnelResource(FunnelResource funnelResource) {
        this.funnelResource = funnelResource;
    }

    public void setLabelResource(LabelResource labelResource) {
        this.labelResource = labelResource;
    }

    public void setRemoteProcessGroupResource(RemoteProcessGroupResource remoteProcessGroupResource) {
        this.remoteProcessGroupResource = remoteProcessGroupResource;
    }

    public void setConnectionResource(ConnectionResource connectionResource) {
        this.connectionResource = connectionResource;
    }

    public void setTemplateResource(TemplateResource templateResource) {
        this.templateResource = templateResource;
    }

    public void setControllerServiceResource(ControllerServiceResource controllerServiceResource) {
        this.controllerServiceResource = controllerServiceResource;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }

    static /* synthetic */ void access$000(ProcessGroupResource x0, String x1, VariableRegistryUpdateRequest x2, VariableRegistryUpdateStep x3, String x4, Runnable x5) {
        x0.performUpdateVariableRegistryStep(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ Map access$100(ProcessGroupResource x0, String x1, Set x2) {
        return x0.getRevisions(x1, x2);
    }

    static /* synthetic */ Logger access$200() {
        return logger;
    }

    static /* synthetic */ void access$300(ProcessGroupResource x0, VariableRegistryUpdateRequest x1, String x2, Map x3, Pause x4) {
        x0.startProcessors(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$400(ProcessGroupResource x0, VariableRegistryUpdateRequest x1, String x2, Map x3, Pause x4) {
        x0.enableControllerServices(x1, x2, x3, x4);
    }

    static /* synthetic */ NiFiServiceFacade access$500(ProcessGroupResource x0) {
        return x0.serviceFacade;
    }

    static /* synthetic */ void access$600(ProcessGroupResource x0, VariableRegistryUpdateRequest x1, String x2, Map x3, Pause x4) {
        x0.disableControllerServices(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$700(ProcessGroupResource x0, VariableRegistryUpdateRequest x1, String x2, Map x3, Pause x4) {
        x0.stopProcessors(x1, x2, x3, x4);
    }
}

