/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.registry.flow.FlowRegistry;
import org.apache.nifi.registry.flow.StandardVersionControlInformation;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.VariableRegistryDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.VariableEntity;
import org.apache.nifi.web.dao.ProcessGroupDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.apache.nifi.web.dao.impl.StandardProcessGroupDAO;

public class StandardProcessGroupDAO
extends ComponentDAO
implements ProcessGroupDAO {
    private FlowController flowController;

    public ProcessGroup createProcessGroup(String parentGroupId, ProcessGroupDTO processGroup) {
        if (processGroup.getParentGroupId() != null && !this.flowController.areGroupsSame(processGroup.getParentGroupId(), parentGroupId)) {
            throw new IllegalArgumentException("Cannot specify a different Parent Group ID than the Group to which the Process Group is being added.");
        }
        ProcessGroup parentGroup = this.locateProcessGroup(this.flowController, parentGroupId);
        ProcessGroup group = this.flowController.createProcessGroup(processGroup.getId());
        if (processGroup.getName() != null) {
            group.setName(processGroup.getName());
        }
        if (processGroup.getPosition() != null) {
            group.setPosition(new Position(processGroup.getPosition().getX().doubleValue(), processGroup.getPosition().getY().doubleValue()));
        }
        group.setParent(parentGroup);
        parentGroup.addProcessGroup(group);
        return group;
    }

    public boolean hasProcessGroup(String groupId) {
        return this.flowController.getGroup(groupId) != null;
    }

    public void verifyUpdate(ProcessGroupDTO processGroup) {
    }

    public ProcessGroup getProcessGroup(String groupId) {
        return this.locateProcessGroup(this.flowController, groupId);
    }

    public Set<ProcessGroup> getProcessGroups(String parentGroupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, parentGroupId);
        return group.getProcessGroups();
    }

    public void verifyScheduleComponents(String groupId, ScheduledState state, Set<String> componentIds) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        for (String componentId : componentIds) {
            Connectable connectable = group.findLocalConnectable(componentId);
            if (connectable == null) {
                RemoteGroupPort remotePort = group.findRemoteGroupPort(componentId);
                if (remotePort == null) {
                    throw new ResourceNotFoundException("Unable to find component with id " + componentId);
                }
                if (ScheduledState.RUNNING.equals((Object)state)) {
                    remotePort.verifyCanStart();
                    continue;
                }
                remotePort.verifyCanStop();
                continue;
            }
            if (ScheduledState.RUNNING.equals((Object)state)) {
                group.verifyCanStart(connectable);
                continue;
            }
            group.verifyCanStop(connectable);
        }
    }

    public void verifyEnableComponents(String groupId, ScheduledState state, Set<String> componentIds) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        for (String componentId : componentIds) {
            Connectable connectable = group.findLocalConnectable(componentId);
            if (ScheduledState.STOPPED.equals((Object)state)) {
                connectable.verifyCanEnable();
                continue;
            }
            if (!ScheduledState.DISABLED.equals((Object)state)) continue;
            connectable.verifyCanDisable();
        }
    }

    public void verifyActivateControllerServices(ControllerServiceState state, Collection<String> serviceIds) {
        Set serviceNodes = serviceIds.stream().map(arg_0 -> ((FlowController)this.flowController).getControllerServiceNode(arg_0)).collect(Collectors.toSet());
        for (ControllerServiceNode serviceNode : serviceNodes) {
            if (state == ControllerServiceState.ENABLED) {
                serviceNode.verifyCanEnable(serviceNodes);
                continue;
            }
            serviceNode.verifyCanDisable(serviceNodes);
        }
    }

    public Future<Void> scheduleComponents(String groupId, ScheduledState state, Set<String> componentIds) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        for (String componentId : componentIds) {
            RemoteGroupPort remotePort;
            CompletableFuture processorFuture;
            Connectable connectable = group.findLocalConnectable(componentId);
            if (ScheduledState.RUNNING.equals((Object)state)) {
                switch (1.$SwitchMap$org$apache$nifi$connectable$ConnectableType[connectable.getConnectableType().ordinal()]) {
                    case 1: {
                        processorFuture = connectable.getProcessGroup().startProcessor((ProcessorNode)connectable, true);
                        future = CompletableFuture.allOf(future, processorFuture);
                        break;
                    }
                    case 2: {
                        connectable.getProcessGroup().startInputPort((Port)connectable);
                        break;
                    }
                    case 3: {
                        connectable.getProcessGroup().startOutputPort((Port)connectable);
                        break;
                    }
                    case 4: 
                    case 5: {
                        remotePort = group.findRemoteGroupPort(componentId);
                        remotePort.getRemoteProcessGroup().startTransmitting(remotePort);
                    }
                }
                continue;
            }
            if (!ScheduledState.STOPPED.equals((Object)state)) continue;
            switch (1.$SwitchMap$org$apache$nifi$connectable$ConnectableType[connectable.getConnectableType().ordinal()]) {
                case 1: {
                    processorFuture = connectable.getProcessGroup().stopProcessor((ProcessorNode)connectable);
                    future = CompletableFuture.allOf(future, processorFuture);
                    break;
                }
                case 2: {
                    connectable.getProcessGroup().stopInputPort((Port)connectable);
                    break;
                }
                case 3: {
                    connectable.getProcessGroup().stopOutputPort((Port)connectable);
                    break;
                }
                case 4: 
                case 5: {
                    remotePort = group.findRemoteGroupPort(componentId);
                    remotePort.getRemoteProcessGroup().stopTransmitting(remotePort);
                }
            }
        }
        return future;
    }

    public void enableComponents(String groupId, ScheduledState state, Set<String> componentIds) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        for (String componentId : componentIds) {
            Connectable connectable = group.findLocalConnectable(componentId);
            if (ScheduledState.STOPPED.equals((Object)state)) {
                switch (1.$SwitchMap$org$apache$nifi$connectable$ConnectableType[connectable.getConnectableType().ordinal()]) {
                    case 1: {
                        connectable.getProcessGroup().enableProcessor((ProcessorNode)connectable);
                        break;
                    }
                    case 2: {
                        connectable.getProcessGroup().enableInputPort((Port)connectable);
                        break;
                    }
                    case 3: {
                        connectable.getProcessGroup().enableOutputPort((Port)connectable);
                    }
                }
                continue;
            }
            if (!ScheduledState.DISABLED.equals((Object)state)) continue;
            switch (1.$SwitchMap$org$apache$nifi$connectable$ConnectableType[connectable.getConnectableType().ordinal()]) {
                case 1: {
                    connectable.getProcessGroup().disableProcessor((ProcessorNode)connectable);
                    break;
                }
                case 2: {
                    connectable.getProcessGroup().disableInputPort((Port)connectable);
                    break;
                }
                case 3: {
                    connectable.getProcessGroup().disableOutputPort((Port)connectable);
                }
            }
        }
    }

    public Future<Void> activateControllerServices(String groupId, ControllerServiceState state, Collection<String> serviceIds) {
        List serviceNodes = serviceIds.stream().map(arg_0 -> ((FlowController)this.flowController).getControllerServiceNode(arg_0)).collect(Collectors.toList());
        if (state == ControllerServiceState.ENABLED) {
            return this.flowController.enableControllerServicesAsync(serviceNodes);
        }
        return this.flowController.disableControllerServicesAsync(serviceNodes);
    }

    public ProcessGroup updateProcessGroup(ProcessGroupDTO processGroupDTO) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, processGroupDTO.getId());
        String name = processGroupDTO.getName();
        String comments = processGroupDTO.getComments();
        if (this.isNotNull((Object)name)) {
            group.setName(name);
        }
        if (this.isNotNull((Object)processGroupDTO.getPosition())) {
            group.setPosition(new Position(processGroupDTO.getPosition().getX().doubleValue(), processGroupDTO.getPosition().getY().doubleValue()));
            ProcessGroup parent = group.getParent();
            if (parent != null) {
                parent.onComponentModified();
            }
        }
        if (this.isNotNull((Object)comments)) {
            group.setComments(comments);
        }
        group.onComponentModified();
        return group;
    }

    public ProcessGroup updateVersionControlInformation(VersionControlInformationDTO versionControlInformation, Map<String, String> versionedComponentMapping) {
        String groupId = versionControlInformation.getGroupId();
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        String registryId = versionControlInformation.getRegistryId();
        FlowRegistry flowRegistry = this.flowController.getFlowRegistryClient().getFlowRegistry(registryId);
        String registryName = flowRegistry == null ? registryId : flowRegistry.getName();
        NiFiRegistryFlowMapper mapper = new NiFiRegistryFlowMapper();
        InstantiatedVersionedProcessGroup flowSnapshot = mapper.mapProcessGroup(group, (ControllerServiceProvider)this.flowController, this.flowController.getFlowRegistryClient(), false);
        StandardVersionControlInformation vci = StandardVersionControlInformation.Builder.fromDto((VersionControlInformationDTO)versionControlInformation).registryName(registryName).flowSnapshot((VersionedProcessGroup)flowSnapshot).build();
        group.setVersionControlInformation((VersionControlInformation)vci, versionedComponentMapping);
        group.onComponentModified();
        return group;
    }

    public ProcessGroup disconnectVersionControl(String groupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        group.disconnectVersionControl(true);
        group.onComponentModified();
        return group;
    }

    public ProcessGroup updateProcessGroupFlow(String groupId, VersionedFlowSnapshot proposedSnapshot, VersionControlInformationDTO versionControlInformation, String componentIdSeed, boolean verifyNotModified, boolean updateSettings, boolean updateDescendantVersionedFlows) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        group.updateFlow(proposedSnapshot, componentIdSeed, verifyNotModified, updateSettings, updateDescendantVersionedFlows);
        group.findAllRemoteProcessGroups().stream().forEach(RemoteProcessGroup::initialize);
        StandardVersionControlInformation svci = StandardVersionControlInformation.Builder.fromDto((VersionControlInformationDTO)versionControlInformation).flowSnapshot(proposedSnapshot.getFlowContents()).build();
        group.setVersionControlInformation((VersionControlInformation)svci, Collections.emptyMap());
        group.onComponentModified();
        return group;
    }

    public ProcessGroup updateVariableRegistry(VariableRegistryDTO variableRegistry) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, variableRegistry.getProcessGroupId());
        if (group == null) {
            throw new ResourceNotFoundException("Could not find Process Group with ID " + variableRegistry.getProcessGroupId());
        }
        HashMap variableMap = new HashMap();
        variableRegistry.getVariables().stream().map(VariableEntity::getVariable).forEach(var -> variableMap.put(var.getName(), var.getValue()));
        group.setVariables(variableMap);
        group.onComponentModified();
        return group;
    }

    public void verifyDelete(String groupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        group.verifyCanDelete();
    }

    public void verifyDeleteFlowRegistry(String registryId) {
        ProcessGroup rootGroup = this.flowController.getRootGroup();
        VersionControlInformation versionControlInformation = rootGroup.getVersionControlInformation();
        if (versionControlInformation != null && versionControlInformation.getRegistryIdentifier().equals(registryId)) {
            throw new IllegalStateException("The Registry cannot be removed because a Process Group currently under version control is tracking to it.");
        }
        Set trackedVersionControlInformation = rootGroup.findAllProcessGroups().stream().map(group -> group.getVersionControlInformation()).filter(Objects::nonNull).filter(vci -> vci.getRegistryIdentifier().equals(registryId)).collect(Collectors.toSet());
        if (!trackedVersionControlInformation.isEmpty()) {
            throw new IllegalStateException("The Registry cannot be removed because a Process Group currently under version control is tracking to it.");
        }
    }

    public void deleteProcessGroup(String processGroupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, processGroupId);
        ProcessGroup parentGroup = group.getParent();
        if (parentGroup == null) {
            throw new IllegalArgumentException("The Root Group cannot be removed");
        }
        parentGroup.removeProcessGroup(group);
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

