/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.registry.flow.Bundle;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.util.Tuple;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.api.dto.BundleDTO;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowRegistryUtils {
    public static Set<ConfigurableComponent> getRestrictedComponents(VersionedProcessGroup group) {
        HashSet<ConfigurableComponent> restrictedComponents = new HashSet<ConfigurableComponent>();
        HashSet componentTypes = new HashSet();
        FlowRegistryUtils.populateComponentTypes((VersionedProcessGroup)group, componentTypes);
        for (Tuple tuple : componentTypes) {
            ConfigurableComponent component = ExtensionManager.getTempComponent((String)((String)tuple.getKey()), (BundleCoordinate)((BundleCoordinate)tuple.getValue()));
            if (component == null) {
                throw new NiFiCoreException("Could not create an instance of component " + (String)tuple.getKey() + " using bundle coordinates " + tuple.getValue());
            }
            boolean isRestricted = component.getClass().isAnnotationPresent(Restricted.class);
            if (!isRestricted) continue;
            restrictedComponents.add(component);
        }
        return restrictedComponents;
    }

    private static void populateComponentTypes(VersionedProcessGroup group, Set<Tuple<String, BundleCoordinate>> componentTypes) {
        group.getProcessors().stream().map(versionedProc -> new Tuple((Object)versionedProc.getType(), (Object)FlowRegistryUtils.createBundleCoordinate((Bundle)versionedProc.getBundle()))).forEach(componentTypes::add);
        group.getControllerServices().stream().map(versionedSvc -> new Tuple((Object)versionedSvc.getType(), (Object)FlowRegistryUtils.createBundleCoordinate((Bundle)versionedSvc.getBundle()))).forEach(componentTypes::add);
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            FlowRegistryUtils.populateComponentTypes((VersionedProcessGroup)childGroup, componentTypes);
        }
    }

    public static BundleCoordinate createBundleCoordinate(Bundle bundle) {
        return new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
    }

    public static BundleDTO createBundleDto(Bundle bundle) {
        return new BundleDTO(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
    }
}

