/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangePurgeDetails;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.AuthorizeAccess;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserContextKeys;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.EnforcePolicyPermissionsThroughBaseResource;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.heartbeat.HeartbeatMonitor;
import org.apache.nifi.cluster.coordination.heartbeat.NodeHeartbeat;
import org.apache.nifi.cluster.coordination.node.ClusterRoles;
import org.apache.nifi.cluster.coordination.node.DisconnectionCode;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.manager.exception.IllegalNodeDeletionException;
import org.apache.nifi.cluster.manager.exception.UnknownNodeException;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.Counter;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.repository.claim.ContentDirection;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.ProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.history.History;
import org.apache.nifi.history.HistoryQuery;
import org.apache.nifi.history.PreviousValue;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinQuery;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.FlowModification;
import org.apache.nifi.web.InvalidRevisionException;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.StandardNiFiServiceFacade;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.dto.AccessPolicySummaryDTO;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.BulletinBoardDTO;
import org.apache.nifi.web.api.dto.BulletinDTO;
import org.apache.nifi.web.api.dto.BulletinQueryDTO;
import org.apache.nifi.web.api.dto.ClusterDTO;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.ComponentHistoryDTO;
import org.apache.nifi.web.api.dto.ComponentReferenceDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerConfigurationDTO;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.ControllerServiceReferencingComponentDTO;
import org.apache.nifi.web.api.dto.CounterDTO;
import org.apache.nifi.web.api.dto.CountersDTO;
import org.apache.nifi.web.api.dto.CountersSnapshotDTO;
import org.apache.nifi.web.api.dto.DocumentedTypeDTO;
import org.apache.nifi.web.api.dto.DropRequestDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.EntityFactory;
import org.apache.nifi.web.api.dto.FlowConfigurationDTO;
import org.apache.nifi.web.api.dto.FlowFileDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.ListingRequestDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.PermissionsDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PreviousValueDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.PropertyHistoryDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.ResourceDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.SnippetDTO;
import org.apache.nifi.web.api.dto.SystemDiagnosticsDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.dto.VariableRegistryDTO;
import org.apache.nifi.web.api.dto.action.HistoryDTO;
import org.apache.nifi.web.api.dto.action.HistoryQueryDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceEventDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceOptionsDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageDTO;
import org.apache.nifi.web.api.dto.search.SearchResultsDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusDTO;
import org.apache.nifi.web.api.dto.status.ControllerStatusDTO;
import org.apache.nifi.web.api.dto.status.NodeProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.PortStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.nifi.web.api.entity.AccessPolicyEntity;
import org.apache.nifi.web.api.entity.AccessPolicySummaryEntity;
import org.apache.nifi.web.api.entity.ActionEntity;
import org.apache.nifi.web.api.entity.ActivateControllerServicesEntity;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ComponentReferenceEntity;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.ConnectionStatusEntity;
import org.apache.nifi.web.api.entity.ControllerBulletinsEntity;
import org.apache.nifi.web.api.entity.ControllerConfigurationEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentsEntity;
import org.apache.nifi.web.api.entity.CurrentUserEntity;
import org.apache.nifi.web.api.entity.FlowConfigurationEntity;
import org.apache.nifi.web.api.entity.FlowEntity;
import org.apache.nifi.web.api.entity.FunnelEntity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.PortStatusEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupPortEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;
import org.apache.nifi.web.api.entity.SnippetEntity;
import org.apache.nifi.web.api.entity.StatusHistoryEntity;
import org.apache.nifi.web.api.entity.TemplateEntity;
import org.apache.nifi.web.api.entity.TenantEntity;
import org.apache.nifi.web.api.entity.UserEntity;
import org.apache.nifi.web.api.entity.UserGroupEntity;
import org.apache.nifi.web.api.entity.VariableEntity;
import org.apache.nifi.web.api.entity.VariableRegistryEntity;
import org.apache.nifi.web.controller.ControllerFacade;
import org.apache.nifi.web.dao.AccessPolicyDAO;
import org.apache.nifi.web.dao.ConnectionDAO;
import org.apache.nifi.web.dao.ControllerServiceDAO;
import org.apache.nifi.web.dao.FunnelDAO;
import org.apache.nifi.web.dao.LabelDAO;
import org.apache.nifi.web.dao.PortDAO;
import org.apache.nifi.web.dao.ProcessGroupDAO;
import org.apache.nifi.web.dao.ProcessorDAO;
import org.apache.nifi.web.dao.RemoteProcessGroupDAO;
import org.apache.nifi.web.dao.ReportingTaskDAO;
import org.apache.nifi.web.dao.SnippetDAO;
import org.apache.nifi.web.dao.TemplateDAO;
import org.apache.nifi.web.dao.UserDAO;
import org.apache.nifi.web.dao.UserGroupDAO;
import org.apache.nifi.web.revision.DeleteRevisionTask;
import org.apache.nifi.web.revision.ExpiredRevisionClaimException;
import org.apache.nifi.web.revision.RevisionClaim;
import org.apache.nifi.web.revision.RevisionManager;
import org.apache.nifi.web.revision.RevisionUpdate;
import org.apache.nifi.web.revision.StandardRevisionClaim;
import org.apache.nifi.web.revision.StandardRevisionUpdate;
import org.apache.nifi.web.revision.UpdateRevisionTask;
import org.apache.nifi.web.util.SnippetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardNiFiServiceFacade
implements NiFiServiceFacade {
    private static final Logger logger = LoggerFactory.getLogger(StandardNiFiServiceFacade.class);
    private ControllerFacade controllerFacade;
    private SnippetUtils snippetUtils;
    private RevisionManager revisionManager;
    private BulletinRepository bulletinRepository;
    private ProcessorDAO processorDAO;
    private ProcessGroupDAO processGroupDAO;
    private RemoteProcessGroupDAO remoteProcessGroupDAO;
    private LabelDAO labelDAO;
    private FunnelDAO funnelDAO;
    private SnippetDAO snippetDAO;
    private PortDAO inputPortDAO;
    private PortDAO outputPortDAO;
    private ConnectionDAO connectionDAO;
    private ControllerServiceDAO controllerServiceDAO;
    private ReportingTaskDAO reportingTaskDAO;
    private TemplateDAO templateDAO;
    private UserDAO userDAO;
    private UserGroupDAO userGroupDAO;
    private AccessPolicyDAO accessPolicyDAO;
    private ClusterCoordinator clusterCoordinator;
    private HeartbeatMonitor heartbeatMonitor;
    private LeaderElectionManager leaderElectionManager;
    private AuditService auditService;
    private NiFiProperties properties;
    private DtoFactory dtoFactory;
    private EntityFactory entityFactory;
    private Authorizer authorizer;
    private AuthorizableLookup authorizableLookup;

    public void authorizeAccess(AuthorizeAccess authorizeAccess) {
        authorizeAccess.authorize(this.authorizableLookup);
    }

    public void verifyRevision(Revision revision, NiFiUser user) {
        Revision curRevision = this.revisionManager.getRevision(revision.getComponentId());
        if (revision.equals((Object)curRevision)) {
            return;
        }
        throw new InvalidRevisionException(revision + " is not the most up-to-date revision. This component appears to have been modified");
    }

    public void verifyRevisions(Set<Revision> revisions, NiFiUser user) {
        for (Revision revision : revisions) {
            this.verifyRevision(revision, user);
        }
    }

    public Set<Revision> getRevisionsFromGroup(String groupId, Function<ProcessGroup, Set<String>> getComponents) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(groupId);
        Set<String> componentIds = getComponents.apply(group);
        return componentIds.stream().map(id -> this.revisionManager.getRevision(id)).collect(Collectors.toSet());
    }

    public Set<Revision> getRevisionsFromSnippet(String snippetId) {
        Snippet snippet = this.snippetDAO.getSnippet(snippetId);
        HashSet componentIds = new HashSet();
        componentIds.addAll(snippet.getProcessors().keySet());
        componentIds.addAll(snippet.getFunnels().keySet());
        componentIds.addAll(snippet.getLabels().keySet());
        componentIds.addAll(snippet.getConnections().keySet());
        componentIds.addAll(snippet.getInputPorts().keySet());
        componentIds.addAll(snippet.getOutputPorts().keySet());
        componentIds.addAll(snippet.getProcessGroups().keySet());
        componentIds.addAll(snippet.getRemoteProcessGroups().keySet());
        return componentIds.stream().map(id -> this.revisionManager.getRevision(id)).collect(Collectors.toSet());
    }

    public void verifyListQueue(String connectionId) {
        this.connectionDAO.verifyList(connectionId);
    }

    public void verifyCreateConnection(String groupId, ConnectionDTO connectionDTO) {
        this.connectionDAO.verifyCreate(groupId, connectionDTO);
    }

    public void verifyUpdateConnection(ConnectionDTO connectionDTO) {
        if (this.connectionDAO.hasConnection(connectionDTO.getId())) {
            this.connectionDAO.verifyUpdate(connectionDTO);
        } else {
            this.connectionDAO.verifyCreate(connectionDTO.getParentGroupId(), connectionDTO);
        }
    }

    public void verifyDeleteConnection(String connectionId) {
        this.connectionDAO.verifyDelete(connectionId);
    }

    public void verifyDeleteFunnel(String funnelId) {
        this.funnelDAO.verifyDelete(funnelId);
    }

    public void verifyUpdateInputPort(PortDTO inputPortDTO) {
        if (this.inputPortDAO.hasPort(inputPortDTO.getId())) {
            this.inputPortDAO.verifyUpdate(inputPortDTO);
        }
    }

    public void verifyDeleteInputPort(String inputPortId) {
        this.inputPortDAO.verifyDelete(inputPortId);
    }

    public void verifyUpdateOutputPort(PortDTO outputPortDTO) {
        if (this.outputPortDAO.hasPort(outputPortDTO.getId())) {
            this.outputPortDAO.verifyUpdate(outputPortDTO);
        }
    }

    public void verifyDeleteOutputPort(String outputPortId) {
        this.outputPortDAO.verifyDelete(outputPortId);
    }

    public void verifyCreateProcessor(ProcessorDTO processorDTO) {
        this.processorDAO.verifyCreate(processorDTO);
    }

    public void verifyUpdateProcessor(ProcessorDTO processorDTO) {
        if (this.processorDAO.hasProcessor(processorDTO.getId())) {
            this.processorDAO.verifyUpdate(processorDTO);
        } else {
            this.verifyCreateProcessor(processorDTO);
        }
    }

    public void verifyDeleteProcessor(String processorId) {
        this.processorDAO.verifyDelete(processorId);
    }

    public void verifyScheduleComponents(String groupId, ScheduledState state, Set<String> componentIds) {
        this.processGroupDAO.verifyScheduleComponents(groupId, state, componentIds);
    }

    public void verifyActivateControllerServices(String groupId, ControllerServiceState state, Set<String> serviceIds) {
        this.processGroupDAO.verifyActivateControllerServices(groupId, state, serviceIds);
    }

    public void verifyDeleteProcessGroup(String groupId) {
        this.processGroupDAO.verifyDelete(groupId);
    }

    public void verifyUpdateRemoteProcessGroup(RemoteProcessGroupDTO remoteProcessGroupDTO) {
        if (this.remoteProcessGroupDAO.hasRemoteProcessGroup(remoteProcessGroupDTO.getId())) {
            this.remoteProcessGroupDAO.verifyUpdate(remoteProcessGroupDTO);
        }
    }

    public void verifyUpdateRemoteProcessGroupInputPort(String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDTO) {
        this.remoteProcessGroupDAO.verifyUpdateInputPort(remoteProcessGroupId, remoteProcessGroupPortDTO);
    }

    public void verifyUpdateRemoteProcessGroupOutputPort(String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDTO) {
        this.remoteProcessGroupDAO.verifyUpdateOutputPort(remoteProcessGroupId, remoteProcessGroupPortDTO);
    }

    public void verifyDeleteRemoteProcessGroup(String remoteProcessGroupId) {
        this.remoteProcessGroupDAO.verifyDelete(remoteProcessGroupId);
    }

    public void verifyCreateControllerService(ControllerServiceDTO controllerServiceDTO) {
        this.controllerServiceDAO.verifyCreate(controllerServiceDTO);
    }

    public void verifyUpdateControllerService(ControllerServiceDTO controllerServiceDTO) {
        if (this.controllerServiceDAO.hasControllerService(controllerServiceDTO.getId())) {
            this.controllerServiceDAO.verifyUpdate(controllerServiceDTO);
        } else {
            this.verifyCreateControllerService(controllerServiceDTO);
        }
    }

    public void verifyUpdateControllerServiceReferencingComponents(String controllerServiceId, ScheduledState scheduledState, ControllerServiceState controllerServiceState) {
        this.controllerServiceDAO.verifyUpdateReferencingComponents(controllerServiceId, scheduledState, controllerServiceState);
    }

    public void verifyDeleteControllerService(String controllerServiceId) {
        this.controllerServiceDAO.verifyDelete(controllerServiceId);
    }

    public void verifyCreateReportingTask(ReportingTaskDTO reportingTaskDTO) {
        this.reportingTaskDAO.verifyCreate(reportingTaskDTO);
    }

    public void verifyUpdateReportingTask(ReportingTaskDTO reportingTaskDTO) {
        if (this.reportingTaskDAO.hasReportingTask(reportingTaskDTO.getId())) {
            this.reportingTaskDAO.verifyUpdate(reportingTaskDTO);
        } else {
            this.verifyCreateReportingTask(reportingTaskDTO);
        }
    }

    public void verifyDeleteReportingTask(String reportingTaskId) {
        this.reportingTaskDAO.verifyDelete(reportingTaskId);
    }

    public AccessPolicyEntity updateAccessPolicy(Revision revision, AccessPolicyDTO accessPolicyDTO) {
        Authorizable authorizable = this.authorizableLookup.getAccessPolicyById(accessPolicyDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, authorizable, () -> this.accessPolicyDAO.updateAccessPolicy(accessPolicyDTO), accessPolicy -> {
            Set users = accessPolicy.getUsers().stream().map(this.mapUserIdToTenantEntity()).collect(Collectors.toSet());
            Set userGroups = accessPolicy.getGroups().stream().map(this.mapUserGroupIdToTenantEntity()).collect(Collectors.toSet());
            ComponentReferenceEntity componentReference = this.createComponentReferenceEntity(accessPolicy.getResource());
            return this.dtoFactory.createAccessPolicyDto(accessPolicy, userGroups, users, componentReference);
        });
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(authorizable);
        return this.entityFactory.createAccessPolicyEntity((AccessPolicyDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public UserEntity updateUser(Revision revision, UserDTO userDTO) {
        Authorizable usersAuthorizable = this.authorizableLookup.getTenant();
        Set groups = this.userGroupDAO.getUserGroupsForUser(userDTO.getId());
        Set policies = this.userGroupDAO.getAccessPoliciesForUser(userDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, usersAuthorizable, () -> this.userDAO.updateUser(userDTO), user -> {
            Set tenantEntities = groups.stream().map(g -> g.getIdentifier()).map(this.mapUserGroupIdToTenantEntity()).collect(Collectors.toSet());
            Set policyEntities = policies.stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
            return this.dtoFactory.createUserDto(user, tenantEntities, policyEntities);
        });
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(usersAuthorizable);
        return this.entityFactory.createUserEntity((UserDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public UserGroupEntity updateUserGroup(Revision revision, UserGroupDTO userGroupDTO) {
        Authorizable userGroupsAuthorizable = this.authorizableLookup.getTenant();
        Set policies = this.userGroupDAO.getAccessPoliciesForUserGroup(userGroupDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, userGroupsAuthorizable, () -> this.userGroupDAO.updateUserGroup(userGroupDTO), userGroup -> {
            Set tenantEntities = userGroup.getUsers().stream().map(this.mapUserIdToTenantEntity()).collect(Collectors.toSet());
            Set policyEntities = policies.stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
            return this.dtoFactory.createUserGroupDto(userGroup, tenantEntities, policyEntities);
        });
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(userGroupsAuthorizable);
        return this.entityFactory.createUserGroupEntity((UserGroupDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public ConnectionEntity updateConnection(Revision revision, ConnectionDTO connectionDTO) {
        Connection connectionNode = this.connectionDAO.getConnection(connectionDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)connectionNode, () -> this.connectionDAO.updateConnection(connectionDTO), connection -> this.dtoFactory.createConnectionDto(connection));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connectionNode);
        ConnectionStatusDTO status = this.dtoFactory.createConnectionStatusDto(this.controllerFacade.getConnectionStatus(connectionNode.getIdentifier()));
        return this.entityFactory.createConnectionEntity((ConnectionDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status);
    }

    public ProcessorEntity updateProcessor(Revision revision, ProcessorDTO processorDTO) {
        ProcessorNode processorNode = this.processorDAO.getProcessor(processorDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)processorNode, () -> this.processorDAO.updateProcessor(processorDTO), proc -> this.dtoFactory.createProcessorDto(proc));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processorNode);
        ProcessorStatusDTO status = this.dtoFactory.createProcessorStatusDto(this.controllerFacade.getProcessorStatus(processorNode.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processorNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createProcessorEntity((ProcessorDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status, bulletinEntities);
    }

    public LabelEntity updateLabel(Revision revision, LabelDTO labelDTO) {
        Label labelNode = this.labelDAO.getLabel(labelDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)labelNode, () -> this.labelDAO.updateLabel(labelDTO), label -> this.dtoFactory.createLabelDto(label));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)labelNode);
        return this.entityFactory.createLabelEntity((LabelDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public FunnelEntity updateFunnel(Revision revision, FunnelDTO funnelDTO) {
        Funnel funnelNode = this.funnelDAO.getFunnel(funnelDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)funnelNode, () -> this.funnelDAO.updateFunnel(funnelDTO), funnel -> this.dtoFactory.createFunnelDto(funnel));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)funnelNode);
        return this.entityFactory.createFunnelEntity((FunnelDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    private <D, C> RevisionUpdate<D> updateComponent(Revision revision, Authorizable authorizable, Supplier<C> daoUpdate, Function<C, D> dtoCreation) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return this.updateComponent(user, revision, authorizable, daoUpdate, dtoCreation);
    }

    private <D, C> RevisionUpdate<D> updateComponent(NiFiUser user, Revision revision, Authorizable authorizable, Supplier<C> daoUpdate, Function<C, D> dtoCreation) {
        try {
            RevisionUpdate updatedComponent = this.revisionManager.updateRevision((RevisionClaim)new StandardRevisionClaim(new Revision[]{revision}), user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
            return updatedComponent;
        }
        catch (ExpiredRevisionClaimException erce) {
            throw new InvalidRevisionException("Failed to update component " + authorizable, (Throwable)erce);
        }
    }

    public void verifyUpdateSnippet(SnippetDTO snippetDto, Set<String> affectedComponentIds) {
        if (this.snippetDAO.hasSnippet(snippetDto.getId())) {
            this.snippetDAO.verifyUpdateSnippetComponent(snippetDto);
        }
    }

    public SnippetEntity updateSnippet(Set<Revision> revisions, SnippetDTO snippetDto) {
        RevisionUpdate snapshot;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim revisionClaim = new StandardRevisionClaim(revisions);
        try {
            snapshot = this.revisionManager.updateRevision((RevisionClaim)revisionClaim, user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (ExpiredRevisionClaimException e) {
            throw new InvalidRevisionException("Failed to update Snippet", (Throwable)e);
        }
        return this.entityFactory.createSnippetEntity((SnippetDTO)snapshot.getComponent());
    }

    public PortEntity updateInputPort(Revision revision, PortDTO inputPortDTO) {
        Port inputPortNode = this.inputPortDAO.getPort(inputPortDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)inputPortNode, () -> this.inputPortDAO.updatePort(inputPortDTO), port -> this.dtoFactory.createPortDto(port));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)inputPortNode);
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getInputPortStatus(inputPortNode.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(inputPortNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity((PortDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status, bulletinEntities);
    }

    public PortEntity updateOutputPort(Revision revision, PortDTO outputPortDTO) {
        Port outputPortNode = this.outputPortDAO.getPort(outputPortDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)outputPortNode, () -> this.outputPortDAO.updatePort(outputPortDTO), port -> this.dtoFactory.createPortDto(port));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)outputPortNode);
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getOutputPortStatus(outputPortNode.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(outputPortNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity((PortDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status, bulletinEntities);
    }

    public RemoteProcessGroupEntity updateRemoteProcessGroup(Revision revision, RemoteProcessGroupDTO remoteProcessGroupDTO) {
        RemoteProcessGroup remoteProcessGroupNode = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)remoteProcessGroupNode, () -> this.remoteProcessGroupDAO.updateRemoteProcessGroup(remoteProcessGroupDTO), remoteProcessGroup -> this.dtoFactory.createRemoteProcessGroupDto(remoteProcessGroup));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroupNode);
        RevisionDTO updateRevision = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        RemoteProcessGroupStatusDTO status = this.dtoFactory.createRemoteProcessGroupStatusDto(this.controllerFacade.getRemoteProcessGroupStatus(remoteProcessGroupNode.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(remoteProcessGroupNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createRemoteProcessGroupEntity((RemoteProcessGroupDTO)snapshot.getComponent(), updateRevision, permissions, status, bulletinEntities);
    }

    public RemoteProcessGroupPortEntity updateRemoteProcessGroupInputPort(Revision revision, String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDTO) {
        RemoteProcessGroup remoteProcessGroupNode = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupPortDTO.getGroupId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)remoteProcessGroupNode, () -> this.remoteProcessGroupDAO.updateRemoteProcessGroupInputPort(remoteProcessGroupId, remoteProcessGroupPortDTO), remoteGroupPort -> this.dtoFactory.createRemoteProcessGroupPortDto(remoteGroupPort));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroupNode);
        RevisionDTO updatedRevision = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        return this.entityFactory.createRemoteProcessGroupPortEntity((RemoteProcessGroupPortDTO)snapshot.getComponent(), updatedRevision, permissions);
    }

    public RemoteProcessGroupPortEntity updateRemoteProcessGroupOutputPort(Revision revision, String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDTO) {
        RemoteProcessGroup remoteProcessGroupNode = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupPortDTO.getGroupId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)remoteProcessGroupNode, () -> this.remoteProcessGroupDAO.updateRemoteProcessGroupOutputPort(remoteProcessGroupId, remoteProcessGroupPortDTO), remoteGroupPort -> this.dtoFactory.createRemoteProcessGroupPortDto(remoteGroupPort));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroupNode);
        RevisionDTO updatedRevision = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        return this.entityFactory.createRemoteProcessGroupPortEntity((RemoteProcessGroupPortDTO)snapshot.getComponent(), updatedRevision, permissions);
    }

    public Set<AffectedComponentDTO> getActiveComponentsAffectedByVariableRegistryUpdate(VariableRegistryDTO variableRegistryDto) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(variableRegistryDto.getProcessGroupId());
        if (group == null) {
            throw new ResourceNotFoundException("Could not find Process Group with ID " + variableRegistryDto.getProcessGroupId());
        }
        HashMap variableMap = new HashMap();
        variableRegistryDto.getVariables().stream().map(VariableEntity::getVariable).forEach(var -> variableMap.put(var.getName(), var.getValue()));
        HashSet<AffectedComponentDTO> affectedComponentDtos = new HashSet<AffectedComponentDTO>();
        Set updatedVariableNames = this.getUpdatedVariables(group, variableMap);
        for (String variableName : updatedVariableNames) {
            Set affectedComponents = group.getComponentsAffectedByVariable(variableName);
            for (ConfiguredComponent component : affectedComponents) {
                if (component instanceof ProcessorNode) {
                    ProcessorNode procNode = (ProcessorNode)component;
                    if (!procNode.isRunning()) continue;
                    affectedComponentDtos.add(this.dtoFactory.createAffectedComponentDto((ConfiguredComponent)procNode));
                    continue;
                }
                if (component instanceof ControllerServiceNode) {
                    ControllerServiceNode serviceNode = (ControllerServiceNode)component;
                    if (!serviceNode.isActive()) continue;
                    affectedComponentDtos.add(this.dtoFactory.createAffectedComponentDto((ConfiguredComponent)serviceNode));
                    continue;
                }
                throw new RuntimeException("Found unexpected type of Component [" + component.getCanonicalClassName() + "] dependending on variable");
            }
        }
        return affectedComponentDtos;
    }

    public Set<AffectedComponentEntity> getComponentsAffectedByVariableRegistryUpdate(VariableRegistryDTO variableRegistryDto) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(variableRegistryDto.getProcessGroupId());
        if (group == null) {
            throw new ResourceNotFoundException("Could not find Process Group with ID " + variableRegistryDto.getProcessGroupId());
        }
        HashMap variableMap = new HashMap();
        variableRegistryDto.getVariables().stream().map(VariableEntity::getVariable).forEach(var -> variableMap.put(var.getName(), var.getValue()));
        HashSet<AffectedComponentEntity> affectedComponentEntities = new HashSet<AffectedComponentEntity>();
        Set updatedVariableNames = this.getUpdatedVariables(group, variableMap);
        for (String variableName : updatedVariableNames) {
            Set affectedComponents = group.getComponentsAffectedByVariable(variableName);
            affectedComponentEntities.addAll(this.dtoFactory.createAffectedComponentEntities(affectedComponents, this.revisionManager));
        }
        return affectedComponentEntities;
    }

    private Set<String> getUpdatedVariables(ProcessGroup group, Map<String, String> newVariableValues) {
        HashSet<String> updatedVariableNames = new HashSet<String>();
        ComponentVariableRegistry registry = group.getVariableRegistry();
        for (Map.Entry<String, String> entry : newVariableValues.entrySet()) {
            String curValue;
            String varName = entry.getKey();
            String newValue = entry.getValue();
            if (Objects.equals(newValue, curValue = registry.getVariableValue(varName))) continue;
            updatedVariableNames.add(varName);
        }
        return updatedVariableNames;
    }

    public VariableRegistryEntity updateVariableRegistry(Revision revision, VariableRegistryDTO variableRegistryDto) {
        return this.updateVariableRegistry(NiFiUserUtils.getNiFiUser(), revision, variableRegistryDto);
    }

    public VariableRegistryEntity updateVariableRegistry(NiFiUser user, Revision revision, VariableRegistryDTO variableRegistryDto) {
        ProcessGroup processGroupNode = this.processGroupDAO.getProcessGroup(variableRegistryDto.getProcessGroupId());
        RevisionUpdate snapshot = this.updateComponent(user, revision, (Authorizable)processGroupNode, () -> this.processGroupDAO.updateVariableRegistry(variableRegistryDto), processGroup -> this.dtoFactory.createVariableRegistryDto(processGroup, this.revisionManager));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroupNode);
        RevisionDTO updatedRevision = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        return this.entityFactory.createVariableRegistryEntity((VariableRegistryDTO)snapshot.getComponent(), updatedRevision, permissions);
    }

    public ProcessGroupEntity updateProcessGroup(Revision revision, ProcessGroupDTO processGroupDTO) {
        ProcessGroup processGroupNode = this.processGroupDAO.getProcessGroup(processGroupDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)processGroupNode, () -> this.processGroupDAO.updateProcessGroup(processGroupDTO), processGroup -> this.dtoFactory.createProcessGroupDto(processGroup));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroupNode);
        RevisionDTO updatedRevision = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        ProcessGroupStatusDTO status = this.dtoFactory.createConciseProcessGroupStatusDto(this.controllerFacade.getProcessGroupStatus(processGroupNode.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processGroupNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createProcessGroupEntity((ProcessGroupDTO)snapshot.getComponent(), updatedRevision, permissions, status, bulletinEntities);
    }

    public void verifyUpdateProcessGroup(ProcessGroupDTO processGroupDTO) {
        if (this.processGroupDAO.hasProcessGroup(processGroupDTO.getId())) {
            this.processGroupDAO.verifyUpdate(processGroupDTO);
        }
    }

    public ScheduleComponentsEntity scheduleComponents(String processGroupId, ScheduledState state, Map<String, Revision> componentRevisions) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return this.scheduleComponents(user, processGroupId, state, componentRevisions);
    }

    public ScheduleComponentsEntity scheduleComponents(NiFiUser user, String processGroupId, ScheduledState state, Map<String, Revision> componentRevisions) {
        RevisionUpdate updatedComponent = this.revisionManager.updateRevision((RevisionClaim)new StandardRevisionClaim(componentRevisions.values()), user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        return (ScheduleComponentsEntity)updatedComponent.getComponent();
    }

    public ActivateControllerServicesEntity activateControllerServices(String processGroupId, ControllerServiceState state, Map<String, Revision> serviceRevisions) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return this.activateControllerServices(user, processGroupId, state, serviceRevisions);
    }

    public ActivateControllerServicesEntity activateControllerServices(NiFiUser user, String processGroupId, ControllerServiceState state, Map<String, Revision> serviceRevisions) {
        RevisionUpdate updatedComponent = this.revisionManager.updateRevision((RevisionClaim)new StandardRevisionClaim(serviceRevisions.values()), user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        return (ActivateControllerServicesEntity)updatedComponent.getComponent();
    }

    public ControllerConfigurationEntity updateControllerConfiguration(Revision revision, ControllerConfigurationDTO controllerConfigurationDTO) {
        RevisionUpdate updatedComponent = this.updateComponent(revision, (Authorizable)this.controllerFacade, () -> {
            if (controllerConfigurationDTO.getMaxTimerDrivenThreadCount() != null) {
                this.controllerFacade.setMaxTimerDrivenThreadCount(controllerConfigurationDTO.getMaxTimerDrivenThreadCount().intValue());
            }
            if (controllerConfigurationDTO.getMaxEventDrivenThreadCount() != null) {
                this.controllerFacade.setMaxEventDrivenThreadCount(controllerConfigurationDTO.getMaxEventDrivenThreadCount().intValue());
            }
            return controllerConfigurationDTO;
        }, controller -> this.dtoFactory.createControllerConfigurationDto(this.controllerFacade));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)this.controllerFacade);
        RevisionDTO updateRevision = this.dtoFactory.createRevisionDTO(updatedComponent.getLastModification());
        return this.entityFactory.createControllerConfigurationEntity((ControllerConfigurationDTO)updatedComponent.getComponent(), updateRevision, permissions);
    }

    public NodeDTO updateNode(NodeDTO nodeDTO) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        String userDn = user.getIdentity();
        NodeIdentifier nodeId = this.clusterCoordinator.getNodeIdentifier(nodeDTO.getNodeId());
        if (nodeId == null) {
            throw new UnknownNodeException("No node exists with ID " + nodeDTO.getNodeId());
        }
        if (NodeConnectionState.CONNECTING.name().equalsIgnoreCase(nodeDTO.getStatus())) {
            this.clusterCoordinator.requestNodeConnect(nodeId, userDn);
        } else if (NodeConnectionState.DISCONNECTING.name().equalsIgnoreCase(nodeDTO.getStatus())) {
            this.clusterCoordinator.requestNodeDisconnect(nodeId, DisconnectionCode.USER_DISCONNECTED, "User " + userDn + " requested that node be disconnected from cluster");
        }
        return this.getNode(nodeId);
    }

    public CounterDTO updateCounter(String counterId) {
        return this.dtoFactory.createCounterDto(this.controllerFacade.resetCounter(counterId));
    }

    public void verifyCanClearProcessorState(String processorId) {
        this.processorDAO.verifyClearState(processorId);
    }

    public void clearProcessorState(String processorId) {
        this.processorDAO.clearState(processorId);
    }

    public void verifyCanClearControllerServiceState(String controllerServiceId) {
        this.controllerServiceDAO.verifyClearState(controllerServiceId);
    }

    public void clearControllerServiceState(String controllerServiceId) {
        this.controllerServiceDAO.clearState(controllerServiceId);
    }

    public void verifyCanClearReportingTaskState(String reportingTaskId) {
        this.reportingTaskDAO.verifyClearState(reportingTaskId);
    }

    public void clearReportingTaskState(String reportingTaskId) {
        this.reportingTaskDAO.clearState(reportingTaskId);
    }

    public ConnectionEntity deleteConnection(Revision revision, String connectionId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection);
        ConnectionDTO snapshot = (ConnectionDTO)this.deleteComponent(revision, connection.getResource(), () -> this.connectionDAO.deleteConnection(connectionId), false, (Object)this.dtoFactory.createConnectionDto(connection));
        return this.entityFactory.createConnectionEntity(snapshot, null, permissions, null);
    }

    public DropRequestDTO deleteFlowFileDropRequest(String connectionId, String dropRequestId) {
        return this.dtoFactory.createDropRequestDTO(this.connectionDAO.deleteFlowFileDropRequest(connectionId, dropRequestId));
    }

    public ListingRequestDTO deleteFlowFileListingRequest(String connectionId, String listingRequestId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        ListingRequestDTO listRequest = this.dtoFactory.createListingRequestDTO(this.connectionDAO.deleteFlowFileListingRequest(connectionId, listingRequestId));
        if (connection.getSource() != null) {
            listRequest.setSourceRunning(Boolean.valueOf(connection.getSource().isRunning()));
        }
        if (connection.getDestination() != null) {
            listRequest.setDestinationRunning(Boolean.valueOf(connection.getDestination().isRunning()));
        }
        return listRequest;
    }

    public ProcessorEntity deleteProcessor(Revision revision, String processorId) {
        ProcessorNode processor = this.processorDAO.getProcessor(processorId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor);
        ProcessorDTO snapshot = (ProcessorDTO)this.deleteComponent(revision, processor.getResource(), () -> this.processorDAO.deleteProcessor(processorId), true, (Object)this.dtoFactory.createProcessorDto(processor));
        return this.entityFactory.createProcessorEntity(snapshot, null, permissions, null, null);
    }

    public LabelEntity deleteLabel(Revision revision, String labelId) {
        Label label = this.labelDAO.getLabel(labelId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)label);
        LabelDTO snapshot = (LabelDTO)this.deleteComponent(revision, label.getResource(), () -> this.labelDAO.deleteLabel(labelId), true, (Object)this.dtoFactory.createLabelDto(label));
        return this.entityFactory.createLabelEntity(snapshot, null, permissions);
    }

    public UserEntity deleteUser(Revision revision, String userId) {
        User user = this.userDAO.getUser(userId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        Set userGroups = user != null ? this.userGroupDAO.getUserGroupsForUser(userId).stream().map(g -> g.getIdentifier()).map(this.mapUserGroupIdToTenantEntity()).collect(Collectors.toSet()) : null;
        Set policyEntities = user != null ? this.userGroupDAO.getAccessPoliciesForUser(userId).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet()) : null;
        String resourceIdentifier = ResourceFactory.getTenantResource().getIdentifier() + "/" + userId;
        UserDTO snapshot = (UserDTO)this.deleteComponent(revision, (Resource)new /* Unavailable Anonymous Inner Class!! */, () -> this.userDAO.deleteUser(userId), false, (Object)this.dtoFactory.createUserDto(user, userGroups, policyEntities));
        return this.entityFactory.createUserEntity(snapshot, null, permissions);
    }

    public UserGroupEntity deleteUserGroup(Revision revision, String userGroupId) {
        Group userGroup = this.userGroupDAO.getUserGroup(userGroupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        Set users = userGroup != null ? userGroup.getUsers().stream().map(this.mapUserIdToTenantEntity()).collect(Collectors.toSet()) : null;
        Set policyEntities = this.userGroupDAO.getAccessPoliciesForUserGroup(userGroup.getIdentifier()).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
        String resourceIdentifier = ResourceFactory.getTenantResource().getIdentifier() + "/" + userGroupId;
        UserGroupDTO snapshot = (UserGroupDTO)this.deleteComponent(revision, (Resource)new /* Unavailable Anonymous Inner Class!! */, () -> this.userGroupDAO.deleteUserGroup(userGroupId), false, (Object)this.dtoFactory.createUserGroupDto(userGroup, users, policyEntities));
        return this.entityFactory.createUserGroupEntity(snapshot, null, permissions);
    }

    public AccessPolicyEntity deleteAccessPolicy(Revision revision, String accessPolicyId) {
        AccessPolicy accessPolicy = this.accessPolicyDAO.getAccessPolicy(accessPolicyId);
        ComponentReferenceEntity componentReference = this.createComponentReferenceEntity(accessPolicy.getResource());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getAccessPolicyById(accessPolicyId));
        Set userGroups = accessPolicy != null ? accessPolicy.getGroups().stream().map(this.mapUserGroupIdToTenantEntity()).collect(Collectors.toSet()) : null;
        Set users = accessPolicy != null ? accessPolicy.getUsers().stream().map(this.mapUserIdToTenantEntity()).collect(Collectors.toSet()) : null;
        AccessPolicyDTO snapshot = (AccessPolicyDTO)this.deleteComponent(revision, (Resource)new /* Unavailable Anonymous Inner Class!! */, () -> this.accessPolicyDAO.deleteAccessPolicy(accessPolicyId), false, (Object)this.dtoFactory.createAccessPolicyDto(accessPolicy, userGroups, users, componentReference));
        return this.entityFactory.createAccessPolicyEntity(snapshot, null, permissions);
    }

    public FunnelEntity deleteFunnel(Revision revision, String funnelId) {
        Funnel funnel = this.funnelDAO.getFunnel(funnelId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)funnel);
        FunnelDTO snapshot = (FunnelDTO)this.deleteComponent(revision, funnel.getResource(), () -> this.funnelDAO.deleteFunnel(funnelId), true, (Object)this.dtoFactory.createFunnelDto(funnel));
        return this.entityFactory.createFunnelEntity(snapshot, null, permissions);
    }

    private <D, C> D deleteComponent(Revision revision, Resource resource, Runnable deleteAction, boolean cleanUpPolicies, D dto) {
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return (D)this.revisionManager.deleteRevision((RevisionClaim)claim, user, (DeleteRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void cleanUpPolicies(Resource componentResource) {
        if (this.accessPolicyDAO.supportsConfigurableAuthorizer()) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.add(componentResource);
            resources.add(ResourceFactory.getDataResource((Resource)componentResource));
            resources.add(ResourceFactory.getDataTransferResource((Resource)componentResource));
            resources.add(ResourceFactory.getPolicyResource((Resource)componentResource));
            for (Resource resource : resources) {
                for (RequestAction action : RequestAction.values()) {
                    try {
                        AccessPolicy readPolicy = this.accessPolicyDAO.getAccessPolicy(action, resource.getIdentifier());
                        if (readPolicy == null) continue;
                        this.accessPolicyDAO.deleteAccessPolicy(readPolicy.getIdentifier());
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Unable to remove access policy for %s %s after component removal.", action, resource.getIdentifier()), (Throwable)e);
                    }
                }
            }
        }
    }

    public void verifyDeleteSnippet(String snippetId, Set<String> affectedComponentIds) {
        this.snippetDAO.verifyDeleteSnippetComponents(snippetId);
    }

    public SnippetEntity deleteSnippet(Set<Revision> revisions, String snippetId) {
        Snippet snippet = this.snippetDAO.getSnippet(snippetId);
        HashSet snippetResources = new HashSet();
        snippet.getProcessors().keySet().forEach(id -> snippetResources.add(this.processorDAO.getProcessor(id).getResource()));
        snippet.getInputPorts().keySet().forEach(id -> snippetResources.add(this.inputPortDAO.getPort(id).getResource()));
        snippet.getOutputPorts().keySet().forEach(id -> snippetResources.add(this.outputPortDAO.getPort(id).getResource()));
        snippet.getFunnels().keySet().forEach(id -> snippetResources.add(this.funnelDAO.getFunnel(id).getResource()));
        snippet.getLabels().keySet().forEach(id -> snippetResources.add(this.labelDAO.getLabel(id).getResource()));
        snippet.getRemoteProcessGroups().keySet().forEach(id -> snippetResources.add(this.remoteProcessGroupDAO.getRemoteProcessGroup(id).getResource()));
        snippet.getProcessGroups().keySet().forEach(id -> {
            ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(id);
            snippetResources.add(processGroup.getResource());
            processGroup.findAllProcessors().forEach(processor -> snippetResources.add(processor.getResource()));
            processGroup.findAllInputPorts().forEach(inputPort -> snippetResources.add(inputPort.getResource()));
            processGroup.findAllOutputPorts().forEach(outputPort -> snippetResources.add(outputPort.getResource()));
            processGroup.findAllFunnels().forEach(funnel -> snippetResources.add(funnel.getResource()));
            processGroup.findAllLabels().forEach(label -> snippetResources.add(label.getResource()));
            processGroup.findAllProcessGroups().forEach(childGroup -> snippetResources.add(childGroup.getResource()));
            processGroup.findAllRemoteProcessGroups().forEach(remoteProcessGroup -> snippetResources.add(remoteProcessGroup.getResource()));
            processGroup.findAllTemplates().forEach(template -> snippetResources.add(template.getResource()));
            processGroup.findAllControllerServices().forEach(controllerService -> snippetResources.add(controllerService.getResource()));
        });
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim claim = new StandardRevisionClaim(revisions);
        SnippetDTO dto = (SnippetDTO)this.revisionManager.deleteRevision((RevisionClaim)claim, user, (DeleteRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        snippetResources.forEach(resource -> this.cleanUpPolicies(resource));
        return this.entityFactory.createSnippetEntity(dto);
    }

    public PortEntity deleteInputPort(Revision revision, String inputPortId) {
        Port port = this.inputPortDAO.getPort(inputPortId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port);
        PortDTO snapshot = (PortDTO)this.deleteComponent(revision, port.getResource(), () -> this.inputPortDAO.deletePort(inputPortId), true, (Object)this.dtoFactory.createPortDto(port));
        return this.entityFactory.createPortEntity(snapshot, null, permissions, null, null);
    }

    public PortEntity deleteOutputPort(Revision revision, String outputPortId) {
        Port port = this.outputPortDAO.getPort(outputPortId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port);
        PortDTO snapshot = (PortDTO)this.deleteComponent(revision, port.getResource(), () -> this.outputPortDAO.deletePort(outputPortId), true, (Object)this.dtoFactory.createPortDto(port));
        return this.entityFactory.createPortEntity(snapshot, null, permissions, null, null);
    }

    public ProcessGroupEntity deleteProcessGroup(Revision revision, String groupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        HashSet groupResources = new HashSet();
        processGroup.findAllProcessors().forEach(processor -> groupResources.add(processor.getResource()));
        processGroup.findAllInputPorts().forEach(inputPort -> groupResources.add(inputPort.getResource()));
        processGroup.findAllOutputPorts().forEach(outputPort -> groupResources.add(outputPort.getResource()));
        processGroup.findAllFunnels().forEach(funnel -> groupResources.add(funnel.getResource()));
        processGroup.findAllLabels().forEach(label -> groupResources.add(label.getResource()));
        processGroup.findAllProcessGroups().forEach(childGroup -> groupResources.add(childGroup.getResource()));
        processGroup.findAllRemoteProcessGroups().forEach(remoteProcessGroup -> groupResources.add(remoteProcessGroup.getResource()));
        processGroup.findAllTemplates().forEach(template -> groupResources.add(template.getResource()));
        processGroup.findAllControllerServices().forEach(controllerService -> groupResources.add(controllerService.getResource()));
        ProcessGroupDTO snapshot = (ProcessGroupDTO)this.deleteComponent(revision, processGroup.getResource(), () -> this.processGroupDAO.deleteProcessGroup(groupId), true, (Object)this.dtoFactory.createProcessGroupDto(processGroup));
        groupResources.forEach(groupResource -> this.cleanUpPolicies(groupResource));
        return this.entityFactory.createProcessGroupEntity(snapshot, null, permissions, null, null);
    }

    public RemoteProcessGroupEntity deleteRemoteProcessGroup(Revision revision, String remoteProcessGroupId) {
        RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroup);
        RemoteProcessGroupDTO snapshot = (RemoteProcessGroupDTO)this.deleteComponent(revision, remoteProcessGroup.getResource(), () -> this.remoteProcessGroupDAO.deleteRemoteProcessGroup(remoteProcessGroupId), true, (Object)this.dtoFactory.createRemoteProcessGroupDto(remoteProcessGroup));
        return this.entityFactory.createRemoteProcessGroupEntity(snapshot, null, permissions, null, null);
    }

    public void deleteTemplate(String id) {
        this.templateDAO.deleteTemplate(id);
        this.controllerFacade.save();
    }

    public ConnectionEntity createConnection(Revision revision, String groupId, ConnectionDTO connectionDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)connectionDTO, () -> this.connectionDAO.createConnection(groupId, connectionDTO), connection -> this.dtoFactory.createConnectionDto(connection));
        Connection connection2 = this.connectionDAO.getConnection(connectionDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection2);
        ConnectionStatusDTO status = this.dtoFactory.createConnectionStatusDto(this.controllerFacade.getConnectionStatus(connectionDTO.getId()));
        return this.entityFactory.createConnectionEntity((ConnectionDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status);
    }

    public DropRequestDTO createFlowFileDropRequest(String connectionId, String dropRequestId) {
        return this.dtoFactory.createDropRequestDTO(this.connectionDAO.createFlowFileDropRequest(connectionId, dropRequestId));
    }

    public ListingRequestDTO createFlowFileListingRequest(String connectionId, String listingRequestId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        ListingRequestDTO listRequest = this.dtoFactory.createListingRequestDTO(this.connectionDAO.createFlowFileListingRequest(connectionId, listingRequestId));
        if (connection.getSource() != null) {
            listRequest.setSourceRunning(Boolean.valueOf(connection.getSource().isRunning()));
        }
        if (connection.getDestination() != null) {
            listRequest.setDestinationRunning(Boolean.valueOf(connection.getDestination().isRunning()));
        }
        return listRequest;
    }

    public ProcessorEntity createProcessor(Revision revision, String groupId, ProcessorDTO processorDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)processorDTO, () -> this.processorDAO.createProcessor(groupId, processorDTO), processor -> this.dtoFactory.createProcessorDto(processor));
        ProcessorNode processor2 = this.processorDAO.getProcessor(processorDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor2);
        ProcessorStatusDTO status = this.dtoFactory.createProcessorStatusDto(this.controllerFacade.getProcessorStatus(processorDTO.getId()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processorDTO.getId()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createProcessorEntity((ProcessorDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status, bulletinEntities);
    }

    public LabelEntity createLabel(Revision revision, String groupId, LabelDTO labelDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)labelDTO, () -> this.labelDAO.createLabel(groupId, labelDTO), label -> this.dtoFactory.createLabelDto(label));
        Label label2 = this.labelDAO.getLabel(labelDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)label2);
        return this.entityFactory.createLabelEntity((LabelDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    private <D, C> RevisionUpdate<D> createComponent(Revision revision, ComponentDTO componentDto, Supplier<C> daoCreation, Function<C, D> dtoCreation) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        return this.revisionManager.updateRevision((RevisionClaim)claim, user, () -> {
            Object component = daoCreation.get();
            this.controllerFacade.save();
            Object dto = dtoCreation.apply(component);
            FlowModification lastMod = new FlowModification(revision.incrementRevision(revision.getClientId()), user.getIdentity());
            return new StandardRevisionUpdate(dto, lastMod);
        });
    }

    public BulletinEntity createBulletin(BulletinDTO bulletinDTO, Boolean canRead) {
        Bulletin bulletin = BulletinFactory.createBulletin((String)bulletinDTO.getCategory(), (String)bulletinDTO.getLevel(), (String)bulletinDTO.getMessage());
        this.bulletinRepository.addBulletin(bulletin);
        return this.entityFactory.createBulletinEntity(this.dtoFactory.createBulletinDto(bulletin), canRead.booleanValue());
    }

    public FunnelEntity createFunnel(Revision revision, String groupId, FunnelDTO funnelDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)funnelDTO, () -> this.funnelDAO.createFunnel(groupId, funnelDTO), funnel -> this.dtoFactory.createFunnelDto(funnel));
        Funnel funnel2 = this.funnelDAO.getFunnel(funnelDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)funnel2);
        return this.entityFactory.createFunnelEntity((FunnelDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public AccessPolicyEntity createAccessPolicy(Revision revision, AccessPolicyDTO accessPolicyDTO) {
        Authorizable tenantAuthorizable = this.authorizableLookup.getTenant();
        String creator = NiFiUserUtils.getNiFiUserIdentity();
        AccessPolicy newAccessPolicy = this.accessPolicyDAO.createAccessPolicy(accessPolicyDTO);
        ComponentReferenceEntity componentReference = this.createComponentReferenceEntity(newAccessPolicy.getResource());
        AccessPolicyDTO newAccessPolicyDto = this.dtoFactory.createAccessPolicyDto(newAccessPolicy, newAccessPolicy.getGroups().stream().map(this.mapUserGroupIdToTenantEntity()).collect(Collectors.toSet()), newAccessPolicy.getUsers().stream().map(userId -> {
            RevisionDTO userRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(userId));
            return this.entityFactory.createTenantEntity(this.dtoFactory.createTenantDTO(this.userDAO.getUser(userId)), userRevision, this.dtoFactory.createPermissionsDto(tenantAuthorizable));
        }).collect(Collectors.toSet()), componentReference);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getAccessPolicyById(accessPolicyDTO.getId()));
        return this.entityFactory.createAccessPolicyEntity(newAccessPolicyDto, this.dtoFactory.createRevisionDTO(new FlowModification(revision, creator)), permissions);
    }

    public UserEntity createUser(Revision revision, UserDTO userDTO) {
        String creator = NiFiUserUtils.getNiFiUserIdentity();
        User newUser = this.userDAO.createUser(userDTO);
        Set tenantEntities = this.userGroupDAO.getUserGroupsForUser(newUser.getIdentifier()).stream().map(g -> g.getIdentifier()).map(this.mapUserGroupIdToTenantEntity()).collect(Collectors.toSet());
        Set policyEntities = this.userGroupDAO.getAccessPoliciesForUser(newUser.getIdentifier()).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
        UserDTO newUserDto = this.dtoFactory.createUserDto(newUser, tenantEntities, policyEntities);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        return this.entityFactory.createUserEntity(newUserDto, this.dtoFactory.createRevisionDTO(new FlowModification(revision, creator)), permissions);
    }

    private ComponentReferenceEntity createComponentReferenceEntity(String resource) {
        ComponentReferenceEntity componentReferenceEntity = null;
        try {
            ComponentReferenceDTO componentReference;
            Authorizable componentAuthorizable = this.authorizableLookup.getAuthorizableFromResource(resource);
            if (componentAuthorizable instanceof EnforcePolicyPermissionsThroughBaseResource) {
                componentAuthorizable = ((EnforcePolicyPermissionsThroughBaseResource)componentAuthorizable).getBaseAuthorizable();
            }
            if ((componentReference = this.dtoFactory.createComponentReferenceDto(componentAuthorizable)) != null) {
                PermissionsDTO componentReferencePermissions = this.dtoFactory.createPermissionsDto(componentAuthorizable);
                RevisionDTO componentReferenceRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(componentReference.getId()));
                componentReferenceEntity = this.entityFactory.createComponentReferenceEntity(componentReference, componentReferenceRevision, componentReferencePermissions);
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        return componentReferenceEntity;
    }

    private AccessPolicySummaryEntity createAccessPolicySummaryEntity(AccessPolicy ap) {
        ComponentReferenceEntity componentReference = this.createComponentReferenceEntity(ap.getResource());
        AccessPolicySummaryDTO apSummary = this.dtoFactory.createAccessPolicySummaryDto(ap, componentReference);
        PermissionsDTO apPermissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getAccessPolicyById(ap.getIdentifier()));
        RevisionDTO apRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(ap.getIdentifier()));
        return this.entityFactory.createAccessPolicySummaryEntity(apSummary, apRevision, apPermissions);
    }

    public UserGroupEntity createUserGroup(Revision revision, UserGroupDTO userGroupDTO) {
        String creator = NiFiUserUtils.getNiFiUserIdentity();
        Group newUserGroup = this.userGroupDAO.createUserGroup(userGroupDTO);
        Set tenantEntities = newUserGroup.getUsers().stream().map(this.mapUserIdToTenantEntity()).collect(Collectors.toSet());
        Set policyEntities = this.userGroupDAO.getAccessPoliciesForUserGroup(newUserGroup.getIdentifier()).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
        UserGroupDTO newUserGroupDto = this.dtoFactory.createUserGroupDto(newUserGroup, tenantEntities, policyEntities);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        return this.entityFactory.createUserGroupEntity(newUserGroupDto, this.dtoFactory.createRevisionDTO(new FlowModification(revision, creator)), permissions);
    }

    private void validateSnippetContents(FlowSnippetDTO flow) {
        Port port;
        ArrayList<String> errors;
        Collection validationErrors;
        if (flow.getProcessors() != null) {
            for (ProcessorDTO processorDTO : flow.getProcessors()) {
                ProcessorNode processorNode = this.processorDAO.getProcessor(processorDTO.getId());
                validationErrors = processorNode.getValidationErrors();
                if (validationErrors == null || validationErrors.isEmpty()) continue;
                errors = new ArrayList<String>();
                for (ValidationResult validationResult : validationErrors) {
                    errors.add(validationResult.toString());
                }
                processorDTO.setValidationErrors(errors);
            }
        }
        if (flow.getInputPorts() != null) {
            for (PortDTO portDTO : flow.getInputPorts()) {
                port = this.inputPortDAO.getPort(portDTO.getId());
                validationErrors = port.getValidationErrors();
                if (validationErrors == null || validationErrors.isEmpty()) continue;
                errors = new ArrayList();
                for (ValidationResult validationResult : validationErrors) {
                    errors.add(validationResult.toString());
                }
                portDTO.setValidationErrors(errors);
            }
        }
        if (flow.getOutputPorts() != null) {
            for (PortDTO portDTO : flow.getOutputPorts()) {
                port = this.outputPortDAO.getPort(portDTO.getId());
                validationErrors = port.getValidationErrors();
                if (validationErrors == null || validationErrors.isEmpty()) continue;
                errors = new ArrayList();
                for (ValidationResult validationResult : validationErrors) {
                    errors.add(validationResult.toString());
                }
                portDTO.setValidationErrors(errors);
            }
        }
        if (flow.getRemoteProcessGroups() != null) {
            for (RemoteProcessGroupDTO remoteProcessGroupDTO : flow.getRemoteProcessGroups()) {
                RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupDTO.getId());
                if (remoteProcessGroup.getAuthorizationIssue() == null) continue;
                remoteProcessGroupDTO.setAuthorizationIssues(Arrays.asList(remoteProcessGroup.getAuthorizationIssue()));
            }
        }
    }

    public FlowEntity copySnippet(String groupId, String snippetId, Double originX, Double originY, String idGenerationSeed) {
        FlowSnippetDTO snippet = this.snippetDAO.copySnippet(groupId, snippetId, originX, originY, idGenerationSeed);
        this.controllerFacade.save();
        this.snippetDAO.dropSnippet(snippetId);
        FlowDTO flowDto = this.postProcessNewFlowSnippet(groupId, snippet);
        FlowEntity flowEntity = new FlowEntity();
        flowEntity.setFlow(flowDto);
        return flowEntity;
    }

    public SnippetEntity createSnippet(SnippetDTO snippetDTO) {
        Snippet snippet = this.snippetDAO.createSnippet(snippetDTO);
        this.controllerFacade.save();
        SnippetDTO dto = this.dtoFactory.createSnippetDto(snippet);
        StandardRevisionUpdate snapshot = new StandardRevisionUpdate((Object)dto, null);
        return this.entityFactory.createSnippetEntity((SnippetDTO)snapshot.getComponent());
    }

    public PortEntity createInputPort(Revision revision, String groupId, PortDTO inputPortDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)inputPortDTO, () -> this.inputPortDAO.createPort(groupId, inputPortDTO), port -> this.dtoFactory.createPortDto(port));
        Port port2 = this.inputPortDAO.getPort(inputPortDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port2);
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getInputPortStatus(port2.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(port2.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity((PortDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status, bulletinEntities);
    }

    public PortEntity createOutputPort(Revision revision, String groupId, PortDTO outputPortDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)outputPortDTO, () -> this.outputPortDAO.createPort(groupId, outputPortDTO), port -> this.dtoFactory.createPortDto(port));
        Port port2 = this.outputPortDAO.getPort(outputPortDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port2);
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getOutputPortStatus(port2.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(port2.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity((PortDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status, bulletinEntities);
    }

    public ProcessGroupEntity createProcessGroup(Revision revision, String parentGroupId, ProcessGroupDTO processGroupDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)processGroupDTO, () -> this.processGroupDAO.createProcessGroup(parentGroupId, processGroupDTO), processGroup -> this.dtoFactory.createProcessGroupDto(processGroup));
        ProcessGroup processGroup2 = this.processGroupDAO.getProcessGroup(processGroupDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup2);
        ProcessGroupStatusDTO status = this.dtoFactory.createConciseProcessGroupStatusDto(this.controllerFacade.getProcessGroupStatus(processGroup2.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processGroup2.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createProcessGroupEntity((ProcessGroupDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status, bulletinEntities);
    }

    public RemoteProcessGroupEntity createRemoteProcessGroup(Revision revision, String groupId, RemoteProcessGroupDTO remoteProcessGroupDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)remoteProcessGroupDTO, () -> this.remoteProcessGroupDAO.createRemoteProcessGroup(groupId, remoteProcessGroupDTO), remoteProcessGroup -> this.dtoFactory.createRemoteProcessGroupDto(remoteProcessGroup));
        RemoteProcessGroup remoteProcessGroup2 = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroup2);
        RemoteProcessGroupStatusDTO status = this.dtoFactory.createRemoteProcessGroupStatusDto(this.controllerFacade.getRemoteProcessGroupStatus(remoteProcessGroup2.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(remoteProcessGroup2.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createRemoteProcessGroupEntity((RemoteProcessGroupDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status, bulletinEntities);
    }

    public void verifyCanAddTemplate(String groupId, String name) {
        this.templateDAO.verifyCanAddTemplate(name, groupId);
    }

    public void verifyComponentTypes(FlowSnippetDTO snippet) {
        this.templateDAO.verifyComponentTypes(snippet);
    }

    public TemplateDTO createTemplate(String name, String description, String snippetId, String groupId, Optional<String> idGenerationSeed) {
        Snippet snippet = this.snippetDAO.getSnippet(snippetId);
        TemplateDTO templateDTO = new TemplateDTO();
        templateDTO.setName(name);
        templateDTO.setDescription(description);
        templateDTO.setTimestamp(new Date());
        templateDTO.setSnippet(this.snippetUtils.populateFlowSnippet(snippet, true, true, true));
        templateDTO.setEncodingVersion("1.1");
        String uuid = idGenerationSeed.isPresent() ? UUID.nameUUIDFromBytes(idGenerationSeed.get().getBytes(StandardCharsets.UTF_8)).toString() : UUID.randomUUID().toString();
        templateDTO.setId(uuid);
        Template template = this.templateDAO.createTemplate(templateDTO, groupId);
        this.snippetDAO.dropSnippet(snippetId);
        this.controllerFacade.save();
        return this.dtoFactory.createTemplateDTO(template);
    }

    private void ensureDefaultPropertyValuesArePopulated(FlowSnippetDTO snippet) {
        if (snippet != null) {
            if (snippet.getControllerServices() != null) {
                snippet.getControllerServices().forEach(dto -> {
                    if (dto.getProperties() == null) {
                        dto.setProperties(new LinkedHashMap());
                    }
                    try {
                        ConfigurableComponent configurableComponent = this.controllerFacade.getTemporaryComponent(dto.getType(), dto.getBundle());
                        configurableComponent.getPropertyDescriptors().forEach(descriptor -> {
                            if (dto.getProperties().get(descriptor.getName()) == null) {
                                dto.getProperties().put(descriptor.getName(), descriptor.getDefaultValue());
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Unable to create ControllerService of type %s to populate default values.", dto.getType()));
                    }
                });
            }
            if (snippet.getProcessors() != null) {
                snippet.getProcessors().forEach(dto -> {
                    ProcessorConfigDTO config;
                    if (dto.getConfig() == null) {
                        dto.setConfig(new ProcessorConfigDTO());
                    }
                    if ((config = dto.getConfig()).getProperties() == null) {
                        config.setProperties(new LinkedHashMap());
                    }
                    try {
                        ConfigurableComponent configurableComponent = this.controllerFacade.getTemporaryComponent(dto.getType(), dto.getBundle());
                        configurableComponent.getPropertyDescriptors().forEach(descriptor -> {
                            if (config.getProperties().get(descriptor.getName()) == null) {
                                config.getProperties().put(descriptor.getName(), descriptor.getDefaultValue());
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Unable to create Processor of type %s to populate default values.", dto.getType()));
                    }
                });
            }
            if (snippet.getProcessGroups() != null) {
                snippet.getProcessGroups().forEach(processGroup -> this.ensureDefaultPropertyValuesArePopulated(processGroup.getContents()));
            }
        }
    }

    public TemplateDTO importTemplate(TemplateDTO templateDTO, String groupId, Optional<String> idGenerationSeed) {
        String uuid = idGenerationSeed.isPresent() ? UUID.nameUUIDFromBytes(idGenerationSeed.get().getBytes(StandardCharsets.UTF_8)).toString() : UUID.randomUUID().toString();
        templateDTO.setId(uuid);
        templateDTO.setTimestamp(new Date());
        this.ensureDefaultPropertyValuesArePopulated(templateDTO.getSnippet());
        Template template = this.templateDAO.importTemplate(templateDTO, groupId);
        this.controllerFacade.save();
        return this.dtoFactory.createTemplateDTO(template);
    }

    private FlowDTO postProcessNewFlowSnippet(String groupId, FlowSnippetDTO snippet) {
        this.validateSnippetContents(snippet);
        HashSet identifiers = new HashSet();
        snippet.getProcessors().stream().map(proc -> proc.getId()).forEach(id -> identifiers.add(id));
        snippet.getConnections().stream().map(conn -> conn.getId()).forEach(id -> identifiers.add(id));
        snippet.getInputPorts().stream().map(port -> port.getId()).forEach(id -> identifiers.add(id));
        snippet.getOutputPorts().stream().map(port -> port.getId()).forEach(id -> identifiers.add(id));
        snippet.getProcessGroups().stream().map(group -> group.getId()).forEach(id -> identifiers.add(id));
        snippet.getRemoteProcessGroups().stream().map(remoteGroup -> remoteGroup.getId()).forEach(id -> identifiers.add(id));
        snippet.getRemoteProcessGroups().stream().filter(remoteGroup -> remoteGroup.getContents() != null && remoteGroup.getContents().getInputPorts() != null).flatMap(remoteGroup -> remoteGroup.getContents().getInputPorts().stream()).map(remoteInputPort -> remoteInputPort.getId()).forEach(id -> identifiers.add(id));
        snippet.getRemoteProcessGroups().stream().filter(remoteGroup -> remoteGroup.getContents() != null && remoteGroup.getContents().getOutputPorts() != null).flatMap(remoteGroup -> remoteGroup.getContents().getOutputPorts().stream()).map(remoteOutputPort -> remoteOutputPort.getId()).forEach(id -> identifiers.add(id));
        snippet.getLabels().stream().map(label -> label.getId()).forEach(id -> identifiers.add(id));
        ProcessGroup group2 = this.processGroupDAO.getProcessGroup(groupId);
        ProcessGroupStatus groupStatus = this.controllerFacade.getProcessGroupStatus(groupId);
        return this.dtoFactory.createFlowDto(group2, groupStatus, snippet, this.revisionManager, arg_0 -> this.getProcessGroupBulletins(arg_0));
    }

    public FlowEntity createTemplateInstance(String groupId, Double originX, Double originY, String templateEncodingVersion, FlowSnippetDTO requestSnippet, String idGenerationSeed) {
        FlowSnippetDTO snippet = this.templateDAO.instantiateTemplate(groupId, originX, originY, templateEncodingVersion, requestSnippet, idGenerationSeed);
        this.controllerFacade.save();
        FlowDTO flowDto = this.postProcessNewFlowSnippet(groupId, snippet);
        FlowEntity flowEntity = new FlowEntity();
        flowEntity.setFlow(flowDto);
        return flowEntity;
    }

    public ControllerServiceEntity createControllerService(Revision revision, String groupId, ControllerServiceDTO controllerServiceDTO) {
        controllerServiceDTO.setParentGroupId(groupId);
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        RevisionUpdate snapshot = groupId == null ? this.revisionManager.updateRevision((RevisionClaim)claim, user, () -> {
            ControllerServiceNode controllerService = this.controllerServiceDAO.createControllerService(controllerServiceDTO);
            ControllerServiceDTO dto = this.dtoFactory.createControllerServiceDto(controllerService);
            this.controllerFacade.save();
            FlowModification lastMod = new FlowModification(revision.incrementRevision(revision.getClientId()), user.getIdentity());
            return new StandardRevisionUpdate((Object)dto, lastMod);
        }) : this.revisionManager.updateRevision((RevisionClaim)claim, user, () -> {
            ControllerServiceNode controllerService = this.controllerServiceDAO.createControllerService(controllerServiceDTO);
            ControllerServiceDTO dto = this.dtoFactory.createControllerServiceDto(controllerService);
            this.controllerFacade.save();
            FlowModification lastMod = new FlowModification(revision.incrementRevision(revision.getClientId()), user.getIdentity());
            return new StandardRevisionUpdate((Object)dto, lastMod);
        });
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)controllerService);
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(controllerServiceDTO.getId()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createControllerServiceEntity((ControllerServiceDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, bulletinEntities);
    }

    public ControllerServiceEntity updateControllerService(Revision revision, ControllerServiceDTO controllerServiceDTO) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)controllerService, () -> this.controllerServiceDAO.updateControllerService(controllerServiceDTO), cs -> {
            ControllerServiceDTO dto = this.dtoFactory.createControllerServiceDto(cs);
            ControllerServiceReference ref = controllerService.getReferences();
            ControllerServiceReferencingComponentsEntity referencingComponentsEntity = this.createControllerServiceReferencingComponentsEntity(ref, (Set)Sets.newHashSet((Object[])new String[]{controllerService.getIdentifier()}));
            dto.setReferencingComponents(referencingComponentsEntity.getControllerServiceReferencingComponents());
            return dto;
        });
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)controllerService);
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(controllerServiceDTO.getId()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createControllerServiceEntity((ControllerServiceDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, bulletinEntities);
    }

    private Set<ConfiguredComponent> findAllReferencingComponents(ControllerServiceReference reference) {
        HashSet<ConfiguredComponent> referencingComponents = new HashSet<ConfiguredComponent>(reference.getReferencingComponents());
        for (ConfiguredComponent referencingComponent : reference.getReferencingComponents()) {
            if (!(referencingComponent instanceof ControllerServiceNode)) continue;
            referencingComponents.addAll(this.findAllReferencingComponents(((ControllerServiceNode)referencingComponent).getReferences()));
        }
        return referencingComponents;
    }

    public ControllerServiceReferencingComponentsEntity updateControllerServiceReferencingComponents(Map<String, Revision> referenceRevisions, String controllerServiceId, ScheduledState scheduledState, ControllerServiceState controllerServiceState) {
        StandardRevisionClaim claim = new StandardRevisionClaim(referenceRevisions.values());
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        RevisionUpdate update = this.revisionManager.updateRevision((RevisionClaim)claim, user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        return (ControllerServiceReferencingComponentsEntity)update.getComponent();
    }

    private void findControllerServiceReferencingComponentIdentifiers(ControllerServiceReference reference, Set<ControllerServiceNode> visited) {
        for (ConfiguredComponent component : reference.getReferencingComponents()) {
            if (!(component instanceof ControllerServiceNode)) continue;
            ControllerServiceNode node = (ControllerServiceNode)component;
            if (!visited.contains(node)) {
                this.findControllerServiceReferencingComponentIdentifiers(node.getReferences(), visited);
            }
            visited.add(node);
        }
    }

    private ControllerServiceReferencingComponentsEntity createControllerServiceReferencingComponentsEntity(ControllerServiceReference reference, Set<String> lockedIds) {
        HashSet<ControllerServiceNode> visited = new HashSet<ControllerServiceNode>();
        visited.add(reference.getReferencedComponent());
        this.findControllerServiceReferencingComponentIdentifiers(reference, visited);
        HashMap<String, Revision> referencingRevisions = new HashMap<String, Revision>();
        for (ConfiguredComponent component : reference.getReferencingComponents()) {
            referencingRevisions.put(component.getIdentifier(), this.revisionManager.getRevision(component.getIdentifier()));
        }
        return this.createControllerServiceReferencingComponentsEntity(reference, referencingRevisions);
    }

    private ControllerServiceReferencingComponentsEntity createControllerServiceReferencingComponentsEntity(ControllerServiceReference reference, Map<String, Revision> revisions) {
        HashSet<ControllerServiceNode> visited = new HashSet<ControllerServiceNode>();
        visited.add(reference.getReferencedComponent());
        return this.createControllerServiceReferencingComponentsEntity(reference, revisions, visited);
    }

    private ControllerServiceReferencingComponentsEntity createControllerServiceReferencingComponentsEntity(ControllerServiceReference reference, Map<String, Revision> revisions, Set<ControllerServiceNode> visited) {
        String modifier = NiFiUserUtils.getNiFiUserIdentity();
        Set referencingComponents = reference.getReferencingComponents();
        HashSet<ControllerServiceReferencingComponentEntity> componentEntities = new HashSet<ControllerServiceReferencingComponentEntity>();
        for (ConfiguredComponent refComponent : referencingComponents) {
            PermissionsDTO permissions = null;
            if (refComponent instanceof Authorizable) {
                permissions = this.dtoFactory.createPermissionsDto((Authorizable)refComponent);
            }
            Revision revision = revisions.get(refComponent.getIdentifier());
            FlowModification flowMod = new FlowModification(revision, modifier);
            RevisionDTO revisionDto = this.dtoFactory.createRevisionDTO(flowMod);
            ControllerServiceReferencingComponentDTO dto = this.dtoFactory.createControllerServiceReferencingComponentDTO(refComponent);
            if (refComponent instanceof ControllerServiceNode) {
                ControllerServiceNode node = (ControllerServiceNode)refComponent;
                dto.setReferenceCycle(Boolean.valueOf(visited.contains(node)));
                visited.add(node);
                if (!dto.getReferenceCycle().booleanValue()) {
                    ControllerServiceReference refReferences = node.getReferences();
                    HashMap<String, Revision> referencingRevisions = new HashMap<String, Revision>(revisions);
                    for (ConfiguredComponent component : refReferences.getReferencingComponents()) {
                        referencingRevisions.putIfAbsent(component.getIdentifier(), this.revisionManager.getRevision(component.getIdentifier()));
                    }
                    ControllerServiceReferencingComponentsEntity references = this.createControllerServiceReferencingComponentsEntity(refReferences, referencingRevisions, visited);
                    dto.setReferencingComponents(references.getControllerServiceReferencingComponents());
                }
            }
            componentEntities.add(this.entityFactory.createControllerServiceReferencingComponentEntity(dto, revisionDto, permissions));
        }
        ControllerServiceReferencingComponentsEntity entity = new ControllerServiceReferencingComponentsEntity();
        entity.setControllerServiceReferencingComponents(componentEntities);
        return entity;
    }

    public ControllerServiceEntity deleteControllerService(Revision revision, String controllerServiceId) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)controllerService);
        ControllerServiceDTO snapshot = (ControllerServiceDTO)this.deleteComponent(revision, controllerService.getResource(), () -> this.controllerServiceDAO.deleteControllerService(controllerServiceId), true, (Object)this.dtoFactory.createControllerServiceDto(controllerService));
        return this.entityFactory.createControllerServiceEntity(snapshot, null, permissions, null);
    }

    public ReportingTaskEntity createReportingTask(Revision revision, ReportingTaskDTO reportingTaskDTO) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        RevisionUpdate snapshot = this.revisionManager.updateRevision((RevisionClaim)claim, user, () -> {
            ReportingTaskNode reportingTask = this.reportingTaskDAO.createReportingTask(reportingTaskDTO);
            this.controllerFacade.save();
            ReportingTaskDTO dto = this.dtoFactory.createReportingTaskDto(reportingTask);
            FlowModification lastMod = new FlowModification(revision.incrementRevision(revision.getClientId()), user.getIdentity());
            return new StandardRevisionUpdate((Object)dto, lastMod);
        });
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(reportingTaskDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)reportingTask);
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(reportingTask.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createReportingTaskEntity((ReportingTaskDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, bulletinEntities);
    }

    public ReportingTaskEntity updateReportingTask(Revision revision, ReportingTaskDTO reportingTaskDTO) {
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(reportingTaskDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)reportingTask, () -> this.reportingTaskDAO.updateReportingTask(reportingTaskDTO), rt -> this.dtoFactory.createReportingTaskDto(rt));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)reportingTask);
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(reportingTask.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createReportingTaskEntity((ReportingTaskDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, bulletinEntities);
    }

    public ReportingTaskEntity deleteReportingTask(Revision revision, String reportingTaskId) {
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(reportingTaskId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)reportingTask);
        ReportingTaskDTO snapshot = (ReportingTaskDTO)this.deleteComponent(revision, reportingTask.getResource(), () -> this.reportingTaskDAO.deleteReportingTask(reportingTaskId), true, (Object)this.dtoFactory.createReportingTaskDto(reportingTask));
        return this.entityFactory.createReportingTaskEntity(snapshot, null, permissions, null);
    }

    public void deleteActions(Date endDate) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        FlowChangePurgeDetails details = new FlowChangePurgeDetails();
        details.setEndDate(endDate);
        FlowChangeAction purgeAction = new FlowChangeAction();
        purgeAction.setUserIdentity(user.getIdentity());
        purgeAction.setOperation(Operation.Purge);
        purgeAction.setTimestamp(new Date());
        purgeAction.setSourceId("Flow Controller");
        purgeAction.setSourceName("History");
        purgeAction.setSourceType(Component.Controller);
        purgeAction.setActionDetails((ActionDetails)details);
        this.auditService.purgeActions(endDate, (Action)purgeAction);
    }

    public ProvenanceDTO submitProvenance(ProvenanceDTO query) {
        return this.controllerFacade.submitProvenance(query);
    }

    public void deleteProvenance(String queryId) {
        this.controllerFacade.deleteProvenanceQuery(queryId);
    }

    public LineageDTO submitLineage(LineageDTO lineage) {
        return this.controllerFacade.submitLineage(lineage);
    }

    public void deleteLineage(String lineageId) {
        this.controllerFacade.deleteLineage(lineageId);
    }

    public ProvenanceEventDTO submitReplay(Long eventId) {
        return this.controllerFacade.submitReplay(eventId);
    }

    public SearchResultsDTO searchController(String query) {
        return this.controllerFacade.search(query);
    }

    public DownloadableContent getContent(String connectionId, String flowFileUuid, String uri) {
        return this.connectionDAO.getContent(connectionId, flowFileUuid, uri);
    }

    public DownloadableContent getContent(Long eventId, String uri, ContentDirection contentDirection) {
        return this.controllerFacade.getContent(eventId, uri, contentDirection);
    }

    public ProvenanceDTO getProvenance(String queryId, Boolean summarize, Boolean incrementalResults) {
        return this.controllerFacade.getProvenanceQuery(queryId, summarize, incrementalResults);
    }

    public LineageDTO getLineage(String lineageId) {
        return this.controllerFacade.getLineage(lineageId);
    }

    public ProvenanceOptionsDTO getProvenanceSearchOptions() {
        return this.controllerFacade.getProvenanceSearchOptions();
    }

    public ProvenanceEventDTO getProvenanceEvent(Long id) {
        return this.controllerFacade.getProvenanceEvent(id);
    }

    public ProcessGroupStatusEntity getProcessGroupStatus(String groupId, boolean recursive) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        ProcessGroupStatusDTO dto = this.dtoFactory.createProcessGroupStatusDto(processGroup, this.controllerFacade.getProcessGroupStatus(groupId));
        if (!recursive) {
            this.pruneChildGroups(dto.getAggregateSnapshot());
            if (dto.getNodeSnapshots() != null) {
                for (NodeProcessGroupStatusSnapshotDTO nodeSnapshot : dto.getNodeSnapshots()) {
                    this.pruneChildGroups(nodeSnapshot.getStatusSnapshot());
                }
            }
        }
        return this.entityFactory.createProcessGroupStatusEntity(dto, permissions);
    }

    private void pruneChildGroups(ProcessGroupStatusSnapshotDTO snapshot) {
        for (ProcessGroupStatusSnapshotEntity childProcessGroupStatusEntity : snapshot.getProcessGroupStatusSnapshots()) {
            ProcessGroupStatusSnapshotDTO childProcessGroupStatus = childProcessGroupStatusEntity.getProcessGroupStatusSnapshot();
            childProcessGroupStatus.setConnectionStatusSnapshots(null);
            childProcessGroupStatus.setProcessGroupStatusSnapshots(null);
            childProcessGroupStatus.setInputPortStatusSnapshots(null);
            childProcessGroupStatus.setOutputPortStatusSnapshots(null);
            childProcessGroupStatus.setProcessorStatusSnapshots(null);
            childProcessGroupStatus.setRemoteProcessGroupStatusSnapshots(null);
        }
    }

    public ControllerStatusDTO getControllerStatus() {
        return this.controllerFacade.getControllerStatus();
    }

    public ComponentStateDTO getProcessorState(String processorId) {
        StateMap clusterState = this.isClustered() ? this.processorDAO.getState(processorId, Scope.CLUSTER) : null;
        StateMap localState = this.processorDAO.getState(processorId, Scope.LOCAL);
        ProcessorNode processor = this.processorDAO.getProcessor(processorId);
        return this.dtoFactory.createComponentStateDTO(processorId, processor.getProcessor().getClass(), localState, clusterState);
    }

    public ComponentStateDTO getControllerServiceState(String controllerServiceId) {
        StateMap clusterState = this.isClustered() ? this.controllerServiceDAO.getState(controllerServiceId, Scope.CLUSTER) : null;
        StateMap localState = this.controllerServiceDAO.getState(controllerServiceId, Scope.LOCAL);
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceId);
        return this.dtoFactory.createComponentStateDTO(controllerServiceId, controllerService.getControllerServiceImplementation().getClass(), localState, clusterState);
    }

    public ComponentStateDTO getReportingTaskState(String reportingTaskId) {
        StateMap clusterState = this.isClustered() ? this.reportingTaskDAO.getState(reportingTaskId, Scope.CLUSTER) : null;
        StateMap localState = this.reportingTaskDAO.getState(reportingTaskId, Scope.LOCAL);
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(reportingTaskId);
        return this.dtoFactory.createComponentStateDTO(reportingTaskId, reportingTask.getReportingTask().getClass(), localState, clusterState);
    }

    public CountersDTO getCounters() {
        List counters = this.controllerFacade.getCounters();
        LinkedHashSet<CounterDTO> counterDTOs = new LinkedHashSet<CounterDTO>(counters.size());
        for (Counter counter : counters) {
            counterDTOs.add(this.dtoFactory.createCounterDto(counter));
        }
        CountersSnapshotDTO snapshotDto = this.dtoFactory.createCountersDto(counterDTOs);
        CountersDTO countersDto = new CountersDTO();
        countersDto.setAggregateSnapshot(snapshotDto);
        return countersDto;
    }

    private ConnectionEntity createConnectionEntity(Connection connection) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(connection.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection);
        ConnectionStatusDTO status = this.dtoFactory.createConnectionStatusDto(this.controllerFacade.getConnectionStatus(connection.getIdentifier()));
        return this.entityFactory.createConnectionEntity(this.dtoFactory.createConnectionDto(connection), revision, permissions, status);
    }

    public Set<ConnectionEntity> getConnections(String groupId) {
        Set connections = this.connectionDAO.getConnections(groupId);
        return connections.stream().map(connection -> this.createConnectionEntity(connection)).collect(Collectors.toSet());
    }

    public ConnectionEntity getConnection(String connectionId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        return this.createConnectionEntity(connection);
    }

    public DropRequestDTO getFlowFileDropRequest(String connectionId, String dropRequestId) {
        return this.dtoFactory.createDropRequestDTO(this.connectionDAO.getFlowFileDropRequest(connectionId, dropRequestId));
    }

    public ListingRequestDTO getFlowFileListingRequest(String connectionId, String listingRequestId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        ListingRequestDTO listRequest = this.dtoFactory.createListingRequestDTO(this.connectionDAO.getFlowFileListingRequest(connectionId, listingRequestId));
        if (connection.getSource() != null) {
            listRequest.setSourceRunning(Boolean.valueOf(connection.getSource().isRunning()));
        }
        if (connection.getDestination() != null) {
            listRequest.setDestinationRunning(Boolean.valueOf(connection.getDestination().isRunning()));
        }
        return listRequest;
    }

    public FlowFileDTO getFlowFile(String connectionId, String flowFileUuid) {
        return this.dtoFactory.createFlowFileDTO(this.connectionDAO.getFlowFile(connectionId, flowFileUuid));
    }

    public ConnectionStatusEntity getConnectionStatus(String connectionId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection);
        ConnectionStatusDTO dto = this.dtoFactory.createConnectionStatusDto(this.controllerFacade.getConnectionStatus(connectionId));
        return this.entityFactory.createConnectionStatusEntity(dto, permissions);
    }

    public StatusHistoryEntity getConnectionStatusHistory(String connectionId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection);
        StatusHistoryDTO dto = this.controllerFacade.getConnectionStatusHistory(connectionId);
        return this.entityFactory.createStatusHistoryEntity(dto, permissions);
    }

    private ProcessorEntity createProcessorEntity(ProcessorNode processor) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(processor.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor);
        ProcessorStatusDTO status = this.dtoFactory.createProcessorStatusDto(this.controllerFacade.getProcessorStatus(processor.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processor.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createProcessorEntity(this.dtoFactory.createProcessorDto(processor), revision, permissions, status, bulletinEntities);
    }

    public Set<ProcessorEntity> getProcessors(String groupId, boolean includeDescendants) {
        Set processors = this.processorDAO.getProcessors(groupId, includeDescendants);
        return processors.stream().map(processor -> this.createProcessorEntity(processor)).collect(Collectors.toSet());
    }

    public TemplateDTO exportTemplate(String id) {
        Template template = this.templateDAO.getTemplate(id);
        TemplateDTO templateDetails = template.getDetails();
        TemplateDTO templateDTO = this.dtoFactory.createTemplateDTO(template);
        templateDTO.setSnippet(this.dtoFactory.copySnippetContents(templateDetails.getSnippet()));
        return templateDTO;
    }

    public TemplateDTO getTemplate(String id) {
        return this.dtoFactory.createTemplateDTO(this.templateDAO.getTemplate(id));
    }

    public Set<TemplateEntity> getTemplates() {
        return this.templateDAO.getTemplates().stream().map(template -> {
            TemplateDTO dto = this.dtoFactory.createTemplateDTO(template);
            PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)template);
            TemplateEntity entity = new TemplateEntity();
            entity.setId(dto.getId());
            entity.setPermissions(permissions);
            entity.setTemplate(dto);
            return entity;
        }).collect(Collectors.toSet());
    }

    public Set<DocumentedTypeDTO> getWorkQueuePrioritizerTypes() {
        return this.controllerFacade.getFlowFileComparatorTypes();
    }

    public Set<DocumentedTypeDTO> getProcessorTypes(String bundleGroup, String bundleArtifact, String type) {
        return this.controllerFacade.getFlowFileProcessorTypes(bundleGroup, bundleArtifact, type);
    }

    public Set<DocumentedTypeDTO> getControllerServiceTypes(String serviceType, String serviceBundleGroup, String serviceBundleArtifact, String serviceBundleVersion, String bundleGroup, String bundleArtifact, String type) {
        return this.controllerFacade.getControllerServiceTypes(serviceType, serviceBundleGroup, serviceBundleArtifact, serviceBundleVersion, bundleGroup, bundleArtifact, type);
    }

    public Set<DocumentedTypeDTO> getReportingTaskTypes(String bundleGroup, String bundleArtifact, String type) {
        return this.controllerFacade.getReportingTaskTypes(bundleGroup, bundleArtifact, type);
    }

    public ProcessorEntity getProcessor(String id) {
        ProcessorNode processor = this.processorDAO.getProcessor(id);
        return this.createProcessorEntity(processor);
    }

    public PropertyDescriptorDTO getProcessorPropertyDescriptor(String id, String property) {
        ProcessorNode processor = this.processorDAO.getProcessor(id);
        PropertyDescriptor descriptor = processor.getPropertyDescriptor(property);
        if (descriptor == null) {
            descriptor = new PropertyDescriptor.Builder().name(property).addValidator(Validator.INVALID).dynamic(true).build();
        }
        return this.dtoFactory.createPropertyDescriptorDto(descriptor, processor.getProcessGroup().getIdentifier());
    }

    public ProcessorStatusEntity getProcessorStatus(String id) {
        ProcessorNode processor = this.processorDAO.getProcessor(id);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor);
        ProcessorStatusDTO dto = this.dtoFactory.createProcessorStatusDto(this.controllerFacade.getProcessorStatus(id));
        return this.entityFactory.createProcessorStatusEntity(dto, permissions);
    }

    public StatusHistoryEntity getProcessorStatusHistory(String id) {
        ProcessorNode processor = this.processorDAO.getProcessor(id);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor);
        StatusHistoryDTO dto = this.controllerFacade.getProcessorStatusHistory(id);
        return this.entityFactory.createStatusHistoryEntity(dto, permissions);
    }

    private boolean authorizeBulletin(Bulletin bulletin) {
        ControllerFacade authorizable;
        String sourceId = bulletin.getSourceId();
        ComponentType type = bulletin.getSourceType();
        try {
            switch (13.$SwitchMap$org$apache$nifi$reporting$ComponentType[type.ordinal()]) {
                case 1: {
                    authorizable = this.authorizableLookup.getProcessor(sourceId).getAuthorizable();
                    break;
                }
                case 2: {
                    authorizable = this.authorizableLookup.getReportingTask(sourceId).getAuthorizable();
                    break;
                }
                case 3: {
                    authorizable = this.authorizableLookup.getControllerService(sourceId).getAuthorizable();
                    break;
                }
                case 4: {
                    authorizable = this.controllerFacade;
                    break;
                }
                case 5: {
                    authorizable = this.authorizableLookup.getInputPort(sourceId);
                    break;
                }
                case 6: {
                    authorizable = this.authorizableLookup.getOutputPort(sourceId);
                    break;
                }
                case 7: {
                    authorizable = this.authorizableLookup.getRemoteProcessGroup(sourceId);
                    break;
                }
                default: {
                    throw new WebApplicationException(Response.serverError().entity((Object)"An unexpected type of component is the source of this bulletin.").build());
                }
            }
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        AuthorizationResult result = authorizable.checkAuthorization(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        return AuthorizationResult.Result.Approved.equals((Object)result.getResult());
    }

    public BulletinBoardDTO getBulletinBoard(BulletinQueryDTO query) {
        BulletinQuery.Builder queryBuilder = new BulletinQuery.Builder().groupIdMatches(query.getGroupId()).sourceIdMatches(query.getSourceId()).nameMatches(query.getName()).messageMatches(query.getMessage()).after(query.getAfter()).limit(query.getLimit());
        List results = this.bulletinRepository.findBulletins(queryBuilder.build());
        ArrayList<BulletinEntity> bulletinEntities = new ArrayList<BulletinEntity>();
        ListIterator bulletinIter = results.listIterator(results.size());
        while (bulletinIter.hasPrevious()) {
            Bulletin bulletin = (Bulletin)bulletinIter.previous();
            bulletinEntities.add(this.entityFactory.createBulletinEntity(this.dtoFactory.createBulletinDto(bulletin), this.authorizeBulletin(bulletin)));
        }
        BulletinBoardDTO bulletinBoard = new BulletinBoardDTO();
        bulletinBoard.setBulletins(bulletinEntities);
        bulletinBoard.setGenerated(new Date());
        return bulletinBoard;
    }

    public SystemDiagnosticsDTO getSystemDiagnostics() {
        SystemDiagnostics sysDiagnostics = this.controllerFacade.getSystemDiagnostics();
        return this.dtoFactory.createSystemDiagnosticsDto(sysDiagnostics);
    }

    public List<ResourceDTO> getResources() {
        List resources = this.controllerFacade.getResources();
        ArrayList<ResourceDTO> resourceDtos = new ArrayList<ResourceDTO>(resources.size());
        for (Resource resource : resources) {
            resourceDtos.add(this.dtoFactory.createResourceDto(resource));
        }
        return resourceDtos;
    }

    private boolean isUserAuthorized(NiFiUser user, RootGroupPort port) {
        HashMap<String, String> userContext;
        boolean isSiteToSiteSecure = Boolean.TRUE.equals(this.properties.isSiteToSiteSecure());
        if (!isSiteToSiteSecure) {
            return true;
        }
        if (user.getClientAddress() != null && !user.getClientAddress().trim().isEmpty()) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
        } else {
            userContext = null;
        }
        AuthorizationRequest request = new AuthorizationRequest.Builder().resource(ResourceFactory.getDataTransferResource((Resource)port.getResource())).identity(user.getIdentity()).groups(user.getGroups()).anonymous(Boolean.valueOf(user.isAnonymous())).accessAttempt(Boolean.valueOf(false)).action(RequestAction.WRITE).userContext(userContext).explanationSupplier(() -> "Unable to retrieve port details.").build();
        AuthorizationResult result = this.authorizer.authorize(request);
        return AuthorizationResult.Result.Approved.equals((Object)result.getResult());
    }

    public ControllerDTO getSiteToSiteDetails() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        LinkedHashSet<PortDTO> inputPortDtos = new LinkedHashSet<PortDTO>();
        Set inputPorts = this.controllerFacade.getInputPorts();
        for (Object inputPort : inputPorts) {
            if (!this.isUserAuthorized(user, (RootGroupPort)inputPort)) continue;
            PortDTO dto = new PortDTO();
            dto.setId(inputPort.getIdentifier());
            dto.setName(inputPort.getName());
            dto.setComments(inputPort.getComments());
            dto.setState(inputPort.getScheduledState().toString());
            inputPortDtos.add(dto);
        }
        LinkedHashSet<PortDTO> outputPortDtos = new LinkedHashSet<PortDTO>();
        for (RootGroupPort outputPort : this.controllerFacade.getOutputPorts()) {
            if (!this.isUserAuthorized(user, outputPort)) continue;
            PortDTO dto = new PortDTO();
            dto.setId(outputPort.getIdentifier());
            dto.setName(outputPort.getName());
            dto.setComments(outputPort.getComments());
            dto.setState(outputPort.getScheduledState().toString());
            outputPortDtos.add(dto);
        }
        ProcessGroup rootGroup = this.processGroupDAO.getProcessGroup(this.controllerFacade.getRootGroupId());
        ProcessGroupCounts counts = rootGroup.getCounts();
        ControllerDTO controllerDTO = new ControllerDTO();
        controllerDTO.setId(this.controllerFacade.getRootGroupId());
        controllerDTO.setInstanceId(this.controllerFacade.getInstanceId());
        controllerDTO.setInputPorts(inputPortDtos);
        controllerDTO.setOutputPorts(outputPortDtos);
        controllerDTO.setInputPortCount(Integer.valueOf(inputPortDtos.size()));
        controllerDTO.setOutputPortCount(Integer.valueOf(outputPortDtos.size()));
        controllerDTO.setRunningCount(Integer.valueOf(counts.getRunningCount()));
        controllerDTO.setStoppedCount(Integer.valueOf(counts.getStoppedCount()));
        controllerDTO.setInvalidCount(Integer.valueOf(counts.getInvalidCount()));
        controllerDTO.setDisabledCount(Integer.valueOf(counts.getDisabledCount()));
        controllerDTO.setRemoteSiteListeningPort(this.controllerFacade.getRemoteSiteListeningPort());
        controllerDTO.setRemoteSiteHttpListeningPort(this.controllerFacade.getRemoteSiteListeningHttpPort());
        controllerDTO.setSiteToSiteSecure(this.controllerFacade.isRemoteSiteCommsSecure());
        return controllerDTO;
    }

    public ControllerConfigurationEntity getControllerConfiguration() {
        Revision rev = this.revisionManager.getRevision(FlowController.class.getSimpleName());
        ControllerConfigurationDTO dto = this.dtoFactory.createControllerConfigurationDto(this.controllerFacade);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)this.controllerFacade);
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(rev);
        return this.entityFactory.createControllerConfigurationEntity(dto, revision, permissions);
    }

    public ControllerBulletinsEntity getControllerBulletins() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        ControllerBulletinsEntity controllerBulletinsEntity = new ControllerBulletinsEntity();
        ArrayList<BulletinEntity> controllerBulletinEntities = new ArrayList<BulletinEntity>();
        Authorizable controllerAuthorizable = this.authorizableLookup.getController();
        boolean authorized = controllerAuthorizable.isAuthorized(this.authorizer, RequestAction.READ, user);
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForController());
        controllerBulletinEntities.addAll(bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, authorized)).collect(Collectors.toList()));
        BulletinQuery controllerServiceQuery = new BulletinQuery.Builder().sourceType(ComponentType.CONTROLLER_SERVICE).build();
        List allControllerServiceBulletins = this.bulletinRepository.findBulletins(controllerServiceQuery);
        ArrayList<BulletinEntity> controllerServiceBulletinEntities = new ArrayList<BulletinEntity>();
        for (Bulletin bulletin2 : allControllerServiceBulletins) {
            try {
                Authorizable controllerServiceAuthorizable = this.authorizableLookup.getControllerService(bulletin2.getSourceId()).getAuthorizable();
                boolean controllerServiceAuthorized = controllerServiceAuthorizable.isAuthorized(this.authorizer, RequestAction.READ, user);
                BulletinEntity controllerServiceBulletin = this.entityFactory.createBulletinEntity(this.dtoFactory.createBulletinDto(bulletin2), controllerServiceAuthorized);
                controllerServiceBulletinEntities.add(controllerServiceBulletin);
                controllerBulletinEntities.add(controllerServiceBulletin);
            }
            catch (ResourceNotFoundException controllerServiceAuthorizable) {}
        }
        controllerBulletinsEntity.setControllerServiceBulletins(controllerServiceBulletinEntities);
        BulletinQuery reportingTaskQuery = new BulletinQuery.Builder().sourceType(ComponentType.REPORTING_TASK).build();
        List allReportingTaskBulletins = this.bulletinRepository.findBulletins(reportingTaskQuery);
        ArrayList<BulletinEntity> reportingTaskBulletinEntities = new ArrayList<BulletinEntity>();
        for (Bulletin bulletin3 : allReportingTaskBulletins) {
            try {
                Authorizable reportingTaskAuthorizable = this.authorizableLookup.getReportingTask(bulletin3.getSourceId()).getAuthorizable();
                boolean reportingTaskAuthorizableAuthorized = reportingTaskAuthorizable.isAuthorized(this.authorizer, RequestAction.READ, user);
                BulletinEntity reportingTaskBulletin = this.entityFactory.createBulletinEntity(this.dtoFactory.createBulletinDto(bulletin3), reportingTaskAuthorizableAuthorized);
                reportingTaskBulletinEntities.add(reportingTaskBulletin);
                controllerBulletinEntities.add(reportingTaskBulletin);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {}
        }
        controllerBulletinsEntity.setReportingTaskBulletins(reportingTaskBulletinEntities);
        controllerBulletinsEntity.setBulletins(this.pruneAndSortBulletins(controllerBulletinEntities, 10));
        return controllerBulletinsEntity;
    }

    public FlowConfigurationEntity getFlowConfiguration() {
        FlowConfigurationDTO dto = this.dtoFactory.createFlowConfigurationDto(this.properties.getAutoRefreshInterval());
        FlowConfigurationEntity entity = new FlowConfigurationEntity();
        entity.setFlowConfiguration(dto);
        return entity;
    }

    public AccessPolicyEntity getAccessPolicy(String accessPolicyId) {
        AccessPolicy accessPolicy = this.accessPolicyDAO.getAccessPolicy(accessPolicyId);
        return this.createAccessPolicyEntity(accessPolicy);
    }

    public AccessPolicyEntity getAccessPolicy(RequestAction requestAction, String resource) {
        Authorizable authorizable;
        try {
            authorizable = this.authorizableLookup.getAuthorizableFromResource(resource);
        }
        catch (ResourceNotFoundException e) {
            authorizable = new /* Unavailable Anonymous Inner Class!! */;
        }
        AccessPolicy accessPolicy = this.accessPolicyDAO.getAccessPolicy(requestAction, authorizable);
        return this.createAccessPolicyEntity(accessPolicy);
    }

    private AccessPolicyEntity createAccessPolicyEntity(AccessPolicy accessPolicy) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(accessPolicy.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getAccessPolicyById(accessPolicy.getIdentifier()));
        ComponentReferenceEntity componentReference = this.createComponentReferenceEntity(accessPolicy.getResource());
        return this.entityFactory.createAccessPolicyEntity(this.dtoFactory.createAccessPolicyDto(accessPolicy, accessPolicy.getGroups().stream().map(this.mapUserGroupIdToTenantEntity()).collect(Collectors.toSet()), accessPolicy.getUsers().stream().map(this.mapUserIdToTenantEntity()).collect(Collectors.toSet()), componentReference), revision, permissions);
    }

    public UserEntity getUser(String userId) {
        User user = this.userDAO.getUser(userId);
        return this.createUserEntity(user);
    }

    public Set<UserEntity> getUsers() {
        Set users = this.userDAO.getUsers();
        return users.stream().map(user -> this.createUserEntity(user)).collect(Collectors.toSet());
    }

    private UserEntity createUserEntity(User user) {
        RevisionDTO userRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(user.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        Set userGroups = this.userGroupDAO.getUserGroupsForUser(user.getIdentifier()).stream().map(g -> g.getIdentifier()).map(this.mapUserGroupIdToTenantEntity()).collect(Collectors.toSet());
        Set policyEntities = this.userGroupDAO.getAccessPoliciesForUser(user.getIdentifier()).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
        return this.entityFactory.createUserEntity(this.dtoFactory.createUserDto(user, userGroups, policyEntities), userRevision, permissions);
    }

    private UserGroupEntity createUserGroupEntity(Group userGroup) {
        RevisionDTO userGroupRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(userGroup.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        Set users = userGroup.getUsers().stream().map(this.mapUserIdToTenantEntity()).collect(Collectors.toSet());
        Set policyEntities = this.userGroupDAO.getAccessPoliciesForUserGroup(userGroup.getIdentifier()).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
        return this.entityFactory.createUserGroupEntity(this.dtoFactory.createUserGroupDto(userGroup, users, policyEntities), userGroupRevision, permissions);
    }

    public UserGroupEntity getUserGroup(String userGroupId) {
        Group userGroup = this.userGroupDAO.getUserGroup(userGroupId);
        return this.createUserGroupEntity(userGroup);
    }

    public Set<UserGroupEntity> getUserGroups() {
        Set userGroups = this.userGroupDAO.getUserGroups();
        return userGroups.stream().map(userGroup -> this.createUserGroupEntity(userGroup)).collect(Collectors.toSet());
    }

    private LabelEntity createLabelEntity(Label label) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(label.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)label);
        return this.entityFactory.createLabelEntity(this.dtoFactory.createLabelDto(label), revision, permissions);
    }

    public Set<LabelEntity> getLabels(String groupId) {
        Set labels = this.labelDAO.getLabels(groupId);
        return labels.stream().map(label -> this.createLabelEntity(label)).collect(Collectors.toSet());
    }

    public LabelEntity getLabel(String labelId) {
        Label label = this.labelDAO.getLabel(labelId);
        return this.createLabelEntity(label);
    }

    private FunnelEntity createFunnelEntity(Funnel funnel) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(funnel.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)funnel);
        return this.entityFactory.createFunnelEntity(this.dtoFactory.createFunnelDto(funnel), revision, permissions);
    }

    public Set<FunnelEntity> getFunnels(String groupId) {
        Set funnels = this.funnelDAO.getFunnels(groupId);
        return funnels.stream().map(funnel -> this.createFunnelEntity(funnel)).collect(Collectors.toSet());
    }

    public FunnelEntity getFunnel(String funnelId) {
        Funnel funnel = this.funnelDAO.getFunnel(funnelId);
        return this.createFunnelEntity(funnel);
    }

    private PortEntity createInputPortEntity(Port port) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(port.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port);
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getInputPortStatus(port.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(port.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity(this.dtoFactory.createPortDto(port), revision, permissions, status, bulletinEntities);
    }

    private PortEntity createOutputPortEntity(Port port) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(port.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port);
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getOutputPortStatus(port.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(port.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity(this.dtoFactory.createPortDto(port), revision, permissions, status, bulletinEntities);
    }

    public Set<PortEntity> getInputPorts(String groupId) {
        Set inputPorts = this.inputPortDAO.getPorts(groupId);
        return inputPorts.stream().map(port -> this.createInputPortEntity(port)).collect(Collectors.toSet());
    }

    public Set<PortEntity> getOutputPorts(String groupId) {
        Set ports = this.outputPortDAO.getPorts(groupId);
        return ports.stream().map(port -> this.createOutputPortEntity(port)).collect(Collectors.toSet());
    }

    private ProcessGroupEntity createProcessGroupEntity(ProcessGroup group) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(group.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)group);
        ProcessGroupStatusDTO status = this.dtoFactory.createConciseProcessGroupStatusDto(this.controllerFacade.getProcessGroupStatus(group.getIdentifier()));
        List bulletins = this.getProcessGroupBulletins(group);
        return this.entityFactory.createProcessGroupEntity(this.dtoFactory.createProcessGroupDto(group), revision, permissions, status, bulletins);
    }

    private List<BulletinEntity> getProcessGroupBulletins(ProcessGroup group) {
        ArrayList bulletins = new ArrayList(this.bulletinRepository.findBulletinsForGroupBySource(group.getIdentifier()));
        for (ProcessGroup descendantGroup : group.findAllProcessGroups()) {
            bulletins.addAll(this.bulletinRepository.findBulletinsForGroupBySource(descendantGroup.getIdentifier()));
        }
        ArrayList<BulletinEntity> bulletinEntities = new ArrayList<BulletinEntity>();
        for (Bulletin bulletin : bulletins) {
            bulletinEntities.add(this.entityFactory.createBulletinEntity(this.dtoFactory.createBulletinDto(bulletin), this.authorizeBulletin(bulletin)));
        }
        return this.pruneAndSortBulletins(bulletinEntities, 5);
    }

    private List<BulletinEntity> pruneAndSortBulletins(List<BulletinEntity> bulletinEntities, int maxBulletins) {
        Collections.sort(bulletinEntities, new /* Unavailable Anonymous Inner Class!! */);
        if (bulletinEntities.size() > maxBulletins) {
            return bulletinEntities.subList(0, maxBulletins);
        }
        return bulletinEntities;
    }

    public Set<ProcessGroupEntity> getProcessGroups(String parentGroupId) {
        Set groups = this.processGroupDAO.getProcessGroups(parentGroupId);
        return groups.stream().map(group -> this.createProcessGroupEntity(group)).collect(Collectors.toSet());
    }

    private RemoteProcessGroupEntity createRemoteGroupEntity(RemoteProcessGroup rpg) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(rpg.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)rpg);
        RemoteProcessGroupStatusDTO status = this.dtoFactory.createRemoteProcessGroupStatusDto(this.controllerFacade.getRemoteProcessGroupStatus(rpg.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(rpg.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createRemoteProcessGroupEntity(this.dtoFactory.createRemoteProcessGroupDto(rpg), revision, permissions, status, bulletinEntities);
    }

    public Set<RemoteProcessGroupEntity> getRemoteProcessGroups(String groupId) {
        Set rpgs = this.remoteProcessGroupDAO.getRemoteProcessGroups(groupId);
        return rpgs.stream().map(rpg -> this.createRemoteGroupEntity(rpg)).collect(Collectors.toSet());
    }

    public PortEntity getInputPort(String inputPortId) {
        Port port = this.inputPortDAO.getPort(inputPortId);
        return this.createInputPortEntity(port);
    }

    public PortStatusEntity getInputPortStatus(String inputPortId) {
        Port inputPort = this.inputPortDAO.getPort(inputPortId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)inputPort);
        PortStatusDTO dto = this.dtoFactory.createPortStatusDto(this.controllerFacade.getInputPortStatus(inputPortId));
        return this.entityFactory.createPortStatusEntity(dto, permissions);
    }

    public PortEntity getOutputPort(String outputPortId) {
        Port port = this.outputPortDAO.getPort(outputPortId);
        return this.createOutputPortEntity(port);
    }

    public PortStatusEntity getOutputPortStatus(String outputPortId) {
        Port outputPort = this.outputPortDAO.getPort(outputPortId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)outputPort);
        PortStatusDTO dto = this.dtoFactory.createPortStatusDto(this.controllerFacade.getOutputPortStatus(outputPortId));
        return this.entityFactory.createPortStatusEntity(dto, permissions);
    }

    public RemoteProcessGroupEntity getRemoteProcessGroup(String remoteProcessGroupId) {
        RemoteProcessGroup rpg = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        return this.createRemoteGroupEntity(rpg);
    }

    public RemoteProcessGroupStatusEntity getRemoteProcessGroupStatus(String id) {
        RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(id);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroup);
        RemoteProcessGroupStatusDTO dto = this.dtoFactory.createRemoteProcessGroupStatusDto(this.controllerFacade.getRemoteProcessGroupStatus(id));
        return this.entityFactory.createRemoteProcessGroupStatusEntity(dto, permissions);
    }

    public StatusHistoryEntity getRemoteProcessGroupStatusHistory(String id) {
        RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(id);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroup);
        StatusHistoryDTO dto = this.controllerFacade.getRemoteProcessGroupStatusHistory(id);
        return this.entityFactory.createStatusHistoryEntity(dto, permissions);
    }

    public CurrentUserEntity getCurrentUser() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        CurrentUserEntity entity = new CurrentUserEntity();
        entity.setIdentity(user.getIdentity());
        entity.setAnonymous(user.isAnonymous());
        entity.setProvenancePermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getProvenance()));
        entity.setCountersPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getCounters()));
        entity.setTenantsPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant()));
        entity.setControllerPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getController()));
        entity.setPoliciesPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getPolicies()));
        entity.setSystemPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getSystem()));
        entity.setRestrictedComponentsPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getRestrictedComponents()));
        return entity;
    }

    public ProcessGroupFlowEntity getProcessGroupFlow(String groupId) {
        HashSet identifiers = new HashSet();
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        processGroup.getProcessors().stream().map(proc -> proc.getIdentifier()).forEach(id -> identifiers.add(id));
        processGroup.getConnections().stream().map(conn -> conn.getIdentifier()).forEach(id -> identifiers.add(id));
        processGroup.getInputPorts().stream().map(port -> port.getIdentifier()).forEach(id -> identifiers.add(id));
        processGroup.getOutputPorts().stream().map(port -> port.getIdentifier()).forEach(id -> identifiers.add(id));
        processGroup.getProcessGroups().stream().map(group -> group.getIdentifier()).forEach(id -> identifiers.add(id));
        processGroup.getRemoteProcessGroups().stream().map(remoteGroup -> remoteGroup.getIdentifier()).forEach(id -> identifiers.add(id));
        processGroup.getRemoteProcessGroups().stream().flatMap(remoteGroup -> remoteGroup.getInputPorts().stream()).map(remoteInputPort -> remoteInputPort.getIdentifier()).forEach(id -> identifiers.add(id));
        processGroup.getRemoteProcessGroups().stream().flatMap(remoteGroup -> remoteGroup.getOutputPorts().stream()).map(remoteOutputPort -> remoteOutputPort.getIdentifier()).forEach(id -> identifiers.add(id));
        ProcessGroupStatus groupStatus = this.controllerFacade.getProcessGroupStatus(groupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        return this.entityFactory.createProcessGroupFlowEntity(this.dtoFactory.createProcessGroupFlowDto(processGroup, groupStatus, this.revisionManager, arg_0 -> this.getProcessGroupBulletins(arg_0)), permissions);
    }

    public ProcessGroupEntity getProcessGroup(String groupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        return this.createProcessGroupEntity(processGroup);
    }

    private ControllerServiceEntity createControllerServiceEntity(ControllerServiceNode serviceNode, Set<String> serviceIds, NiFiUser user) {
        ControllerServiceDTO dto = this.dtoFactory.createControllerServiceDto(serviceNode);
        ControllerServiceReference ref = serviceNode.getReferences();
        ControllerServiceReferencingComponentsEntity referencingComponentsEntity = this.createControllerServiceReferencingComponentsEntity(ref, serviceIds);
        dto.setReferencingComponents(referencingComponentsEntity.getControllerServiceReferencingComponents());
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(serviceNode.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)serviceNode, user);
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(serviceNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createControllerServiceEntity(dto, revision, permissions, bulletinEntities);
    }

    public VariableRegistryEntity getVariableRegistry(String groupId, boolean includeAncestorGroups) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        if (processGroup == null) {
            throw new ResourceNotFoundException("Could not find group with ID " + groupId);
        }
        return this.createVariableRegistryEntity(processGroup, includeAncestorGroups);
    }

    private VariableRegistryEntity createVariableRegistryEntity(ProcessGroup processGroup, boolean includeAncestorGroups) {
        VariableRegistryDTO registryDto = this.dtoFactory.createVariableRegistryDto(processGroup, this.revisionManager);
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(processGroup.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        if (includeAncestorGroups) {
            for (ProcessGroup parent = processGroup.getParent(); parent != null; parent = parent.getParent()) {
                PermissionsDTO parentPerms = this.dtoFactory.createPermissionsDto((Authorizable)parent);
                if (!Boolean.TRUE.equals(parentPerms.getCanRead())) continue;
                VariableRegistryDTO parentRegistryDto = this.dtoFactory.createVariableRegistryDto(parent, this.revisionManager);
                Set parentVariables = parentRegistryDto.getVariables();
                registryDto.getVariables().addAll(parentVariables);
            }
        }
        return this.entityFactory.createVariableRegistryEntity(registryDto, revision, permissions);
    }

    public VariableRegistryEntity populateAffectedComponents(VariableRegistryDTO variableRegistryDto) {
        String groupId = variableRegistryDto.getProcessGroupId();
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        if (processGroup == null) {
            throw new ResourceNotFoundException("Could not find group with ID " + groupId);
        }
        VariableRegistryDTO registryDto = this.dtoFactory.populateAffectedComponents(variableRegistryDto, processGroup, this.revisionManager);
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(processGroup.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        return this.entityFactory.createVariableRegistryEntity(registryDto, revision, permissions);
    }

    public Set<ControllerServiceEntity> getControllerServices(String groupId, boolean includeAncestorGroups, boolean includeDescendantGroups) {
        return this.getControllerServices(groupId, includeAncestorGroups, includeDescendantGroups, NiFiUserUtils.getNiFiUser());
    }

    public Set<ControllerServiceEntity> getControllerServices(String groupId, boolean includeAncestorGroups, boolean includeDescendantGroups, NiFiUser user) {
        Set serviceNodes = this.controllerServiceDAO.getControllerServices(groupId, includeAncestorGroups, includeDescendantGroups);
        Set serviceIds = serviceNodes.stream().map(service -> service.getIdentifier()).collect(Collectors.toSet());
        return serviceNodes.stream().map(serviceNode -> this.createControllerServiceEntity(serviceNode, serviceIds, user)).collect(Collectors.toSet());
    }

    public ControllerServiceEntity getControllerService(String controllerServiceId) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceId);
        return this.createControllerServiceEntity(controllerService, (Set)Sets.newHashSet((Object[])new String[]{controllerServiceId}), NiFiUserUtils.getNiFiUser());
    }

    public PropertyDescriptorDTO getControllerServicePropertyDescriptor(String id, String property) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(id);
        PropertyDescriptor descriptor = controllerService.getControllerServiceImplementation().getPropertyDescriptor(property);
        if (descriptor == null) {
            descriptor = new PropertyDescriptor.Builder().name(property).addValidator(Validator.INVALID).dynamic(true).build();
        }
        String groupId = controllerService.getProcessGroup() == null ? null : controllerService.getProcessGroup().getIdentifier();
        return this.dtoFactory.createPropertyDescriptorDto(descriptor, groupId);
    }

    public ControllerServiceReferencingComponentsEntity getControllerServiceReferencingComponents(String controllerServiceId) {
        ControllerServiceNode service = this.controllerServiceDAO.getControllerService(controllerServiceId);
        ControllerServiceReference ref = service.getReferences();
        return this.createControllerServiceReferencingComponentsEntity(ref, (Set)Sets.newHashSet((Object[])new String[]{controllerServiceId}));
    }

    private ReportingTaskEntity createReportingTaskEntity(ReportingTaskNode reportingTask) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(reportingTask.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)reportingTask);
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(reportingTask.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createReportingTaskEntity(this.dtoFactory.createReportingTaskDto(reportingTask), revision, permissions, bulletinEntities);
    }

    public Set<ReportingTaskEntity> getReportingTasks() {
        Set reportingTasks = this.reportingTaskDAO.getReportingTasks();
        return reportingTasks.stream().map(reportingTask -> this.createReportingTaskEntity(reportingTask)).collect(Collectors.toSet());
    }

    public ReportingTaskEntity getReportingTask(String reportingTaskId) {
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(reportingTaskId);
        return this.createReportingTaskEntity(reportingTask);
    }

    public PropertyDescriptorDTO getReportingTaskPropertyDescriptor(String id, String property) {
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(id);
        PropertyDescriptor descriptor = reportingTask.getReportingTask().getPropertyDescriptor(property);
        if (descriptor == null) {
            descriptor = new PropertyDescriptor.Builder().name(property).addValidator(Validator.INVALID).dynamic(true).build();
        }
        return this.dtoFactory.createPropertyDescriptorDto(descriptor, null);
    }

    public StatusHistoryEntity getProcessGroupStatusHistory(String groupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        StatusHistoryDTO dto = this.controllerFacade.getProcessGroupStatusHistory(groupId);
        return this.entityFactory.createStatusHistoryEntity(dto, permissions);
    }

    private AuthorizationResult authorizeAction(Action action) {
        ControllerFacade authorizable;
        String sourceId = action.getSourceId();
        Component type = action.getSourceType();
        try {
            switch (13.$SwitchMap$org$apache$nifi$action$Component[type.ordinal()]) {
                case 1: {
                    authorizable = this.authorizableLookup.getProcessor(sourceId).getAuthorizable();
                    break;
                }
                case 2: {
                    authorizable = this.authorizableLookup.getReportingTask(sourceId).getAuthorizable();
                    break;
                }
                case 3: {
                    authorizable = this.authorizableLookup.getControllerService(sourceId).getAuthorizable();
                    break;
                }
                case 4: {
                    authorizable = this.controllerFacade;
                    break;
                }
                case 5: {
                    authorizable = this.authorizableLookup.getInputPort(sourceId);
                    break;
                }
                case 6: {
                    authorizable = this.authorizableLookup.getOutputPort(sourceId);
                    break;
                }
                case 7: {
                    authorizable = this.authorizableLookup.getProcessGroup(sourceId).getAuthorizable();
                    break;
                }
                case 8: {
                    authorizable = this.authorizableLookup.getRemoteProcessGroup(sourceId);
                    break;
                }
                case 9: {
                    authorizable = this.authorizableLookup.getFunnel(sourceId);
                    break;
                }
                case 10: {
                    authorizable = this.authorizableLookup.getConnection(sourceId).getAuthorizable();
                    break;
                }
                case 11: {
                    authorizable = this.authorizableLookup.getAccessPolicyById(sourceId);
                    break;
                }
                case 12: 
                case 13: {
                    authorizable = this.authorizableLookup.getTenant();
                    break;
                }
                default: {
                    throw new WebApplicationException(Response.serverError().entity((Object)"An unexpected type of component is the source of this action.").build());
                }
            }
        }
        catch (ResourceNotFoundException e) {
            authorizable = this.controllerFacade;
        }
        return authorizable.checkAuthorization(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
    }

    public HistoryDTO getActions(HistoryQueryDTO historyQueryDto) {
        HistoryQuery historyQuery = new HistoryQuery();
        historyQuery.setStartDate(historyQueryDto.getStartDate());
        historyQuery.setEndDate(historyQueryDto.getEndDate());
        historyQuery.setSourceId(historyQueryDto.getSourceId());
        historyQuery.setUserIdentity(historyQueryDto.getUserIdentity());
        historyQuery.setOffset(historyQueryDto.getOffset());
        historyQuery.setCount(historyQueryDto.getCount());
        historyQuery.setSortColumn(historyQueryDto.getSortColumn());
        historyQuery.setSortOrder(historyQueryDto.getSortOrder());
        History history = this.auditService.getActions(historyQuery);
        HistoryDTO historyDto = this.dtoFactory.createHistoryDto(history);
        if (history.getActions() != null) {
            ArrayList<ActionEntity> actionEntities = new ArrayList<ActionEntity>();
            for (Action action : history.getActions()) {
                AuthorizationResult result = this.authorizeAction(action);
                actionEntities.add(this.entityFactory.createActionEntity(this.dtoFactory.createActionDto(action), AuthorizationResult.Result.Approved.equals((Object)result.getResult())));
            }
            historyDto.setActions(actionEntities);
        }
        return historyDto;
    }

    public ActionEntity getAction(Integer actionId) {
        Action action = this.auditService.getAction(actionId);
        if (action == null) {
            throw new ResourceNotFoundException(String.format("Unable to find action with id '%s'.", actionId));
        }
        AuthorizationResult result = this.authorizeAction(action);
        boolean authorized = AuthorizationResult.Result.Approved.equals((Object)result.getResult());
        if (!authorized) {
            throw new AccessDeniedException(result.getExplanation());
        }
        return this.entityFactory.createActionEntity(this.dtoFactory.createActionDto(action), authorized);
    }

    public ComponentHistoryDTO getComponentHistory(String componentId) {
        LinkedHashMap propertyHistoryDtos = new LinkedHashMap();
        Map propertyHistory = this.auditService.getPreviousValues(componentId);
        for (Map.Entry entry : propertyHistory.entrySet()) {
            ArrayList<PreviousValueDTO> previousValueDtos = new ArrayList<PreviousValueDTO>();
            for (PreviousValue previousValue : (List)entry.getValue()) {
                PreviousValueDTO dto = new PreviousValueDTO();
                dto.setPreviousValue(previousValue.getPreviousValue());
                dto.setTimestamp(previousValue.getTimestamp());
                dto.setUserIdentity(previousValue.getUserIdentity());
                previousValueDtos.add(dto);
            }
            if (previousValueDtos.isEmpty()) continue;
            PropertyHistoryDTO propertyHistoryDto = new PropertyHistoryDTO();
            propertyHistoryDto.setPreviousValues(previousValueDtos);
            propertyHistoryDtos.put(entry.getKey(), propertyHistoryDto);
        }
        ComponentHistoryDTO history = new ComponentHistoryDTO();
        history.setComponentId(componentId);
        history.setPropertyHistory(propertyHistoryDtos);
        return history;
    }

    public boolean isClustered() {
        return this.controllerFacade.isClustered();
    }

    public String getNodeId() {
        NodeIdentifier nodeId = this.controllerFacade.getNodeId();
        if (nodeId != null) {
            return nodeId.getId();
        }
        return null;
    }

    public ClusterDTO getCluster() {
        ClusterDTO clusterDto = new ClusterDTO();
        clusterDto.setGenerated(new Date());
        List nodeDtos = this.clusterCoordinator.getNodeIdentifiers(new NodeConnectionState[0]).stream().map(nodeId -> this.getNode(nodeId)).collect(Collectors.toList());
        clusterDto.setNodes(nodeDtos);
        return clusterDto;
    }

    public NodeDTO getNode(String nodeId) {
        NodeIdentifier nodeIdentifier = this.clusterCoordinator.getNodeIdentifier(nodeId);
        return this.getNode(nodeIdentifier);
    }

    private NodeDTO getNode(NodeIdentifier nodeId) {
        NodeConnectionStatus nodeStatus = this.clusterCoordinator.getConnectionStatus(nodeId);
        List events = this.clusterCoordinator.getNodeEvents(nodeId);
        Set roles = this.getRoles(nodeId);
        NodeHeartbeat heartbeat = this.heartbeatMonitor.getLatestHeartbeat(nodeId);
        return this.dtoFactory.createNodeDTO(nodeId, nodeStatus, heartbeat, events, roles);
    }

    private Set<String> getRoles(NodeIdentifier nodeId) {
        HashSet<String> roles = new HashSet<String>();
        String nodeAddress = nodeId.getSocketAddress() + ":" + nodeId.getSocketPort();
        for (String roleName : ClusterRoles.getAllRoles()) {
            String leader = this.leaderElectionManager.getLeader(roleName);
            if (leader == null || !leader.equals(nodeAddress)) continue;
            roles.add(roleName);
        }
        return roles;
    }

    public void deleteNode(String nodeId) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        String userDn = user.getIdentity();
        NodeIdentifier nodeIdentifier = this.clusterCoordinator.getNodeIdentifier(nodeId);
        if (nodeIdentifier == null) {
            throw new UnknownNodeException("Cannot remove Node with ID " + nodeId + " because it is not part of the cluster");
        }
        NodeConnectionStatus nodeConnectionStatus = this.clusterCoordinator.getConnectionStatus(nodeIdentifier);
        if (!nodeConnectionStatus.getState().equals((Object)NodeConnectionState.DISCONNECTED)) {
            throw new IllegalNodeDeletionException("Cannot remove Node with ID " + nodeId + " because it is not disconnected, current state = " + nodeConnectionStatus.getState());
        }
        this.clusterCoordinator.removeNode(nodeIdentifier, userDn);
        this.heartbeatMonitor.removeHeartbeat(nodeIdentifier);
    }

    private Function<String, TenantEntity> mapUserGroupIdToTenantEntity() {
        return userGroupId -> {
            RevisionDTO userGroupRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(userGroupId));
            return this.entityFactory.createTenantEntity(this.dtoFactory.createTenantDTO(this.userGroupDAO.getUserGroup(userGroupId)), userGroupRevision, this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant()));
        };
    }

    private Function<String, TenantEntity> mapUserIdToTenantEntity() {
        return userId -> {
            RevisionDTO userRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(userId));
            return this.entityFactory.createTenantEntity(this.dtoFactory.createTenantDTO(this.userDAO.getUser(userId)), userRevision, this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant()));
        };
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setControllerFacade(ControllerFacade controllerFacade) {
        this.controllerFacade = controllerFacade;
    }

    public void setRemoteProcessGroupDAO(RemoteProcessGroupDAO remoteProcessGroupDAO) {
        this.remoteProcessGroupDAO = remoteProcessGroupDAO;
    }

    public void setLabelDAO(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    public void setFunnelDAO(FunnelDAO funnelDAO) {
        this.funnelDAO = funnelDAO;
    }

    public void setSnippetDAO(SnippetDAO snippetDAO) {
        this.snippetDAO = snippetDAO;
    }

    public void setProcessorDAO(ProcessorDAO processorDAO) {
        this.processorDAO = processorDAO;
    }

    public void setConnectionDAO(ConnectionDAO connectionDAO) {
        this.connectionDAO = connectionDAO;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setRevisionManager(RevisionManager revisionManager) {
        this.revisionManager = revisionManager;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }

    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public void setInputPortDAO(PortDAO inputPortDAO) {
        this.inputPortDAO = inputPortDAO;
    }

    public void setOutputPortDAO(PortDAO outputPortDAO) {
        this.outputPortDAO = outputPortDAO;
    }

    public void setProcessGroupDAO(ProcessGroupDAO processGroupDAO) {
        this.processGroupDAO = processGroupDAO;
    }

    public void setControllerServiceDAO(ControllerServiceDAO controllerServiceDAO) {
        this.controllerServiceDAO = controllerServiceDAO;
    }

    public void setReportingTaskDAO(ReportingTaskDAO reportingTaskDAO) {
        this.reportingTaskDAO = reportingTaskDAO;
    }

    public void setTemplateDAO(TemplateDAO templateDAO) {
        this.templateDAO = templateDAO;
    }

    public void setSnippetUtils(SnippetUtils snippetUtils) {
        this.snippetUtils = snippetUtils;
    }

    public void setAuthorizableLookup(AuthorizableLookup authorizableLookup) {
        this.authorizableLookup = authorizableLookup;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setUserGroupDAO(UserGroupDAO userGroupDAO) {
        this.userGroupDAO = userGroupDAO;
    }

    public void setAccessPolicyDAO(AccessPolicyDAO accessPolicyDAO) {
        this.accessPolicyDAO = accessPolicyDAO;
    }

    public void setClusterCoordinator(ClusterCoordinator coordinator) {
        this.clusterCoordinator = coordinator;
    }

    public void setHeartbeatMonitor(HeartbeatMonitor heartbeatMonitor) {
        this.heartbeatMonitor = heartbeatMonitor;
    }

    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.bulletinRepository = bulletinRepository;
    }

    public void setLeaderElectionManager(LeaderElectionManager leaderElectionManager) {
        this.leaderElectionManager = leaderElectionManager;
    }

    static /* synthetic */ ControllerFacade access$000(StandardNiFiServiceFacade x0) {
        return x0.controllerFacade;
    }

    static /* synthetic */ RevisionManager access$100(StandardNiFiServiceFacade x0) {
        return x0.revisionManager;
    }

    static /* synthetic */ SnippetDAO access$200(StandardNiFiServiceFacade x0) {
        return x0.snippetDAO;
    }

    static /* synthetic */ DtoFactory access$300(StandardNiFiServiceFacade x0) {
        return x0.dtoFactory;
    }

    static /* synthetic */ ProcessGroupDAO access$400(StandardNiFiServiceFacade x0) {
        return x0.processGroupDAO;
    }

    static /* synthetic */ Logger access$500() {
        return logger;
    }

    static /* synthetic */ void access$600(StandardNiFiServiceFacade x0, Resource x1) {
        x0.cleanUpPolicies(x1);
    }

    static /* synthetic */ ControllerServiceDAO access$700(StandardNiFiServiceFacade x0) {
        return x0.controllerServiceDAO;
    }

    static /* synthetic */ Set access$800(StandardNiFiServiceFacade x0, ControllerServiceReference x1) {
        return x0.findAllReferencingComponents(x1);
    }

    static /* synthetic */ ControllerServiceReferencingComponentsEntity access$900(StandardNiFiServiceFacade x0, ControllerServiceReference x1, Map x2) {
        return x0.createControllerServiceReferencingComponentsEntity(x1, x2);
    }
}

