/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Date;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.action.details.FlowChangeMoveDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.dao.ProcessGroupDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ProcessGroupAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(ProcessGroupAuditor.class);

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(org.apache.nifi.groups.ProcessGroup createProcessGroup(java.lang.String, org.apache.nifi.web.api.dto.ProcessGroupDTO))")
    public ProcessGroup createProcessGroupAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        ProcessGroup processGroup = (ProcessGroup)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(processGroup, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return processGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(org.apache.nifi.groups.ProcessGroup updateProcessGroup(org.apache.nifi.web.api.dto.ProcessGroupDTO)) && args(processGroupDTO)")
    public ProcessGroup updateProcessGroupAdvice(ProceedingJoinPoint proceedingJoinPoint, ProcessGroupDTO processGroupDTO) throws Throwable {
        ProcessGroupDAO processGroupDAO = this.getProcessGroupDAO();
        ProcessGroup processGroup = processGroupDAO.getProcessGroup(processGroupDTO.getId());
        String name = processGroup.getName();
        String comments = processGroup.getComments();
        ProcessGroup updatedProcessGroup = (ProcessGroup)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            FlowChangeConfigureDetails configDetails;
            ArrayList<FlowChangeConfigureDetails> details = new ArrayList<FlowChangeConfigureDetails>();
            if (name != null && updatedProcessGroup.getName() != null && !name.equals(updatedProcessGroup.getName())) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("name");
                configDetails.setValue(updatedProcessGroup.getName());
                configDetails.setPreviousValue(name);
                details.add(configDetails);
            }
            if (comments != null && updatedProcessGroup.getComments() != null && !comments.equals(updatedProcessGroup.getComments())) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("comments");
                configDetails.setValue(updatedProcessGroup.getComments());
                configDetails.setPreviousValue(comments);
                details.add(configDetails);
            }
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            if (!details.isEmpty()) {
                Date timestamp = new Date();
                for (ActionDetails actionDetails : details) {
                    Operation operation = Operation.Configure;
                    if (actionDetails instanceof FlowChangeMoveDetails) {
                        operation = Operation.Move;
                    }
                    FlowChangeAction processGroupAction = new FlowChangeAction();
                    processGroupAction.setUserIdentity(user.getIdentity());
                    processGroupAction.setOperation(operation);
                    processGroupAction.setTimestamp(timestamp);
                    processGroupAction.setSourceId(updatedProcessGroup.getIdentifier());
                    processGroupAction.setSourceName(updatedProcessGroup.getName());
                    processGroupAction.setSourceType(Component.ProcessGroup);
                    processGroupAction.setActionDetails(actionDetails);
                    actions.add(processGroupAction);
                }
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedProcessGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(void scheduleComponents(java.lang.String, org.apache.nifi.controller.ScheduledState, java.util.Set)) && args(groupId, state)")
    public void scheduleComponentsAdvice(ProceedingJoinPoint proceedingJoinPoint, String groupId, ScheduledState state) throws Throwable {
        Operation operation = ScheduledState.RUNNING.equals((Object)state) ? Operation.Start : Operation.Stop;
        this.saveUpdateAction(proceedingJoinPoint, groupId, operation);
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(java.util.concurrent.Future activateControllerServices(java.lang.String, org.apache.nifi.controller.service.ControllerServiceState, java.util.Set)) && args(groupId, state)")
    public void activateControllerServicesAdvice(ProceedingJoinPoint proceedingJoinPoint, String groupId, ControllerServiceState state) throws Throwable {
        Operation operation = ControllerServiceState.ENABLED.equals((Object)state) ? Operation.Enable : Operation.Disable;
        this.saveUpdateAction(proceedingJoinPoint, groupId, operation);
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(org.apache.nifi.groups.ProcessGroup updateVariableRegistry(org.apache.nifi.web.api.dto.VariableRegistryDTO)) && args(groupId)")
    public void updateVariableRegistryAdvice(ProceedingJoinPoint proceedingJoinPoint, String groupId) throws Throwable {
        Operation operation = Operation.Configure;
        this.saveUpdateAction(proceedingJoinPoint, groupId, operation);
    }

    private void saveUpdateAction(ProceedingJoinPoint proceedingJoinPoint, String groupId, Operation operation) throws Throwable {
        ProcessGroupDAO processGroupDAO = this.getProcessGroupDAO();
        ProcessGroup processGroup = processGroupDAO.getProcessGroup(groupId);
        proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        FlowChangeAction action = new FlowChangeAction();
        action.setUserIdentity(user.getIdentity());
        action.setSourceId(processGroup.getIdentifier());
        action.setSourceName(processGroup.getName());
        action.setSourceType(Component.ProcessGroup);
        action.setTimestamp(new Date());
        action.setOperation(operation);
        this.saveAction((Action)action, logger);
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(void deleteProcessGroup(java.lang.String)) && args(groupId)")
    public void removeProcessGroupAdvice(ProceedingJoinPoint proceedingJoinPoint, String groupId) throws Throwable {
        ProcessGroupDAO processGroupDAO = this.getProcessGroupDAO();
        ProcessGroup processGroup = processGroupDAO.getProcessGroup(groupId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(processGroup, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public Action generateAuditRecord(ProcessGroup processGroup, Operation operation) {
        return this.generateAuditRecord(processGroup, operation, null);
    }

    public Action generateAuditRecord(ProcessGroup processGroup, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(processGroup.getIdentifier());
            action.setSourceName(processGroup.getName());
            action.setSourceType(Component.ProcessGroup);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }
}

