/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.dao.ProcessGroupDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;

public class StandardProcessGroupDAO
extends ComponentDAO
implements ProcessGroupDAO {
    private FlowController flowController;

    public ProcessGroup createProcessGroup(String parentGroupId, ProcessGroupDTO processGroup) {
        if (processGroup.getParentGroupId() != null && !this.flowController.areGroupsSame(processGroup.getParentGroupId(), parentGroupId)) {
            throw new IllegalArgumentException("Cannot specify a different Parent Group ID than the Group to which the Process Group is being added.");
        }
        ProcessGroup parentGroup = this.locateProcessGroup(this.flowController, parentGroupId);
        ProcessGroup group = this.flowController.createProcessGroup(processGroup.getId());
        group.setName(processGroup.getName());
        if (processGroup.getPosition() != null) {
            group.setPosition(new Position(processGroup.getPosition().getX().doubleValue(), processGroup.getPosition().getY().doubleValue()));
        }
        group.setParent(parentGroup);
        parentGroup.addProcessGroup(group);
        return group;
    }

    public boolean hasProcessGroup(String groupId) {
        return this.flowController.getGroup(groupId) != null;
    }

    public ProcessGroup getProcessGroup(String groupId) {
        return this.locateProcessGroup(this.flowController, groupId);
    }

    public Set<ProcessGroup> getProcessGroups(String parentGroupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, parentGroupId);
        return group.getProcessGroups();
    }

    public void verifyScheduleComponents(String groupId, ScheduledState state, Set<String> componentIds) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        HashSet<Connectable> connectables = new HashSet<Connectable>(componentIds.size());
        for (String componentId : componentIds) {
            Connectable connectable2 = group.findLocalConnectable(componentId);
            if (connectable2 == null) {
                throw new ResourceNotFoundException("Unable to find component with id " + componentId);
            }
            connectables.add(connectable2);
        }
        connectables.forEach(connectable -> {
            if (ScheduledState.RUNNING.equals((Object)state)) {
                group.verifyCanStart(connectable);
            } else {
                group.verifyCanStop(connectable);
            }
        });
    }

    public void scheduleComponents(String groupId, ScheduledState state, Set<String> componentIds) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        for (String componentId : componentIds) {
            Connectable connectable = group.findLocalConnectable(componentId);
            if (ScheduledState.RUNNING.equals((Object)state)) {
                if (ConnectableType.PROCESSOR.equals((Object)connectable.getConnectableType())) {
                    connectable.getProcessGroup().startProcessor((ProcessorNode)connectable);
                    continue;
                }
                if (ConnectableType.INPUT_PORT.equals((Object)connectable.getConnectableType())) {
                    connectable.getProcessGroup().startInputPort((Port)connectable);
                    continue;
                }
                if (!ConnectableType.OUTPUT_PORT.equals((Object)connectable.getConnectableType())) continue;
                connectable.getProcessGroup().startOutputPort((Port)connectable);
                continue;
            }
            if (ConnectableType.PROCESSOR.equals((Object)connectable.getConnectableType())) {
                connectable.getProcessGroup().stopProcessor((ProcessorNode)connectable);
                continue;
            }
            if (ConnectableType.INPUT_PORT.equals((Object)connectable.getConnectableType())) {
                connectable.getProcessGroup().stopInputPort((Port)connectable);
                continue;
            }
            if (!ConnectableType.OUTPUT_PORT.equals((Object)connectable.getConnectableType())) continue;
            connectable.getProcessGroup().stopOutputPort((Port)connectable);
        }
    }

    public ProcessGroup updateProcessGroup(ProcessGroupDTO processGroupDTO) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, processGroupDTO.getId());
        String name = processGroupDTO.getName();
        String comments = processGroupDTO.getComments();
        if (this.isNotNull((Object)name)) {
            group.setName(name);
        }
        if (this.isNotNull((Object)processGroupDTO.getPosition())) {
            group.setPosition(new Position(processGroupDTO.getPosition().getX().doubleValue(), processGroupDTO.getPosition().getY().doubleValue()));
        }
        if (this.isNotNull((Object)comments)) {
            group.setComments(comments);
        }
        return group;
    }

    public void verifyDelete(String groupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        group.verifyCanDelete();
    }

    public void deleteProcessGroup(String processGroupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, processGroupId);
        ProcessGroup parentGroup = group.getParent();
        if (parentGroup == null) {
            throw new IllegalArgumentException("The Root Group cannot be removed");
        }
        parentGroup.removeProcessGroup(group);
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

