/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.nifi.web.api.config.JsonMappingExceptionMapper;
import org.codehaus.jackson.JsonParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JsonParseExceptionMapper
implements ExceptionMapper<JsonParseException> {
    private static final Logger logger = LoggerFactory.getLogger(JsonMappingExceptionMapper.class);

    public Response toResponse(JsonParseException ex) {
        logger.info(String.format("%s. Returning %s response.", ex, Response.Status.BAD_REQUEST));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)ex);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Unable to parse body as JSON.").type("text/plain").build();
    }
}

