/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.Map;
import java.util.Objects;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.web.ResourceNotFoundException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AuthorizeControllerServiceReference {
    public static void authorizeControllerServiceReferences(ComponentAuthorizable authorizable, Authorizer authorizer, AuthorizableLookup lookup, boolean authorizeTransitiveServices) {
        authorizable.getPropertyDescriptors().stream().forEach(descriptor -> {
            String serviceId;
            if (descriptor.getControllerServiceDefinition() != null && (serviceId = authorizable.getValue(descriptor)) != null) {
                try {
                    ComponentAuthorizable currentServiceAuthorizable = lookup.getControllerService(serviceId);
                    currentServiceAuthorizable.getAuthorizable().authorize(authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
                    if (authorizeTransitiveServices) {
                        AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)currentServiceAuthorizable, (Authorizer)authorizer, (AuthorizableLookup)lookup, (boolean)authorizeTransitiveServices);
                    }
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    public static void authorizeControllerServiceReferences(Map<String, String> proposedProperties, ComponentAuthorizable authorizable, Authorizer authorizer, AuthorizableLookup lookup) {
        if (proposedProperties != null) {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            for (Map.Entry<String, String> entry : proposedProperties.entrySet()) {
                String proposedValue;
                String currentValue;
                String propertyName = entry.getKey();
                PropertyDescriptor propertyDescriptor = authorizable.getPropertyDescriptor(propertyName);
                if (propertyDescriptor.getControllerServiceDefinition() == null || Objects.equals(currentValue = authorizable.getValue(propertyDescriptor), proposedValue = entry.getValue())) continue;
                if (currentValue != null) {
                    try {
                        Authorizable currentServiceAuthorizable = lookup.getControllerService(currentValue).getAuthorizable();
                        currentServiceAuthorizable.authorize(authorizer, RequestAction.READ, user);
                    }
                    catch (ResourceNotFoundException currentServiceAuthorizable) {
                        // empty catch block
                    }
                }
                if (proposedValue == null) continue;
                Authorizable newServiceAuthorizable = lookup.getControllerService(proposedValue).getAuthorizable();
                newServiceAuthorizable.authorize(authorizer, RequestAction.READ, user);
            }
        }
    }
}

