/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import org.apache.nifi.web.util.Interval;

final class ClosedOpenInterval
implements Interval {
    private final int lowerBoundary;
    private final int higherBoundary;

    ClosedOpenInterval(int lowerBoundary, int higherBoundary) {
        if (lowerBoundary < 0) {
            throw new IllegalArgumentException("Lower boundary cannot be negative");
        }
        if (higherBoundary < 0) {
            throw new IllegalArgumentException("Higher boundary cannot be negative");
        }
        if (higherBoundary <= lowerBoundary && higherBoundary != 0) {
            throw new IllegalArgumentException("Higher boundary cannot be lower than or equal to lower boundary except when unspecified. Higher boundary is considered unspecified when the value is set to 0");
        }
        this.lowerBoundary = lowerBoundary;
        this.higherBoundary = higherBoundary;
    }

    public Interval.RelativePosition getRelativePositionOf(int otherIntervalLowerBoundary, int otherIntervalHigherBoundary) {
        if (otherIntervalLowerBoundary < 0) {
            throw new IllegalArgumentException("Lower boundary cannot be negative");
        }
        if (otherIntervalHigherBoundary <= 0) {
            throw new IllegalArgumentException("Higher boundary must be positive");
        }
        if (otherIntervalLowerBoundary >= otherIntervalHigherBoundary) {
            throw new IllegalArgumentException("Higher boundary must be greater than lower boundary");
        }
        if (otherIntervalHigherBoundary <= this.lowerBoundary) {
            return Interval.RelativePosition.BEFORE;
        }
        if (otherIntervalLowerBoundary < this.lowerBoundary && otherIntervalHigherBoundary > this.higherBoundary && !this.isEndUnspecified()) {
            return Interval.RelativePosition.EXCEEDS;
        }
        if (otherIntervalLowerBoundary < this.lowerBoundary) {
            return Interval.RelativePosition.TAIL_INTERSECTS;
        }
        if (otherIntervalHigherBoundary <= this.higherBoundary || this.isEndUnspecified()) {
            return Interval.RelativePosition.WITHIN;
        }
        if (otherIntervalLowerBoundary < this.higherBoundary) {
            return Interval.RelativePosition.HEAD_INTERSECTS;
        }
        return Interval.RelativePosition.AFTER;
    }

    private boolean isEndUnspecified() {
        return this.higherBoundary == 0;
    }
}

