/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.search.query.MapBasedSearchQuery;
import org.apache.nifi.web.search.query.SearchQuery;
import org.apache.nifi.web.search.query.SearchQueryParser;

public class RegexSearchQueryParser
implements SearchQueryParser {
    private static final String REGEX = "(?<filter>(\\w+:[\\w-]+\\s+)*(\\w+:[\\w-]+)?)(?<term>.*)";
    private static final String FILTER_TOKEN_SEPARATOR = "\\:";
    private static final String FILTER_SEPARATOR = "[\\s]+";
    private static final String FILTER_GROUP = "filter";
    private static final String TERM_GROUP = "term";
    private final Pattern pattern = Pattern.compile("(?<filter>(\\w+:[\\w-]+\\s+)*(\\w+:[\\w-]+)?)(?<term>.*)");

    public SearchQuery parse(String searchLiteral, NiFiUser user, ProcessGroup rootGroup, ProcessGroup activeGroup) {
        Matcher matcher = this.pattern.matcher(searchLiteral);
        if (matcher.matches()) {
            String term = matcher.group(TERM_GROUP);
            String filters = matcher.group(FILTER_GROUP);
            return new MapBasedSearchQuery(term, this.processFilters(filters), user, rootGroup, activeGroup);
        }
        return new MapBasedSearchQuery(searchLiteral, Collections.emptyMap(), user, rootGroup, activeGroup);
    }

    private Map<String, String> processFilters(String filters) {
        return Arrays.stream(filters.split(FILTER_SEPARATOR)).map(token -> token.split(FILTER_TOKEN_SEPARATOR)).filter(filter -> ((String[])filter).length == 2).collect(Collectors.toMap(filter -> filter[0].trim(), filter -> filter[1].trim(), (first, second) -> first));
    }
}

