/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.firewall.RequestRejectedException;

public class ExceptionFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionFilter.class);

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        try {
            filterChain.doFilter(req, resp);
        }
        catch (RequestRejectedException e) {
            logger.warn("Client request rejected", (Throwable)e);
            HttpServletResponse filteredResponse = (HttpServletResponse)resp;
            filteredResponse.setStatus(500);
            filteredResponse.getWriter().write("Client request rejected");
        }
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }
}

