/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.concurrent;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRequestManager<R, T>
implements RequestManager<R, T> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncRequestManager.class);
    private final long requestExpirationMillis;
    private final int maxConcurrentRequests;
    private final ConcurrentMap<String, AsynchronousWebRequest<R, T>> requests = new ConcurrentHashMap();
    private final ExecutorService threadPool;

    public AsyncRequestManager(int maxConcurrentRequests, long requestExpirationMillis, String threadNamePrefix) {
        this.requestExpirationMillis = requestExpirationMillis;
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.threadPool = new ThreadPoolExecutor(1, maxConcurrentRequests, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getKey(String type, String request) {
        return type + "/" + request;
    }

    public void submitRequest(String type, String requestId, AsynchronousWebRequest<R, T> request, Consumer<AsynchronousWebRequest<R, T>> task) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(requestId);
        Objects.requireNonNull(request);
        Objects.requireNonNull(task);
        Date oneMinuteAgo = new Date(System.currentTimeMillis() - this.requestExpirationMillis);
        List<String> completedRequestIds = this.requests.entrySet().stream().filter(entry -> ((AsynchronousWebRequest)entry.getValue()).isComplete()).filter(entry -> ((AsynchronousWebRequest)entry.getValue()).getLastUpdated().before(oneMinuteAgo)).map(Map.Entry::getKey).collect(Collectors.toList());
        completedRequestIds.forEach(this.requests::remove);
        int requestCount = this.requests.size();
        if (requestCount > this.maxConcurrentRequests) {
            throw new IllegalStateException("There are already " + requestCount + " update requests for variable registries. Cannot issue any more requests until the older ones are deleted or expire");
        }
        String key = this.getKey(type, requestId);
        AsynchronousWebRequest<R, T> existing = this.requests.putIfAbsent(key, request);
        if (existing != null) {
            throw new IllegalArgumentException("A requests already exists with this ID and type");
        }
        this.threadPool.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public AsynchronousWebRequest<R, T> removeRequest(String type, String id, NiFiUser user) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(id);
        Objects.requireNonNull(user);
        String key = this.getKey(type, id);
        AsynchronousWebRequest request = (AsynchronousWebRequest)this.requests.get(key);
        if (request == null) {
            throw new ResourceNotFoundException("Could not find a Request with identifier " + id);
        }
        if (!request.getUser().equals(user)) {
            throw new IllegalArgumentException("Only the user that submitted the update request can delete it.");
        }
        if (!request.isComplete()) {
            request.cancel();
        }
        this.requests.remove(key);
        return request;
    }

    public AsynchronousWebRequest<R, T> getRequest(String type, String id, NiFiUser user) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(id);
        Objects.requireNonNull(user);
        String key = this.getKey(type, id);
        AsynchronousWebRequest request = (AsynchronousWebRequest)this.requests.get(key);
        if (request == null) {
            throw new ResourceNotFoundException("Could not find a Request with identifier " + id);
        }
        if (!request.getUser().equals(user)) {
            throw new IllegalArgumentException("Only the user that submitted the update request can delete it.");
        }
        return request;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

