/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.component.details.FlowChangeRemoteProcessGroupDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.ConnectDetails;
import org.apache.nifi.action.details.FlowChangeConnectDetails;
import org.apache.nifi.audit.FunnelAuditor;
import org.apache.nifi.audit.LabelAuditor;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.audit.PortAuditor;
import org.apache.nifi.audit.ProcessGroupAuditor;
import org.apache.nifi.audit.ProcessorAuditor;
import org.apache.nifi.audit.RelationshipAuditor;
import org.apache.nifi.audit.RemoteProcessGroupAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.SnippetDTO;
import org.apache.nifi.web.dao.ConnectionDAO;
import org.apache.nifi.web.dao.FunnelDAO;
import org.apache.nifi.web.dao.LabelDAO;
import org.apache.nifi.web.dao.PortDAO;
import org.apache.nifi.web.dao.ProcessGroupDAO;
import org.apache.nifi.web.dao.ProcessorDAO;
import org.apache.nifi.web.dao.RemoteProcessGroupDAO;
import org.apache.nifi.web.dao.SnippetDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class SnippetAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(SnippetAuditor.class);
    private PortDAO inputPortDAO;
    private PortDAO outputPortDAO;
    private RemoteProcessGroupDAO remoteProcessGroupDAO;
    private ProcessorDAO processorDAO;
    private FunnelDAO funnelDAO;
    private ConnectionDAO connectionDAO;
    private LabelDAO labelDAO;
    private PortAuditor portAuditor;
    private RemoteProcessGroupAuditor remoteProcessGroupAuditor;
    private ProcessGroupAuditor processGroupAuditor;
    private ProcessorAuditor processorAuditor;
    private FunnelAuditor funnelAuditor;
    private RelationshipAuditor relationshipAuditor;
    private LabelAuditor labelAuditor;

    @Around(value="within(org.apache.nifi.web.dao.SnippetDAO+) && execution(org.apache.nifi.web.api.dto.FlowSnippetDTO copySnippet(java.lang.String, java.lang.String, java.lang.Double, java.lang.Double, java.lang.String))")
    public FlowSnippetDTO copySnippetAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        FlowSnippetDTO snippet = (FlowSnippetDTO)proceedingJoinPoint.proceed();
        this.auditSnippet(snippet);
        return snippet;
    }

    @Around(value="within(org.apache.nifi.web.dao.TemplateDAO+) && execution(org.apache.nifi.web.api.dto.FlowSnippetDTO instantiateTemplate(java.lang.String, java.lang.Double, java.lang.Double, java.lang.String, org.apache.nifi.web.api.dto.FlowSnippetDTO, java.lang.String))")
    public FlowSnippetDTO instantiateTemplateAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        FlowSnippetDTO snippet = (FlowSnippetDTO)proceedingJoinPoint.proceed();
        this.auditSnippet(snippet);
        return snippet;
    }

    private void auditSnippet(FlowSnippetDTO snippet) {
        FlowChangeAction action;
        ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
        Date timestamp = new Date();
        for (PortDTO inputPort : snippet.getInputPorts()) {
            actions.add(this.generateAuditRecord(inputPort.getId(), inputPort.getName(), Component.InputPort, Operation.Add, timestamp));
        }
        for (PortDTO outputPort : snippet.getOutputPorts()) {
            actions.add(this.generateAuditRecord(outputPort.getId(), outputPort.getName(), Component.OutputPort, Operation.Add, timestamp));
        }
        for (RemoteProcessGroupDTO remoteProcessGroup : snippet.getRemoteProcessGroups()) {
            FlowChangeRemoteProcessGroupDetails remoteProcessGroupDetails = new FlowChangeRemoteProcessGroupDetails();
            remoteProcessGroupDetails.setUri(remoteProcessGroup.getTargetUri());
            action = this.generateAuditRecord(remoteProcessGroup.getId(), remoteProcessGroup.getName(), Component.RemoteProcessGroup, Operation.Add, timestamp);
            action.setComponentDetails((ComponentDetails)remoteProcessGroupDetails);
            actions.add(action);
        }
        for (ProcessGroupDTO processGroup : snippet.getProcessGroups()) {
            actions.add(this.generateAuditRecord(processGroup.getId(), processGroup.getName(), Component.ProcessGroup, Operation.Add, timestamp));
        }
        for (ProcessorDTO processor : snippet.getProcessors()) {
            FlowChangeExtensionDetails processorDetails = new FlowChangeExtensionDetails();
            processorDetails.setType(StringUtils.substringAfterLast((String)processor.getType(), (String)"."));
            action = this.generateAuditRecord(processor.getId(), processor.getName(), Component.Processor, Operation.Add, timestamp);
            action.setComponentDetails((ComponentDetails)processorDetails);
            actions.add(action);
        }
        for (FunnelDTO funnel : snippet.getFunnels()) {
            actions.add(this.generateAuditRecord(funnel.getId(), "", Component.Funnel, Operation.Add, timestamp));
        }
        for (ConnectionDTO connection : snippet.getConnections()) {
            ConnectableDTO source = connection.getSource();
            ConnectableDTO destination = connection.getDestination();
            String relationships = CollectionUtils.isEmpty((Collection)connection.getSelectedRelationships()) ? "" : StringUtils.join((Iterable)connection.getSelectedRelationships(), (String)", ");
            String name = StringUtils.isBlank((CharSequence)connection.getName()) ? relationships : connection.getName();
            FlowChangeConnectDetails connectDetails = new FlowChangeConnectDetails();
            connectDetails.setSourceId(source.getId());
            connectDetails.setSourceName(source.getName());
            connectDetails.setSourceType(this.determineConnectableType(source));
            connectDetails.setRelationship(relationships);
            connectDetails.setDestinationId(destination.getId());
            connectDetails.setDestinationName(destination.getName());
            connectDetails.setDestinationType(this.determineConnectableType(destination));
            FlowChangeAction action2 = this.generateAuditRecord(connection.getId(), name, Component.Connection, Operation.Connect, timestamp);
            action2.setActionDetails((ActionDetails)connectDetails);
            actions.add(action2);
        }
        if (!actions.isEmpty()) {
            this.saveActions(actions, logger);
        }
    }

    private Component determineConnectableType(ConnectableDTO connectable) {
        Component component = Component.Controller;
        String connectableType = connectable.getType();
        component = ConnectableType.PROCESSOR.name().equals(connectableType) ? Component.Processor : (ConnectableType.INPUT_PORT.name().equals(connectableType) ? Component.InputPort : (ConnectableType.OUTPUT_PORT.name().equals(connectableType) ? Component.OutputPort : (ConnectableType.FUNNEL.name().equals(connectableType) ? Component.Funnel : Component.RemoteProcessGroup)));
        return component;
    }

    private FlowChangeAction generateAuditRecord(String id, String name, Component type, Operation operation, Date timestamp) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(timestamp);
            action.setSourceId(id);
            action.setSourceName(name);
            action.setSourceType(type);
        }
        return action;
    }

    @Around(value="within(org.apache.nifi.web.dao.SnippetDAO+) && execution(org.apache.nifi.controller.Snippet updateSnippetComponents(org.apache.nifi.web.api.dto.SnippetDTO)) && args(snippetDTO) && target(snippetDAO)")
    public Snippet updateSnippetAdvice(ProceedingJoinPoint proceedingJoinPoint, SnippetDTO snippetDTO, SnippetDAO snippetDAO) throws Throwable {
        Snippet snippet = snippetDAO.getSnippet(snippetDTO.getId());
        String previousGroupId = snippet.getParentGroupId();
        snippet = (Snippet)proceedingJoinPoint.proceed();
        String groupId = snippetDTO.getParentGroupId();
        if (!previousGroupId.equals(groupId)) {
            Port port;
            Action action;
            ArrayList<Action> actions = new ArrayList<Action>();
            for (String id : snippet.getProcessors().keySet()) {
                ProcessorNode processor = this.processorDAO.getProcessor(id);
                action = this.processorAuditor.generateAuditRecord(processor, Operation.Move, (ActionDetails)this.createMoveDetails(previousGroupId, groupId, logger));
                if (action == null) continue;
                actions.add(action);
            }
            for (String id : snippet.getFunnels().keySet()) {
                Funnel funnel = this.funnelDAO.getFunnel(id);
                action = this.funnelAuditor.generateAuditRecord(funnel, Operation.Move, (ActionDetails)this.createMoveDetails(previousGroupId, groupId, logger));
                if (action == null) continue;
                actions.add(action);
            }
            for (String id : snippet.getInputPorts().keySet()) {
                port = this.inputPortDAO.getPort(id);
                action = this.portAuditor.generateAuditRecord(port, Operation.Move, (ActionDetails)this.createMoveDetails(previousGroupId, groupId, logger));
                if (action == null) continue;
                actions.add(action);
            }
            for (String id : snippet.getOutputPorts().keySet()) {
                port = this.outputPortDAO.getPort(id);
                action = this.portAuditor.generateAuditRecord(port, Operation.Move, (ActionDetails)this.createMoveDetails(previousGroupId, groupId, logger));
                if (action == null) continue;
                actions.add(action);
            }
            for (String id : snippet.getRemoteProcessGroups().keySet()) {
                RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(id);
                action = this.remoteProcessGroupAuditor.generateAuditRecord(remoteProcessGroup, Operation.Move, (ActionDetails)this.createMoveDetails(previousGroupId, groupId, logger));
                if (action == null) continue;
                actions.add(action);
            }
            for (String id : snippet.getProcessGroups().keySet()) {
                ProcessGroupDAO processGroupDAO = this.getProcessGroupDAO();
                ProcessGroup processGroup = processGroupDAO.getProcessGroup(id);
                Action action2 = this.processGroupAuditor.generateAuditRecord(processGroup, Operation.Move, (ActionDetails)this.createMoveDetails(previousGroupId, groupId, logger));
                if (action2 == null) continue;
                actions.add(action2);
            }
            for (String id : snippet.getConnections().keySet()) {
                Connection connection = this.connectionDAO.getConnection(id);
                action = this.relationshipAuditor.generateAuditRecordForConnection(connection, Operation.Move, (ActionDetails)this.createMoveDetails(previousGroupId, groupId, logger));
                if (action == null) continue;
                actions.add(action);
            }
            for (String id : snippet.getLabels().keySet()) {
                Label label = this.labelDAO.getLabel(id);
                action = this.labelAuditor.generateAuditRecord(label, Operation.Move, (ActionDetails)this.createMoveDetails(previousGroupId, groupId, logger));
                if (action == null) continue;
                actions.add(action);
            }
            if (CollectionUtils.isNotEmpty(actions)) {
                this.saveActions(actions, logger);
            }
        }
        return snippet;
    }

    @Around(value="within(org.apache.nifi.web.dao.SnippetDAO+) && execution(void deleteSnippetComponents(java.lang.String)) && args(snippetId) && target(snippetDAO)")
    public void removeSnippetAdvice(ProceedingJoinPoint proceedingJoinPoint, String snippetId, SnippetDAO snippetDAO) throws Throwable {
        Action action;
        Snippet snippet = snippetDAO.getSnippet(snippetId);
        HashSet<Funnel> funnels = new HashSet<Funnel>();
        for (Object id : snippet.getFunnels().keySet()) {
            funnels.add(this.funnelDAO.getFunnel((String)id));
        }
        HashSet<Port> inputPorts = new HashSet<Port>();
        for (Object id : snippet.getInputPorts().keySet()) {
            inputPorts.add(this.inputPortDAO.getPort((String)id));
        }
        HashSet<Port> outputPorts = new HashSet<Port>();
        for (Object id : snippet.getOutputPorts().keySet()) {
            outputPorts.add(this.outputPortDAO.getPort((String)id));
        }
        HashSet<RemoteProcessGroup> remoteProcessGroups = new HashSet<RemoteProcessGroup>();
        for (String id : snippet.getRemoteProcessGroups().keySet()) {
            remoteProcessGroups.add(this.remoteProcessGroupDAO.getRemoteProcessGroup(id));
        }
        HashSet<ProcessGroup> processGroups = new HashSet<ProcessGroup>();
        ProcessGroupDAO processGroupDAO = this.getProcessGroupDAO();
        for (Object id : snippet.getProcessGroups().keySet()) {
            processGroups.add(processGroupDAO.getProcessGroup((String)id));
        }
        HashSet<ProcessorNode> processors = new HashSet<ProcessorNode>();
        for (Object id : snippet.getProcessors().keySet()) {
            processors.add(this.processorDAO.getProcessor((String)id));
        }
        HashSet<Connection> connections = new HashSet<Connection>();
        for (Object id : snippet.getConnections().keySet()) {
            connections.add(this.connectionDAO.getConnection((String)id));
        }
        HashSet<Label> labels = new HashSet<Label>();
        for (String id : snippet.getLabels().keySet()) {
            labels.add(this.labelDAO.getLabel(id));
        }
        proceedingJoinPoint.proceed();
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Funnel funnel : funnels) {
            action = this.funnelAuditor.generateAuditRecord(funnel, Operation.Remove);
            if (action == null) continue;
            actions.add(action);
        }
        for (Port inputPort : inputPorts) {
            action = this.portAuditor.generateAuditRecord(inputPort, Operation.Remove);
            if (action == null) continue;
            actions.add(action);
        }
        for (Port outputPort : outputPorts) {
            action = this.portAuditor.generateAuditRecord(outputPort, Operation.Remove);
            if (action == null) continue;
            actions.add(action);
        }
        for (RemoteProcessGroup remoteProcessGroup : remoteProcessGroups) {
            action = this.remoteProcessGroupAuditor.generateAuditRecord(remoteProcessGroup, Operation.Remove);
            if (action == null) continue;
            actions.add(action);
        }
        for (ProcessGroup processGroup : processGroups) {
            action = this.processGroupAuditor.generateAuditRecord(processGroup, Operation.Remove);
            if (action == null) continue;
            actions.add(action);
        }
        for (ProcessorNode processor : processors) {
            action = this.processorAuditor.generateAuditRecord(processor, Operation.Remove);
            if (action == null) continue;
            actions.add(action);
        }
        for (Connection connection : connections) {
            ConnectDetails connectDetails;
            Action action2 = this.relationshipAuditor.generateAuditRecordForConnection(connection, Operation.Disconnect, (ActionDetails)(connectDetails = this.relationshipAuditor.createConnectDetails(connection, connection.getRelationships())));
            if (action2 == null) continue;
            actions.add(action2);
        }
        for (Label label : labels) {
            action = this.labelAuditor.generateAuditRecord(label, Operation.Remove);
            if (action == null) continue;
            actions.add(action);
        }
        if (CollectionUtils.isNotEmpty(actions)) {
            this.saveActions(actions, logger);
        }
    }

    public void setFunnelDAO(FunnelDAO funnelDAO) {
        this.funnelDAO = funnelDAO;
    }

    public void setInputPortDAO(PortDAO inputPortDAO) {
        this.inputPortDAO = inputPortDAO;
    }

    public void setOutputPortDAO(PortDAO outputPortDAO) {
        this.outputPortDAO = outputPortDAO;
    }

    public void setPortAuditor(PortAuditor portAuditor) {
        this.portAuditor = portAuditor;
    }

    public void setFunnelAuditor(FunnelAuditor funnelAuditor) {
        this.funnelAuditor = funnelAuditor;
    }

    public void setProcessGroupAuditor(ProcessGroupAuditor processGroupAuditor) {
        this.processGroupAuditor = processGroupAuditor;
    }

    public void setRemoteProcessGroupAuditor(RemoteProcessGroupAuditor remoteProcessGroupAuditor) {
        this.remoteProcessGroupAuditor = remoteProcessGroupAuditor;
    }

    public void setLabelAuditor(LabelAuditor labelAuditor) {
        this.labelAuditor = labelAuditor;
    }

    public void setRemoteProcessGroupDAO(RemoteProcessGroupDAO remoteProcessGroupDAO) {
        this.remoteProcessGroupDAO = remoteProcessGroupDAO;
    }

    public void setConnectionDAO(ConnectionDAO connectionDAO) {
        this.connectionDAO = connectionDAO;
    }

    public void setProcessorAuditor(ProcessorAuditor processorAuditor) {
        this.processorAuditor = processorAuditor;
    }

    public void setProcessorDAO(ProcessorDAO processorDAO) {
        this.processorDAO = processorDAO;
    }

    public void setLabelDAO(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    public void setRelationshipAuditor(RelationshipAuditor relationshipAuditor) {
        this.relationshipAuditor = relationshipAuditor;
    }
}

