/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.logging.NiFiLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger
implements Filter {
    private static final Logger logger = new NiFiLog(LoggerFactory.getLogger(RequestLogger.class));

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        if ("http".equalsIgnoreCase(request.getScheme())) {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            String identity = "<no user found>";
            if (user != null) {
                identity = user.getIdentity();
            }
            logger.info(String.format("Attempting request for (%s) %s %s (source ip: %s)", identity, request.getMethod(), request.getRequestURL().toString(), request.getRemoteAddr()));
        }
        filterChain.doFilter(req, resp);
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }
}

