/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.dao.AccessPolicyDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AccessPolicyAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(AccessPolicyAuditor.class);
    private static final String USERS = "Users";
    private static final String USER_GROUPS = "User Groups";

    @Around(value="within(org.apache.nifi.web.dao.AccessPolicyDAO+) && execution(org.apache.nifi.authorization.AccessPolicy createAccessPolicy(org.apache.nifi.web.api.dto.AccessPolicyDTO))")
    public AccessPolicy createAccessPolicyAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        AccessPolicy policy = (AccessPolicy)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(policy, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return policy;
    }

    @Around(value="within(org.apache.nifi.web.dao.AccessPolicyDAO+) && execution(org.apache.nifi.authorization.AccessPolicy updateAccessPolicy(org.apache.nifi.web.api.dto.AccessPolicyDTO)) && args(accessPolicyDTO) && target(accessPolicyDAO)")
    public AccessPolicy updateAccessPolicyAdvice(ProceedingJoinPoint proceedingJoinPoint, AccessPolicyDTO accessPolicyDTO, AccessPolicyDAO accessPolicyDAO) throws Throwable {
        AccessPolicy accessPolicy = accessPolicyDAO.getAccessPolicy(accessPolicyDTO.getId());
        Map values = this.extractConfiguredPropertyValues(accessPolicy, accessPolicyDTO);
        AccessPolicy updatedAccessPolicy = (AccessPolicy)proceedingJoinPoint.proceed();
        accessPolicy = accessPolicyDAO.getAccessPolicy(updatedAccessPolicy.getIdentifier());
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            Map updatedValues = this.extractConfiguredPropertyValues(accessPolicy, accessPolicyDTO);
            Date actionTimestamp = new Date();
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            for (String property : updatedValues.keySet()) {
                String newValue = (String)updatedValues.get(property);
                String oldValue = (String)values.get(property);
                Operation operation = null;
                if (oldValue == null || newValue == null || !newValue.equals(oldValue)) {
                    operation = Operation.Configure;
                }
                if (operation == null) continue;
                FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
                actionDetails.setName(property);
                actionDetails.setValue(newValue);
                actionDetails.setPreviousValue(oldValue);
                FlowChangeAction configurationAction = new FlowChangeAction();
                configurationAction.setUserIdentity(user.getIdentity());
                configurationAction.setOperation(operation);
                configurationAction.setTimestamp(actionTimestamp);
                configurationAction.setSourceId(accessPolicy.getIdentifier());
                configurationAction.setSourceName(this.formatPolicyName(accessPolicy));
                configurationAction.setSourceType(Component.AccessPolicy);
                configurationAction.setActionDetails((ActionDetails)actionDetails);
                actions.add(configurationAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedAccessPolicy;
    }

    @Around(value="within(org.apache.nifi.web.dao.AccessPolicyDAO+) && execution(org.apache.nifi.authorization.AccessPolicy deleteAccessPolicy(java.lang.String)) && args(policyId) && target(accessPolicyDAO)")
    public AccessPolicy removePolicyAdvice(ProceedingJoinPoint proceedingJoinPoint, String policyId, AccessPolicyDAO accessPolicyDAO) throws Throwable {
        AccessPolicy accessPolicy = accessPolicyDAO.getAccessPolicy(policyId);
        AccessPolicy removedAccessPolicy = (AccessPolicy)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(accessPolicy, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return removedAccessPolicy;
    }

    public Action generateAuditRecord(AccessPolicy policy, Operation operation) {
        return this.generateAuditRecord(policy, operation, null);
    }

    public Action generateAuditRecord(AccessPolicy policy, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(policy.getIdentifier());
            action.setSourceName(this.formatPolicyName(policy));
            action.setSourceType(Component.AccessPolicy);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }

    private String formatPolicyName(AccessPolicy policy) {
        return policy.getAction().toString() + " " + policy.getResource();
    }

    private Map<String, String> extractConfiguredPropertyValues(AccessPolicy policy, AccessPolicyDTO policyDTO) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (policyDTO.getUsers() != null) {
            ArrayList currentUsers = new ArrayList(policy.getUsers());
            Collections.sort(currentUsers, Collator.getInstance(Locale.US));
            values.put(USERS, StringUtils.join(currentUsers, (String)", "));
        }
        if (policyDTO.getUserGroups() != null) {
            ArrayList currentUserGroups = new ArrayList(policy.getGroups());
            Collections.sort(currentUserGroups, Collator.getInstance(Locale.US));
            values.put(USER_GROUPS, StringUtils.join(currentUserGroups, (String)", "));
        }
        return values;
    }
}

