/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.controller;

import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ContentAvailability;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.Counter;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.repository.ContentNotFoundException;
import org.apache.nifi.controller.repository.claim.ContentDirection;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.analytics.StatusAnalytics;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsEngine;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.ProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QueryResult;
import org.apache.nifi.provenance.search.QuerySubmission;
import org.apache.nifi.provenance.search.SearchTerms;
import org.apache.nifi.provenance.search.SearchableField;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.DocumentedTypeDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.diagnostics.ProcessorDiagnosticsDTO;
import org.apache.nifi.web.api.dto.provenance.AttributeDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceEventDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceOptionsDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceRequestDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceResultsDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceSearchableFieldDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageRequestDTO;
import org.apache.nifi.web.api.dto.search.SearchResultsDTO;
import org.apache.nifi.web.api.dto.status.ControllerStatusDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.controller.ControllerFacade;
import org.apache.nifi.web.controller.ControllerSearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerFacade
implements Authorizable {
    private static final Logger logger = LoggerFactory.getLogger(ControllerFacade.class);
    private FlowController flowController;
    private FlowService flowService;
    private Authorizer authorizer;
    private NiFiProperties properties;
    private DtoFactory dtoFactory;
    private VariableRegistry variableRegistry;
    private ControllerSearchService controllerSearchService;

    private ProcessGroup getRootGroup() {
        return this.flowController.getFlowManager().getRootGroup();
    }

    public String findProcessGroupIdForProcessor(String processorId) {
        ProcessGroup rootGroup = this.getRootGroup();
        ProcessorNode processor = rootGroup.findProcessor(processorId);
        if (processor == null) {
            return null;
        }
        return processor.getProcessGroup().getIdentifier();
    }

    public Connectable findLocalConnectable(String componentId) {
        return this.flowController.getFlowManager().findConnectable(componentId);
    }

    public ControllerServiceProvider getControllerServiceProvider() {
        return this.flowController.getControllerServiceProvider();
    }

    public ExtensionManager getExtensionManager() {
        return this.flowController.getExtensionManager();
    }

    public FlowManager getFlowManager() {
        return this.flowController.getFlowManager();
    }

    public void setName(String name) {
        this.getRootGroup().setName(name);
    }

    public Authorizable getParentAuthorizable() {
        return this.flowController.getParentAuthorizable();
    }

    public Resource getResource() {
        return this.flowController.getResource();
    }

    public void setComments(String comments) {
        this.getRootGroup().setComments(comments);
    }

    public ConfigurableComponent getTemporaryComponent(String type, BundleDTO bundle) {
        BundleCoordinate bundleCoordinate;
        ExtensionManager extensionManager = this.getExtensionManager();
        ConfigurableComponent configurableComponent = extensionManager.getTempComponent(type, bundleCoordinate = BundleUtils.getBundle((ExtensionManager)extensionManager, (String)type, (BundleDTO)bundle));
        if (configurableComponent == null) {
            throw new IllegalStateException("Unable to obtain temporary component for " + type);
        }
        return configurableComponent;
    }

    public void setMaxTimerDrivenThreadCount(int maxTimerDrivenThreadCount) {
        this.flowController.setMaxTimerDrivenThreadCount(maxTimerDrivenThreadCount);
    }

    public void setMaxEventDrivenThreadCount(int maxEventDrivenThreadCount) {
        this.flowController.setMaxEventDrivenThreadCount(maxEventDrivenThreadCount);
    }

    public String getRootGroupId() {
        return this.flowController.getFlowManager().getRootGroupId();
    }

    public Set<Port> getPublicInputPorts() {
        return this.flowController.getFlowManager().getPublicInputPorts();
    }

    public Set<Port> getPublicOutputPorts() {
        return this.flowController.getFlowManager().getPublicOutputPorts();
    }

    public StatusHistoryDTO getProcessorStatusHistory(String processorId) {
        ProcessGroup root = this.getRootGroup();
        ProcessorNode processor = root.findProcessor(processorId);
        if (processor == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate processor with id '%s'.", processorId));
        }
        boolean authorized = processor.isAuthorized(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        StatusHistoryDTO statusHistory = this.flowController.getProcessorStatusHistory(processorId, authorized);
        if (!authorized) {
            statusHistory.getComponentDetails().put("Name", processorId);
            statusHistory.getComponentDetails().put("Type", "Processor");
        }
        return statusHistory;
    }

    public StatusHistoryDTO getConnectionStatusHistory(String connectionId) {
        ProcessGroup root = this.getRootGroup();
        Connection connection = root.findConnection(connectionId);
        if (connection == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate connection with id '%s'.", connectionId));
        }
        StatusHistoryDTO statusHistory = this.flowController.getConnectionStatusHistory(connectionId);
        if (!connection.isAuthorized(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser())) {
            statusHistory.getComponentDetails().put("Name", connectionId);
            statusHistory.getComponentDetails().put("Source Name", connection.getSource().getIdentifier());
            statusHistory.getComponentDetails().put("Destination Name", connection.getDestination().getIdentifier());
        }
        return statusHistory;
    }

    public StatusHistoryDTO getProcessGroupStatusHistory(String groupId) {
        FlowManager flowManager = this.flowController.getFlowManager();
        String searchId = groupId.equals("root") ? flowManager.getRootGroupId() : groupId;
        ProcessGroup root = flowManager.getRootGroup();
        ProcessGroup group = root.findProcessGroup(searchId);
        if (group == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate process group with id '%s'.", groupId));
        }
        StatusHistoryDTO statusHistory = this.flowController.getProcessGroupStatusHistory(groupId);
        if (!group.isAuthorized(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser())) {
            statusHistory.getComponentDetails().put("Name", groupId);
        }
        return statusHistory;
    }

    public StatusHistoryDTO getRemoteProcessGroupStatusHistory(String remoteProcessGroupId) {
        ProcessGroup root = this.getRootGroup();
        RemoteProcessGroup remoteProcessGroup = root.findRemoteProcessGroup(remoteProcessGroupId);
        if (remoteProcessGroup == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate remote process group with id '%s'.", remoteProcessGroupId));
        }
        StatusHistoryDTO statusHistory = this.flowController.getRemoteProcessGroupStatusHistory(remoteProcessGroupId);
        if (!remoteProcessGroup.isAuthorized(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser())) {
            statusHistory.getComponentDetails().put("Name", remoteProcessGroupId);
            statusHistory.getComponentDetails().remove("Uri");
        }
        return statusHistory;
    }

    public NodeIdentifier getNodeId() {
        return this.flowController.getNodeId();
    }

    public boolean isClustered() {
        return this.flowController.isClustered();
    }

    public String getName() {
        return this.getRootGroup().getName();
    }

    public String getInstanceId() {
        return this.flowController.getInstanceId();
    }

    public String getComments() {
        return this.getRootGroup().getComments();
    }

    public int getMaxTimerDrivenThreadCount() {
        return this.flowController.getMaxTimerDrivenThreadCount();
    }

    public int getMaxEventDrivenThreadCount() {
        return this.flowController.getMaxEventDrivenThreadCount();
    }

    public Set<DocumentedTypeDTO> getFlowFileProcessorTypes(String bundleGroupFilter, String bundleArtifactFilter, String typeFilter) {
        return this.dtoFactory.fromDocumentedTypes(this.getExtensionManager().getExtensions(Processor.class), bundleGroupFilter, bundleArtifactFilter, typeFilter);
    }

    public Set<DocumentedTypeDTO> getFlowFileComparatorTypes() {
        return this.dtoFactory.fromDocumentedTypes(this.getExtensionManager().getExtensions(FlowFilePrioritizer.class), null, null, null);
    }

    private boolean implementsServiceType(Class serviceType, Class type) {
        List interfaces = ClassUtils.getAllInterfaces((Class)type);
        for (Class i : interfaces) {
            if (!ControllerService.class.isAssignableFrom(i) || !serviceType.isAssignableFrom(i)) continue;
            return true;
        }
        return false;
    }

    public Set<DocumentedTypeDTO> getControllerServiceTypes(String serviceType, String serviceBundleGroup, String serviceBundleArtifact, String serviceBundleVersion, String bundleGroupFilter, String bundleArtifactFilter, String typeFilter) {
        Set serviceImplementations = this.getExtensionManager().getExtensions(ControllerService.class);
        if (serviceType != null) {
            BundleCoordinate bundleCoordinate = new BundleCoordinate(serviceBundleGroup, serviceBundleArtifact, serviceBundleVersion);
            Bundle csBundle = this.getExtensionManager().getBundle(bundleCoordinate);
            if (csBundle == null) {
                throw new IllegalStateException("Unable to find bundle for coordinate " + bundleCoordinate.getCoordinate());
            }
            Class<?> serviceClass = null;
            ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(csBundle.getClassLoader());
                serviceClass = Class.forName(serviceType, false, csBundle.getClassLoader());
            }
            catch (Exception e) {
                Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                throw new IllegalArgumentException(String.format("Unable to load %s from bundle %s: %s", serviceType, bundleCoordinate, e), e);
            }
            HashMap<Class, Bundle> matchingServiceImplementations = new HashMap<Class, Bundle>();
            for (Class csClass : serviceImplementations) {
                if (!this.implementsServiceType(serviceClass, csClass)) continue;
                matchingServiceImplementations.put(csClass, this.getExtensionManager().getBundle(csClass.getClassLoader()));
            }
            return this.dtoFactory.fromDocumentedTypes(matchingServiceImplementations, bundleGroupFilter, bundleArtifactFilter, typeFilter);
        }
        return this.dtoFactory.fromDocumentedTypes(serviceImplementations, bundleGroupFilter, bundleArtifactFilter, typeFilter);
    }

    public Set<DocumentedTypeDTO> getReportingTaskTypes(String bundleGroupFilter, String bundleArtifactFilter, String typeFilter) {
        return this.dtoFactory.fromDocumentedTypes(this.getExtensionManager().getExtensions(ReportingTask.class), bundleGroupFilter, bundleArtifactFilter, typeFilter);
    }

    public List<Counter> getCounters() {
        return this.flowController.getCounters();
    }

    public Counter resetCounter(String id) {
        Counter counter = this.flowController.resetCounter(id);
        if (counter == null) {
            throw new ResourceNotFoundException(String.format("Unable to find Counter with id '%s'.", id));
        }
        return counter;
    }

    public ControllerStatusDTO getControllerStatus() {
        ProcessGroup rootGroup = this.getRootGroup();
        FlowController.GroupStatusCounts groupStatusCounts = this.flowController.getGroupStatusCounts(rootGroup);
        ControllerStatusDTO controllerStatus = new ControllerStatusDTO();
        controllerStatus.setActiveThreadCount(Integer.valueOf(groupStatusCounts.getActiveThreadCount()));
        controllerStatus.setTerminatedThreadCount(Integer.valueOf(groupStatusCounts.getTerminatedThreadCount()));
        controllerStatus.setQueued(FormatUtils.formatCount((long)groupStatusCounts.getQueuedCount()) + " / " + FormatUtils.formatDataSize((double)groupStatusCounts.getQueuedContentSize()));
        controllerStatus.setBytesQueued(Long.valueOf(groupStatusCounts.getQueuedContentSize()));
        controllerStatus.setFlowFilesQueued(Integer.valueOf(groupStatusCounts.getQueuedCount()));
        ProcessGroupCounts counts = rootGroup.getCounts();
        controllerStatus.setRunningCount(Integer.valueOf(counts.getRunningCount()));
        controllerStatus.setStoppedCount(Integer.valueOf(counts.getStoppedCount()));
        controllerStatus.setInvalidCount(Integer.valueOf(counts.getInvalidCount()));
        controllerStatus.setDisabledCount(Integer.valueOf(counts.getDisabledCount()));
        controllerStatus.setActiveRemotePortCount(Integer.valueOf(counts.getActiveRemotePortCount()));
        controllerStatus.setInactiveRemotePortCount(Integer.valueOf(counts.getInactiveRemotePortCount()));
        controllerStatus.setUpToDateCount(Integer.valueOf(counts.getUpToDateCount()));
        controllerStatus.setLocallyModifiedCount(Integer.valueOf(counts.getLocallyModifiedCount()));
        controllerStatus.setStaleCount(Integer.valueOf(counts.getStaleCount()));
        controllerStatus.setLocallyModifiedAndStaleCount(Integer.valueOf(counts.getLocallyModifiedAndStaleCount()));
        controllerStatus.setSyncFailureCount(Integer.valueOf(counts.getSyncFailureCount()));
        return controllerStatus;
    }

    public ProcessGroupStatus getProcessGroupStatus(String groupId) {
        return this.getProcessGroupStatus(groupId, Integer.MAX_VALUE);
    }

    public ProcessGroupStatus getProcessGroupStatus(String groupId, int recursiveStatusDepth) {
        ProcessGroupStatus processGroupStatus = this.flowController.getEventAccess().getGroupStatus(groupId, NiFiUserUtils.getNiFiUser(), recursiveStatusDepth);
        if (processGroupStatus == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate group with id '%s'.", groupId));
        }
        return processGroupStatus;
    }

    public ProcessorStatus getProcessorStatus(String processorId) {
        ProcessGroup root = this.getRootGroup();
        ProcessorNode processor = root.findProcessor(processorId);
        if (processor == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate processor with id '%s'.", processorId));
        }
        String groupId = processor.getProcessGroup().getIdentifier();
        ProcessGroupStatus processGroupStatus = this.flowController.getEventAccess().getGroupStatus(groupId, NiFiUserUtils.getNiFiUser(), 1);
        if (processGroupStatus == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate group with id '%s'.", groupId));
        }
        ProcessorStatus status = processGroupStatus.getProcessorStatus().stream().filter(processorStatus -> processorId.equals(processorStatus.getId())).findFirst().orElse(null);
        if (status == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate processor with id '%s'.", processorId));
        }
        return status;
    }

    public ConnectionStatus getConnectionStatus(String connectionId) {
        ProcessGroup root = this.getRootGroup();
        Connection connection = root.findConnection(connectionId);
        if (connection == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate connection with id '%s'.", connectionId));
        }
        String groupId = connection.getProcessGroup().getIdentifier();
        ProcessGroupStatus processGroupStatus = this.flowController.getEventAccess().getGroupStatus(groupId, NiFiUserUtils.getNiFiUser(), 1);
        if (processGroupStatus == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate group with id '%s'.", groupId));
        }
        ConnectionStatus status = processGroupStatus.getConnectionStatus().stream().filter(connectionStatus -> connectionId.equals(connectionStatus.getId())).findFirst().orElse(null);
        if (status == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate connection with id '%s'.", connectionId));
        }
        return status;
    }

    public StatusAnalytics getConnectionStatusAnalytics(String connectionId) {
        ProcessGroup root = this.getRootGroup();
        Connection connection = root.findConnection(connectionId);
        if (connection == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate connection with id '%s'.", connectionId));
        }
        String groupId = connection.getProcessGroup().getIdentifier();
        ProcessGroupStatus processGroupStatus = this.flowController.getEventAccess().getGroupStatus(groupId, NiFiUserUtils.getNiFiUser(), 1);
        if (processGroupStatus == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate group with id '%s'.", groupId));
        }
        StatusAnalyticsEngine statusAnalyticsEngine = this.flowController.getStatusAnalyticsEngine();
        if (statusAnalyticsEngine == null) {
            throw new ResourceNotFoundException(String.format("Unable to provide analytics for connection with id '%s'. Analytics may not be enabled", connectionId));
        }
        return statusAnalyticsEngine.getStatusAnalytics(connectionId);
    }

    public PortStatus getInputPortStatus(String portId) {
        ProcessGroup root = this.getRootGroup();
        Port port = root.findInputPort(portId);
        if (port == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate input port with id '%s'.", portId));
        }
        String groupId = port.getProcessGroup().getIdentifier();
        ProcessGroupStatus processGroupStatus = this.flowController.getEventAccess().getGroupStatus(groupId, NiFiUserUtils.getNiFiUser(), 1);
        if (processGroupStatus == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate group with id '%s'.", groupId));
        }
        PortStatus status = processGroupStatus.getInputPortStatus().stream().filter(portStatus -> portId.equals(portStatus.getId())).findFirst().orElse(null);
        if (status == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate input port with id '%s'.", portId));
        }
        return status;
    }

    public PortStatus getOutputPortStatus(String portId) {
        ProcessGroup root = this.getRootGroup();
        Port port = root.findOutputPort(portId);
        if (port == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate output port with id '%s'.", portId));
        }
        String groupId = port.getProcessGroup().getIdentifier();
        ProcessGroupStatus processGroupStatus = this.flowController.getEventAccess().getGroupStatus(groupId, NiFiUserUtils.getNiFiUser(), 1);
        if (processGroupStatus == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate group with id '%s'.", groupId));
        }
        PortStatus status = processGroupStatus.getOutputPortStatus().stream().filter(portStatus -> portId.equals(portStatus.getId())).findFirst().orElse(null);
        if (status == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate output port with id '%s'.", portId));
        }
        return status;
    }

    public RemoteProcessGroupStatus getRemoteProcessGroupStatus(String remoteProcessGroupId) {
        ProcessGroup root = this.getRootGroup();
        RemoteProcessGroup remoteProcessGroup = root.findRemoteProcessGroup(remoteProcessGroupId);
        if (remoteProcessGroup == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate remote process group with id '%s'.", remoteProcessGroupId));
        }
        String groupId = remoteProcessGroup.getProcessGroup().getIdentifier();
        ProcessGroupStatus groupStatus = this.flowController.getEventAccess().getGroupStatus(groupId, NiFiUserUtils.getNiFiUser(), 1);
        if (groupStatus == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate group with id '%s'.", groupId));
        }
        RemoteProcessGroupStatus status = groupStatus.getRemoteProcessGroupStatus().stream().filter(rpgStatus -> remoteProcessGroupId.equals(rpgStatus.getId())).findFirst().orElse(null);
        if (status == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate remote process group with id '%s'.", remoteProcessGroupId));
        }
        return status;
    }

    public void save() throws NiFiCoreException {
        long writeDelaySeconds = FormatUtils.getTimeDuration((String)this.properties.getFlowServiceWriteDelay(), (TimeUnit)TimeUnit.SECONDS);
        this.flowService.saveFlowChanges(TimeUnit.SECONDS, writeDelaySeconds);
    }

    public Integer getRemoteSiteListeningPort() {
        return this.flowController.getRemoteSiteListeningPort();
    }

    public Integer getRemoteSiteListeningHttpPort() {
        return this.flowController.getRemoteSiteListeningHttpPort();
    }

    public Boolean isRemoteSiteCommsSecure() {
        return this.flowController.isRemoteSiteCommsSecure();
    }

    public SystemDiagnostics getSystemDiagnostics() {
        return this.flowController.getSystemDiagnostics();
    }

    public List<Resource> getResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(ResourceFactory.getFlowResource());
        resources.add(ResourceFactory.getSystemResource());
        resources.add(ResourceFactory.getControllerResource());
        resources.add(ResourceFactory.getCountersResource());
        resources.add(ResourceFactory.getProvenanceResource());
        resources.add(ResourceFactory.getPoliciesResource());
        resources.add(ResourceFactory.getTenantResource());
        resources.add(ResourceFactory.getProxyResource());
        resources.add(ResourceFactory.getResourceResource());
        resources.add(ResourceFactory.getSiteToSiteResource());
        resources.add(ResourceFactory.getParameterContextsResource());
        this.flowController.getFlowManager().getParameterContextManager().getParameterContexts().forEach(parameterContext -> resources.add(parameterContext.getResource()));
        resources.add(ResourceFactory.getRestrictedComponentsResource());
        Arrays.stream(RequiredPermission.values()).forEach(requiredPermission -> resources.add(ResourceFactory.getRestrictedComponentsResource((RequiredPermission)requiredPermission)));
        ProcessGroup root = this.getRootGroup();
        Resource rootResource = root.getResource();
        resources.add(rootResource);
        resources.add(ResourceFactory.getDataResource((Resource)rootResource));
        resources.add(ResourceFactory.getProvenanceDataResource((Resource)rootResource));
        resources.add(ResourceFactory.getPolicyResource((Resource)rootResource));
        for (ProcessorNode processor : root.findAllProcessors()) {
            Resource processorResource = processor.getResource();
            resources.add(processorResource);
            resources.add(ResourceFactory.getDataResource((Resource)processorResource));
            resources.add(ResourceFactory.getProvenanceDataResource((Resource)processorResource));
            resources.add(ResourceFactory.getPolicyResource((Resource)processorResource));
            resources.add(ResourceFactory.getOperationResource((Resource)processorResource));
        }
        for (Label label : root.findAllLabels()) {
            Resource labelResource = label.getResource();
            resources.add(labelResource);
            resources.add(ResourceFactory.getPolicyResource((Resource)labelResource));
        }
        for (ProcessGroup processGroup : root.findAllProcessGroups()) {
            Resource processGroupResource = processGroup.getResource();
            resources.add(processGroupResource);
            resources.add(ResourceFactory.getDataResource((Resource)processGroupResource));
            resources.add(ResourceFactory.getProvenanceDataResource((Resource)processGroupResource));
            resources.add(ResourceFactory.getPolicyResource((Resource)processGroupResource));
            resources.add(ResourceFactory.getOperationResource((Resource)processGroupResource));
        }
        for (RemoteProcessGroup remoteProcessGroup : root.findAllRemoteProcessGroups()) {
            Resource remoteProcessGroupResource = remoteProcessGroup.getResource();
            resources.add(remoteProcessGroupResource);
            resources.add(ResourceFactory.getDataResource((Resource)remoteProcessGroupResource));
            resources.add(ResourceFactory.getProvenanceDataResource((Resource)remoteProcessGroupResource));
            resources.add(ResourceFactory.getPolicyResource((Resource)remoteProcessGroupResource));
            resources.add(ResourceFactory.getOperationResource((Resource)remoteProcessGroupResource));
        }
        for (Port inputPort : root.findAllInputPorts()) {
            Resource inputPortResource = inputPort.getResource();
            resources.add(inputPortResource);
            resources.add(ResourceFactory.getDataResource((Resource)inputPortResource));
            resources.add(ResourceFactory.getProvenanceDataResource((Resource)inputPortResource));
            resources.add(ResourceFactory.getPolicyResource((Resource)inputPortResource));
            resources.add(ResourceFactory.getOperationResource((Resource)inputPortResource));
            if (!(inputPort instanceof PublicPort)) continue;
            resources.add(ResourceFactory.getDataTransferResource((Resource)inputPortResource));
        }
        for (Port outputPort : root.findAllOutputPorts()) {
            Resource outputPortResource = outputPort.getResource();
            resources.add(outputPortResource);
            resources.add(ResourceFactory.getDataResource((Resource)outputPortResource));
            resources.add(ResourceFactory.getProvenanceDataResource((Resource)outputPortResource));
            resources.add(ResourceFactory.getPolicyResource((Resource)outputPortResource));
            resources.add(ResourceFactory.getOperationResource((Resource)outputPortResource));
            if (!(outputPort instanceof PublicPort)) continue;
            resources.add(ResourceFactory.getDataTransferResource((Resource)outputPortResource));
        }
        Consumer<ControllerServiceNode> csConsumer = controllerService -> {
            Resource controllerServiceResource = controllerService.getResource();
            resources.add(controllerServiceResource);
            resources.add(ResourceFactory.getPolicyResource((Resource)controllerServiceResource));
            resources.add(ResourceFactory.getOperationResource((Resource)controllerServiceResource));
        };
        this.flowController.getFlowManager().getAllControllerServices().forEach(csConsumer);
        root.findAllControllerServices().forEach(csConsumer);
        for (ReportingTaskNode reportingTask : this.flowController.getAllReportingTasks()) {
            Resource reportingTaskResource = reportingTask.getResource();
            resources.add(reportingTaskResource);
            resources.add(ResourceFactory.getPolicyResource((Resource)reportingTaskResource));
            resources.add(ResourceFactory.getOperationResource((Resource)reportingTaskResource));
        }
        for (Template template : root.findAllTemplates()) {
            Resource templateResource = template.getResource();
            resources.add(templateResource);
            resources.add(ResourceFactory.getPolicyResource((Resource)templateResource));
        }
        return resources;
    }

    public ProvenanceOptionsDTO getProvenanceSearchOptions() {
        ProvenanceRepository provenanceRepository = this.flowController.getProvenanceRepository();
        ProvenanceOptionsDTO searchOptions = new ProvenanceOptionsDTO();
        ArrayList<ProvenanceSearchableFieldDTO> searchableFieldNames = new ArrayList<ProvenanceSearchableFieldDTO>();
        List fields = provenanceRepository.getSearchableFields();
        for (SearchableField field : fields) {
            if (SearchableFields.EventTime.equals(field)) continue;
            ProvenanceSearchableFieldDTO searchableField = new ProvenanceSearchableFieldDTO();
            searchableField.setId(field.getIdentifier());
            searchableField.setField(field.getSearchableFieldName());
            searchableField.setLabel(field.getFriendlyName());
            searchableField.setType(field.getFieldType().name());
            searchableFieldNames.add(searchableField);
        }
        List searchableAttributes = provenanceRepository.getSearchableAttributes();
        for (SearchableField searchableAttr : searchableAttributes) {
            ProvenanceSearchableFieldDTO searchableAttribute = new ProvenanceSearchableFieldDTO();
            searchableAttribute.setId(searchableAttr.getIdentifier());
            searchableAttribute.setField(searchableAttr.getSearchableFieldName());
            searchableAttribute.setLabel(searchableAttr.getFriendlyName());
            searchableAttribute.setType(searchableAttr.getFieldType().name());
            searchableFieldNames.add(searchableAttribute);
        }
        searchOptions.setSearchableFields(searchableFieldNames);
        return searchOptions;
    }

    public ProvenanceDTO submitProvenance(ProvenanceDTO provenanceDto) {
        ProvenanceRequestDTO requestDto = provenanceDto.getRequest();
        Query query = new Query(provenanceDto.getId());
        if (requestDto != null) {
            Map searchTerms = requestDto.getSearchTerms();
            if (searchTerms != null) {
                for (Map.Entry searchTerm : searchTerms.entrySet()) {
                    SearchableField field = SearchableFields.getSearchableField((String)((String)searchTerm.getKey()));
                    if (field == null) {
                        field = SearchableFields.newSearchableAttribute((String)((String)searchTerm.getKey()));
                    }
                    query.addSearchTerm(SearchTerms.newSearchTerm((SearchableField)field, (String)((String)searchTerm.getValue())));
                }
            }
            if (requestDto.getStartDate() != null) {
                query.setStartDate(requestDto.getStartDate());
            }
            if (requestDto.getEndDate() != null) {
                query.setEndDate(requestDto.getEndDate());
            }
            query.setMinFileSize(requestDto.getMinimumFileSize());
            query.setMaxFileSize(requestDto.getMaximumFileSize());
            query.setMaxResults(requestDto.getMaxResults().intValue());
        }
        ProvenanceRepository provenanceRepository = this.flowController.getProvenanceRepository();
        QuerySubmission querySubmission = provenanceRepository.submitQuery(query, NiFiUserUtils.getNiFiUser());
        return this.getProvenanceQuery(querySubmission.getQueryIdentifier(), requestDto.getSummarize(), requestDto.getIncrementalResults());
    }

    public ProvenanceDTO getProvenanceQuery(String provenanceId, Boolean summarize, Boolean incrementalResults) {
        try {
            boolean includeResults;
            ProvenanceRepository provenanceRepository = this.flowController.getProvenanceRepository();
            QuerySubmission querySubmission = provenanceRepository.retrieveQuerySubmission(provenanceId, NiFiUserUtils.getNiFiUser());
            if (querySubmission == null) {
                throw new ResourceNotFoundException("Cannot find the results for the specified provenance requests. Results may have been purged.");
            }
            Query query = querySubmission.getQuery();
            QueryResult queryResult = querySubmission.getResult();
            ProvenanceDTO provenanceDto = new ProvenanceDTO();
            ProvenanceRequestDTO requestDto = new ProvenanceRequestDTO();
            ProvenanceResultsDTO resultsDto = new ProvenanceResultsDTO();
            provenanceDto.setRequest(requestDto);
            provenanceDto.setResults(resultsDto);
            requestDto.setStartDate(query.getStartDate());
            requestDto.setEndDate(query.getEndDate());
            requestDto.setMinimumFileSize(query.getMinFileSize());
            requestDto.setMaximumFileSize(query.getMaxFileSize());
            requestDto.setMaxResults(Integer.valueOf(query.getMaxResults()));
            if (query.getSearchTerms() != null) {
                HashMap<String, String> searchTerms = new HashMap<String, String>();
                for (Object searchTerm : query.getSearchTerms()) {
                    searchTerms.put(searchTerm.getSearchableField().getFriendlyName(), searchTerm.getValue());
                }
                requestDto.setSearchTerms(searchTerms);
            }
            provenanceDto.setId(query.getIdentifier());
            provenanceDto.setSubmissionTime(querySubmission.getSubmissionTime());
            provenanceDto.setExpiration(queryResult.getExpiration());
            provenanceDto.setFinished(Boolean.valueOf(queryResult.isFinished()));
            provenanceDto.setPercentCompleted(Integer.valueOf(queryResult.getPercentComplete()));
            boolean bl = includeResults = incrementalResults == null || Boolean.TRUE.equals(incrementalResults);
            if (includeResults || queryResult.isFinished()) {
                ArrayList<ProvenanceEventDTO> events = new ArrayList<ProvenanceEventDTO>();
                for (ProvenanceEventRecord record : queryResult.getMatchingEvents()) {
                    events.add(this.createProvenanceEventDto(record, Boolean.TRUE.equals(summarize)));
                }
                resultsDto.setProvenanceEvents(events);
            }
            if (requestDto.getMaxResults() != null && queryResult.getTotalHitCount() >= (long)requestDto.getMaxResults().intValue()) {
                resultsDto.setTotalCount(Long.valueOf(requestDto.getMaxResults().longValue()));
                resultsDto.setTotal(FormatUtils.formatCount((long)requestDto.getMaxResults().longValue()) + "+");
            } else {
                resultsDto.setTotalCount(Long.valueOf(queryResult.getTotalHitCount()));
                resultsDto.setTotal(FormatUtils.formatCount((long)queryResult.getTotalHitCount()));
            }
            if (queryResult.getError() != null) {
                HashSet<String> errors = new HashSet<String>();
                errors.add(queryResult.getError());
                resultsDto.setErrors(errors);
            }
            Date now = new Date();
            resultsDto.setGenerated(now);
            resultsDto.setTimeOffset(Integer.valueOf(TimeZone.getDefault().getOffset(now.getTime())));
            List firstEvent = provenanceRepository.getEvents(0L, 1);
            if (!firstEvent.isEmpty()) {
                resultsDto.setOldestEvent(new Date(((ProvenanceEventRecord)firstEvent.get(0)).getEventTime()));
            }
            provenanceDto.setResults(resultsDto);
            return provenanceDto;
        }
        catch (IOException ioe) {
            throw new NiFiCoreException("An error occurred while searching the provenance events.", (Throwable)ioe);
        }
    }

    public LineageDTO submitLineage(LineageDTO lineageDto) {
        LineageRequestDTO requestDto = lineageDto.getRequest();
        ProvenanceRepository provenanceRepository = this.flowController.getProvenanceRepository();
        ComputeLineageSubmission result = LineageRequestDTO.LineageRequestType.FLOWFILE.equals((Object)requestDto.getLineageRequestType()) ? (requestDto.getUuid() != null ? provenanceRepository.submitLineageComputation(requestDto.getUuid(), NiFiUserUtils.getNiFiUser()) : provenanceRepository.submitLineageComputation(requestDto.getEventId().longValue(), NiFiUserUtils.getNiFiUser())) : (LineageRequestDTO.LineageRequestType.PARENTS.equals((Object)requestDto.getLineageRequestType()) ? provenanceRepository.submitExpandParents(requestDto.getEventId().longValue(), NiFiUserUtils.getNiFiUser()) : provenanceRepository.submitExpandChildren(requestDto.getEventId().longValue(), NiFiUserUtils.getNiFiUser()));
        return this.getLineage(result.getLineageIdentifier());
    }

    public LineageDTO getLineage(String lineageId) {
        ProvenanceRepository provenanceRepository = this.flowController.getProvenanceRepository();
        ComputeLineageSubmission computeLineageSubmission = provenanceRepository.retrieveLineageSubmission(lineageId, NiFiUserUtils.getNiFiUser());
        if (computeLineageSubmission == null) {
            throw new ResourceNotFoundException("Cannot find the results for the specified lineage request. Results may have been purged.");
        }
        return this.dtoFactory.createLineageDto(computeLineageSubmission);
    }

    public void deleteProvenanceQuery(String provenanceId) {
        ProvenanceRepository provenanceRepository = this.flowController.getProvenanceRepository();
        QuerySubmission querySubmission = provenanceRepository.retrieveQuerySubmission(provenanceId, NiFiUserUtils.getNiFiUser());
        if (querySubmission != null) {
            querySubmission.cancel();
        }
    }

    public void deleteLineage(String lineageId) {
        ProvenanceRepository provenanceRepository = this.flowController.getProvenanceRepository();
        ComputeLineageSubmission computeLineageSubmission = provenanceRepository.retrieveLineageSubmission(lineageId, NiFiUserUtils.getNiFiUser());
        if (computeLineageSubmission != null) {
            computeLineageSubmission.cancel();
        }
    }

    public DownloadableContent getContent(Long eventId, String uri, ContentDirection contentDirection) {
        try {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            ProvenanceEventRecord event = this.flowController.getProvenanceRepository().getEvent(eventId.longValue(), user);
            if (event == null) {
                throw new ResourceNotFoundException("Unable to find the specified event.");
            }
            Map attributes = ContentDirection.INPUT.equals((Object)contentDirection) ? event.getPreviousAttributes() : event.getAttributes();
            Authorizable dataAuthorizable = this.getDataAuthorizable(event);
            dataAuthorizable.authorize(this.authorizer, RequestAction.READ, user, attributes);
            String filename = (String)attributes.get(CoreAttributes.FILENAME.key());
            if (filename == null) {
                filename = event.getFlowFileUuid();
            }
            String type = (String)attributes.get(CoreAttributes.MIME_TYPE.key());
            InputStream content = this.flowController.getContent(event, contentDirection, user.getIdentity(), uri);
            return new DownloadableContent(filename, type, content);
        }
        catch (ContentNotFoundException cnfe) {
            throw new ResourceNotFoundException("Unable to find the specified content.");
        }
        catch (IOException ioe) {
            logger.error(String.format("Unable to get the content for event (%s) at this time.", eventId), (Throwable)ioe);
            throw new IllegalStateException("Unable to get the content at this time.");
        }
    }

    private Authorizable getDataAuthorizable(ProvenanceEventRecord event) {
        if (event.isRemotePortType()) {
            return this.flowController.getProvenanceAuthorizableFactory().createRemoteDataAuthorizable(event.getComponentId());
        }
        return this.flowController.getProvenanceAuthorizableFactory().createLocalDataAuthorizable(event.getComponentId());
    }

    public ProvenanceEventDTO submitReplay(Long eventId) {
        try {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            if (user == null) {
                throw new WebApplicationException(new Throwable("Unable to access details for current user."));
            }
            ProvenanceEventRecord originalEvent = this.flowController.getProvenanceRepository().getEvent(eventId.longValue(), user);
            if (originalEvent == null) {
                throw new ResourceNotFoundException("Unable to find the specified event.");
            }
            this.authorizeReplay(originalEvent);
            ProvenanceEventRecord event = this.flowController.replayFlowFile(originalEvent, user);
            return this.createProvenanceEventDto(event, false);
        }
        catch (IOException ioe) {
            throw new NiFiCoreException("An error occurred while getting the specified event.", (Throwable)ioe);
        }
    }

    private AuthorizationResult checkAuthorizationForReplay(ProvenanceEventRecord event, boolean checkReadDataPermissions) {
        AuthorizationResult result;
        if (event.getSourceQueueIdentifier() == null) {
            return AuthorizationResult.denied((String)"The connection id in the provenance event is unknown.");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Authorizable dataAuthorizable = this.getDataAuthorizable(event);
        Map eventAttributes = event.getAttributes();
        if (checkReadDataPermissions && !AuthorizationResult.Result.Approved.equals((Object)(result = dataAuthorizable.checkAuthorization(this.authorizer, RequestAction.READ, user, eventAttributes)).getResult())) {
            return result;
        }
        return dataAuthorizable.checkAuthorization(this.authorizer, RequestAction.WRITE, user, eventAttributes);
    }

    private void authorizeReplay(ProvenanceEventRecord event) {
        if (event.getSourceQueueIdentifier() == null) {
            throw new AccessDeniedException("The connection id in the provenance event is unknown.");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Authorizable dataAuthorizable = this.getDataAuthorizable(event);
        Map eventAttributes = event.getAttributes();
        dataAuthorizable.authorize(this.authorizer, RequestAction.READ, user, eventAttributes);
        dataAuthorizable.authorize(this.authorizer, RequestAction.WRITE, user, eventAttributes);
    }

    private AuthorizationResult checkAuthorizationForData(ProvenanceEventRecord event) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Authorizable dataAuthorizable = this.getDataAuthorizable(event);
        Map eventAttributes = event.getAttributes();
        return dataAuthorizable.checkAuthorization(this.authorizer, RequestAction.READ, user, eventAttributes);
    }

    public ProvenanceEventDTO getProvenanceEvent(Long eventId) {
        try {
            ProvenanceEventRecord event = this.flowController.getProvenanceRepository().getEvent(eventId.longValue(), NiFiUserUtils.getNiFiUser());
            if (event == null) {
                throw new ResourceNotFoundException("Unable to find the specified event.");
            }
            return this.createProvenanceEventDto(event, false);
        }
        catch (IOException ioe) {
            throw new NiFiCoreException("An error occurred while getting the specified event.", (Throwable)ioe);
        }
    }

    private ProvenanceEventDTO createProvenanceEventDto(ProvenanceEventRecord event, boolean summarize) {
        ProvenanceEventDTO dto = new ProvenanceEventDTO();
        dto.setId(String.valueOf(event.getEventId()));
        dto.setEventId(Long.valueOf(event.getEventId()));
        dto.setEventTime(new Date(event.getEventTime()));
        dto.setEventType(event.getEventType().name());
        dto.setFlowFileUuid(event.getFlowFileUuid());
        dto.setFileSize(FormatUtils.formatDataSize((double)event.getFileSize()));
        dto.setFileSizeBytes(Long.valueOf(event.getFileSize()));
        dto.setComponentId(event.getComponentId());
        dto.setComponentType(event.getComponentType());
        if (!summarize) {
            AttributeDTO attribute;
            1 attributeComparator = new /* Unavailable Anonymous Inner Class!! */;
            TreeSet<AttributeDTO> attributes = new TreeSet<AttributeDTO>((Comparator<AttributeDTO>)attributeComparator);
            Map updatedAttrs = event.getUpdatedAttributes();
            Map previousAttrs = event.getPreviousAttributes();
            for (Map.Entry entry : previousAttrs.entrySet()) {
                if (updatedAttrs.containsKey(entry.getKey())) continue;
                attribute = new AttributeDTO();
                attribute.setName((String)entry.getKey());
                attribute.setValue((String)entry.getValue());
                attribute.setPreviousValue((String)entry.getValue());
                attributes.add(attribute);
            }
            for (Map.Entry entry : updatedAttrs.entrySet()) {
                attribute = new AttributeDTO();
                attribute.setName((String)entry.getKey());
                attribute.setValue((String)entry.getValue());
                attribute.setPreviousValue((String)previousAttrs.get(entry.getKey()));
                attributes.add(attribute);
            }
            dto.setAlternateIdentifierUri(event.getAlternateIdentifierUri());
            dto.setTransitUri(event.getTransitUri());
            dto.setSourceSystemFlowFileId(event.getSourceSystemFlowFileIdentifier());
            dto.setRelationship(event.getRelationship());
            dto.setDetails(event.getDetails());
            AuthorizationResult dataResult = this.checkAuthorizationForData(event);
            if (AuthorizationResult.Result.Approved.equals((Object)dataResult.getResult())) {
                ContentAvailability contentAvailability = this.flowController.getContentAvailability(event);
                dto.setAttributes(attributes);
                dto.setContentEqual(Boolean.valueOf(contentAvailability.isContentSame()));
                dto.setInputContentAvailable(Boolean.valueOf(contentAvailability.isInputAvailable()));
                dto.setInputContentClaimSection(event.getPreviousContentClaimSection());
                dto.setInputContentClaimContainer(event.getPreviousContentClaimContainer());
                dto.setInputContentClaimIdentifier(event.getPreviousContentClaimIdentifier());
                dto.setInputContentClaimOffset(event.getPreviousContentClaimOffset());
                dto.setInputContentClaimFileSizeBytes(event.getPreviousFileSize());
                dto.setOutputContentAvailable(Boolean.valueOf(contentAvailability.isOutputAvailable()));
                dto.setOutputContentClaimSection(event.getContentClaimSection());
                dto.setOutputContentClaimContainer(event.getContentClaimContainer());
                dto.setOutputContentClaimIdentifier(event.getContentClaimIdentifier());
                dto.setOutputContentClaimOffset(event.getContentClaimOffset());
                dto.setOutputContentClaimFileSize(FormatUtils.formatDataSize((double)event.getFileSize()));
                dto.setOutputContentClaimFileSizeBytes(Long.valueOf(event.getFileSize()));
                if (event.getPreviousFileSize() != null) {
                    dto.setInputContentClaimFileSize(FormatUtils.formatDataSize((double)event.getPreviousFileSize().longValue()));
                }
                AuthorizationResult replayAuthorized = this.checkAuthorizationForReplay(event, false);
                dto.setReplayAvailable(Boolean.valueOf(contentAvailability.isReplayable() && AuthorizationResult.Result.Approved.equals((Object)replayAuthorized.getResult())));
                dto.setReplayExplanation(contentAvailability.isReplayable() && !AuthorizationResult.Result.Approved.equals((Object)replayAuthorized.getResult()) ? replayAuthorized.getExplanation() : contentAvailability.getReasonNotReplayable());
                dto.setSourceConnectionIdentifier(event.getSourceQueueIdentifier());
            } else {
                dto.setReplayAvailable(Boolean.valueOf(false));
                dto.setReplayExplanation(dataResult.getExplanation());
            }
            if (event.getEventDuration() >= 0L) {
                dto.setEventDuration(Long.valueOf(event.getEventDuration()));
            }
            if (event.getLineageStartDate() > 0L) {
                long lineageDuration = event.getEventTime() - event.getLineageStartDate();
                dto.setLineageDuration(Long.valueOf(lineageDuration));
            }
            ArrayList<Object> parentUuids = new ArrayList<Object>(event.getParentUuids());
            parentUuids.sort(Collator.getInstance(Locale.US));
            dto.setParentUuids(parentUuids);
            ArrayList<Object> childUuids = new ArrayList<Object>(event.getChildUuids());
            childUuids.sort(Collator.getInstance(Locale.US));
            dto.setChildUuids(childUuids);
        }
        this.setComponentDetails(dto);
        return dto;
    }

    private void setComponentDetails(ProvenanceEventDTO dto) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        ProcessGroup root = this.getRootGroup();
        Connectable connectable = this.findLocalConnectable(dto.getComponentId());
        if (connectable != null) {
            dto.setGroupId(connectable.getProcessGroup().getIdentifier());
            if (AuthorizationResult.Result.Approved.equals((Object)connectable.checkAuthorization(this.authorizer, RequestAction.READ, user).getResult())) {
                dto.setComponentName(connectable.getName());
            } else {
                dto.setComponentType(connectable.getConnectableType().toString());
                dto.setComponentName(dto.getComponentId());
                dto.setRelationship(null);
            }
            return;
        }
        RemoteGroupPort remoteGroupPort = root.findRemoteGroupPort(dto.getComponentId());
        if (remoteGroupPort != null) {
            dto.setGroupId(remoteGroupPort.getProcessGroupIdentifier());
            if (AuthorizationResult.Result.Approved.equals((Object)remoteGroupPort.checkAuthorization(this.authorizer, RequestAction.READ, user).getResult())) {
                dto.setComponentName(remoteGroupPort.getName());
            } else {
                dto.setComponentName(dto.getComponentId());
                dto.setRelationship(null);
            }
            return;
        }
        Connection connection = root.findConnection(dto.getComponentId());
        if (connection != null) {
            dto.setGroupId(connection.getProcessGroup().getIdentifier());
            if (AuthorizationResult.Result.Approved.equals((Object)connection.checkAuthorization(this.authorizer, RequestAction.READ, user).getResult())) {
                String name = connection.getName();
                Collection relationships = connection.getRelationships();
                if (StringUtils.isBlank((CharSequence)name) && CollectionUtils.isNotEmpty((Collection)relationships)) {
                    name = StringUtils.join((Iterable)relationships.stream().map(Relationship::getName).collect(Collectors.toSet()), (String)", ");
                }
                dto.setComponentName(name);
            } else {
                dto.setComponentName(dto.getComponentId());
                dto.setRelationship(null);
            }
        }
    }

    public SearchResultsDTO search(String search) {
        ProcessGroup rootGroup = this.getRootGroup();
        SearchResultsDTO results = new SearchResultsDTO();
        this.controllerSearchService.search(results, search, rootGroup);
        this.controllerSearchService.searchParameters(results, search);
        return results;
    }

    public void verifyComponentTypes(VersionedProcessGroup versionedFlow) {
        this.flowController.verifyComponentTypesInSnippet(versionedFlow);
    }

    public ProcessorDiagnosticsDTO getProcessorDiagnostics(ProcessorNode processor, ProcessorStatus processorStatus, BulletinRepository bulletinRepository, Function<String, ControllerServiceEntity> serviceEntityFactory) {
        return this.dtoFactory.createProcessorDiagnosticsDto(processor, processorStatus, bulletinRepository, this.flowController, serviceEntityFactory);
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setFlowService(FlowService flowService) {
        this.flowService = flowService;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }

    public void setVariableRegistry(VariableRegistry variableRegistry) {
        this.variableRegistry = variableRegistry;
    }

    public void setControllerSearchService(ControllerSearchService controllerSearchService) {
        this.controllerSearchService = controllerSearchService;
    }
}

