/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.cluster.exception.NoClusterCoordinatorException;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.exception.IllegalClusterStateException;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.repository.claim.ContentDirection;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.ClusterRequestException;
import org.apache.nifi.web.ContentAccess;
import org.apache.nifi.web.ContentRequestContext;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;

public class StandardNiFiContentAccess
implements ContentAccess {
    public static final String CLIENT_ID_PARAM = "clientId";
    private static final Pattern FLOWFILE_CONTENT_URI_PATTERN = Pattern.compile("/flowfile-queues/([a-f0-9\\-]{36})/flowfiles/([a-f0-9\\-]{36})/content.*");
    private static final Pattern PROVENANCE_CONTENT_URI_PATTERN = Pattern.compile("/provenance-events/([0-9]+)/content/((?:input)|(?:output)).*");
    private NiFiProperties properties;
    private NiFiServiceFacade serviceFacade;
    private ClusterCoordinator clusterCoordinator;
    private RequestReplicator requestReplicator;

    public DownloadableContent getContent(ContentRequestContext request) {
        if (this.properties.isClustered() && this.clusterCoordinator != null && this.clusterCoordinator.isConnected()) {
            NodeResponse nodeResponse;
            URI dataUri;
            try {
                dataUri = new URI(request.getDataUri());
            }
            catch (URISyntaxException use) {
                throw new ClusterRequestException((Throwable)use);
            }
            MultivaluedHashMap parameters = new MultivaluedHashMap();
            parameters.add((Object)CLIENT_ID_PARAM, (Object)request.getClientId());
            HashMap<String, String> headers = new HashMap<String, String>();
            if (request.getClusterNodeId() == null) {
                throw new IllegalArgumentException("Unable to determine the which node has the content.");
            }
            NodeIdentifier nodeId = this.clusterCoordinator.getNodeIdentifier(request.getClusterNodeId());
            try {
                headers.put("X-Replication-Target-Id", nodeId.getId());
                NodeIdentifier coordinatorNode = this.clusterCoordinator.getElectedActiveCoordinatorNode();
                if (coordinatorNode == null) {
                    throw new NoClusterCoordinatorException();
                }
                Set<NodeIdentifier> coordinatorNodes = Collections.singleton(coordinatorNode);
                nodeResponse = this.requestReplicator.replicate(coordinatorNodes, "GET", dataUri, (Object)parameters, headers, false, true).awaitMergedResponse();
            }
            catch (InterruptedException e) {
                throw new IllegalClusterStateException("Interrupted while waiting for a response from node");
            }
            Response clientResponse = nodeResponse.getClientResponse();
            MultivaluedMap responseHeaders = clientResponse.getStringHeaders();
            if (Response.Status.NOT_FOUND.getStatusCode() == clientResponse.getStatusInfo().getStatusCode()) {
                throw new ResourceNotFoundException((String)clientResponse.readEntity(String.class));
            }
            if (Response.Status.FORBIDDEN.getStatusCode() == clientResponse.getStatusInfo().getStatusCode() || Response.Status.UNAUTHORIZED.getStatusCode() == clientResponse.getStatusInfo().getStatusCode()) {
                throw new AccessDeniedException((String)clientResponse.readEntity(String.class));
            }
            if (Response.Status.OK.getStatusCode() != clientResponse.getStatusInfo().getStatusCode()) {
                throw new IllegalStateException((String)clientResponse.readEntity(String.class));
            }
            String contentDisposition = (String)responseHeaders.getFirst((Object)"Content-Disposition");
            String filename = StringUtils.substringBetween((String)contentDisposition, (String)"filename=\"", (String)"\"");
            String contentType = (String)responseHeaders.getFirst((Object)"Content-Type");
            return new DownloadableContent(filename, contentType, nodeResponse.getInputStream());
        }
        String dataUri = StringUtils.substringAfter((String)request.getDataUri(), (String)"/nifi-api");
        if (StringUtils.isBlank((CharSequence)dataUri)) {
            throw new IllegalArgumentException("The specified data reference URI is not valid.");
        }
        Matcher flowFileMatcher = FLOWFILE_CONTENT_URI_PATTERN.matcher(dataUri);
        if (flowFileMatcher.matches()) {
            String connectionId = flowFileMatcher.group(1);
            String flowfileId = flowFileMatcher.group(2);
            return this.getFlowFileContent(connectionId, flowfileId, dataUri);
        }
        Matcher provenanceMatcher = PROVENANCE_CONTENT_URI_PATTERN.matcher(dataUri);
        if (provenanceMatcher.matches()) {
            try {
                Long eventId = Long.parseLong(provenanceMatcher.group(1));
                ContentDirection direction = ContentDirection.valueOf((String)provenanceMatcher.group(2).toUpperCase());
                return this.getProvenanceEventContent(eventId, dataUri, direction);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("The specified data reference URI is not valid.");
            }
        }
        throw new IllegalArgumentException("The specified data reference URI is not valid.");
    }

    private DownloadableContent getFlowFileContent(String connectionId, String flowfileId, String dataUri) {
        return this.serviceFacade.getContent(connectionId, flowfileId, dataUri);
    }

    private DownloadableContent getProvenanceEventContent(Long eventId, String dataUri, ContentDirection direction) {
        return this.serviceFacade.getContent(eventId, dataUri, direction);
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setRequestReplicator(RequestReplicator requestReplicator) {
        this.requestReplicator = requestReplicator;
    }

    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }
}

