/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.variable;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.registry.variable.VariableRegistryUpdateStep;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;

public class VariableRegistryUpdateRequest {
    private final String requestId;
    private final String processGroupId;
    private final NiFiUser user;
    private volatile Date submissionTime = new Date();
    private volatile Date lastUpdated = new Date();
    private volatile boolean complete = false;
    private final AtomicReference<String> failureReason = new AtomicReference();
    private RevisionDTO processGroupRevision;
    private Map<String, AffectedComponentEntity> affectedComponents;
    private final VariableRegistryUpdateStep identifyComponentsStep = new VariableRegistryUpdateStep("Identifying components affected");
    private final VariableRegistryUpdateStep stopProcessors = new VariableRegistryUpdateStep("Stopping affected Processors");
    private final VariableRegistryUpdateStep disableServices = new VariableRegistryUpdateStep("Disabling affected Controller Services");
    private final VariableRegistryUpdateStep applyUpdates = new VariableRegistryUpdateStep("Applying Updates");
    private final VariableRegistryUpdateStep enableServices = new VariableRegistryUpdateStep("Re-Enabling affected Controller Services");
    private final VariableRegistryUpdateStep startProcessors = new VariableRegistryUpdateStep("Restarting affected Processors");

    public VariableRegistryUpdateRequest(String requestId, String processGroupId, Set<AffectedComponentEntity> affectedComponents, NiFiUser user) {
        this.requestId = requestId;
        this.processGroupId = processGroupId;
        this.affectedComponents = affectedComponents.stream().collect(Collectors.toMap(ComponentEntity::getId, Function.identity()));
        this.user = user;
    }

    public String getProcessGroupId() {
        return this.processGroupId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public NiFiUser getUser() {
        return this.user;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public VariableRegistryUpdateStep getIdentifyRelevantComponentsStep() {
        return this.identifyComponentsStep;
    }

    public VariableRegistryUpdateStep getStopProcessorsStep() {
        return this.stopProcessors;
    }

    public VariableRegistryUpdateStep getDisableServicesStep() {
        return this.disableServices;
    }

    public VariableRegistryUpdateStep getApplyUpdatesStep() {
        return this.applyUpdates;
    }

    public VariableRegistryUpdateStep getEnableServicesStep() {
        return this.enableServices;
    }

    public VariableRegistryUpdateStep getStartProcessorsStep() {
        return this.startProcessors;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public String getFailureReason() {
        return (String)this.failureReason.get();
    }

    public void setFailureReason(String reason) {
        this.failureReason.set(reason);
    }

    public RevisionDTO getProcessGroupRevision() {
        return this.processGroupRevision;
    }

    public void setProcessGroupRevision(RevisionDTO processGroupRevision) {
        this.processGroupRevision = processGroupRevision;
    }

    public Map<String, AffectedComponentEntity> getAffectedComponents() {
        return this.affectedComponents;
    }

    public void cancel() {
        this.failureReason.compareAndSet(null, "Update was cancelled");
        this.complete = true;
    }
}

