/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeAccess;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.AuthorizeParameterReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.ProcessGroupAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.SnippetAuthorizable;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.cluster.exception.NoClusterCoordinatorException;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.exception.IllegalClusterStateException;
import org.apache.nifi.cluster.manager.exception.UnknownNodeException;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.remote.HttpRemoteSiteListener;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.exception.BadRequestException;
import org.apache.nifi.util.ComponentIdGenerator;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.apache.nifi.web.security.util.CacheKey;
import org.apache.nifi.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationResource {
    public static final String VERSION = "version";
    public static final String CLIENT_ID = "clientId";
    public static final String DISCONNECTED_NODE_ACKNOWLEDGED = "disconnectedNodeAcknowledged";
    public static final String PROXY_SCHEME_HTTP_HEADER = "X-ProxyScheme";
    public static final String PROXY_HOST_HTTP_HEADER = "X-ProxyHost";
    public static final String PROXY_PORT_HTTP_HEADER = "X-ProxyPort";
    public static final String PROXY_CONTEXT_PATH_HTTP_HEADER = "X-ProxyContextPath";
    public static final String FORWARDED_PROTO_HTTP_HEADER = "X-Forwarded-Proto";
    public static final String FORWARDED_HOST_HTTP_HEADER = "X-Forwarded-Host";
    public static final String FORWARDED_PORT_HTTP_HEADER = "X-Forwarded-Port";
    public static final String FORWARDED_CONTEXT_HTTP_HEADER = "X-Forwarded-Context";
    public static final String FORWARDED_PREFIX_HTTP_HEADER = "X-Forwarded-Prefix";
    protected static final String NON_GUARANTEED_ENDPOINT = "Note: This endpoint is subject to change as NiFi and it's REST API evolve.";
    private static final Logger logger = LoggerFactory.getLogger(ApplicationResource.class);
    public static final String NODEWISE = "false";
    @Context
    protected HttpServletRequest httpServletRequest;
    @Context
    protected UriInfo uriInfo;
    protected NiFiProperties properties;
    private RequestReplicator requestReplicator;
    private ClusterCoordinator clusterCoordinator;
    private FlowController flowController;
    private static final int MAX_CACHE_SOFT_LIMIT = 500;
    private final Cache<CacheKey, Request<? extends Entity>> twoPhaseCommitCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    protected String generateResourceUri(String ... path) {
        URI uri = this.buildResourceUri(path);
        return uri.toString();
    }

    private URI buildResourceUri(String ... path) {
        UriBuilder uriBuilder = this.uriInfo.getBaseUriBuilder();
        uriBuilder.segment(path);
        URI uri = uriBuilder.build(new Object[0]);
        try {
            String scheme = this.getFirstHeaderValue(new String[]{PROXY_SCHEME_HTTP_HEADER, FORWARDED_PROTO_HTTP_HEADER});
            String hostHeaderValue = this.getFirstHeaderValue(new String[]{PROXY_HOST_HTTP_HEADER, FORWARDED_HOST_HTTP_HEADER});
            String portHeaderValue = this.getFirstHeaderValue(new String[]{PROXY_PORT_HTTP_HEADER, FORWARDED_PORT_HTTP_HEADER});
            String host = this.determineProxiedHost(hostHeaderValue);
            String port = this.determineProxiedPort(hostHeaderValue, portHeaderValue);
            String whitelistedContextPaths = this.properties.getWhitelistedContextPaths();
            String resourcePath = WebUtils.getResourcePath((URI)uri, (HttpServletRequest)this.httpServletRequest, (String)whitelistedContextPaths);
            int uriPort = uri.getPort();
            if (port != null) {
                if (StringUtils.isWhitespace((CharSequence)port)) {
                    uriPort = -1;
                } else {
                    try {
                        uriPort = Integer.parseInt(port);
                    }
                    catch (NumberFormatException nfe) {
                        logger.warn(String.format("Unable to parse proxy port HTTP header '%s'. Using port from request URI '%s'.", port, uriPort));
                    }
                }
            }
            uri = new URI(StringUtils.isBlank((CharSequence)scheme) ? uri.getScheme() : scheme, uri.getUserInfo(), StringUtils.isBlank((CharSequence)host) ? uri.getHost() : host, uriPort, resourcePath, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException use) {
            throw new UriBuilderException((Throwable)use);
        }
        return uri;
    }

    private String determineProxiedHost(String hostHeaderValue) {
        String[] hostSplits;
        String[] stringArray = hostSplits = hostHeaderValue == null ? new String[]{} : hostHeaderValue.split(":");
        String host = hostSplits.length >= 1 && hostSplits.length <= 2 ? hostSplits[0] : (hostSplits.length == 0 ? null : hostHeaderValue);
        return host;
    }

    private String determineProxiedPort(String hostHeaderValue, String portHeaderValue) {
        String[] hostSplits = hostHeaderValue == null ? new String[]{} : hostHeaderValue.split(":");
        String portFromHostHeader = hostSplits.length == 2 ? hostSplits[1] : null;
        if (StringUtils.isNotBlank((CharSequence)portFromHostHeader) && StringUtils.isNotBlank((CharSequence)portHeaderValue)) {
            logger.warn(String.format("The proxied host header contained a port, but was overridden by the proxied port header", new Object[0]));
        }
        String port = StringUtils.isNotBlank((CharSequence)portHeaderValue) ? portHeaderValue : (StringUtils.isNotBlank((CharSequence)portFromHostHeader) ? portFromHostHeader : null);
        return port;
    }

    protected Response.ResponseBuilder noCache(Response.ResponseBuilder response) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setPrivate(true);
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return response.cacheControl(cacheControl);
    }

    protected String generateUuid() {
        UUID uuid;
        Optional seed = this.getIdGenerationSeed();
        if (seed.isPresent()) {
            try {
                UUID seedId = UUID.fromString((String)seed.get());
                uuid = new UUID(seedId.getMostSignificantBits(), ((String)seed.get()).hashCode());
            }
            catch (Exception e) {
                logger.warn("Provided 'seed' does not represent UUID. Will not be able to extract most significant bits for ID generation.");
                uuid = UUID.nameUUIDFromBytes(((String)seed.get()).getBytes(StandardCharsets.UTF_8));
            }
        } else {
            uuid = ComponentIdGenerator.generateId();
        }
        return uuid.toString();
    }

    protected Optional<String> getIdGenerationSeed() {
        String idGenerationSeed = this.httpServletRequest.getHeader("X-Cluster-Id-Generation-Seed");
        if (StringUtils.isBlank((CharSequence)idGenerationSeed)) {
            return Optional.empty();
        }
        return Optional.of(idGenerationSeed);
    }

    protected Response.ResponseBuilder generateOkResponse() {
        return this.noCache(Response.ok());
    }

    protected Response.ResponseBuilder generateOkResponse(Object entity) {
        Response.ResponseBuilder response = Response.ok((Object)entity);
        return this.noCache(response);
    }

    protected Response.ResponseBuilder generateCreatedResponse(URI uri, Object entity) {
        return Response.created((URI)uri).entity(entity);
    }

    protected Response.ResponseBuilder generateNotAuthorizedResponse() {
        return Response.status((int)401);
    }

    protected Response.ResponseBuilder generateContinueResponse() {
        return Response.status((int)202);
    }

    protected URI getAbsolutePath() {
        return this.uriInfo.getAbsolutePath();
    }

    protected URI getRequestUri() {
        return this.uriInfo.getRequestUri();
    }

    protected MultivaluedMap<String, String> getRequestParameters() {
        MultivaluedHashMap entity = new MultivaluedHashMap();
        for (Map.Entry entry : this.httpServletRequest.getParameterMap().entrySet()) {
            if (entry.getValue() == null) {
                entity.add(entry.getKey(), null);
                continue;
            }
            for (String aValue : (String[])entry.getValue()) {
                entity.add(entry.getKey(), (Object)aValue);
            }
        }
        return entity;
    }

    protected Map<String, String> getHeaders() {
        return this.getHeaders(new HashMap());
    }

    protected Map<String, String> getHeaders(Map<String, String> overriddenHeaders) {
        String proxyPort;
        String proxyHost;
        HashMap<String, String> result = new HashMap<String, String>();
        TreeMap<String, String> overriddenHeadersIgnoreCaseMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (overriddenHeaders != null) {
            overriddenHeadersIgnoreCaseMap.putAll(overriddenHeaders);
        }
        Enumeration headerNames = this.httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!overriddenHeadersIgnoreCaseMap.isEmpty() && headerName.equalsIgnoreCase("content-length")) continue;
            if (overriddenHeadersIgnoreCaseMap.containsKey(headerName)) {
                result.put(headerName, (String)overriddenHeadersIgnoreCaseMap.get(headerName));
                continue;
            }
            result.put(headerName, this.httpServletRequest.getHeader(headerName));
        }
        String proxyScheme = this.getFirstHeaderValue(new String[]{PROXY_SCHEME_HTTP_HEADER, FORWARDED_PROTO_HTTP_HEADER});
        if (proxyScheme == null) {
            result.put(PROXY_SCHEME_HTTP_HEADER, this.httpServletRequest.getScheme());
        }
        if ((proxyHost = this.getFirstHeaderValue(new String[]{PROXY_HOST_HTTP_HEADER, FORWARDED_HOST_HTTP_HEADER})) == null) {
            result.put(PROXY_HOST_HTTP_HEADER, this.httpServletRequest.getServerName());
        }
        if ((proxyPort = this.getFirstHeaderValue(new String[]{PROXY_PORT_HTTP_HEADER, FORWARDED_PORT_HTTP_HEADER})) == null) {
            result.put(PROXY_PORT_HTTP_HEADER, String.valueOf(this.httpServletRequest.getServerPort()));
        }
        return result;
    }

    private String getFirstHeaderValue(String ... keys) {
        if (keys == null) {
            return null;
        }
        for (String key : keys) {
            String value = this.httpServletRequest.getHeader(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected boolean isTwoPhaseRequest(HttpServletRequest httpServletRequest) {
        String transactionId = httpServletRequest.getHeader("X-RequestTransactionId");
        return transactionId != null && this.isConnectedToCluster();
    }

    protected boolean isValidationPhase(HttpServletRequest httpServletRequest) {
        return this.isTwoPhaseRequest(httpServletRequest) && httpServletRequest.getHeader("X-Validation-Expects") != null;
    }

    protected boolean isExecutionPhase(HttpServletRequest httpServletRequest) {
        return this.isTwoPhaseRequest(httpServletRequest) && httpServletRequest.getHeader("X-Execution-Continue") != null;
    }

    protected boolean isCancellationPhase(HttpServletRequest httpServletRequest) {
        return this.isTwoPhaseRequest(httpServletRequest) && httpServletRequest.getHeader("X-Cancel-Transaction") != null;
    }

    boolean isReplicateRequest() {
        if (!this.properties.isNode()) {
            return false;
        }
        this.ensureFlowInitialized();
        if (!this.isConnectedToCluster()) {
            return false;
        }
        String header = this.httpServletRequest.getHeader("X-Request-Replicated");
        return header == null;
    }

    protected Revision getRevision(RevisionDTO revisionDto, String componentId) {
        return new Revision(revisionDto.getVersion(), revisionDto.getClientId(), componentId);
    }

    protected Revision getRevision(ComponentEntity entity, String componentId) {
        return this.getRevision(entity.getRevision(), componentId);
    }

    protected void authorizeRestrictions(Authorizer authorizer, ComponentAuthorizable authorizable) {
        authorizable.getRestrictedAuthorizables().forEach(restrictionAuthorizable -> restrictionAuthorizable.authorize(authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser()));
    }

    protected void authorizeProcessGroup(ProcessGroupAuthorizable processGroupAuthorizable, Authorizer authorizer, AuthorizableLookup lookup, RequestAction action, boolean authorizeReferencedServices, boolean authorizeTemplates, boolean authorizeControllerServices, boolean authorizeTransitiveServices, boolean authorizeParamterReferences) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Consumer<Authorizable> authorize = authorizable -> authorizable.authorize(authorizer, action, user);
        authorize.accept(processGroupAuthorizable.getAuthorizable());
        processGroupAuthorizable.getEncapsulatedProcessors().forEach(processorAuthorizable -> {
            authorize.accept(processorAuthorizable.getAuthorizable());
            if (authorizeReferencedServices) {
                AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)processorAuthorizable, (Authorizer)authorizer, (AuthorizableLookup)lookup, (boolean)authorizeTransitiveServices);
            }
            if (authorizeParamterReferences) {
                AuthorizeParameterReference.authorizeParameterReferences((ComponentAuthorizable)processorAuthorizable, (Authorizer)authorizer, (Authorizable)processorAuthorizable.getParameterContext(), (NiFiUser)user);
            }
        });
        processGroupAuthorizable.getEncapsulatedConnections().stream().map(connection -> connection.getAuthorizable()).forEach(authorize);
        processGroupAuthorizable.getEncapsulatedInputPorts().forEach(authorize);
        processGroupAuthorizable.getEncapsulatedOutputPorts().forEach(authorize);
        processGroupAuthorizable.getEncapsulatedFunnels().forEach(authorize);
        processGroupAuthorizable.getEncapsulatedLabels().forEach(authorize);
        processGroupAuthorizable.getEncapsulatedProcessGroups().stream().map(group -> group.getAuthorizable()).forEach(authorize);
        processGroupAuthorizable.getEncapsulatedRemoteProcessGroups().forEach(authorize);
        if (authorizeTemplates) {
            processGroupAuthorizable.getEncapsulatedTemplates().forEach(authorize);
        }
        if (authorizeControllerServices) {
            processGroupAuthorizable.getEncapsulatedControllerServices().forEach(controllerServiceAuthorizable -> {
                authorize.accept(controllerServiceAuthorizable.getAuthorizable());
                if (authorizeReferencedServices) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)controllerServiceAuthorizable, (Authorizer)authorizer, (AuthorizableLookup)lookup, (boolean)authorizeTransitiveServices);
                }
                if (authorizeParamterReferences) {
                    AuthorizeParameterReference.authorizeParameterReferences((ComponentAuthorizable)controllerServiceAuthorizable, (Authorizer)authorizer, (Authorizable)controllerServiceAuthorizable.getParameterContext(), (NiFiUser)user);
                }
            });
        }
    }

    protected void authorizeSnippet(SnippetAuthorizable snippet, Authorizer authorizer, AuthorizableLookup lookup, RequestAction action, boolean authorizeReferencedServices, boolean authorizeTransitiveServices, boolean authorizeParameterReferences) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Consumer<Authorizable> authorize = authorizable -> authorizable.authorize(authorizer, action, user);
        snippet.getSelectedProcessGroups().forEach(processGroupAuthorizable -> this.authorizeProcessGroup(processGroupAuthorizable, authorizer, lookup, action, authorizeReferencedServices, false, false, authorizeTransitiveServices, authorizeParameterReferences));
        snippet.getSelectedRemoteProcessGroups().forEach(authorize);
        snippet.getSelectedProcessors().forEach(processorAuthorizable -> {
            authorize.accept(processorAuthorizable.getAuthorizable());
            if (authorizeReferencedServices) {
                AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)processorAuthorizable, (Authorizer)authorizer, (AuthorizableLookup)lookup, (boolean)authorizeTransitiveServices);
            }
            if (authorizeParameterReferences) {
                AuthorizeParameterReference.authorizeParameterReferences((ComponentAuthorizable)processorAuthorizable, (Authorizer)authorizer, (Authorizable)processorAuthorizable.getParameterContext(), (NiFiUser)user);
            }
        });
        snippet.getSelectedInputPorts().forEach(authorize);
        snippet.getSelectedOutputPorts().forEach(authorize);
        snippet.getSelectedConnections().forEach(connAuth -> authorize.accept(connAuth.getAuthorizable()));
        snippet.getSelectedFunnels().forEach(authorize);
        snippet.getSelectedLabels().forEach(authorize);
    }

    protected <T extends Entity> Response withWriteLock(NiFiServiceFacade serviceFacade, T entity, Revision revision, AuthorizeAccess authorizer, Runnable verifier, BiFunction<Revision, T, Response> action) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (this.isTwoPhaseRequest(this.httpServletRequest)) {
            if (this.isValidationPhase(this.httpServletRequest)) {
                serviceFacade.authorizeAccess(authorizer);
                serviceFacade.verifyRevision(revision, user);
                if (verifier != null) {
                    verifier.run();
                }
                this.phaseOneStoreTransaction(entity, revision, null);
                return this.generateContinueResponse().build();
            }
            if (this.isExecutionPhase(this.httpServletRequest)) {
                Request phaseOneRequest = this.phaseTwoVerifyTransaction();
                return action.apply(phaseOneRequest.getRevision(), (Revision)phaseOneRequest.getRequest());
            }
            if (this.isCancellationPhase(this.httpServletRequest)) {
                this.cancelTransaction();
                return this.generateOkResponse().build();
            }
            throw new IllegalStateException("This request does not appear to be part of the two phase commit.");
        }
        serviceFacade.authorizeAccess(authorizer);
        serviceFacade.verifyRevision(revision, user);
        if (verifier != null) {
            verifier.run();
        }
        return action.apply(revision, (Revision)entity);
    }

    protected <T extends Entity> Response withWriteLock(NiFiServiceFacade serviceFacade, T entity, Set<Revision> revisions, AuthorizeAccess authorizer, Runnable verifier, BiFunction<Set<Revision>, T, Response> action) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (this.isTwoPhaseRequest(this.httpServletRequest)) {
            if (this.isValidationPhase(this.httpServletRequest)) {
                serviceFacade.authorizeAccess(authorizer);
                serviceFacade.verifyRevisions(revisions, user);
                if (verifier != null) {
                    verifier.run();
                }
                this.phaseOneStoreTransaction(entity, null, revisions);
                return this.generateContinueResponse().build();
            }
            if (this.isExecutionPhase(this.httpServletRequest)) {
                Request phaseOneRequest = this.phaseTwoVerifyTransaction();
                return action.apply(phaseOneRequest.getRevisions(), (Set<Revision>)phaseOneRequest.getRequest());
            }
            if (this.isCancellationPhase(this.httpServletRequest)) {
                this.cancelTransaction();
                return this.generateOkResponse().build();
            }
            throw new IllegalStateException("This request does not appear to be part of the two phase commit.");
        }
        serviceFacade.authorizeAccess(authorizer);
        serviceFacade.verifyRevisions(revisions, user);
        if (verifier != null) {
            verifier.run();
        }
        return action.apply(revisions, (Set<Revision>)entity);
    }

    protected <T extends Entity> Response withWriteLock(NiFiServiceFacade serviceFacade, T entity, AuthorizeAccess authorizer, Runnable verifier, Function<T, Response> action) {
        if (this.isTwoPhaseRequest(this.httpServletRequest)) {
            if (this.isValidationPhase(this.httpServletRequest)) {
                serviceFacade.authorizeAccess(authorizer);
                if (verifier != null) {
                    verifier.run();
                }
                this.phaseOneStoreTransaction(entity, null, null);
                return this.generateContinueResponse().build();
            }
            if (this.isExecutionPhase(this.httpServletRequest)) {
                Request phaseOneRequest = this.phaseTwoVerifyTransaction();
                return action.apply(phaseOneRequest.getRequest());
            }
            if (this.isCancellationPhase(this.httpServletRequest)) {
                this.cancelTransaction();
                return this.generateOkResponse().build();
            }
            throw new IllegalStateException("This request does not appear to be part of the two phase commit.");
        }
        serviceFacade.authorizeAccess(authorizer);
        if (verifier != null) {
            verifier.run();
        }
        return action.apply(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Entity> void phaseOneStoreTransaction(T requestEntity, Revision revision, Set<Revision> revisions) {
        if (this.twoPhaseCommitCache.size() > 500L) {
            throw new IllegalStateException("The maximum number of requests are in progress.");
        }
        String transactionId = this.httpServletRequest.getHeader("X-RequestTransactionId");
        if (StringUtils.isBlank((CharSequence)transactionId)) {
            throw new IllegalArgumentException("Two phase commit Transaction Id missing.");
        }
        Cache cache = this.twoPhaseCommitCache;
        synchronized (cache) {
            CacheKey key = new CacheKey(transactionId);
            if (this.twoPhaseCommitCache.getIfPresent((Object)key) != null) {
                throw new IllegalStateException("Transaction " + transactionId + " is already in progress.");
            }
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Request request = new Request(this, ProxiedEntitiesUtils.buildProxiedEntitiesChainString((NiFiUser)user), this.getAbsolutePath().toString(), revision, revisions, requestEntity);
            this.twoPhaseCommitCache.put((Object)key, (Object)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Entity> Request<T> phaseTwoVerifyTransaction() {
        Request request;
        String transactionId = this.httpServletRequest.getHeader("X-RequestTransactionId");
        if (StringUtils.isBlank((CharSequence)transactionId)) {
            throw new IllegalArgumentException("Two phase commit Transaction Id missing.");
        }
        Cache cache = this.twoPhaseCommitCache;
        synchronized (cache) {
            CacheKey key = new CacheKey(transactionId);
            request = (Request)this.twoPhaseCommitCache.getIfPresent((Object)key);
            if (request == null) {
                throw new IllegalArgumentException("The request from phase one is missing.");
            }
            this.twoPhaseCommitCache.invalidate((Object)key);
        }
        String phaseOneChain = request.getUserChain();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        String phaseTwoChain = ProxiedEntitiesUtils.buildProxiedEntitiesChainString((NiFiUser)user);
        if (phaseOneChain == null || !phaseOneChain.equals(phaseTwoChain)) {
            throw new IllegalArgumentException("The same user must issue the request for phase one and two.");
        }
        String phaseOneUri = request.getUri();
        if (phaseOneUri == null || !phaseOneUri.equals(this.getAbsolutePath().toString())) {
            throw new IllegalArgumentException("The URI must be the same for phase one and two.");
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTransaction() {
        String transactionId = this.httpServletRequest.getHeader("X-RequestTransactionId");
        if (StringUtils.isBlank((CharSequence)transactionId)) {
            throw new IllegalArgumentException("Two phase commit Transaction Id missing.");
        }
        Cache cache = this.twoPhaseCommitCache;
        synchronized (cache) {
            CacheKey key = new CacheKey(transactionId);
            this.twoPhaseCommitCache.invalidate((Object)key);
        }
    }

    protected Response replicate(String method, String nodeUuid) {
        return this.replicate(method, (Object)this.getRequestParameters(), nodeUuid);
    }

    private void ensureFlowInitialized() {
        if (!this.flowController.isInitialized()) {
            throw new IllegalClusterStateException("The Flow Controller is initializing the Data Flow.");
        }
    }

    protected Response replicate(String method, Object entity, String nodeUuid, Map<String, String> headersToOverride) {
        URI path = this.getAbsolutePath();
        return this.replicate(path, method, entity, nodeUuid, headersToOverride);
    }

    protected Response replicate(String method, Object entity, String nodeUuid) {
        return this.replicate(method, entity, nodeUuid, null);
    }

    protected Response replicate(URI path, String method, Object entity, String nodeUuid, Map<String, String> headersToOverride) {
        if (nodeUuid == null) {
            throw new IllegalArgumentException("The cluster node identifier must be specified.");
        }
        NodeIdentifier nodeId = this.clusterCoordinator.getNodeIdentifier(nodeUuid);
        if (nodeId == null) {
            throw new UnknownNodeException("Cannot replicate request " + method + " " + this.getAbsolutePath() + " to node with ID " + nodeUuid + " because the specified node does not exist.");
        }
        this.ensureFlowInitialized();
        try {
            Map headers;
            Map map = headers = headersToOverride == null ? this.getHeaders() : this.getHeaders(headersToOverride);
            if (this.getReplicationTarget() == ReplicationTarget.CLUSTER_NODES) {
                Set<NodeIdentifier> targetNodes = Collections.singleton(nodeId);
                return this.requestReplicator.replicate(targetNodes, method, path, entity, headers, true, true).awaitMergedResponse().getResponse();
            }
            headers.put("X-Replication-Target-Id", nodeId.getId());
            return this.requestReplicator.forwardToCoordinator(this.getClusterCoordinatorNode(), method, path, entity, headers).awaitMergedResponse().getResponse();
        }
        catch (InterruptedException ie) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Request to " + method + " " + path + " was interrupted")).type("text/plain").build();
        }
    }

    protected NodeIdentifier getClusterCoordinatorNode() {
        NodeIdentifier activeClusterCoordinator = this.clusterCoordinator.getElectedActiveCoordinatorNode();
        if (activeClusterCoordinator != null) {
            return activeClusterCoordinator;
        }
        throw new NoClusterCoordinatorException();
    }

    protected ReplicationTarget getReplicationTarget() {
        return this.clusterCoordinator.isActiveClusterCoordinator() ? ReplicationTarget.CLUSTER_NODES : ReplicationTarget.CLUSTER_COORDINATOR;
    }

    protected Response replicate(String method, NodeIdentifier targetNode) {
        return this.replicate(method, targetNode, (Object)this.getRequestParameters());
    }

    protected Response replicate(String method, NodeIdentifier targetNode, Object entity) {
        this.ensureFlowInitialized();
        try {
            if (this.getReplicationTarget() == ReplicationTarget.CLUSTER_NODES) {
                Set<NodeIdentifier> nodeIds = Collections.singleton(targetNode);
                return this.getRequestReplicator().replicate(nodeIds, method, this.getAbsolutePath(), entity, this.getHeaders(), true, true).awaitMergedResponse().getResponse();
            }
            Map headers = this.getHeaders(Collections.singletonMap("X-Replication-Target-Id", targetNode.getId()));
            return this.requestReplicator.forwardToCoordinator(this.getClusterCoordinatorNode(), method, this.getAbsolutePath(), entity, headers).awaitMergedResponse().getResponse();
        }
        catch (InterruptedException ie) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Request to " + method + " " + this.getAbsolutePath() + " was interrupted")).type("text/plain").build();
        }
    }

    protected Response replicateToCoordinator(String method, Object entity) {
        this.ensureFlowInitialized();
        try {
            NodeIdentifier coordinatorNode = this.getClusterCoordinatorNode();
            Set<NodeIdentifier> coordinatorNodes = Collections.singleton(coordinatorNode);
            return this.getRequestReplicator().replicate(coordinatorNodes, method, this.getAbsolutePath(), entity, this.getHeaders(), true, false).awaitMergedResponse().getResponse();
        }
        catch (InterruptedException ie) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Request to " + method + " " + this.getAbsolutePath() + " was interrupted")).type("text/plain").build();
        }
    }

    protected Response replicate(String method) {
        return this.replicate(method, (Object)this.getRequestParameters());
    }

    protected NodeResponse replicateNodeResponse(String method) throws InterruptedException {
        return this.replicateNodeResponse(method, (Object)this.getRequestParameters(), null);
    }

    protected Response replicate(String method, Object entity) {
        return this.replicate(method, entity, (Map)null);
    }

    protected Response replicate(String method, Object entity, Map<String, String> headersToOverride) {
        try {
            return this.replicateNodeResponse(method, entity, headersToOverride).getResponse();
        }
        catch (InterruptedException ie) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Request to " + method + " " + this.getAbsolutePath() + " was interrupted")).type("text/plain").build();
        }
    }

    protected NodeResponse replicateNodeResponse(String method, Object entity, Map<String, String> headersToOverride) throws InterruptedException {
        URI path = this.getAbsolutePath();
        return this.replicateNodeResponse(path, method, entity, headersToOverride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeResponse replicateNodeResponse(URI path, String method, Object entity, Map<String, String> headersToOverride) throws InterruptedException {
        String action;
        long replicateStart;
        Map headers;
        block3: {
            NodeResponse nodeResponse;
            this.ensureFlowInitialized();
            headers = headersToOverride == null ? this.getHeaders() : this.getHeaders(headersToOverride);
            replicateStart = System.nanoTime();
            action = null;
            try {
                if (this.getReplicationTarget() != ReplicationTarget.CLUSTER_NODES) break block3;
                action = "Replicate Request " + method + " " + path;
                nodeResponse = this.requestReplicator.replicate(method, path, entity, headers).awaitMergedResponse();
            }
            catch (Throwable throwable) {
                long replicateNanos = System.nanoTime() - replicateStart;
                String transactionId = (String)headers.get("X-RequestTransactionId");
                String requestId = transactionId == null ? "Request with no ID" : transactionId;
                logger.debug("Took a total of {} millis to {} for {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(replicateNanos), action, requestId});
                throw throwable;
            }
            long replicateNanos = System.nanoTime() - replicateStart;
            String transactionId = (String)headers.get("X-RequestTransactionId");
            String requestId = transactionId == null ? "Request with no ID" : transactionId;
            logger.debug("Took a total of {} millis to {} for {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(replicateNanos), action, requestId});
            return nodeResponse;
        }
        action = "Forward Request " + method + " " + path + " to Coordinator";
        NodeResponse nodeResponse = this.requestReplicator.forwardToCoordinator(this.getClusterCoordinatorNode(), method, path, entity, headers).awaitMergedResponse();
        long replicateNanos = System.nanoTime() - replicateStart;
        String transactionId = (String)headers.get("X-RequestTransactionId");
        String requestId = transactionId == null ? "Request with no ID" : transactionId;
        logger.debug("Took a total of {} millis to {} for {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(replicateNanos), action, requestId});
        return nodeResponse;
    }

    boolean isConnectedToCluster() {
        return this.isClustered() && this.clusterCoordinator.isConnected();
    }

    boolean isClustered() {
        return this.clusterCoordinator != null;
    }

    boolean isDisconnectedFromCluster() {
        return this.isClustered() && !this.clusterCoordinator.isConnected();
    }

    void verifyDisconnectedNodeModification(Boolean disconnectionAcknowledged) {
        if (!Boolean.TRUE.equals(disconnectionAcknowledged)) {
            throw new IllegalArgumentException("This node is disconnected from its configured cluster. The requested change will only be allowed if the flag to acknowledge the disconnected node is set.");
        }
    }

    public void setRequestReplicator(RequestReplicator requestReplicator) {
        this.requestReplicator = requestReplicator;
    }

    protected RequestReplicator getRequestReplicator() {
        this.ensureFlowInitialized();
        return this.requestReplicator;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    protected ClusterCoordinator getClusterCoordinator() {
        return this.clusterCoordinator;
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    protected NiFiProperties getProperties() {
        return this.properties;
    }

    protected Integer negotiateTransportProtocolVersion(HttpServletRequest req, VersionNegotiator transportProtocolVersionNegotiator) throws BadRequestException {
        Integer requestedProtocolVersion;
        String protocolVersionStr = req.getHeader("x-nifi-site-to-site-protocol-version");
        if (StringUtils.isEmpty((CharSequence)protocolVersionStr)) {
            throw new BadRequestException("Protocol version was not specified.");
        }
        try {
            requestedProtocolVersion = Integer.valueOf(protocolVersionStr);
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Specified protocol version was not in a valid number format: " + protocolVersionStr);
        }
        if (transportProtocolVersionNegotiator.isVersionSupported(requestedProtocolVersion.intValue())) {
            return requestedProtocolVersion;
        }
        Integer protocolVersion = transportProtocolVersionNegotiator.getPreferredVersion(requestedProtocolVersion.intValue());
        if (protocolVersion == null) {
            throw new BadRequestException("Specified protocol version is not supported: " + protocolVersionStr);
        }
        return protocolVersion;
    }

    protected Response.ResponseBuilder setCommonHeaders(Response.ResponseBuilder builder, Integer transportProtocolVersion, HttpRemoteSiteListener transactionManager) {
        return builder.header("x-nifi-site-to-site-protocol-version", (Object)transportProtocolVersion).header("x-nifi-site-to-site-server-transaction-ttl", (Object)transactionManager.getTransactionTtlSec());
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ URI access$100(ApplicationResource x0, String[] x1) {
        return x0.buildResourceUri(x1);
    }
}

